/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Rect;
import android.util.Log;
import android.util.Rational;
import android.util.Size;
import io.scanbot.sdk.exceptions.camera.CodecFailedException;
import io.scanbot.sdk.image.ImageRotation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u001a\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0007J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0007J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/scanbot/sdk/util/ImageUtils;", "", "<init>", "()V", "TAG", "", "cropByteArray", "", "data", "cropRect", "Landroid/graphics/Rect;", "isAspectRatioValid", "", "aspectRatio", "Landroid/util/Rational;", "sourceSize", "Landroid/util/Size;", "computeCropRectFromAspectRatio", "toImageRotation", "Lio/scanbot/sdk/image/ImageRotation;", "", "isCropAspectRatioHasEffect", "sdk-base_release"})
public final class ImageUtils {
    @NotNull
    public static final ImageUtils INSTANCE = new ImageUtils();
    @NotNull
    private static final String TAG = "ImageUtils";

    private ImageUtils() {
    }

    @JvmStatic
    @NotNull
    public static final byte[] cropByteArray(@NotNull byte[] data, @Nullable Rect cropRect) {
        IllegalArgumentException illegalArgumentException2;
        block10: {
            block9: {
                block8: {
                    ByteArrayOutputStream byteArrayOutputStream;
                    BitmapFactory.Options options;
                    BitmapFactory.Options options2;
                    byte[] byArray;
                    Intrinsics.checkNotNullParameter((Object)byArray, (String)"data");
                    if (cropRect == null) {
                        return byArray;
                    }
                    int n = 0;
                    Object object = BitmapRegionDecoder.newInstance((byte[])byArray, (int)n, (int)byArray.length, (boolean)false);
                    void v0 = options2;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newInstance(...)");
                    options2 = options;
                    options = new BitmapFactory.Options();
                    options2 = object.decodeRegion((Rect)v0, options2);
                    try {
                        object.recycle();
                        if (options2 == null) break block8;
                    }
                    catch (IOException iOException) {
                        break block9;
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        break block10;
                    }
                    object = byteArrayOutputStream;
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    if (options2.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)object)) {
                        options2.recycle();
                        byte[] byArray2 = ((ByteArrayOutputStream)object).toByteArray();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
                        return byArray2;
                    }
                    throw new CodecFailedException("Encode bitmap failed.", CodecFailedException.FailureType.ENCODE_FAILED);
                }
                throw new CodecFailedException("Decode byte array failed.", CodecFailedException.FailureType.DECODE_FAILED);
            }
            throw new CodecFailedException("Decode byte array failed.", CodecFailedException.FailureType.DECODE_FAILED);
        }
        throw new CodecFailedException("Decode byte array failed with illegal argument." + illegalArgumentException2.getMessage(), CodecFailedException.FailureType.DECODE_FAILED);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final Rect computeCropRectFromAspectRatio(@NotNull Size sourceSize, @NotNull Rational aspectRatio) {
        void var1_2;
        Size size;
        Intrinsics.checkNotNullParameter((Object)size, (String)"sourceSize");
        Intrinsics.checkNotNullParameter((Object)aspectRatio, (String)"aspectRatio");
        if (!INSTANCE.isAspectRatioValid((Rational)var1_2)) {
            Log.w((String)TAG, (String)"Invalid view ratio.");
            return null;
        }
        void v0 = var1_2;
        int n = size.getWidth();
        int n2 = size.getHeight();
        float f = n;
        float f2 = n2;
        float f3 = f / f2;
        int n3 = 0;
        int n4 = 0;
        int n5 = v0.getNumerator();
        int n6 = v0.getDenominator();
        if (v0.floatValue() > f3) {
            int n7 = n2;
            n2 = Math.round(f / (float)n5 * (float)n6);
            n4 = (n7 - n2) / 2;
        } else {
            int n8 = n;
            n = Math.round(f2 / (float)n6 * (float)n5);
            n3 = (n8 - n) / 2;
        }
        n = n3 + n;
        n2 = n4 + n2;
        return new Rect(n3, n4, n, n2);
    }

    @JvmStatic
    @NotNull
    public static final ImageRotation toImageRotation(int $this$toImageRotation) {
        if ($this$toImageRotation != 0) {
            int n;
            if (n != 90) {
                if (n != 180) {
                    if (n == 270) {
                        return ImageRotation.COUNTERCLOCKWISE_90;
                    }
                    throw new IllegalArgumentException("Unsupported rotation: " + n);
                }
                return ImageRotation.CLOCKWISE_180;
            }
            return ImageRotation.CLOCKWISE_90;
        }
        return ImageRotation.NONE;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCropAspectRatioHasEffect(Size sourceSize, Rational aspectRatio) {
        int n;
        float f;
        void var2_4;
        Size size = sourceSize;
        int n2 = size.getWidth();
        int n3 = size.getHeight();
        void v1 = var2_4;
        int n4 = v1.getNumerator();
        float f2 = n4;
        return n3 != Math.round((float)n2 / f2 * (f = (float)(n = v1.getDenominator()))) || n2 != Math.round((float)n3 / f * f2);
        {
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAspectRatioValid(@Nullable Rational aspectRatio) {
        void var1_1;
        return aspectRatio != null && var1_1.floatValue() > 0.0f && !var1_1.isNaN();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAspectRatioValid(@NotNull Size sourceSize, @Nullable Rational aspectRatio) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"sourceSize");
        return aspectRatio != null && var2_2.floatValue() > 0.0f && this.isCropAspectRatioHasEffect((Size)var1_1, (Rational)var2_2) && !var2_2.isNaN();
    }
}

