/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.blob;

import android.content.res.AssetManager;
import android.net.Uri;
import io.scanbot.sdk.blob.BlobFactory;
import io.scanbot.sdk.blob.BlobType;
import io.scanbot.sdk.entity.Blob;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.exceptions.files.blobManager.BlobsDirectoryException;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import io.scanbot.sdk.util.FileUtilsKt;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b,\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\u000e\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\"\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001a\u0010&\u001a\u00020\u001f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b$\u0010%\u001a\u0004\b#\u0010!R\u001a\u0010)\u001a\u00020\u001f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b(\u0010%\u001a\u0004\b'\u0010!R\u001a\u0010,\u001a\u00020\u001f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b+\u0010%\u001a\u0004\b*\u0010!R\u001a\u0010/\u001a\u00020\u001f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b.\u0010%\u001a\u0004\b-\u0010!R\u001a\u00102\u001a\u00020\u001f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b1\u0010%\u001a\u0004\b0\u0010!R\u001a\u00105\u001a\u00020\u001f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b4\u0010%\u001a\u0004\b3\u0010!R\u001a\u00108\u001a\u00020\u001f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b7\u0010%\u001a\u0004\b6\u0010!R\u001a\u0010;\u001a\u00020\u001f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b:\u0010%\u001a\u0004\b9\u0010!R\u001a\u0010>\u001a\u00020\u001f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b=\u0010%\u001a\u0004\b<\u0010!R\u001a\u0010A\u001a\u00020\u001f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b@\u0010%\u001a\u0004\b?\u0010!R\u001a\u0010D\u001a\u00020\u001f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bC\u0010%\u001a\u0004\bB\u0010!R\u001a\u0010G\u001a\u00020\u001f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bF\u0010%\u001a\u0004\bE\u0010!R\u001a\u0010J\u001a\u00020\u001f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\bI\u0010%\u001a\u0004\bH\u0010!\u00a8\u0006K"}, d2={"Lio/scanbot/sdk/blob/BlobManager;", "", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "blobStoreStrategy", "Landroid/content/res/AssetManager;", "assetManager", "Lio/scanbot/sdk/blob/BlobFactory;", "blobFactory", "<init>", "(Lio/scanbot/sdk/persistence/BlobStoreStrategy;Landroid/content/res/AssetManager;Lio/scanbot/sdk/blob/BlobFactory;)V", "", "Lio/scanbot/sdk/entity/Blob;", "blobs", "", "allBlobsAvailable", "(Ljava/util/Collection;)Z", "blob", "isBlobAvailable", "(Lio/scanbot/sdk/entity/Blob;)Z", "", "fetch", "(Lio/scanbot/sdk/entity/Blob;)V", "Lio/scanbot/sdk/blob/BlobType;", "blobType", "forceFetch", "(Lio/scanbot/sdk/blob/BlobType;)V", "", "Lio/scanbot/sdk/entity/Language;", "getAllLanguagesWithAvailableOcrBlobs", "()Ljava/util/Set;", "allLanguagesWithAvailableOcrBlobs", "Ljava/io/File;", "getOcrBlobsDirectory", "()Ljava/io/File;", "ocrBlobsDirectory", "getBanksDataFile", "getBanksDataFile$annotations", "()V", "banksDataFile", "getBarcodeScanningModelFile", "getBarcodeScanningModelFile$annotations", "barcodeScanningModelFile", "getBarcodeBinarizationModelFile", "getBarcodeBinarizationModelFile$annotations", "barcodeBinarizationModelFile", "getBlurEstimatorModelFile", "getBlurEstimatorModelFile$annotations", "blurEstimatorModelFile", "getMrzCascadeFile", "getMrzCascadeFile$annotations", "mrzCascadeFile", "getMrzTrainedDataFile", "getMrzTrainedDataFile$annotations", "mrzTrainedDataFile", "getFilterPredictionModelFile", "getFilterPredictionModelFile$annotations", "filterPredictionModelFile", "getCheckDigitPredictionModelFile", "getCheckDigitPredictionModelFile$annotations", "checkDigitPredictionModelFile", "getDcModelsFolderFile", "getDcModelsFolderFile$annotations", "dcModelsFolderFile", "getIdCardScannerModelsFolderFile", "getIdCardScannerModelsFolderFile$annotations", "idCardScannerModelsFolderFile", "getTextPatternScannerModelsFolderFile", "getTextPatternScannerModelsFolderFile$annotations", "textPatternScannerModelsFolderFile", "getDocumentDetectorModelFile", "getDocumentDetectorModelFile$annotations", "documentDetectorModelFile", "getImageProcessorModelsFolderFile", "getImageProcessorModelsFolderFile$annotations", "imageProcessorModelsFolderFile", "sdk-base_release"}, xi=48)
public final class BlobManager {
    public final BlobStoreStrategy zon;
    public final AssetManager zof;
    public final BlobFactory zoq;

    public final boolean allBlobsAvailable(@NotNull Collection<Blob> blobs) {
        Collection<Blob> collection = blobs;
        Intrinsics.checkNotNullParameter(collection, (String)"blobs");
        Iterator<Blob> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.isBlobAvailable(iterator.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isBlobAvailable(@NotNull Blob blob) {
        Throwable throwable2;
        block6: {
            boolean bl;
            block5: {
                block4: {
                    void var1_1;
                    File file;
                    Intrinsics.checkNotNullParameter((Object)blob, (String)"blob");
                    File file2 = file;
                    file2(var1_1.getLocalPath());
                    InputStream inputStream = ((BlobManager)((Object)inputStream)).zof.open(var1_1.getRemotePath());
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"open(...)");
                    try {
                        if (!file.exists()) break block4;
                    }
                    catch (Throwable throwable2) {
                        break block6;
                    }
                    long l = inputStream.available();
                    if (l != file2.length()) break block4;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            inputStream.close();
            return bl;
        }
        inputStream.close();
        throw throwable2;
    }

    @NotNull
    public final Set<Language> getAllLanguagesWithAvailableOcrBlobs() {
        BlobManager blobManager = this_;
        EnumSet<Language> this_ = EnumSet.noneOf(Language.class);
        Intrinsics.checkNotNullExpressionValue(this_, (String)"noneOf(...)");
        File[] fileArray = blobManager.zon.getOcrDataDirectory().listFiles();
        if (fileArray != null) {
            for (Object object : fileArray) {
                if (object.isDirectory()) continue;
                File file = object;
                Intrinsics.checkNotNull((Object)file);
                object = Language.Companion.languageByTessTag(FilesKt.getNameWithoutExtension((File)file));
                if (object == null) continue;
                this_.add((Language)((Object)object));
            }
        }
        return this_;
    }

    @NotNull
    public final File getOcrBlobsDirectory() {
        File this_ = ((BlobManager)((Object)this_)).zon.getOcrDataDirectory();
        if (!this_.exists() && !this_.mkdirs()) {
            throw new BlobsDirectoryException("Can't get OCR blobs directory");
        }
        return this_;
    }

    @NotNull
    public final File getBanksDataFile() {
        return this.zon.getLocalFileFor(BlobType.BANKS_DATA);
    }

    @NotNull
    public final File getBarcodeScanningModelFile() {
        return this.zon.getLocalFileFor(BlobType.BARCODE_SCANNING_MODEL);
    }

    @NotNull
    public final File getBarcodeBinarizationModelFile() {
        return this.zon.getLocalFileFor(BlobType.BARCODE_BINARIZATION_MODEL);
    }

    @NotNull
    public final File getBlurEstimatorModelFile() {
        return this.zon.getLocalFileFor(BlobType.BLUR_ESTIMATOR_MODEL);
    }

    @NotNull
    public final File getMrzCascadeFile() {
        return this.zon.getLocalFileFor(BlobType.MRZ_CASCADE);
    }

    @NotNull
    public final File getMrzTrainedDataFile() {
        return this.zon.getLocalFileFor(BlobType.MRZ_TRAINEDDATA);
    }

    @NotNull
    public final File getFilterPredictionModelFile() {
        return this.zon.getLocalFileFor(BlobType.FILTER_PREDICTION_MODEL);
    }

    @NotNull
    public final File getCheckDigitPredictionModelFile() {
        return this.zon.getLocalFileFor(BlobType.CHECK_DIGIT_RECOGNITION_MODEL);
    }

    @NotNull
    public final File getDcModelsFolderFile() {
        return this.zon.getLocalFileFor(BlobType.DC_FORM_MODELS);
    }

    @NotNull
    public final File getIdCardScannerModelsFolderFile() {
        return this.zon.getLocalFileFor(BlobType.IDCARD_SCANNER_MODELS);
    }

    @NotNull
    public final File getTextPatternScannerModelsFolderFile() {
        return this.zon.getLocalFileFor(BlobType.TEXT_PATTERN_SCANNER_MODELS);
    }

    @NotNull
    public final File getDocumentDetectorModelFile() {
        return this.zon.getLocalFileFor(BlobType.DOC_DETECTOR_MODEL);
    }

    @NotNull
    public final File getImageProcessorModelsFolderFile() {
        return this.zon.getLocalFileFor(BlobType.IMAGE_PROCESSOR_MODELS);
    }

    /*
     * WARNING - void declaration
     */
    public final void fetch(@NotNull Blob blob) {
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"blob");
        if (!this.isBlobAvailable((Blob)v0)) {
            Object object = new File(var1_1.getLocalPath()).getParentFile();
            if (!((File)object).exists() && !((File)object).mkdirs()) {
                throw new BlobsDirectoryException("Can't create destination directory");
            }
            Uri uri = Uri.parse((String)var1_1.getRemotePath());
            Intrinsics.checkNotNull((Object)uri);
            object = uri.getPath();
            if (object != null) {
                InputStream inputStream = this.zof.open((String)object);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"open(...)");
                FileUtilsKt.copyToFileAndClose(inputStream, new File(var1_1.getLocalPath()));
                return;
            }
        }
    }

    public final void forceFetch(@NotNull BlobType blobType) {
        Iterator<Blob> iterator;
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"blobType");
        iterator = this.zoq.getBlobsForType((BlobType)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            this.fetch(iterator.next());
        }
    }

    /*
     * WARNING - void declaration
     */
    public BlobManager(@NotNull BlobStoreStrategy blobStoreStrategy, @NotNull AssetManager assetManager, @NotNull BlobFactory blobFactory) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"assetManager");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"blobFactory");
        this.zon = var1_1;
        this.zof = var2_2;
        this.zoq = var3_3;
        LoggerProvider.getLogger();
    }

    @Deprecated(message="banksDataFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getBanksDataFile$annotations() {
    }

    @Deprecated(message="barcodeScanningModel is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getBarcodeScanningModelFile$annotations() {
    }

    @Deprecated(message="barcodeBinarizationModel is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getBarcodeBinarizationModelFile$annotations() {
    }

    @Deprecated(message="blurEstimatorModel file is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getBlurEstimatorModelFile$annotations() {
    }

    @Deprecated(message="cascadeFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getMrzCascadeFile$annotations() {
    }

    @Deprecated(message="mrzTrainedData is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getMrzTrainedDataFile$annotations() {
    }

    @Deprecated(message="filterPredictionModelFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getFilterPredictionModelFile$annotations() {
    }

    @Deprecated(message="check_digit_model files are outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getCheckDigitPredictionModelFile$annotations() {
    }

    @Deprecated(message="dc_forms_models files are outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getDcModelsFolderFile$annotations() {
    }

    @Deprecated(message="idCardScannerModelsFolderFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getIdCardScannerModelsFolderFile$annotations() {
    }

    @Deprecated(message="textPatternScannerModelsFolderFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getTextPatternScannerModelsFolderFile$annotations() {
    }

    @Deprecated(message="documentDetectorModelFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getDocumentDetectorModelFile$annotations() {
    }

    @Deprecated(message="imageProcessorModelsFolderFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getImageProcessorModelsFolderFile$annotations() {
    }
}

