/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.os.Build;
import android.util.Pair;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.internal.CamcorderProfileHelper;
import androidx.camera.camera2.internal.CameraUnavailableExceptionHelper;
import androidx.camera.camera2.internal.DisplayInfoManager;
import androidx.camera.camera2.internal.SupportedSurfaceCombination;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.camera2.internal.compat.workaround.ExcludedSupportedSizesContainer;
import androidx.camera.camera2.internal.compat.workaround.ExtraSupportedSurfaceCombinationsContainer;
import androidx.camera.camera2.internal.compat.workaround.ResolutionCorrector;
import androidx.camera.camera2.internal.compat.workaround.TargetAspectRatio;
import androidx.camera.core.CameraUnavailableException;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.SurfaceCombination;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.SurfaceSizeDefinition;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.utils.CameraOrientationUtil;
import androidx.camera.core.impl.utils.CompareSizesByArea;
import androidx.core.util.Preconditions;
import io.scanbot.sdk.scanbotsdkcamera.g;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@RequiresApi(value=21)
@SuppressLint(value={"RestrictedApi"})
public final class a {
    public static final String q = "SupportedSurfaceCombination";
    public static final Size r = new Size(640, 480);
    public static final Size s = new Size(0, 0);
    public static final Size t = new Size(1920, 1080);
    public static final Size u = new Size(720, 480);
    public static final int v = 16;
    public static final Rational w = new Rational(4, 3);
    public static final Rational x = new Rational(3, 4);
    public static final Rational y = new Rational(16, 9);
    public static final Rational z = new Rational(9, 16);
    public final List<SurfaceCombination> a;
    public final Map<Integer, Size> b;
    public final String c;
    public final CamcorderProfileHelper d;
    public final CameraCharacteristicsCompat e;
    public final ExcludedSupportedSizesContainer f;
    public final ExtraSupportedSurfaceCombinationsContainer g;
    public final int h;
    public final boolean i;
    public final Map<Integer, List<Size>> j;
    public boolean k;
    public boolean l;
    public SurfaceSizeDefinition m;
    public Map<Integer, Size[]> n;
    @NonNull
    public final DisplayInfoManager o;
    public final ResolutionCorrector p;

    /*
     * WARNING - void declaration
     */
    public a(@NonNull Context context, @NonNull String cameraId, @NonNull CameraManagerCompat cameraManagerCompat, @NonNull CamcorderProfileHelper camcorderProfileHelper) throws CameraUnavailableException {
        int n2;
        block6: {
            block5: {
                CameraCharacteristicsCompat cameraCharacteristicsCompat;
                void var4_5;
                void var2_3;
                Object object;
                void v0 = object;
                a a2 = this;
                this.a = new ArrayList<SurfaceCombination>();
                this.b = new HashMap<Integer, Size>();
                this.j = new HashMap<Integer, List<Size>>();
                this.k = false;
                this.l = false;
                this.n = new HashMap<Integer, Size[]>();
                this.p = new ResolutionCorrector();
                object = (String)Preconditions.checkNotNull((Object)var2_3);
                this.c = object;
                a2.d = (CamcorderProfileHelper)Preconditions.checkNotNull((Object)var4_5);
                a2.f = new ExcludedSupportedSizesContainer((String)var2_3);
                a2.g = new ExtraSupportedSurfaceCombinationsContainer();
                this.o = DisplayInfoManager.getInstance((Context)v0);
                try {
                    cameraCharacteristicsCompat = cameraManagerCompat.getCameraCharacteristicsCompat((String)object);
                }
                catch (CameraAccessExceptionCompat cameraAccessExceptionCompat) {
                    throw CameraUnavailableExceptionHelper.createFrom((CameraAccessExceptionCompat)cameraAccessExceptionCompat);
                }
                this.e = cameraCharacteristicsCompat;
                object = (Integer)cameraCharacteristicsCompat.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
                if (object == null) break block5;
                n2 = (Integer)object;
                break block6;
            }
            n2 = 2;
        }
        a a3 = this;
        a3.h = n2;
        a3.i = a3.p();
        a3.b();
        a3.c();
        a3.a();
    }

    /*
     * WARNING - void declaration
     */
    public final Rational a(@NonNull ImageOutputConfig imageOutputConfig) {
        TargetAspectRatio targetAspectRatio;
        Object object = null;
        Object object2 = targetAspectRatio;
        a a2 = a3;
        object2();
        object2 = a2.c;
        switch (targetAspectRatio.get((String)object2, a2.e)) {
            default: {
                break;
            }
            case 3: {
                Rational rational;
                a a3;
                void var1_3;
                object2 = a3.b((ImageOutputConfig)var1_3);
                if (var1_3.hasTargetAspectRatio()) {
                    int n2 = var1_3.getTargetAspectRatio();
                    if (n2 != 0) {
                        if (n2 != 1) {
                            Logger.e((String)q, (String)("Undefined target aspect ratio: " + n2));
                            break;
                        }
                        a3 = a3.i ? y : z;
                    } else {
                        a3 = a3.i ? w : x;
                    }
                    object = a3;
                    break;
                }
                if (object2 == null) break;
                object = rational;
                Object object3 = object2;
                int n3 = object3.getWidth();
                rational = new Rational(n3, object3.getHeight());
                break;
            }
            case 2: {
                Rational rational;
                a a3 = a3.c(256);
                object = rational;
                a a4 = a3;
                int n4 = a4.getWidth();
                rational = new Rational(n4, a4.getHeight());
                break;
            }
            case 1: {
                a a3;
                if (a3.i) {
                    a3 = y;
                    object = a3;
                    break;
                }
                a3 = z;
                object = a3;
                break;
            }
            case 0: {
                a a3;
                if (a3.i) {
                    a3 = w;
                    object = a3;
                    break;
                }
                a3 = x;
                object = a3;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public final Size c(int imageFormat) {
        void var1_1;
        Size size = this.b.get((int)var1_1);
        if (size != null) {
            return size;
        }
        size = this.f((int)var1_1);
        this.b.put((int)var1_1, size);
        return size;
    }

    /*
     * WARNING - void declaration
     */
    public final List<Integer> c(List<UseCaseConfig<?>> newUseCaseConfigs) {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3 = arrayList2;
        arrayList2 = new ArrayList();
        Object object = arrayList;
        arrayList = new ArrayList();
        Iterator<UseCaseConfig<?>> iterator = newUseCaseConfigs.iterator();
        while (iterator.hasNext()) {
            int n2 = iterator.next().getSurfaceOccupancyPriority(0);
            if (((ArrayList)object).contains(n2)) continue;
            ((ArrayList)object).add(n2);
        }
        ArrayList arrayList4 = object;
        Collections.sort(arrayList4);
        Collections.reverse(arrayList4);
        object = arrayList4.iterator();
        while (object.hasNext()) {
            void var1_1;
            int n3 = (Integer)object.next();
            for (UseCaseConfig useCaseConfig : var1_1) {
                if (n3 != useCaseConfig.getSurfaceOccupancyPriority(0)) continue;
                arrayList3.add(var1_1.indexOf(useCaseConfig));
            }
        }
        return arrayList3;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public final SurfaceConfig.ConfigType e(int imageFormat) {
        void var1_1;
        if (imageFormat == 35) {
            return SurfaceConfig.ConfigType.YUV;
        }
        if (var1_1 == 256) {
            return SurfaceConfig.ConfigType.JPEG;
        }
        if (var1_1 == 32) {
            return SurfaceConfig.ConfigType.RAW;
        }
        return SurfaceConfig.ConfigType.PRIV;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Size b(@NonNull ImageOutputConfig imageOutputConfig) {
        void var1_2;
        void v0 = var1_2;
        int n2 = v0.getTargetRotation(0);
        return this.a(v0.getTargetResolution(null), n2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Size a(@Nullable Size size, int targetRotation) {
        a a2;
        void var2_3;
        if (size != null && a3.h((int)var2_3)) {
            Size size2;
            a a3 = size2;
            void v1 = a2;
            int n2 = v1.getHeight();
            size2 = new Size(n2, v1.getWidth());
            a2 = a3;
        }
        return a2;
    }

    public final boolean h(int targetRotation) {
        int n2;
        a a2 = this_;
        Integer this_ = (Integer)((a)((Object)this_)).e.get(CameraCharacteristics.SENSOR_ORIENTATION);
        Preconditions.checkNotNull((Object)this_, (Object)"Camera HAL in bad state, unable to retrieve the SENSOR_ORIENTATION");
        n2 = CameraOrientationUtil.surfaceRotationToDegrees((int)n2);
        Integer n3 = (Integer)a2.e.get(CameraCharacteristics.LENS_FACING);
        Preconditions.checkNotNull((Object)n3, (Object)"Camera HAL in bad state, unable to retrieve the LENS_FACING");
        boolean bl = 1 == n3;
        int n4 = CameraOrientationUtil.getRelativeImageRotation((int)n2, (int)this_, (boolean)bl);
        return n4 == 90 || n4 == 270;
    }

    public final boolean p() {
        a this_ = (Size)this_.e.get(CameraCharacteristics.SENSOR_INFO_PIXEL_ARRAY_SIZE);
        return this_ == null || this_.getWidth() >= this_.getHeight();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean a(Size resolution, Rational aspectRatio) {
        boolean bl = false;
        if (aspectRatio == null) {
            bl = false;
        } else {
            void var1_1;
            Size size;
            Size size2 = size;
            int n2 = size2.getWidth();
            if (var1_1.equals((Object)new Rational(n2, size2.getHeight()))) {
                bl = true;
            } else if (androidx.camera.camera2.internal.a.a(size) >= androidx.camera.camera2.internal.a.a(r)) {
                bl = androidx.camera.camera2.internal.a.b(size, (Rational)var1_1);
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean b(Size resolution, Rational aspectRatio) {
        void var1_2;
        Rational rational;
        Size size;
        int n2 = resolution.getWidth();
        int n3 = size.getHeight();
        Rational rational2 = rational;
        void v1 = var1_2;
        int n4 = v1.getDenominator();
        rational = new Rational(n4, v1.getNumerator());
        n4 = n2 % 16;
        if (n4 == 0 && n3 % 16 == 0) {
            return androidx.camera.camera2.internal.a.a(Math.max(0, n3 - 16), n2, (Rational)var1_2) || androidx.camera.camera2.internal.a.a(Math.max(0, n2 - 16), n3, rational2);
        }
        if (n4 == 0) {
            return androidx.camera.camera2.internal.a.a(n3, n2, (Rational)var1_2);
        }
        if (n3 % 16 == 0) {
            return androidx.camera.camera2.internal.a.a(n2, n3, rational2);
        }
        return false;
    }

    public static int a(Size size) {
        Size size2 = size;
        int n2 = size2.getWidth();
        return size2.getHeight() * n2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean a(int height, int mod16Width, Rational aspectRatio) {
        void var1_1;
        double d2;
        int n2;
        void var2_2;
        Preconditions.checkArgument((mod16Width % 16 == 0 ? 1 : 0) != 0);
        double d3 = (double)(var2_2.getNumerator() * n2) / (double)var2_2.getDenominator();
        return d2 > (double)Math.max(0, (int)(var1_1 - 16)) && d3 < (double)(var1_1 + 16);
    }

    public final Map<Rational, List<Size>> d(List<Size> sizes) {
        Size size;
        Size size2;
        HashMap<Rational, Size> hashMap;
        HashMap<Rational, Size> hashMap2 = hashMap;
        Object object = w;
        Size size32 = size2;
        size2 = new ArrayList();
        new HashMap<Rational, Size>().put((Rational)object, size32);
        object = y;
        size32 = size;
        size = new ArrayList();
        hashMap2.put((Rational)object, size32);
        for (Size size32 : sizes) {
            ArrayList<Size> arrayList;
            List list = null;
            for (Rational rational : hashMap2.keySet()) {
                if (!androidx.camera.camera2.internal.a.a(size32, rational)) continue;
                list = (List)hashMap2.get(rational);
                if (!list.contains(size32)) {
                    list.add(size32);
                }
                list = rational;
            }
            if (list != null) continue;
            Size size4 = size32;
            int n2 = size4.getWidth();
            list = arrayList;
            arrayList = new ArrayList<Size>(Collections.singleton(size32));
            hashMap2.put(new Rational(n2, size4.getHeight()), (Size)list);
        }
        return hashMap2;
    }

    /*
     * WARNING - void declaration
     */
    public final void a(List<Size> supportedSizesList, Size targetSize) {
        void var1_2;
        if (supportedSizesList != null && !var1_2.isEmpty()) {
            void var2_3;
            Size size;
            int n2;
            ArrayList<Size> arrayList;
            int n3 = -1;
            ArrayList<Size> arrayList2 = arrayList;
            arrayList = new ArrayList<Size>();
            int n4 = n2 = 0;
            n2 = n3;
            n3 = n4;
            while (n3 < var1_2.size() && (size = (Size)var1_2.get(n3)).getWidth() >= var2_3.getWidth() && size.getHeight() >= var2_3.getHeight()) {
                if (n2 >= 0) {
                    arrayList2.add((Size)var1_2.get(n2));
                }
                int n5 = n2 = n3 + 1;
                n2 = n3;
                n3 = n5;
            }
            var1_2.removeAll(arrayList2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final List<List<Size>> b(List<List<Size>> supportedOutputSizesList) {
        int n2 = 1;
        Object object = supportedOutputSizesList.iterator();
        while (object.hasNext()) {
            n2 = object.next().size() * n2;
        }
        if (n2 != 0) {
            void var1_2;
            int n3;
            ArrayList arrayList;
            object = arrayList;
            arrayList = new ArrayList();
            for (n3 = 0; n3 < n2; ++n3) {
                ArrayList arrayList2;
                ArrayList arrayList3 = arrayList2;
                arrayList2 = new ArrayList();
                ((ArrayList)object).add(arrayList3);
            }
            n3 = n2 / ((List)var1_2.get(0)).size();
            int n4 = n2;
            for (int i2 = 0; i2 < var1_2.size(); ++i2) {
                List list = (List)var1_2.get(i2);
                for (int i3 = 0; i3 < n2; ++i3) {
                    ((List)((ArrayList)object).get(i3)).add((Size)list.get(i3 % n4 / n3));
                }
                if (i2 < var1_2.size() - 1) {
                    n4 = n3 / ((List)var1_2.get(i2 + 1)).size();
                } else {
                    int n5 = n4;
                    n4 = n3;
                    n3 = n5;
                }
                int n6 = n3;
                n3 = n4;
                n4 = n6;
            }
            return object;
        }
        throw new IllegalArgumentException("Failed to find supported resolutions.");
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public final Size[] a(@NonNull Size[] outputSizes, int imageFormat) {
        void var1_1;
        void var2_2;
        List<Size> this_ = ((a)((Object)this_)).b((int)var2_2);
        ArrayList<Size> arrayList = new ArrayList<Size>(Arrays.asList(var1_1));
        arrayList.removeAll(this_);
        return arrayList.toArray(new Size[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Size[] a(int imageFormat, @NonNull ImageOutputConfig config) {
        void var1_1;
        Size[] sizeArray = null;
        Object object = config.getSupportedResolutions(null);
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                Pair pair = (Pair)object.next();
                if (((Integer)pair.first).intValue() != var1_1) continue;
                sizeArray = (Size[])pair.second;
                break;
            }
        }
        if (sizeArray != null) {
            CompareSizesByArea compareSizesByArea;
            sizeArray = a2.a(sizeArray, (int)var1_1);
            a a2 = compareSizesByArea;
            compareSizesByArea = new CompareSizesByArea(true);
            Arrays.sort(sizeArray, a2);
        }
        return sizeArray;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public final Size[] d(int imageFormat) {
        void var1_1;
        Size[] sizeArray = this.n.get((int)var1_1);
        if (sizeArray == null) {
            a a2 = this;
            sizeArray = a2.a((int)var1_1);
            a2.n.put((int)var1_1, sizeArray);
        }
        return sizeArray;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public final Size[] a(int imageFormat) {
        Size[] sizeArray = (Size[])this_.e.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        if (sizeArray != null) {
            void var1_1;
            sizeArray = Build.VERSION.SDK_INT < 23 && var1_1 == 34 ? sizeArray.getOutputSizes(SurfaceTexture.class) : sizeArray.getOutputSizes((int)var1_1);
            if (sizeArray != null) {
                CompareSizesByArea compareSizesByArea;
                Size[] sizeArray2 = this_.a(sizeArray, (int)var1_1);
                a this_ = compareSizesByArea;
                compareSizesByArea = new CompareSizesByArea(true);
                Arrays.sort(sizeArray2, this_);
                return sizeArray2;
            }
            throw new IllegalArgumentException("Can not get supported output size for the format: " + (int)var1_1);
        }
        throw new IllegalArgumentException("Can not retrieve SCALER_STREAM_CONFIGURATION_MAP");
    }

    public final void b() {
        int[] nArray;
        a a2 = this_;
        a2.a.addAll(((a)((Object)this_)).g());
        int n2 = a2.h;
        if (n2 == 0 || n2 == 1 || n2 == 3) {
            ((a)((Object)this_)).a.addAll(((a)((Object)this_)).i());
        }
        if ((n2 = ((a)((Object)this_)).h) == 1 || n2 == 3) {
            ((a)((Object)this_)).a.addAll(((a)((Object)this_)).f());
        }
        if ((nArray = (int[])((a)((Object)this_)).e.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES)) != null) {
            for (int n3 : nArray) {
                if (n3 == 3) {
                    ((a)((Object)this_)).k = true;
                    continue;
                }
                if (n3 != 6) continue;
                ((a)((Object)this_)).l = true;
            }
        }
        if (((a)((Object)this_)).k) {
            ((a)((Object)this_)).a.addAll(((a)((Object)this_)).j());
        }
        if (((a)((Object)this_)).l && ((a)((Object)this_)).h == 0) {
            ((a)((Object)this_)).a.addAll(((a)((Object)this_)).d());
        }
        if (((a)((Object)this_)).h == 3) {
            ((a)((Object)this_)).a.addAll(((a)((Object)this_)).h());
        }
        a a3 = this_;
        String this_ = a3.c;
        ((a)((Object)this_)).a.addAll(((a)((Object)this_)).g.get(this_, a3.h));
    }

    public final void a() {
    }

    public final void c() {
        Size size;
        a a2 = this_;
        a this_ = size;
        size = new Size(1920, 1080);
        a2.m = SurfaceSizeDefinition.create((Size)new Size(640, 480), (Size)this_, (Size)this_.k());
    }

    public final void q() {
        a a2 = this_;
        a2.o.refresh();
        if (a2.m == null) {
            this_.c();
        } else {
            Size size;
            a a3 = this_;
            a this_ = size;
            size = new Size(1920, 1080);
            Size size2 = a3.m.getRecordSize();
            a3.m = SurfaceSizeDefinition.create((Size)a3.m.getAnalysisSize(), (Size)this_, (Size)size2);
        }
    }

    @NonNull
    public final Size k() {
        CamcorderProfile camcorderProfile;
        int n2;
        block3: {
            try {
                a a2 = this;
                n2 = Integer.parseInt(a2.c);
                camcorderProfile = null;
                if (!a2.d.hasProfile(n2, 1)) break block3;
            }
            catch (NumberFormatException numberFormatException) {
                return this.l();
            }
            camcorderProfile = this.d.get(n2, 1);
        }
        if (camcorderProfile != null) {
            CamcorderProfile camcorderProfile2 = camcorderProfile;
            int n3 = camcorderProfile2.videoFrameWidth;
            return new Size(n3, camcorderProfile2.videoFrameHeight);
        }
        return this.g(n2);
    }

    @NonNull
    public final Size l() {
        StreamConfigurationMap this_ = (StreamConfigurationMap)this_.e.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        if (this_ != null) {
            CompareSizesByArea compareSizesByArea;
            if ((this_ = this_.getOutputSizes(MediaRecorder.class)) == null) {
                return u;
            }
            CompareSizesByArea compareSizesByArea2 = compareSizesByArea;
            compareSizesByArea = new CompareSizesByArea(true);
            Arrays.sort(this_, compareSizesByArea2);
            for (Size size : this_) {
                Size size2 = t;
                if (size.getWidth() > size2.getWidth() || size.getHeight() > size2.getHeight()) continue;
                return size;
            }
            return u;
        }
        throw new IllegalArgumentException("Can not retrieve SCALER_STREAM_CONFIGURATION_MAP");
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public final Size g(int cameraId) {
        void var1_2;
        Size size = u;
        CamcorderProfile camcorderProfile = null;
        if (this.d.hasProfile((int)var1_2, 10)) {
            camcorderProfile = this.d.get((int)var1_2, 10);
        } else if (this.d.hasProfile((int)var1_2, 8)) {
            camcorderProfile = this.d.get((int)var1_2, 8);
        } else if (this.d.hasProfile((int)var1_2, 12)) {
            camcorderProfile = this.d.get((int)var1_2, 12);
        } else if (this.d.hasProfile((int)var1_2, 6)) {
            camcorderProfile = this.d.get((int)var1_2, 6);
        } else if (this.d.hasProfile((int)var1_2, 5)) {
            camcorderProfile = this.d.get((int)var1_2, 5);
        } else if (this.d.hasProfile((int)var1_2, 4)) {
            camcorderProfile = this.d.get((int)var1_2, 4);
        }
        if (camcorderProfile != null) {
            Size size2;
            size = size2;
            CamcorderProfile camcorderProfile2 = camcorderProfile;
            int n2 = camcorderProfile2.videoFrameWidth;
            size2 = new Size(n2, camcorderProfile2.videoFrameHeight);
        }
        return size;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public final List<Size> b(int imageFormat) {
        void var1_1;
        List list = this.j.get((int)var1_1);
        if (list == null) {
            a a2 = this;
            list = a2.f.get((int)var1_1);
            a2.j.put((int)var1_1, list);
        }
        return list;
    }

    public String e() {
        return this.c;
    }

    public boolean o() {
        return this.k;
    }

    public boolean n() {
        return this.l;
    }

    /*
     * WARNING - void declaration
     */
    public boolean a(List<SurfaceConfig> surfaceConfigList) {
        void var1_2;
        boolean bl = false;
        Iterator<SurfaceCombination> iterator = this.a.iterator();
        while (iterator.hasNext() && !(bl = iterator.next().isSupported((List)var1_2))) {
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public SurfaceConfig a(int imageFormat, Size size) {
        void var1_2;
        Size size2 = size;
        SurfaceConfig.ConfigType configType = this.e((int)var1_2);
        SurfaceConfig.ConfigSize configSize = SurfaceConfig.ConfigSize.NOT_SUPPORT;
        Size size3 = this.c((int)var1_2);
        int n2 = size2.getWidth();
        int n3 = size2.getHeight() * n2;
        a a2 = this;
        n2 = a2.m.getAnalysisSize().getWidth();
        if (n3 <= a2.m.getAnalysisSize().getHeight() * n2) {
            configSize = SurfaceConfig.ConfigSize.ANALYSIS;
        } else {
            void var2_4;
            void v3 = var2_4;
            n2 = v3.getWidth();
            int n4 = v3.getHeight() * n2;
            a a3 = this;
            n2 = a3.m.getPreviewSize().getWidth();
            if (n4 <= a3.m.getPreviewSize().getHeight() * n2) {
                configSize = SurfaceConfig.ConfigSize.PREVIEW;
            } else {
                void v6 = var2_4;
                n2 = v6.getWidth();
                a a4 = this;
                int n5 = a4.m.getRecordSize().getWidth();
                if (v6.getHeight() * n2 <= a4.m.getRecordSize().getHeight() * n5) {
                    configSize = SurfaceConfig.ConfigSize.RECORD;
                } else {
                    void v8 = var2_4;
                    n5 = v8.getWidth();
                    int n6 = v8.getHeight() * n5;
                    Size size4 = size3;
                    n5 = size4.getWidth();
                    if (n6 <= size4.getHeight() * n5) {
                        configSize = SurfaceConfig.ConfigSize.MAXIMUM;
                    }
                }
            }
        }
        return SurfaceConfig.create((SurfaceConfig.ConfigType)configType, (SurfaceConfig.ConfigSize)configSize);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Map<UseCaseConfig<?>, Size> a(@NonNull List<SurfaceConfig> existingSurfaces, @NonNull List<UseCaseConfig<?>> newUseCaseConfigs) {
        void var2_2;
        void var1_1;
        ArrayList<SurfaceConfig> arrayList;
        this.q();
        List<Object> list = arrayList;
        arrayList = new ArrayList<SurfaceConfig>((Collection<SurfaceConfig>)var1_1);
        Object object = newUseCaseConfigs.iterator();
        while (object.hasNext()) {
            ((ArrayList)list).add(this.a(object.next().getInputFormat(), new Size(640, 480)));
        }
        if (this.a(list)) {
            ArrayList arrayList2;
            list = this.c((List<UseCaseConfig<?>>)var2_2);
            object = arrayList2;
            arrayList2 = new ArrayList();
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                ((ArrayList)object).add(this.a((UseCaseConfig)var2_2.get(iterator.next())));
            }
            List<List<Size>> list2 = this.b((List<List<Size>>)object);
            object = null;
            iterator = list2.iterator();
            while (iterator.hasNext()) {
                HashMap hashMap;
                UseCaseConfig useCaseConfig;
                List list3 = (List)iterator.next();
                UseCaseConfig useCaseConfig22 = useCaseConfig;
                useCaseConfig = new ArrayList(var1_1);
                for (int i2 = 0; i2 < list3.size(); ++i2) {
                    Size size = (Size)list3.get(i2);
                    useCaseConfig22.add((SurfaceConfig)this.a(((UseCaseConfig)var2_2.get((Integer)list.get(i2))).getInputFormat(), size));
                }
                if (!this.a((List<SurfaceConfig>)useCaseConfig22)) continue;
                object = hashMap;
                hashMap = new HashMap();
                for (UseCaseConfig useCaseConfig22 : var2_2) {
                    ((HashMap)object).put(useCaseConfig22, (Size)list3.get(list.indexOf(var2_2.indexOf(useCaseConfig22))));
                }
            }
            if (object != null) {
                return object;
            }
            throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.c + " and Hardware level: " + this.h + ". May be the specified resolution is too large and not supported. Existing surfaces: " + var1_1 + " New configs: " + var2_2);
        }
        throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.c + ".  May be attempting to bind too many use cases. Existing surfaces: " + var1_1 + " New configs: " + var2_2);
    }

    @VisibleForTesting
    public SurfaceSizeDefinition m() {
        return this.m;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    @VisibleForTesting
    public List<Size> a(@NonNull UseCaseConfig<?> config) {
        ArrayList<Size> arrayList;
        Object object;
        void var1_1;
        void v0 = var1_1;
        int n2 = v0.getInputFormat();
        Object object2 = this.a(n2, (ImageOutputConfig)(object = (ImageOutputConfig)v0));
        if (object2 == null) {
            object2 = this.d(n2);
        }
        Iterator iterator = arrayList;
        arrayList = new ArrayList<Size>();
        Size size5 = object.getMaxResolution(null);
        Size size2 = this.f(n2);
        if (size5 == null || androidx.camera.camera2.internal.a.a(size2) < androidx.camera.camera2.internal.a.a(size5)) {
            size5 = size2;
        }
        Arrays.sort(object2, new CompareSizesByArea(true));
        size2 = this.b((ImageOutputConfig)object);
        Size size3 = r;
        int n3 = androidx.camera.camera2.internal.a.a(size3);
        if (androidx.camera.camera2.internal.a.a(size5) < n3) {
            size3 = s;
        } else if (size2 != null && androidx.camera.camera2.internal.a.a(size2) < n3) {
            size3 = size2;
        }
        for (Size size4 : object2) {
            if (androidx.camera.camera2.internal.a.a(size4) > androidx.camera.camera2.internal.a.a(size5) || androidx.camera.camera2.internal.a.a(size4) < androidx.camera.camera2.internal.a.a(size3) || ((ArrayList)((Object)iterator)).contains(size4)) continue;
            ((ArrayList)((Object)iterator)).add(size4);
        }
        if (!((ArrayList)((Object)iterator)).isEmpty()) {
            ArrayList arrayList2;
            Object object3 = this.a((ImageOutputConfig)object);
            if (size2 == null) {
                size2 = object.getDefaultResolution(null);
            }
            object = arrayList2;
            arrayList2 = new ArrayList();
            new HashMap();
            if (object3 == null) {
                ((ArrayList)object).addAll(iterator);
                if (size2 != null) {
                    this.a((List<Size>)object, size2);
                }
            } else {
                object2 = this.d((List<Size>)((Object)iterator));
                if (size2 != null) {
                    iterator = object2.keySet().iterator();
                    while (iterator.hasNext()) {
                        this.a((List)object2.get((Rational)iterator.next()), size2);
                    }
                }
                ArrayList arrayList3 = new ArrayList(object2.keySet());
                Collections.sort(arrayList3, new SupportedSurfaceCombination.CompareAspectRatiosByDistanceToTargetRatio((Rational)object3));
                object3 = arrayList3.iterator();
                while (object3.hasNext()) {
                    for (Size size5 : (List)object2.get((Rational)object3.next())) {
                        if (((ArrayList)object).contains(size5)) continue;
                        ((ArrayList)object).add(size5);
                    }
                }
            }
            return this.p.insertOrPrioritize(this.e(var1_1.getInputFormat()), (List)object);
        }
        throw new IllegalArgumentException("Can not get supported output size under supported maximum for the format: " + n2);
    }

    /*
     * WARNING - void declaration
     */
    public Size f(int imageFormat) {
        void var1_1;
        return Collections.max(Arrays.asList(this.d((int)var1_1)), new CompareSizesByArea());
    }

    public List<SurfaceCombination> g() {
        SurfaceCombination surfaceCombination;
        ArrayList<SurfaceCombination> arrayList;
        ArrayList<SurfaceCombination> arrayList2 = arrayList;
        arrayList = new ArrayList<SurfaceCombination>();
        SurfaceCombination surfaceCombination2 = surfaceCombination;
        surfaceCombination = new SurfaceCombination();
        surfaceCombination2 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.PRIV, SurfaceConfig.ConfigSize.MAXIMUM, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination2 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.JPEG, SurfaceConfig.ConfigSize.MAXIMUM, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination2 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.YUV, SurfaceConfig.ConfigSize.MAXIMUM, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.JPEG, SurfaceConfig.ConfigSize.MAXIMUM, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.JPEG, SurfaceConfig.ConfigSize.MAXIMUM, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.PRIV, SurfaceConfig.ConfigSize.PREVIEW, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        SurfaceCombination surfaceCombination3 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.YUV, SurfaceConfig.ConfigSize.PREVIEW, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        arrayList.add(surfaceCombination3);
        return arrayList;
    }

    public List<SurfaceCombination> i() {
        SurfaceCombination surfaceCombination;
        ArrayList<SurfaceCombination> arrayList;
        ArrayList<SurfaceCombination> arrayList2 = arrayList;
        arrayList = new ArrayList<SurfaceCombination>();
        SurfaceCombination surfaceCombination2 = surfaceCombination;
        new SurfaceCombination().addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.PRIV, SurfaceConfig.ConfigSize.RECORD, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.YUV, SurfaceConfig.ConfigSize.RECORD, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.YUV, SurfaceConfig.ConfigSize.RECORD, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.RECORD));
        surfaceCombination2 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.JPEG, SurfaceConfig.ConfigSize.RECORD, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.RECORD));
        SurfaceCombination surfaceCombination3 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.JPEG, SurfaceConfig.ConfigSize.RECORD, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        arrayList.add(surfaceCombination3);
        return arrayList;
    }

    public List<SurfaceCombination> f() {
        SurfaceCombination surfaceCombination;
        ArrayList<SurfaceCombination> arrayList;
        ArrayList<SurfaceCombination> arrayList2 = arrayList;
        arrayList = new ArrayList<SurfaceCombination>();
        SurfaceCombination surfaceCombination2 = surfaceCombination;
        new SurfaceCombination().addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.PRIV, SurfaceConfig.ConfigSize.MAXIMUM, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.YUV, SurfaceConfig.ConfigSize.MAXIMUM, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.YUV, SurfaceConfig.ConfigSize.MAXIMUM, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.JPEG, SurfaceConfig.ConfigSize.MAXIMUM, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.ANALYSIS));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        SurfaceCombination surfaceCombination3 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.YUV, SurfaceConfig.ConfigSize.MAXIMUM, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.ANALYSIS));
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        arrayList.add(surfaceCombination3);
        return arrayList;
    }

    public List<SurfaceCombination> j() {
        SurfaceCombination surfaceCombination;
        ArrayList<SurfaceCombination> arrayList;
        ArrayList<SurfaceCombination> arrayList2 = arrayList;
        arrayList = new ArrayList<SurfaceCombination>();
        SurfaceCombination surfaceCombination2 = surfaceCombination;
        surfaceCombination = new SurfaceCombination();
        surfaceCombination2 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.RAW, SurfaceConfig.ConfigSize.MAXIMUM, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.RAW, SurfaceConfig.ConfigSize.MAXIMUM, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.RAW, SurfaceConfig.ConfigSize.MAXIMUM, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.RAW, SurfaceConfig.ConfigSize.MAXIMUM, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.RAW, SurfaceConfig.ConfigSize.MAXIMUM, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.RAW, SurfaceConfig.ConfigSize.MAXIMUM, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        SurfaceCombination surfaceCombination3 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.RAW, SurfaceConfig.ConfigSize.MAXIMUM, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.RAW, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        arrayList.add(surfaceCombination3);
        return arrayList;
    }

    public List<SurfaceCombination> d() {
        SurfaceCombination surfaceCombination;
        ArrayList<SurfaceCombination> arrayList;
        ArrayList<SurfaceCombination> arrayList2 = arrayList;
        arrayList = new ArrayList<SurfaceCombination>();
        SurfaceCombination surfaceCombination2 = surfaceCombination;
        new SurfaceCombination().addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.PRIV, SurfaceConfig.ConfigSize.MAXIMUM, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        SurfaceCombination surfaceCombination3 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.YUV, SurfaceConfig.ConfigSize.MAXIMUM, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        arrayList.add(surfaceCombination3);
        return arrayList;
    }

    public List<SurfaceCombination> h() {
        SurfaceCombination surfaceCombination;
        ArrayList<SurfaceCombination> arrayList;
        ArrayList<SurfaceCombination> arrayList2 = arrayList;
        arrayList = new ArrayList<SurfaceCombination>();
        SurfaceCombination surfaceCombination2 = surfaceCombination;
        new SurfaceCombination().addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.ANALYSIS));
        surfaceCombination2.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.YUV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        SurfaceCombination surfaceCombination3 = io.scanbot.sdk.scanbotsdkcamera.g.a(SurfaceConfig.ConfigType.RAW, SurfaceConfig.ConfigSize.MAXIMUM, surfaceCombination2, arrayList2, surfaceCombination2);
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.PREVIEW));
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.PRIV, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.ANALYSIS));
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.JPEG, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        surfaceCombination3.addSurfaceConfig(SurfaceConfig.create((SurfaceConfig.ConfigType)SurfaceConfig.ConfigType.RAW, (SurfaceConfig.ConfigSize)SurfaceConfig.ConfigSize.MAXIMUM));
        arrayList.add(surfaceCombination3);
        return arrayList;
    }
}

