/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.exif;

import android.util.Log;
import com.android.mms.exif.ExifInterface;
import com.android.mms.exif.ExifTag;
import com.android.mms.exif.IfdData;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ExifData {
    private static final String TAG = "ExifData";
    private static final byte[] USER_COMMENT_ASCII = new byte[]{65, 83, 67, 73, 73, 0, 0, 0};
    private static final byte[] USER_COMMENT_JIS = new byte[]{74, 73, 83, 0, 0, 0, 0, 0};
    private static final byte[] USER_COMMENT_UNICODE = new byte[]{85, 78, 73, 67, 79, 68, 69, 0};
    private final IfdData[] mIfdDatas = new IfdData[5];
    private byte[] mThumbnail;
    private final ArrayList<byte[]> mStripBytes = new ArrayList();
    private final ByteOrder mByteOrder;

    /*
     * WARNING - void declaration
     */
    public ExifData(ByteOrder order) {
        void var1_1;
        this.mByteOrder = var1_1;
    }

    public byte[] getCompressedThumbnail() {
        return this.mThumbnail;
    }

    /*
     * WARNING - void declaration
     */
    public void setCompressedThumbnail(byte[] thumbnail) {
        void var1_1;
        this.mThumbnail = var1_1;
    }

    public boolean hasCompressedThumbnail() {
        return this.mThumbnail != null;
    }

    public void setStripBytes(int index, byte[] strip) {
        if (index < this.mStripBytes.size()) {
            this.mStripBytes.set((int)var1_1, (byte[])var2_2);
        } else {
            for (int i2 = this.mStripBytes.size(); i2 < var1_1; ++i2) {
                this.mStripBytes.add(null);
            }
            this.mStripBytes.add((byte[])var2_2);
        }
    }

    public int getStripCount() {
        return this.mStripBytes.size();
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getStrip(int index) {
        void var1_1;
        return this.mStripBytes.get((int)var1_1);
    }

    public boolean hasUncompressedStrip() {
        return this.mStripBytes.size() != 0;
    }

    public ByteOrder getByteOrder() {
        return this.mByteOrder;
    }

    /*
     * WARNING - void declaration
     */
    public IfdData getIfdData(int ifdId) {
        if (ExifTag.isValidIfd(ifdId)) {
            void var1_1;
            return this.mIfdDatas[var1_1];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void addIfdData(IfdData data) {
        void var1_1;
        this.mIfdDatas[var1_1.getId()] = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IfdData getOrCreateIfdData(int ifdId) {
        void var1_1;
        IfdData ifdData = this.mIfdDatas[var1_1];
        if (ifdData == null) {
            IfdData ifdData2;
            ifdData = ifdData2;
            ifdData2 = new IfdData((int)var1_1);
            this.mIfdDatas[var1_1] = ifdData;
        }
        return ifdData;
    }

    /*
     * WARNING - void declaration
     */
    public ExifTag getTag(short tag, int ifd) {
        void var1_1;
        void var2_2;
        IfdData this_ = ((ExifData)((Object)this_)).mIfdDatas[var2_2];
        return this_ == null ? null : this_.getTag((short)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ExifTag addTag(ExifTag tag) {
        if (tag != null) {
            void var1_1;
            void v0 = var1_1;
            return this.addTag((ExifTag)v0, v0.getIfd());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public ExifTag addTag(ExifTag tag, int ifdId) {
        void var2_2;
        if (tag != null && ExifTag.isValidIfd((int)var2_2)) {
            void var1_1;
            return this.getOrCreateIfdData((int)var2_2).setTag((ExifTag)var1_1);
        }
        return null;
    }

    public void clearThumbnailAndStrips() {
        this.mThumbnail = null;
        this.mStripBytes.clear();
    }

    public void removeThumbnailData() {
        ExifData exifData = this;
        exifData.clearThumbnailAndStrips();
        exifData.mIfdDatas[1] = null;
    }

    /*
     * WARNING - void declaration
     */
    public void removeTag(short tagId, int ifdId) {
        void var1_1;
        void var2_2;
        IfdData this_ = ((ExifData)((Object)this_)).mIfdDatas[var2_2];
        if (this_ == null) {
            return;
        }
        this_.removeTag((short)var1_1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getUserComment() {
        block10: {
            block11: {
                this = this.mIfdDatas[0];
                if (this == null) {
                    return null;
                }
                if ((this = this.getTag(ExifInterface.getTrueTagKey(ExifInterface.TAG_USER_COMMENT))) == null) {
                    return null;
                }
                if (this.getComponentCount() < 8) {
                    return null;
                }
                v0 = this;
                var0_1 = v0.getComponentCount();
                var1_2 = new byte[var0_1];
                v0.getBytes(var1_2);
                var2_3 = new byte[8];
                System.arraycopy(var1_2, 0, var2_3, 0, 8);
                try {
                    if (Arrays.equals(var2_3, ExifData.USER_COMMENT_ASCII)) {
                        v1 = var0_1;
                        var0_1 = 8;
                    }
                    ** GOTO lbl-1000
                }
                catch (UnsupportedEncodingException v2) {
                    break block10;
                }
                var2_4 = v1 - 8;
                {
                    var3_7 = "US-ASCII";
                    return new String(var1_2, var0_1, var2_4, var3_7);
                }
lbl-1000:
                // 1 sources

                {
                    if (!Arrays.equals(var2_3, ExifData.USER_COMMENT_JIS)) ** GOTO lbl31
                    v3 = var0_1;
                    var0_1 = 8;
                }
                var2_5 = v3 - 8;
                {
                    var3_8 = "EUC-JP";
                    return new String(var1_2, var0_1, var2_5, var3_8);
lbl31:
                    // 1 sources

                    if (!Arrays.equals(var2_3, ExifData.USER_COMMENT_UNICODE)) break block11;
                    v4 = var0_1;
                    var0_1 = 8;
                }
                var2_6 = v4 - 8;
                {
                    var3_9 = "UTF-16";
                    return new String(var1_2, var0_1, var2_6, var3_9);
                }
            }
            return null;
        }
        Log.w((String)"ExifData", (String)"Failed to decode the user comment");
        return null;
    }

    public List<ExifTag> getAllTags() {
        ArrayList arrayList;
        ExifData exifData = this_;
        ArrayList this_ = arrayList;
        arrayList = new ArrayList();
        IfdData[] ifdDataArray = exifData.mIfdDatas;
        int n2 = exifData.mIfdDatas.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ExifTag[] exifTagArray = ifdDataArray[i2];
            if (exifTagArray == null || (exifTagArray = exifTagArray.getAllTags()) == null) continue;
            int n3 = exifTagArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                this_.add(exifTagArray[i3]);
            }
        }
        if (this_.size() == 0) {
            return null;
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     */
    public List<ExifTag> getAllTagsForIfd(int ifd) {
        ArrayList<ExifTag> arrayList;
        void var1_1;
        Object this_ = this_.mIfdDatas[var1_1];
        if (this_ == null) {
            return null;
        }
        if ((this_ = this_.getAllTags()) == null) {
            return null;
        }
        ArrayList<ExifTag> arrayList2 = arrayList;
        arrayList = new ArrayList<ExifTag>(((ExifTag[])this_).length);
        int n2 = ((ExifTag[])this_).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList2.add(this_[i2]);
        }
        if (arrayList2.size() == 0) {
            return null;
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    public List<ExifTag> getAllTagsForTagId(short tag) {
        ArrayList arrayList;
        ExifData exifData = this_;
        ArrayList this_ = arrayList;
        arrayList = new ArrayList();
        IfdData[] ifdDataArray = exifData.mIfdDatas;
        int n2 = exifData.mIfdDatas.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            void var1_1;
            Object object = ifdDataArray[i2];
            if (object == null || (object = ((IfdData)object).getTag((short)var1_1)) == null) continue;
            this_.add(object);
        }
        if (this_.size() == 0) {
            return null;
        }
        return this_;
    }

    public boolean equals(Object obj) {
        ExifData exifData;
        if (this == exifData) {
            return true;
        }
        if (exifData == null) {
            return false;
        }
        if (exifData instanceof ExifData) {
            exifData = exifData;
            if (exifData.mByteOrder == this.mByteOrder && exifData.mStripBytes.size() == this.mStripBytes.size() && Arrays.equals(exifData.mThumbnail, this.mThumbnail)) {
                int n2;
                for (n2 = 0; n2 < this.mStripBytes.size(); ++n2) {
                    if (Arrays.equals(exifData.mStripBytes.get(n2), this.mStripBytes.get(n2))) continue;
                    return false;
                }
                for (n2 = 0; n2 < 5; ++n2) {
                    IfdData ifdData;
                    IfdData ifdData2 = exifData.getIfdData(n2);
                    if (ifdData2 == (ifdData = this.getIfdData(n2)) || ifdData2 == null || ifdData2.equals(ifdData)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

