/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.MediaRecorder;
import android.os.Build;
import android.util.Pair;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import androidx.camera.camera2.internal.CamcorderProfileHelper;
import androidx.camera.camera2.internal.CameraUnavailableExceptionHelper;
import androidx.camera.camera2.internal.DisplayInfoManager;
import androidx.camera.camera2.internal.DynamicRangeResolver;
import androidx.camera.camera2.internal.GuaranteedConfigurationsUtil;
import androidx.camera.camera2.internal.StreamUseCaseUtil;
import androidx.camera.camera2.internal.SupportedSurfaceCombination;
import androidx.camera.camera2.internal.VideoStabilizationUtil;
import androidx.camera.camera2.internal.b;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.camera2.internal.compat.workaround.ExtraSupportedSurfaceCombinationsContainer;
import androidx.camera.camera2.internal.compat.workaround.ResolutionCorrector;
import androidx.camera.camera2.internal.compat.workaround.TargetAspectRatio;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.AttachedSurfaceInfo;
import androidx.camera.core.impl.CameraMode;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.SurfaceCombination;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.SurfaceSizeDefinition;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.utils.AspectRatioUtil;
import androidx.camera.core.impl.utils.CompareSizesByArea;
import androidx.camera.core.internal.utils.SizeUtil;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class c {
    public final ArrayList a;
    public final ArrayList b;
    public final ArrayList c;
    public final ArrayList d;
    public final HashMap e;
    public final ArrayList f;
    public final ArrayList g;
    public final ArrayList h;
    public final String i;
    public final CamcorderProfileHelper j;
    public final CameraCharacteristicsCompat k;
    public final ExtraSupportedSurfaceCombinationsContainer l;
    public final int m;
    public final boolean n;
    public final boolean o;
    public final boolean p;
    public final boolean q;
    public final boolean r;
    public SurfaceSizeDefinition s;
    public final ArrayList t;
    public final DisplayInfoManager u;
    public final TargetAspectRatio v;
    public final ResolutionCorrector w;
    public final DynamicRangeResolver x;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public c(Context context, String object, CameraManagerCompat object2, CamcorderProfileHelper camcorderProfileHelper) {
        DynamicRangeResolver dynamicRangeResolver;
        int n2;
        ExtraSupportedSurfaceCombinationsContainer extraSupportedSurfaceCombinationsContainer;
        ResolutionCorrector resolutionCorrector;
        TargetAspectRatio targetAspectRatio;
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        ArrayList arrayList4;
        HashMap hashMap;
        ArrayList arrayList5;
        ArrayList arrayList6;
        ArrayList arrayList7;
        ArrayList arrayList8;
        CameraManagerCompat cameraManagerCompat = object2;
        String string = object;
        object = arrayList8;
        arrayList8 = new ArrayList();
        this.a = object;
        object = arrayList7;
        arrayList7 = new ArrayList();
        this.b = object;
        object = arrayList6;
        arrayList6 = new ArrayList();
        this.c = object;
        object = arrayList5;
        arrayList5 = new ArrayList();
        this.d = object;
        object = hashMap;
        hashMap = new HashMap();
        this.e = object;
        object = arrayList4;
        arrayList4 = new ArrayList();
        this.f = object;
        object = arrayList3;
        arrayList3 = new ArrayList();
        this.g = object;
        object = arrayList2;
        arrayList2 = new ArrayList();
        this.h = object;
        this.n = false;
        this.o = false;
        this.p = false;
        this.q = false;
        this.r = false;
        object = arrayList;
        arrayList = new ArrayList();
        this.t = object;
        object = targetAspectRatio;
        targetAspectRatio = new TargetAspectRatio();
        this.v = object;
        object = resolutionCorrector;
        resolutionCorrector = new ResolutionCorrector();
        this.w = object;
        this.i = object = (String)Preconditions.checkNotNull((Object)string);
        this.j = (CamcorderProfileHelper)Preconditions.checkNotNull((Object)camcorderProfileHelper);
        object2 = extraSupportedSurfaceCombinationsContainer;
        extraSupportedSurfaceCombinationsContainer = new ExtraSupportedSurfaceCombinationsContainer();
        this.l = object2;
        object2 = DisplayInfoManager.getInstance((Context)context);
        this.u = object2;
        try {
            object = cameraManagerCompat.getCameraCharacteristicsCompat((String)object);
        }
        catch (CameraAccessExceptionCompat cameraAccessExceptionCompat) {
            throw CameraUnavailableExceptionHelper.createFrom((CameraAccessExceptionCompat)cameraAccessExceptionCompat);
        }
        {
            this.k = object;
            object2 = (Integer)object.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
            n2 = object2 != null ? (Integer)object2 : 2;
        }
        this.m = n2;
        int[] nArray = (int[])object.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        object = nArray;
        if (nArray != null) {
            for (Object object3 : object) {
                if (object3 == 3) {
                    this.n = true;
                    continue;
                }
                if (object3 == 6) {
                    this.o = true;
                    continue;
                }
                if (Build.VERSION.SDK_INT < 31 || object3 != 16) continue;
                this.r = true;
            }
        }
        object = dynamicRangeResolver;
        dynamicRangeResolver = new DynamicRangeResolver(this.k);
        this.x = object;
        this.a.addAll(GuaranteedConfigurationsUtil.generateSupportedCombinationList((int)this.m, (boolean)this.n, (boolean)this.o));
        this.a.addAll(this.l.get(this.i));
        if (this.r) {
            this.b.addAll(GuaranteedConfigurationsUtil.getUltraHighResolutionSupportedCombinationList());
        }
        if (this.p = context.getPackageManager().hasSystemFeature("android.hardware.camera.concurrent")) {
            this.c.addAll(GuaranteedConfigurationsUtil.getConcurrentSupportedCombinationList());
        }
        if (object.is10BitDynamicRangeSupported()) {
            this.f.addAll(GuaranteedConfigurationsUtil.get10BitSupportedCombinationList());
        }
        if ((this.q = StreamUseCaseUtil.isStreamUseCaseSupported((CameraCharacteristicsCompat)this.k)) && Build.VERSION.SDK_INT >= 33) {
            this.h.addAll(GuaranteedConfigurationsUtil.getStreamUseCaseSupportedCombinationList());
        }
        if (VideoStabilizationUtil.isPreviewStabilizationSupported((CameraCharacteristicsCompat)this.k) && Build.VERSION.SDK_INT >= 33) {
            this.d.addAll(GuaranteedConfigurationsUtil.getPreviewStabilizationSupportedCombinationList());
        }
        this.a();
    }

    public static int a(CameraCharacteristicsCompat cameraCharacteristicsCompat, int n2, Size size) {
        int n3 = 0;
        try {
            n3 = (int)(1.0E9 / (double)((StreamConfigurationMap)cameraCharacteristicsCompat.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)).getOutputMinFrameDuration(n2, size));
        }
        catch (Exception exception) {}
        return n3;
    }

    public static int a(Range range) {
        return (Integer)range.getUpper() - (Integer)range.getLower() + 1;
    }

    public static int a(Range range, Range range2) {
        Preconditions.checkState((!range.contains((Comparable)((Integer)range2.getUpper())) && !range.contains((Comparable)((Integer)range2.getLower())) ? 1 : 0) != 0, (String)"Ranges must not intersect");
        if ((Integer)range.getLower() > (Integer)range2.getUpper()) {
            return (Integer)range.getLower() - (Integer)range2.getUpper();
        }
        return (Integer)range2.getLower() - (Integer)range.getUpper();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Size a(StreamConfigurationMap var0, int var1_1, boolean var2_2) {
        block6: {
            var3_3 = null;
            if (var1_1 != 34) ** GOTO lbl-1000
            try {
                v0 = var0.getOutputSizes(SurfaceTexture.class);
            }
            catch (Throwable v1) {
                break block6;
            }
lbl8:
            // 2 sources

            while (true) {
                var3_3 = v0;
                break block6;
                break;
            }
lbl-1000:
            // 1 sources

            {
                v0 = var0.getOutputSizes(var1_1);
                ** continue;
            }
        }
        if (var3_3 == null) return null;
        if (((Size[])var3_3).length == 0) {
            return null;
        }
        v2 = var3_3;
        var3_3 = v3;
        v3 = new CompareSizesByArea();
        var4_4 = (Size)Collections.max(Arrays.asList(v2), var3_3);
        var5_5 = SizeUtil.RESOLUTION_ZERO;
        if (Build.VERSION.SDK_INT >= 23 && var2_2 && (var0 = androidx.camera.camera2.internal.b.a((StreamConfigurationMap)var0, var1_1)) != null && var0.length > 0) {
            var5_5 = Collections.max(Arrays.asList(var0), var3_3);
        }
        return Collections.max(Arrays.asList(new Size[]{var4_4, var5_5}), var3_3);
    }

    /*
     * Unable to fully structure code
     */
    public final void a() {
        block29: {
            block28: {
                block27: {
                    var1_1 = v0;
                    v0 = new Size(1280, 720);
                    var2_2 = Integer.parseInt(this.i);
                    var3_4 = 8;
                    v1 = new int[8];
                    var4_7 = v1;
                    v1[0] = 1;
                    v1[1] = 13;
                    v1[2] = 10;
                    v1[3] = 8;
                    v1[4] = 12;
                    v1[5] = 6;
                    v1[6] = 5;
                    v1[7] = 4;
                    for (var5_10 = 0; var5_10 < var3_4; ++var5_10) {
                        try {
                            v2 = this;
                            var6_12 = var4_7[var5_10];
                        }
                        catch (NumberFormatException v3) {}
                        if (!v2.j.hasProfile(var2_2, var6_12)) continue;
                        var6_13 = this.j.get(var2_2, var6_12);
                        if (var6_13 == null) continue;
                        var2_3 = v4;
                        v5 = var6_13;
                        v6 = v5;
                        var3_4 = v5.videoFrameWidth;
                        v4 = new Size(var3_4, v6.videoFrameHeight);
                        break block27;
                        break block28;
                    }
                    var2_3 = null;
                }
                if (var2_3 != null) break block29;
            }
            var2_3 = null;
            try {
                var2_3 = this.k.getStreamConfigurationMapCompat().toStreamConfigurationMap().getOutputSizes(MediaRecorder.class);
            }
            catch (Throwable v7) {}
            if (var2_3 == null) {
                while (true) {
                    var2_3 = null;
                    break;
                }
            } else {
                v8 = var2_3;
                var3_5 = v9;
                v9 = new CompareSizesByArea(true);
                Arrays.sort(v8, var3_5);
                var3_4 = ((Size)v8).length;
                var4_8 = 0;
                while (true) {
                    if (var4_8 >= var3_4) ** continue;
                    var5_11 = var2_3[var4_8];
                    var6_14 = SizeUtil.RESOLUTION_1080P;
                    if (var5_11.getWidth() <= var6_14.getWidth() && var5_11.getHeight() <= var6_14.getHeight()) {
                        var2_3 = var5_11;
                        break;
                    }
                    ++var4_8;
                }
            }
            if (var2_3 == null) {
                var2_3 = SizeUtil.RESOLUTION_480P;
            }
        }
        v10 = this;
        this = v11;
        v11 = new HashMap<K, V>();
        var3_6 = v12;
        v12 = new HashMap<K, V>();
        var4_9 = v13;
        v13 = new HashMap<K, V>();
        v10.s = SurfaceSizeDefinition.create((Size)SizeUtil.RESOLUTION_VGA, new HashMap<K, V>(), (Size)var1_1, (Map)this, (Size)var2_3, var3_6, var4_9);
    }

    public final boolean a(SupportedSurfaceCombination.FeatureSettings featureSettings, List list) {
        boolean bl;
        Object object;
        boolean bl2 = false;
        if (((c)object).e.containsKey(featureSettings)) {
            object = (List)((c)object).e.get(featureSettings);
        } else {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            if (featureSettings.isUltraHdrOn()) {
                if (((c)object).g.isEmpty()) {
                    ((c)object).g.addAll(GuaranteedConfigurationsUtil.getUltraHdrSupportedCombinationList());
                }
                if (featureSettings.getCameraMode() == 0) {
                    arrayList2.addAll(((c)object).g);
                }
            } else if (featureSettings.getRequiredMaxBitDepth() == 8) {
                int n2 = featureSettings.getCameraMode();
                if (n2 != 1) {
                    if (n2 != 2) {
                        ArrayList arrayList3 = featureSettings.isPreviewStabilizationOn() ? ((c)object).d : ((c)object).a;
                        arrayList2.addAll(arrayList3);
                    } else {
                        arrayList2.addAll(((c)object).b);
                        arrayList2.addAll(((c)object).a);
                    }
                } else {
                    arrayList2 = ((c)object).c;
                }
            } else if (featureSettings.getRequiredMaxBitDepth() == 10 && featureSettings.getCameraMode() == 0) {
                arrayList2.addAll(((c)object).f);
            }
            ((c)object).e.put(featureSettings, arrayList2);
            object = arrayList2;
        }
        object = object.iterator();
        while (object.hasNext() && !(bl2 = ((SurfaceCombination)object.next()).getOrderedSupportedSurfaceConfigList(list) != null ? (bl = true) : (bl = false))) {
        }
        return bl2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final Pair a(int var1_1, List var2_6, Map var3_7, boolean var4_8, boolean var5_10) {
        block89: {
            block90: {
                block91: {
                    block88: {
                        block92: {
                            block84: {
                                block83: {
                                    this.u.refresh();
                                    if (this.s == null) {
                                        this.a();
                                    } else {
                                        var6_11 = v0;
                                        v0 = new Size(1280, 720);
                                        v1 /* !! */  = var6_11;
                                        var6_11 = this.s.getS1440pSizeMap();
                                        var7_12 = this.s.getMaximumSizeMap();
                                        var8_13 = this.s.getUltraMaximumSizeMap();
                                        this.s = SurfaceSizeDefinition.create((Size)this.s.getAnalysisSize(), (Map)this.s.getS720pSizeMap(), (Size)v1 /* !! */ , (Map)var6_11, (Size)this.s.getRecordSize(), (Map)var7_12, var8_13);
                                    }
                                    var6_11 = v2;
                                    var7_12 = v3;
                                    v3 = new ArrayList<E>();
                                    var8_13 = v4;
                                    v4 = new ArrayList<E>();
                                    var9_14 = new ArrayList<K>(var3_7.keySet()).iterator();
                                    while (var9_14.hasNext()) {
                                        var10_21 = ((UseCaseConfig)var9_14.next()).getSurfaceOccupancyPriority(0);
                                        if (var8_13.contains(var10_21)) continue;
                                        var8_13.add(var10_21);
                                    }
                                    v5 = var8_13;
                                    Collections.sort(v5);
                                    Collections.reverse(v5);
                                    var8_13 = v5.iterator();
                                    while (var8_13.hasNext()) {
                                        var9_15 = (Integer)var8_13.next();
                                        var10_22 = var6_11.iterator();
                                        while (var10_22.hasNext()) {
                                            var11_28 = (UseCaseConfig)var10_22.next();
                                            if (var9_15 != var11_28.getSurfaceOccupancyPriority(0)) continue;
                                            var7_12.add(var6_11.indexOf(var11_28));
                                        }
                                    }
                                    var8_13 = this.x.resolveAndValidateDynamicRanges((List)var2_6, (List)var6_11, (List)var7_12);
                                    var9_14 = var2_6.iterator();
                                    while (var9_14.hasNext()) {
                                        if (((AttachedSurfaceInfo)var9_14.next()).getImageFormat() != 4101) continue;
lbl42:
                                        // 2 sources

                                        while (true) {
                                            var9_16 = true;
                                            break block83;
                                            break;
                                        }
                                    }
                                    var9_14 = var3_7.keySet().iterator();
                                    while (var9_14.hasNext()) {
                                        if (((UseCaseConfig)var9_14.next()).getInputFormat() != 4101) continue;
                                        ** continue;
lbl49:
                                        // 1 sources

                                        ** GOTO lbl42
                                    }
                                    var9_16 = false;
                                }
                                var10_23 = var8_13.values().iterator();
                                while (var10_23.hasNext()) {
                                    if (((DynamicRange)var10_23.next()).getBitDepth() != 10) continue;
                                    var10_24 = 10;
                                    break block84;
                                }
                                var10_24 = 8;
                            }
                            if (var1_1 != 0 && var9_16) {
                                this = this.i;
                                var1_2 = CameraMode.toLabelString((int)var1_1);
                                v6 = var2_6 = v7;
                                var2_6("Camera device id is ");
                                v6.append((String)this);
                                v6.append(". Ultra HDR is not currently supported in ");
                                v7.append(var1_2);
                                v7.append(" camera mode.");
                                throw new IllegalArgumentException(v7.toString());
                            }
                            if (var1_1 != 0 && var10_24 == 10) {
                                this = this.i;
                                var1_3 = CameraMode.toLabelString((int)var1_1);
                                v8 = var2_6 = v9;
                                var2_6("Camera device id is ");
                                v8.append((String)this);
                                v8.append(". 10 bit dynamic range is not currently supported in ");
                                v9.append(var1_3);
                                v9.append(" camera mode.");
                                throw new IllegalArgumentException(v9.toString());
                            }
                            var4_9 = SupportedSurfaceCombination.FeatureSettings.of((int)var1_1, (int)var10_24, (boolean)var4_8, (boolean)var9_16);
                            var9_17 = v10;
                            v10 = new ArrayList<SurfaceConfig>();
                            var10_25 /* !! */  = var2_6.iterator();
                            while (var10_25 /* !! */ .hasNext()) {
                                var9_17.add(((AttachedSurfaceInfo)var10_25 /* !! */ .next()).getSurfaceConfig());
                            }
                            var10_25 /* !! */  = v11;
                            v11 = new CompareSizesByArea();
                            for (Object var12_31 : var3_7.keySet()) {
                                var13_34 = (List)var3_7.get(var12_31);
                                var14_39 = var13_34 != null && var13_34.isEmpty() == false;
                                v12 = var12_31;
                                Preconditions.checkArgument((boolean)var14_39, (Object)("No available output size is found for " + var12_31 + "."));
                                var12_31 = (Size)Collections.min(var13_34, var10_25 /* !! */ );
                                var13_33 = v12.getInputFormat();
                                var9_17.add(SurfaceConfig.transformSurfaceConfig((int)var4_9.getCameraMode(), (int)var13_33, (Size)var12_31, (SurfaceSizeDefinition)this.a(var13_33)));
                            }
                            var9_18 = this.a((SupportedSurfaceCombination.FeatureSettings)var4_9, var9_17);
                            if (!var9_18) break block89;
                            var10_25 /* !! */  = null;
                            var11_28 = var2_6.iterator();
                            while (var11_28.hasNext()) {
                                var12_31 = ((AttachedSurfaceInfo)var11_28.next()).getTargetFrameRate();
                                if (var10_25 /* !! */  == null) {
                                    var10_25 /* !! */  = var12_31;
                                    continue;
                                }
                                if (var12_31 == null) continue;
                                try {
                                    var10_25 /* !! */  = var10_25 /* !! */ .intersect((Range)var12_31);
                                }
                                catch (IllegalArgumentException v13) {}
                            }
                            var11_28 = var7_12.iterator();
                            while (var11_28.hasNext()) {
                                var12_31 = ((UseCaseConfig)var6_11.get((Integer)var11_28.next())).getTargetFrameRate(null);
                                if (var10_25 /* !! */  == null) {
                                    var10_25 /* !! */  = var12_31;
                                    continue;
                                }
                                if (var12_31 == null) continue;
                                try {
                                    var10_25 /* !! */  = var10_25 /* !! */ .intersect((Range)var12_31);
                                }
                                catch (IllegalArgumentException v14) {}
                            }
                            var11_28 = v15;
                            v15 = new HashMap<K, V>();
                            for (UseCaseConfig var13_35 : var3_7.keySet()) {
                                var14_41 = v16;
                                v16 = new ArrayList<Object>();
                                var15_46 = v17;
                                v17 = new HashMap();
                                for (Object var17_52 : (List)var3_7.get(var13_35)) {
                                    var18_56 = var13_35.getInputFormat();
                                    var19_58 = SurfaceConfig.transformSurfaceConfig((int)var4_9.getCameraMode(), (int)var18_56, (Size)var17_52, (SurfaceSizeDefinition)this.a(var18_56)).getConfigSize();
                                    var20_63 = 0x7FFFFFFF;
                                    if (var10_25 /* !! */  != null) {
                                        var20_63 = androidx.camera.camera2.internal.c.a(this.k, var18_56, (Size)var17_52);
                                    }
                                    if ((var18_55 = (Set)var15_46.get(var19_58)) == null) {
                                        var18_55 = v18;
                                        v18 = new HashSet<E>();
                                        var15_46.put(var19_58, var18_55);
                                    }
                                    if (var18_55.contains(var20_63)) continue;
                                    var14_41.add(var17_52);
                                    var18_55.add(var20_63);
                                }
                                var11_28.put(var13_35, var14_41);
                            }
                            var3_7 = v19;
                            v19 = new ArrayList<E>();
                            var12_31 = var7_12.iterator();
                            while (var12_31.hasNext()) {
                                v20 = (UseCaseConfig)var6_11.get((Integer)var12_31.next());
                                var13_36 = (List)var11_28.get(v20);
                                var14_42 = v20.getInputFormat();
                                var15_46 = null;
                                switch (this.v.get(this.i, this.k)) {
                                    default: {
                                        break;
                                    }
                                    case 3: {
                                        var15_46 = null;
                                        break;
                                    }
                                    case 2: {
                                        var15_46 = this.a(256).getMaximumSize(256);
                                        var16_50 = v21;
                                        v22 = var15_46;
                                        var15_47 = v22.getWidth();
                                        v21 = new Rational(var15_47, v22.getHeight());
                                        var15_46 = var16_50;
                                        break;
                                    }
                                    case 1: {
                                        var15_46 = AspectRatioUtil.ASPECT_RATIO_16_9;
                                        break;
                                    }
                                    case 0: {
                                        var15_46 = AspectRatioUtil.ASPECT_RATIO_4_3;
                                    }
                                }
                                if (var15_46 != null) {
                                    v23 = var13_36;
                                    var13_36 = v24;
                                    v24 = new ArrayList<E>();
                                    var16_50 = v25;
                                    v25 = new ArrayList<E>();
                                    for (Set var18_55 : v23) {
                                        if (AspectRatioUtil.hasMatchingAspectRatio((Size)var18_55, (Rational)var15_46)) {
                                            var13_36.add(var18_55);
                                            continue;
                                        }
                                        var16_50.add(var18_55);
                                    }
                                    var16_50.addAll(0, var13_36);
                                    var13_36 = var16_50;
                                }
                                var3_7.add(this.w.insertOrPrioritize(SurfaceConfig.getConfigType((int)var14_42), (List)var13_36));
                            }
                            var11_29 = 1;
                            var12_31 = var3_7.iterator();
                            while (var12_31.hasNext()) {
                                var11_29 = ((List)var12_31.next()).size() * var11_29;
                            }
                            if (var11_29 == 0) break block90;
                            var12_31 = v26;
                            v26 = new ArrayList<E>();
                            for (var13_37 = 0; var13_37 < var11_29; ++var13_37) {
                                var14_43 = v27;
                                v27 = new ArrayList<E>();
                                var12_31.add(var14_43);
                            }
                            var13_37 = var11_29 / ((List)var3_7.get(0)).size();
                            var15_48 = var11_29;
                            for (var14_44 = 0; var14_44 < var3_7.size(); ++var14_44) {
                                var16_50 = (List)var3_7.get(var14_44);
                                for (var17_53 = 0; var17_53 < var11_29; ++var17_53) {
                                    ((List)var12_31.get(var17_53)).add((Size)var16_50.get(var17_53 % var15_48 / var13_37));
                                }
                                if (var14_44 < var3_7.size() - 1) {
                                    var15_48 = var13_37 / ((List)var3_7.get(var14_44 + 1)).size();
                                } else {
                                    v28 = var15_48;
                                    var15_48 = var13_37;
                                    var13_37 = v28;
                                }
                                v29 = var13_37;
                                var13_37 = var15_48;
                                var15_48 = v29;
                            }
                            v30 = var2_6;
                            var3_7 = v31;
                            v31 = new HashMap<K, V>();
                            var11_30 = v32;
                            v32 = new HashMap<UseCaseConfig, StreamSpec>();
                            var13_38 = v33;
                            v33 = new HashMap<K, V>();
                            var14_45 = v34;
                            v34 = new HashMap<K, V>();
                            var15_49 = null;
                            var16_51 = 0x7FFFFFFF;
                            var17_54 = null;
                            var18_57 = 0x7FFFFFFF;
                            var19_59 = StreamUseCaseUtil.containsZslUseCase((List)v30, (List)var6_11);
                            var20_64 = null;
                            var21_65 = 0x7FFFFFFF;
                            var22_67 = v30.iterator();
                            while (var22_67.hasNext()) {
                                v35 = var21_65;
                                v36 = (AttachedSurfaceInfo)var22_67.next();
                                var21_65 = v36.getImageFormat();
                                var23_70 /* !! */  = v36.getSize();
                                var21_65 = Math.min(v35, androidx.camera.camera2.internal.c.a(this.k, var21_65, var23_70 /* !! */ ));
                            }
                            if (this.q && !var19_59) {
                                var19_60 = var12_31.iterator();
                                while (var19_60.hasNext()) {
                                    var20_64 = (List)var19_60.next();
                                    var20_64 = (List)this.a((int)var1_1, (List)var2_6, (List)var20_64, (ArrayList)var6_11, (ArrayList)var7_12, (int)var21_65, var13_38, var14_45).first;
                                    if (!StreamUseCaseUtil.shouldUseStreamUseCase((SupportedSurfaceCombination.FeatureSettings)var4_9)) {
                                        while (true) {
                                            var20_64 = null;
                                            break;
                                        }
                                    } else {
                                        var22_67 = this.h.iterator();
                                        do {
                                            if (!var22_67.hasNext()) ** continue;
                                        } while ((var23_70 /* !! */  = ((SurfaceCombination)var22_67.next()).getOrderedSupportedSurfaceConfigList(var20_64)) == null);
                                        var20_64 = var23_70 /* !! */ ;
                                    }
                                    if (var20_64 != null && !StreamUseCaseUtil.areCaptureTypesEligible(var13_38, var14_45, (List)var20_64)) {
                                        var20_64 = null;
                                    }
                                    if (var20_64 != null) {
                                        if (StreamUseCaseUtil.areStreamUseCasesAvailableForSurfaceConfigs((CameraCharacteristicsCompat)this.k, (List)var20_64)) break;
                                        var20_64 = null;
                                    }
                                    var13_38.clear();
                                    var14_45.clear();
                                }
                                if (var20_64 == null && !var9_18) {
                                    throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.i + ".  May be attempting to bind too many use cases. Existing surfaces: " + var2_6 + " New configs: " + var6_11);
                                }
                            }
                            var9_18 = false;
                            var12_32 = 0;
                            var19_61 = var12_31.iterator();
                            while (var19_61.hasNext()) {
                                var22_67 = (List)var19_61.next();
                                v37 = this.a(var1_1, (List)var2_6, (List)var22_67, (ArrayList)var6_11, (ArrayList)var7_12, var21_65, null, null);
                                var23_70 /* !! */  = (List)v37.first;
                                var24_71 = (Integer)v37.second;
                                var25_73 = true;
                                if (var10_25 /* !! */  != null && var21_65 > var24_71 && var24_71 < (Integer)var10_25 /* !! */ .getLower()) {
                                    var25_73 = false;
                                }
                                if (!var9_18 && this.a((SupportedSurfaceCombination.FeatureSettings)var4_9, (List)var23_70 /* !! */ )) {
                                    if (var16_51 == 0x7FFFFFFF || var16_51 < var24_71) {
                                        var15_49 = var22_67;
                                        var16_51 = var24_71;
                                    }
                                    if (var25_73) {
                                        var9_18 = true;
                                        if (var12_32 != 0) {
                                            var16_51 = var24_71;
                                            var15_49 = var22_67;
                                            break;
                                        }
                                        var15_49 = var22_67;
                                        var16_51 = var24_71;
                                    }
                                }
                                if (var20_64 == null || var12_32 != 0) continue;
                                if (!StreamUseCaseUtil.shouldUseStreamUseCase((SupportedSurfaceCombination.FeatureSettings)var4_9)) {
                                    while (true) {
                                        var23_70 /* !! */  = null;
                                        break;
                                    }
                                } else {
                                    var26_74 = this.h.iterator();
                                    do {
                                        if (!var26_74.hasNext()) ** continue;
                                    } while ((var27_76 = ((SurfaceCombination)var26_74.next()).getOrderedSupportedSurfaceConfigList((List)var23_70 /* !! */ )) == null);
                                    var23_70 /* !! */  = var27_76;
                                }
                                if (var23_70 /* !! */  == null) continue;
                                if (var18_57 == 0x7FFFFFFF || var18_57 < var24_71) {
                                    var17_54 = var22_67;
                                    var18_57 = var24_71;
                                }
                                if (!var25_73) continue;
                                var12_32 = 1;
                                if (var9_18) {
                                    var17_54 = var22_67;
                                    var18_57 = var24_71;
                                    break;
                                }
                                var17_54 = var22_67;
                                var18_57 = var24_71;
                            }
                            if (var15_49 == null) break block91;
                            var1_4 /* !! */  = null;
                            if (var10_25 /* !! */  == null || var10_25 /* !! */ .equals((Object)(var1_4 /* !! */  = StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED)) || (var4_9 = (Range[])this.k.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES)) == null) break block92;
                            var9_19 = v38;
                            v38 = new Range((Comparable)Integer.valueOf(Math.min((Integer)var10_25 /* !! */ .getLower(), var16_51)), (Comparable)Integer.valueOf(Math.min((Integer)var10_25 /* !! */ .getUpper(), var16_51)));
                            var10_26 = 0;
                            for (Object var21_66 : var4_9) {
                                block85: {
                                    block86: {
                                        block87: {
                                            block94: {
                                                block93: {
                                                    if (var16_51 < (Integer)var21_66.getLower()) continue;
                                                    if (var1_4 /* !! */ .equals((Object)StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED)) {
                                                        var1_4 /* !! */  = var21_66;
                                                    }
                                                    if (var21_66.equals((Object)var9_19)) {
                                                        var1_4 /* !! */  = var21_66;
                                                        break;
                                                    }
                                                    var22_68 = androidx.camera.camera2.internal.c.a(var21_66.intersect(var9_19));
                                                    if (var10_26 == 0) {
                                                        var10_26 = var22_68;
                                                        break block85;
                                                    }
                                                    if (var22_68 < var10_26) break block86;
                                                    v39 = var21_66;
                                                    v40 = var9_19;
                                                    var22_69 = androidx.camera.camera2.internal.c.a(var1_4 /* !! */ .intersect(var9_19));
                                                    var24_72 = androidx.camera.camera2.internal.c.a(v39.intersect(v40));
                                                    v41 = var22_69;
                                                    v42 = v41;
                                                    v43 = v41;
                                                    v44 /* !! */  = var1_4 /* !! */ ;
                                                    var26_75 = var24_72 / (double)androidx.camera.camera2.internal.c.a((Range)var21_66);
                                                    var28_77 = v42 / (double)androidx.camera.camera2.internal.c.a(v44 /* !! */ );
                                                    if (!(v45 > v43)) break block93;
                                                    if (var26_75 >= 0.5 || var26_75 >= var28_77) lbl-1000:
                                                    // 4 sources

                                                    {
                                                        while (true) {
                                                            var1_4 /* !! */  = var21_66;
                                                            ** GOTO lbl383
                                                            break;
                                                        }
                                                    }
                                                    break block87;
                                                }
                                                if (var24_72 != var22_69) break block94;
                                                if (var26_75 > var28_77) ** GOTO lbl-1000
                                                if (var26_75 != var28_77) break block87;
                                                if ((Integer)var21_66.getLower() <= (Integer)var1_4 /* !! */ .getLower()) break block87;
                                                ** GOTO lbl-1000
                                            }
                                            if (!(var28_77 < 0.5) || !(var26_75 > var28_77)) ** break;
                                            ** continue;
                                        }
                                        try {
                                            var10_26 = androidx.camera.camera2.internal.c.a(var9_19.intersect(var1_4 /* !! */ ));
                                        }
                                        catch (IllegalArgumentException v46) {
                                            if (var10_26 != 0 || androidx.camera.camera2.internal.c.a((Range)var21_66, var9_19) >= androidx.camera.camera2.internal.c.a(var1_4 /* !! */ , var9_19) && (androidx.camera.camera2.internal.c.a((Range)var21_66, var9_19) != androidx.camera.camera2.internal.c.a(var1_4 /* !! */ , var9_19) || (Integer)var21_66.getLower() <= (Integer)var1_4 /* !! */ .getUpper() && androidx.camera.camera2.internal.c.a((Range)var21_66) >= androidx.camera.camera2.internal.c.a(var1_4 /* !! */ ))) continue;
                                        }
                                    }
                                    var21_66 = var1_4 /* !! */ ;
                                }
                                var1_4 /* !! */  = var21_66;
                            }
                        }
                        var4_9 = var6_11.iterator();
                        while (var4_9.hasNext()) {
                            var9_20 = (UseCaseConfig)var4_9.next();
                            var10_27 = StreamSpec.builder((Size)((Size)var15_49.get(var7_12.indexOf(var6_11.indexOf(var9_20))))).setDynamicRange((DynamicRange)Preconditions.checkNotNull((Object)((DynamicRange)var8_13.get(var9_20)))).setImplementationOptions((Config)StreamUseCaseUtil.getStreamSpecImplementationOptions((UseCaseConfig)var9_20)).setZslDisabled(var5_10);
                            if (var1_4 /* !! */  != null) {
                                var10_27.setExpectedFrameRateRange(var1_4 /* !! */ );
                            }
                            var11_30.put(var9_20, var10_27.build());
                        }
                        if (var20_64 != null && var16_51 == var18_57 && var15_49.size() == var17_54.size()) {
                            for (var1_5 = 0; var1_5 < var15_49.size(); ++var1_5) {
                                if (((Size)var15_49.get(var1_5)).equals(var17_54.get(var1_5))) {
                                    continue;
                                }
                                break block88;
                            }
                            if (!StreamUseCaseUtil.populateStreamUseCaseStreamSpecOptionWithInteropOverride((CameraCharacteristicsCompat)this.k, (List)var2_6, var11_30, (Map)var3_7)) {
                                StreamUseCaseUtil.populateStreamUseCaseStreamSpecOptionWithSupportedSurfaceConfigs(var11_30, (Map)var3_7, var13_38, var14_45, (List)var20_64);
                            }
                        }
                    }
                    return new Pair(var11_30, var3_7);
                }
                throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.i + " and Hardware level: " + this.m + ". May be the specified resolution is too large and not supported. Existing surfaces: " + var2_6 + " New configs: " + var6_11);
            }
            throw new IllegalArgumentException("Failed to find supported resolutions.");
        }
        throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.i + ".  May be attempting to bind too many use cases. Existing surfaces: " + var2_6 + " New configs: " + var6_11);
    }

    public final SurfaceSizeDefinition a(int n2) {
        if (!this.t.contains(n2)) {
            Integer n3;
            Size size;
            c c2 = this;
            Object object = c2.s.getS720pSizeMap();
            Size size2 = SizeUtil.RESOLUTION_720P;
            if (c2.p) {
                size = androidx.camera.camera2.internal.c.a(this.k.getStreamConfigurationMapCompat().toStreamConfigurationMap(), n2, false);
                n3 = n2;
                if (size != null) {
                    size2 = Collections.min(Arrays.asList(size2, size), new CompareSizesByArea());
                }
                object.put(n3, size2);
            }
            c c3 = this;
            object = c3.s.getS1440pSizeMap();
            size2 = SizeUtil.RESOLUTION_1440P;
            if (c3.p) {
                size = androidx.camera.camera2.internal.c.a(this.k.getStreamConfigurationMapCompat().toStreamConfigurationMap(), n2, false);
                n3 = n2;
                if (size != null) {
                    size2 = Collections.min(Arrays.asList(size2, size), new CompareSizesByArea());
                }
                object.put(n3, size2);
            }
            c c4 = this;
            object = c4.s.getMaximumSizeMap();
            size2 = androidx.camera.camera2.internal.c.a(c4.k.getStreamConfigurationMapCompat().toStreamConfigurationMap(), n2, true);
            if (size2 != null) {
                object.put(n2, size2);
            }
            object = this.s.getUltraMaximumSizeMap();
            if (Build.VERSION.SDK_INT >= 31 && this.r && (size2 = (StreamConfigurationMap)this.k.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP_MAXIMUM_RESOLUTION)) != null) {
                Map map = object;
                object = n2;
                map.put(object, androidx.camera.camera2.internal.c.a((StreamConfigurationMap)size2, n2, true));
            }
            this.t.add(n2);
        }
        return this.s;
    }

    public final Pair a(int n2, List list, List list2, ArrayList arrayList, ArrayList arrayList2, int n3, HashMap hashMap, HashMap hashMap2) {
        ArrayList arrayList3;
        List list3 = list;
        list = arrayList3;
        arrayList3 = new ArrayList();
        for (AttachedSurfaceInfo attachedSurfaceInfo : list3) {
            ((ArrayList)list).add(attachedSurfaceInfo.getSurfaceConfig());
            if (hashMap == null) continue;
            hashMap.put(((ArrayList)list).size() - 1, attachedSurfaceInfo);
        }
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            AttachedSurfaceInfo attachedSurfaceInfo;
            Size size = (Size)list2.get(i2);
            attachedSurfaceInfo = (UseCaseConfig)arrayList.get((Integer)arrayList2.get(i2));
            int n4 = attachedSurfaceInfo.getInputFormat();
            SurfaceSizeDefinition surfaceSizeDefinition = this.a(n4);
            ((ArrayList)list).add(SurfaceConfig.transformSurfaceConfig((int)n2, (int)n4, (Size)size, (SurfaceSizeDefinition)surfaceSizeDefinition));
            if (hashMap2 != null) {
                hashMap2.put(((ArrayList)list).size() - 1, attachedSurfaceInfo);
            }
            int n5 = n3;
            n3 = attachedSurfaceInfo.getInputFormat();
            n3 = Math.min(n5, androidx.camera.camera2.internal.c.a(this.k, n3, size));
        }
        return new Pair((Object)list, (Object)n3);
    }
}

