/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.Log;
import android.util.Rational;
import android.util.Size;
import androidx.camera.core.ImageProxy;
import io.scanbot.sdk.exceptions.camera.CodecFailedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001J\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J!\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J1\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ'\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b \u0010\u0006J'\u0010!\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020#2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010$\u001a\u00020#2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b$\u0010&\u00a8\u0006'"}, d2={"Lio/scanbot/sdk/ui/camera/util/CameraImageUtils;", "", "Landroidx/camera/core/ImageProxy;", "image", "", "imageToJpegByteArray", "(Landroidx/camera/core/ImageProxy;)[B", "data", "Landroid/graphics/Rect;", "cropRect", "cropByteArray", "([BLandroid/graphics/Rect;)[B", "Landroid/util/Size;", "sourceSize", "Landroid/util/Rational;", "aspectRatio", "computeCropRectFromAspectRatio", "(Landroid/util/Size;Landroid/util/Rational;)Landroid/graphics/Rect;", "rational", "", "rotation", "rotate", "(Landroid/util/Rational;I)Landroid/util/Rational;", "nv21", "width", "height", "nv21ToJpeg", "([BIILandroid/graphics/Rect;)[B", "Landroid/graphics/Bitmap;", "src", "bitmapToNv21", "(Landroid/graphics/Bitmap;II)[B", "yuv420888toNv21", "nv21ToYuv420888", "([BII)[B", "", "isAspectRatioValid", "(Landroid/util/Rational;)Z", "(Landroid/util/Size;Landroid/util/Rational;)Z", "sdk-camera_release"}, xi=48)
public final class CameraImageUtils {
    @NotNull
    public static final CameraImageUtils INSTANCE = new CameraImageUtils();

    @JvmStatic
    @Nullable
    public static final byte[] imageToJpegByteArray(@NotNull ImageProxy image) {
        ImageProxy imageProxy = image;
        Intrinsics.checkNotNullParameter((Object)imageProxy, (String)"image");
        Object object = null;
        int n2 = imageProxy.getFormat();
        if (n2 != 35) {
            if (n2 != 256) {
                Log.w((String)"ImageUtil", (String)("Unrecognized image format: " + var0.getFormat()));
            } else {
                Size size;
                INSTANCE.getClass();
                ImageProxy.PlaneProxy[] planeProxyArray = var0.getPlanes();
                Intrinsics.checkNotNullExpressionValue((Object)planeProxyArray, (String)"getPlanes(...)");
                ByteBuffer byteBuffer = planeProxyArray[0].getBuffer();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"getBuffer(...)");
                byteBuffer.rewind();
                object = new byte[byteBuffer.capacity()];
                byteBuffer.get((byte[])object);
                Size size2 = size;
                ImageProxy imageProxy2 = var0;
                int n3 = imageProxy2.getWidth();
                size = new Size(n3, imageProxy2.getHeight());
                if (!Intrinsics.areEqual((Object)new Size(var0.getCropRect().width(), var0.getCropRect().height()), (Object)size2)) {
                    var0 = CameraImageUtils.cropByteArray(object, var0.getCropRect());
                    object = var0;
                }
            }
        } else {
            Size size;
            ImageProxy imageProxy3 = var0;
            INSTANCE.getClass();
            object = CameraImageUtils.yuv420888toNv21(imageProxy3);
            n2 = imageProxy3.getWidth();
            int n4 = imageProxy3.getHeight();
            Size size3 = size;
            ImageProxy imageProxy4 = var0;
            int n5 = imageProxy4.getWidth();
            size = new Size(n5, imageProxy4.getHeight());
            var0 = !Intrinsics.areEqual((Object)new Size(var0.getCropRect().width(), var0.getCropRect().height()), (Object)size3) ? var0.getCropRect() : null;
            object = CameraImageUtils.nv21ToJpeg(object, n2, n4, (Rect)var0);
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final byte[] cropByteArray(@NotNull byte[] data, @Nullable Rect cropRect) {
        IllegalArgumentException illegalArgumentException2;
        block10: {
            block9: {
                block8: {
                    ByteArrayOutputStream byteArrayOutputStream;
                    BitmapFactory.Options options;
                    BitmapFactory.Options options2;
                    byte[] byArray;
                    Intrinsics.checkNotNullParameter((Object)byArray, (String)"data");
                    if (cropRect == null) {
                        return byArray;
                    }
                    int n2 = 0;
                    Object object = BitmapRegionDecoder.newInstance((byte[])byArray, (int)n2, (int)byArray.length, (boolean)false);
                    void v0 = options2;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newInstance(...)");
                    options2 = options;
                    options = new BitmapFactory.Options();
                    options2 = object.decodeRegion((Rect)v0, options2);
                    try {
                        object.recycle();
                        if (options2 == null) break block8;
                    }
                    catch (IOException iOException) {
                        break block9;
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        break block10;
                    }
                    object = byteArrayOutputStream;
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    if (options2.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)object)) {
                        options2.recycle();
                        byte[] byArray2 = ((ByteArrayOutputStream)object).toByteArray();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
                        return byArray2;
                    }
                    throw new CodecFailedException("Encode bitmap failed.", CodecFailedException.FailureType.ENCODE_FAILED);
                }
                throw new CodecFailedException("Decode byte array failed.", CodecFailedException.FailureType.DECODE_FAILED);
            }
            throw new CodecFailedException("Decode byte array failed.", CodecFailedException.FailureType.DECODE_FAILED);
        }
        throw new CodecFailedException("Decode byte array failed with illegal argument." + illegalArgumentException2, CodecFailedException.FailureType.DECODE_FAILED);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final Rect computeCropRectFromAspectRatio(@NotNull Size sourceSize, @NotNull Rational aspectRatio) {
        void var1_2;
        Size size;
        Intrinsics.checkNotNullParameter((Object)size, (String)"sourceSize");
        Intrinsics.checkNotNullParameter((Object)aspectRatio, (String)"aspectRatio");
        if (!INSTANCE.isAspectRatioValid((Rational)var1_2)) {
            Log.w((String)"ImageUtil", (String)"Invalid view ratio.");
            return null;
        }
        void v0 = var1_2;
        int n2 = size.getWidth();
        int n3 = size.getHeight();
        float f2 = n2;
        float f3 = n3;
        float f4 = f2 / f3;
        int n4 = 0;
        int n5 = 0;
        int n6 = v0.getNumerator();
        int n7 = v0.getDenominator();
        if (v0.floatValue() > f4) {
            int n8 = n3;
            n3 = Math.round(f2 / (float)n6 * (float)n7);
            n5 = (n8 - n3) / 2;
        } else {
            int n9 = n2;
            n2 = Math.round(f3 / (float)n7 * (float)n6);
            n4 = (n9 - n2) / 2;
        }
        n2 = n4 + n2;
        n3 = n5 + n3;
        return new Rect(n4, n5, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Rational rotate(@NotNull Rational rational, int rotation) {
        void var1_2;
        Rational rational2;
        Intrinsics.checkNotNullParameter((Object)rational2, (String)"rational");
        if (rotation == 90 || var1_2 == 270) {
            INSTANCE.getClass();
            if (rational2 == null) {
                rational2 = null;
            } else {
                Rational rational3;
                Rational rational4 = rational3;
                Rational rational5 = rational2;
                int n2 = rational5.getDenominator();
                rational3 = new Rational(n2, rational5.getNumerator());
                rational2 = rational4;
            }
        }
        return rational2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final byte[] nv21ToJpeg(@NotNull byte[] nv21, int width, int height, @Nullable Rect cropRect) {
        Rect rect;
        void var2_2;
        void var1_1;
        YuvImage yuvImage;
        ByteArrayOutputStream byteArrayOutputStream;
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"nv21");
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        YuvImage yuvImage2 = yuvImage;
        yuvImage = new YuvImage(byArray, 17, (int)var1_1, (int)var2_2, null);
        if (cropRect == null) {
            Rect rect2;
            rect = rect2;
            rect2 = new Rect(0, 0, (int)var1_1, (int)var2_2);
        }
        if (yuvImage2.compressToJpeg(rect, 100, (OutputStream)byteArrayOutputStream2)) {
            byte[] byArray2 = byteArrayOutputStream2.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
            return byArray2;
        }
        throw new CodecFailedException("YuvImage failed to encode jpeg.", CodecFailedException.FailureType.ENCODE_FAILED);
    }

    @JvmStatic
    @NotNull
    public static final byte[] bitmapToNv21(@NotNull Bitmap src, int width, int height) {
        int n2;
        Object object;
        int n3;
        Bitmap bitmap = src;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"src");
        if (bitmap.getWidth() >= n3 && object.getHeight() >= n2) {
            void var3_3 = n3 * n2;
            Bitmap bitmap2 = object;
            int[] nArray = new int[var3_3];
            object = nArray;
            bitmap2.getPixels(nArray, 0, n3, 0, 0, n3, n2);
            INSTANCE.getClass();
            int n4 = 0;
            int n5 = 0;
            void var6_6 = var3_3 * 3 / 2;
            byte[] byArray = new byte[var6_6];
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i3 = 0; i3 < n3; ++i3) {
                    Bitmap bitmap3 = object[n5];
                    int n6 = (bitmap3 & 0xFF0000) >> 16;
                    int n7 = (bitmap3 & 0xFF00) >> 8;
                    int n8 = bitmap3 & 0xFF;
                    int n9 = n6 * 66;
                    n9 = n7 * 129 + n9;
                    n9 = (n8 * 25 + n9 + 128 >> 8) + 16;
                    int n10 = n6;
                    n6 = (n10 * 112 - n7 * 94 - n8 * 18 + 128 >> 8) + 128;
                    n7 = n10 * -38 - n7 * 74;
                    n7 = (n8 * 112 + n7 + 128 >> 8) + 128;
                    n8 = n4 + 1;
                    if (n9 < 0) {
                        n9 = 0;
                    } else if (n9 > 255) {
                        n9 = 255;
                    }
                    byArray[n4] = (byte)n9;
                    if (i2 % 2 == 0 && n5 % 2 == 0 && var3_3 < var6_6 - 2) {
                        n4 = var3_3 + true;
                        if (n7 < 0) {
                            n7 = 0;
                        } else if (n7 > 255) {
                            n7 = 255;
                        }
                        byArray[var3_3] = (byte)n7;
                        var3_3 += 2;
                        if (n6 < 0) {
                            n6 = 0;
                        } else if (n6 > 255) {
                            n6 = 255;
                        }
                        byArray[n4] = (byte)n6;
                    }
                    n4 = n5 + 1;
                    int n11 = n4;
                    n4 = n8;
                    n5 = n11;
                }
            }
            return byArray;
        }
        throw new CodecFailedException("Invalid source Bitmap image!");
    }

    @JvmStatic
    @NotNull
    public static final byte[] yuv420888toNv21(@NotNull ImageProxy image) {
        int n2;
        ImageProxy imageProxy;
        ImageProxy imageProxy2 = image;
        Intrinsics.checkNotNullParameter((Object)imageProxy2, (String)"image");
        ImageProxy.PlaneProxy planeProxy = imageProxy2.getPlanes()[0];
        ImageProxy imageProxy3 = imageProxy;
        ImageProxy.PlaneProxy planeProxy2 = imageProxy3.getPlanes()[1];
        ImageProxy.PlaneProxy planeProxy3 = imageProxy3.getPlanes()[2];
        ByteBuffer byteBuffer = planeProxy.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"getBuffer(...)");
        ByteBuffer byteBuffer2 = planeProxy2.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"getBuffer(...)");
        ByteBuffer byteBuffer3 = planeProxy3.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"getBuffer(...)");
        byteBuffer.rewind();
        byteBuffer2.rewind();
        byteBuffer3.rewind();
        int n3 = byteBuffer.remaining();
        int n4 = 0;
        int n5 = imageProxy2.getWidth();
        byte[] byArray = new byte[imageProxy2.getHeight() * n5 / 2 + n3];
        int n6 = imageProxy2.getHeight();
        for (int i2 = 0; i2 < n6; ++i2) {
            byteBuffer.get(byArray, n4, imageProxy.getWidth());
            n4 = imageProxy.getWidth() + n4;
            n2 = byteBuffer.position() - imageProxy.getWidth();
            byteBuffer.position(Math.min(n3, planeProxy.getRowStride() + n2));
        }
        ImageProxy imageProxy4 = imageProxy;
        int n7 = imageProxy4.getHeight() / 2;
        int n8 = imageProxy4.getWidth() / 2;
        int n9 = planeProxy3.getRowStride();
        n3 = planeProxy2.getRowStride();
        int n10 = planeProxy3.getPixelStride();
        int n11 = planeProxy2.getPixelStride();
        byte[] byArray2 = new byte[n9];
        byte[] byArray3 = new byte[n3];
        for (n2 = 0; n2 < n7; ++n2) {
            byteBuffer3.get(byArray2, 0, Math.min(n9, byteBuffer3.remaining()));
            byteBuffer2.get(byArray3, 0, Math.min(n3, byteBuffer2.remaining()));
            int n12 = 0;
            int n13 = 0;
            for (int i3 = 0; i3 < n8; ++i3) {
                int n14 = n4 + 1;
                byArray[n4] = byArray2[n12];
                n4 += 2;
                byArray[n14] = byArray3[n13];
                n12 += n10;
                n13 += n11;
            }
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final byte[] nv21ToYuv420888(@NotNull byte[] nv21, int width, int height) {
        void var1_1;
        void var2_2;
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"nv21");
        byte[] byArray2 = new byte[(var1_1 *= var2_2) * 3 / 2];
        int n2 = var1_1 / 2;
        System.arraycopy(nv21, 0, byArray2, 0, (int)var1_1);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2 * 2 + var1_1;
            int n4 = n3 + 1;
            byArray2[n3] = byArray[n4];
            byArray2[n4] = byArray[n3];
        }
        return byArray2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAspectRatioValid(@Nullable Rational aspectRatio) {
        void var1_1;
        return aspectRatio != null && var1_1.floatValue() > 0.0f && !var1_1.isNaN();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAspectRatioValid(@NotNull Size sourceSize, @Nullable Rational aspectRatio) {
        int n2;
        float f2;
        void var2_4;
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)var1_2, (String)"sourceSize");
        if (aspectRatio == null) return false;
        if (!(var2_4.floatValue() > 0.0f)) return false;
        void v0 = var1_2;
        int n3 = v0.getWidth();
        int n4 = v0.getHeight();
        void v1 = var2_4;
        int n5 = v1.getNumerator();
        float f3 = n5;
        if (n4 == Math.round((float)n3 / f3 * (f2 = (float)(n2 = v1.getDenominator())))) {
            if (n3 == Math.round((float)n4 / f2 * f3)) return false;
        }
        if (var2_4.isNaN()) return false;
        return true;
    }
}

