/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.os.Build;
import android.util.Pair;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import androidx.camera.camera2.internal.CamcorderProfileHelper;
import androidx.camera.camera2.internal.CameraUnavailableExceptionHelper;
import androidx.camera.camera2.internal.DisplayInfoManager;
import androidx.camera.camera2.internal.DynamicRangeResolver;
import androidx.camera.camera2.internal.GuaranteedConfigurationsUtil;
import androidx.camera.camera2.internal.StreamUseCaseUtil;
import androidx.camera.camera2.internal.SupportedSurfaceCombination;
import androidx.camera.camera2.internal.VideoStabilizationUtil;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.camera2.internal.compat.CameraManagerCompat;
import androidx.camera.camera2.internal.compat.workaround.ExtraSupportedSurfaceCombinationsContainer;
import androidx.camera.camera2.internal.compat.workaround.ResolutionCorrector;
import androidx.camera.camera2.internal.compat.workaround.TargetAspectRatio;
import androidx.camera.camera2.internal.scb;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.AttachedSurfaceInfo;
import androidx.camera.core.impl.CameraMode;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.SurfaceCombination;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.SurfaceSizeDefinition;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.utils.AspectRatioUtil;
import androidx.camera.core.impl.utils.CompareSizesByArea;
import androidx.camera.core.internal.utils.SizeUtil;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class scc {
    public final ArrayList a;
    public final ArrayList b;
    public final ArrayList c;
    public final ArrayList d;
    public final HashMap e;
    public final ArrayList f;
    public final ArrayList g;
    public final ArrayList h;
    public final String i;
    public final CamcorderProfileHelper j;
    public final CameraCharacteristicsCompat k;
    public final ExtraSupportedSurfaceCombinationsContainer l;
    public final int m;
    public final boolean n;
    public final boolean o;
    public final boolean p;
    public final boolean q;
    public final boolean r;
    public SurfaceSizeDefinition s;
    public final ArrayList t;
    public final DisplayInfoManager u;
    public final TargetAspectRatio v;
    public final ResolutionCorrector w;
    public final DynamicRangeResolver x;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public scc(Context object, String object2, CameraManagerCompat object3, CamcorderProfileHelper camcorderProfileHelper) {
        DynamicRangeResolver dynamicRangeResolver;
        int n;
        ExtraSupportedSurfaceCombinationsContainer extraSupportedSurfaceCombinationsContainer;
        ResolutionCorrector resolutionCorrector;
        TargetAspectRatio targetAspectRatio;
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        ArrayList arrayList4;
        HashMap hashMap;
        ArrayList arrayList5;
        ArrayList arrayList6;
        ArrayList arrayList7;
        ArrayList arrayList8;
        CameraManagerCompat cameraManagerCompat = object3;
        String string = object2;
        object2 = arrayList8;
        arrayList8 = new ArrayList();
        this.a = object2;
        object2 = arrayList7;
        arrayList7 = new ArrayList();
        this.b = object2;
        object2 = arrayList6;
        arrayList6 = new ArrayList();
        this.c = object2;
        object2 = arrayList5;
        arrayList5 = new ArrayList();
        this.d = object2;
        object2 = hashMap;
        hashMap = new HashMap();
        this.e = object2;
        object2 = arrayList4;
        arrayList4 = new ArrayList();
        this.f = object2;
        object2 = arrayList3;
        arrayList3 = new ArrayList();
        this.g = object2;
        object2 = arrayList2;
        arrayList2 = new ArrayList();
        this.h = object2;
        this.n = false;
        this.o = false;
        this.p = false;
        this.q = false;
        this.r = false;
        object2 = arrayList;
        arrayList = new ArrayList();
        this.t = object2;
        object2 = targetAspectRatio;
        targetAspectRatio = new TargetAspectRatio();
        this.v = object2;
        object2 = resolutionCorrector;
        resolutionCorrector = new ResolutionCorrector();
        this.w = object2;
        this.i = object2 = (String)Preconditions.checkNotNull((Object)string);
        this.j = (CamcorderProfileHelper)Preconditions.checkNotNull((Object)camcorderProfileHelper);
        object3 = extraSupportedSurfaceCombinationsContainer;
        extraSupportedSurfaceCombinationsContainer = new ExtraSupportedSurfaceCombinationsContainer();
        this.l = object3;
        object3 = DisplayInfoManager.getInstance((Context)object);
        this.u = object3;
        try {
            object2 = cameraManagerCompat.getCameraCharacteristicsCompat((String)object2);
        }
        catch (CameraAccessExceptionCompat cameraAccessExceptionCompat) {
            throw CameraUnavailableExceptionHelper.createFrom((CameraAccessExceptionCompat)cameraAccessExceptionCompat);
        }
        {
            this.k = object2;
            object3 = (Integer)object2.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
            n = object3 != null ? (Integer)object3 : 2;
        }
        this.m = n;
        int[] nArray = (int[])object2.get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        object2 = nArray;
        if (nArray != null) {
            for (Object object4 : object2) {
                if (object4 == 3) {
                    this.n = true;
                    continue;
                }
                if (object4 == 6) {
                    this.o = true;
                    continue;
                }
                if (Build.VERSION.SDK_INT < 31 || object4 != 16) continue;
                this.r = true;
            }
        }
        object2 = dynamicRangeResolver;
        dynamicRangeResolver = new DynamicRangeResolver(this.k);
        this.x = object2;
        this.a.addAll(GuaranteedConfigurationsUtil.generateSupportedCombinationList((int)this.m, (boolean)this.n, (boolean)this.o));
        this.a.addAll(this.l.get(this.i));
        if (this.r) {
            this.b.addAll(GuaranteedConfigurationsUtil.getUltraHighResolutionSupportedCombinationList());
        }
        if (this.p = object.getPackageManager().hasSystemFeature("android.hardware.camera.concurrent")) {
            this.c.addAll(GuaranteedConfigurationsUtil.getConcurrentSupportedCombinationList());
        }
        if (object2.is10BitDynamicRangeSupported()) {
            this.f.addAll(GuaranteedConfigurationsUtil.get10BitSupportedCombinationList());
        }
        int[] nArray2 = this.k.getStreamConfigurationMapCompat().getOutputFormats();
        object = nArray2;
        if (nArray2 != null) {
            int n2 = ((Context)object).length;
            for (n = 0; n < n2; ++n) {
                if (object[n] != 4101) continue;
                this.g.addAll(GuaranteedConfigurationsUtil.getUltraHdrSupportedCombinationList());
                break;
            }
        }
        this.q = StreamUseCaseUtil.isStreamUseCaseSupported((CameraCharacteristicsCompat)this.k);
        if (this.q && Build.VERSION.SDK_INT >= 33) {
            this.h.addAll(GuaranteedConfigurationsUtil.getStreamUseCaseSupportedCombinationList());
        }
        if (VideoStabilizationUtil.isPreviewStabilizationSupported((CameraCharacteristicsCompat)this.k) && Build.VERSION.SDK_INT >= 33) {
            this.d.addAll(GuaranteedConfigurationsUtil.getPreviewStabilizationSupportedCombinationList());
        }
        this.a();
    }

    public static int a(CameraCharacteristicsCompat cameraCharacteristicsCompat, int n, Size size) {
        int n2 = 0;
        try {
            n2 = (int)(1.0E9 / (double)((StreamConfigurationMap)cameraCharacteristicsCompat.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)).getOutputMinFrameDuration(n, size));
        }
        catch (Exception exception) {}
        return n2;
    }

    public static int a(Range range) {
        return (Integer)range.getUpper() - (Integer)range.getLower() + 1;
    }

    public static int a(Range range, Range range2) {
        Preconditions.checkState((!range.contains((Comparable)((Integer)range2.getUpper())) && !range.contains((Comparable)((Integer)range2.getLower())) ? 1 : 0) != 0, (String)"Ranges must not intersect");
        if ((Integer)range.getLower() > (Integer)range2.getUpper()) {
            return (Integer)range.getLower() - (Integer)range2.getUpper();
        }
        return (Integer)range2.getLower() - (Integer)range.getUpper();
    }

    public static Size a(StreamConfigurationMap sizeArray, int n, boolean bl) {
        Object object = n == 34 ? sizeArray.getOutputSizes(SurfaceTexture.class) : sizeArray.getOutputSizes(n);
        if (object != null && ((Size[])object).length != 0) {
            CompareSizesByArea compareSizesByArea;
            CompareSizesByArea compareSizesByArea2 = object;
            object = compareSizesByArea;
            compareSizesByArea = new CompareSizesByArea();
            Size size = (Size)Collections.max(Arrays.asList(compareSizesByArea2), object);
            Size size2 = SizeUtil.RESOLUTION_ZERO;
            if (Build.VERSION.SDK_INT >= 23 && bl && (sizeArray = scb.a((StreamConfigurationMap)sizeArray, n)) != null && sizeArray.length > 0) {
                size2 = Collections.max(Arrays.asList(sizeArray), object);
            }
            return Collections.max(Arrays.asList(size, size2), object);
        }
        return null;
    }

    public final void a() {
        HashMap hashMap;
        HashMap hashMap2;
        HashMap hashMap3;
        Size size;
        Size size2;
        int n;
        Size size3;
        scc scc2 = hashMap4;
        Size size4 = size3;
        size3 = new Size(1280, 720);
        try {
            n = Integer.parseInt(scc2.i);
            size2 = null;
        }
        catch (NumberFormatException numberFormatException) {
            CompareSizesByArea compareSizesByArea;
            size = ((scc)((Object)hashMap4)).k.getStreamConfigurationMapCompat().toStreamConfigurationMap().getOutputSizes(MediaRecorder.class);
            if (size == null) {
                size = SizeUtil.RESOLUTION_480P;
            }
            Size size5 = size;
            CompareSizesByArea compareSizesByArea2 = compareSizesByArea;
            compareSizesByArea = new CompareSizesByArea(true);
            Arrays.sort(size5, compareSizesByArea2);
            int n2 = ((Size)size5).length;
            for (int i = 0; i < n2; ++i) {
                Size size6 = size[i];
                Size size7 = SizeUtil.RESOLUTION_1080P;
                if (size6.getWidth() > size7.getWidth() || size6.getHeight() > size7.getHeight()) continue;
                size = size6;
            }
            size = SizeUtil.RESOLUTION_480P;
        }
        if (scc2.j.hasProfile(n, 1)) {
            size2 = ((scc)((Object)hashMap4)).j.get(n, 1);
        }
        if (size2 != null) {
            Size size8;
            size = size8;
            Size size9 = size2;
            int n3 = size9.videoFrameWidth;
            size8 = new Size(n3, size9.videoFrameHeight);
        } else {
            size2 = SizeUtil.RESOLUTION_480P;
            CamcorderProfile camcorderProfile = null;
            if (((scc)((Object)hashMap4)).j.hasProfile(n, 10)) {
                camcorderProfile = ((scc)((Object)hashMap4)).j.get(n, 10);
            } else if (((scc)((Object)hashMap4)).j.hasProfile(n, 8)) {
                camcorderProfile = ((scc)((Object)hashMap4)).j.get(n, 8);
            } else if (((scc)((Object)hashMap4)).j.hasProfile(n, 12)) {
                camcorderProfile = ((scc)((Object)hashMap4)).j.get(n, 12);
            } else if (((scc)((Object)hashMap4)).j.hasProfile(n, 6)) {
                camcorderProfile = ((scc)((Object)hashMap4)).j.get(n, 6);
            } else if (((scc)((Object)hashMap4)).j.hasProfile(n, 5)) {
                camcorderProfile = ((scc)((Object)hashMap4)).j.get(n, 5);
            } else if (((scc)((Object)hashMap4)).j.hasProfile(n, 4)) {
                camcorderProfile = ((scc)((Object)hashMap4)).j.get(n, 4);
            }
            if (camcorderProfile != null) {
                Size size10;
                size = size10;
                CamcorderProfile camcorderProfile2 = camcorderProfile;
                int n4 = camcorderProfile2.videoFrameWidth;
                size10 = new Size(n4, camcorderProfile2.videoFrameHeight);
            } else {
                size = size2;
            }
        }
        scc scc3 = hashMap4;
        HashMap hashMap4 = hashMap3;
        hashMap3 = new HashMap();
        HashMap hashMap5 = hashMap2;
        hashMap2 = new HashMap();
        HashMap hashMap6 = hashMap;
        hashMap = new HashMap();
        scc3.s = SurfaceSizeDefinition.create((Size)SizeUtil.RESOLUTION_VGA, new HashMap(), (Size)size4, (Map)hashMap4, (Size)size, hashMap5, hashMap6);
    }

    public final boolean a(SupportedSurfaceCombination.FeatureSettings featureSettings, List list) {
        boolean bl;
        Object object;
        boolean bl2 = false;
        if (((scc)object).e.containsKey(featureSettings)) {
            object = (List)((scc)object).e.get(featureSettings);
        } else {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            if (featureSettings.isUltraHdrOn()) {
                if (featureSettings.getCameraMode() == 0) {
                    arrayList2.addAll(((scc)object).g);
                }
            } else if (featureSettings.getRequiredMaxBitDepth() == 8) {
                int n = featureSettings.getCameraMode();
                if (n != 1) {
                    if (n != 2) {
                        ArrayList arrayList3 = featureSettings.isPreviewStabilizationOn() ? ((scc)object).d : ((scc)object).a;
                        arrayList2.addAll(arrayList3);
                    } else {
                        arrayList2.addAll(((scc)object).b);
                        arrayList2.addAll(((scc)object).a);
                    }
                } else {
                    arrayList2 = ((scc)object).c;
                }
            } else if (featureSettings.getRequiredMaxBitDepth() == 10 && featureSettings.getCameraMode() == 0) {
                arrayList2.addAll(((scc)object).f);
            }
            ((scc)object).e.put(featureSettings, arrayList2);
            object = arrayList2;
        }
        object = object.iterator();
        while (object.hasNext() && !(bl2 = ((SurfaceCombination)object.next()).getOrderedSupportedSurfaceConfigList(list) != null ? (bl = true) : (bl = false))) {
        }
        return bl2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final Pair a(int var1_1, List var2_6, Map var3_7, boolean var4_8, boolean var5_10) {
        block89: {
            block90: {
                block91: {
                    block88: {
                        block92: {
                            block84: {
                                block83: {
                                    this.u.refresh();
                                    if (this.s == null) {
                                        this.a();
                                    } else {
                                        var6_11 = v0;
                                        v0 = new Size(1280, 720);
                                        v1 /* !! */  = var6_11;
                                        var6_11 = this.s.getS1440pSizeMap();
                                        var7_12 = this.s.getMaximumSizeMap();
                                        var8_13 = this.s.getUltraMaximumSizeMap();
                                        this.s = SurfaceSizeDefinition.create((Size)this.s.getAnalysisSize(), (Map)this.s.getS720pSizeMap(), (Size)v1 /* !! */ , (Map)var6_11, (Size)this.s.getRecordSize(), (Map)var7_12, var8_13);
                                    }
                                    var6_11 = v2;
                                    var7_12 = v3;
                                    v3 = new ArrayList<E>();
                                    var8_13 = v4;
                                    v4 = new ArrayList<E>();
                                    var9_14 = new ArrayList<K>(var3_7.keySet()).iterator();
                                    while (var9_14.hasNext()) {
                                        var10_21 = ((UseCaseConfig)var9_14.next()).getSurfaceOccupancyPriority(0);
                                        if (var8_13.contains(var10_21)) continue;
                                        var8_13.add(var10_21);
                                    }
                                    v5 = var8_13;
                                    Collections.sort(v5);
                                    Collections.reverse(v5);
                                    var8_13 = v5.iterator();
                                    while (var8_13.hasNext()) {
                                        var9_15 = (Integer)var8_13.next();
                                        var10_22 = var6_11.iterator();
                                        while (var10_22.hasNext()) {
                                            var11_28 = (UseCaseConfig)var10_22.next();
                                            if (var9_15 != var11_28.getSurfaceOccupancyPriority(0)) continue;
                                            var7_12.add(var6_11.indexOf(var11_28));
                                        }
                                    }
                                    var8_13 = this.x.resolveAndValidateDynamicRanges((List)var2_6, (List)var6_11, (List)var7_12);
                                    var9_14 = var2_6.iterator();
                                    while (var9_14.hasNext()) {
                                        if (((AttachedSurfaceInfo)var9_14.next()).getImageFormat() != 4101) continue;
lbl42:
                                        // 2 sources

                                        while (true) {
                                            var9_16 = true;
                                            break block83;
                                            break;
                                        }
                                    }
                                    var9_14 = var3_7.keySet().iterator();
                                    while (var9_14.hasNext()) {
                                        if (((UseCaseConfig)var9_14.next()).getInputFormat() != 4101) continue;
                                        ** continue;
lbl49:
                                        // 1 sources

                                        ** GOTO lbl42
                                    }
                                    var9_16 = false;
                                }
                                var10_23 = var8_13.values().iterator();
                                while (var10_23.hasNext()) {
                                    if (((DynamicRange)var10_23.next()).getBitDepth() != 10) continue;
                                    var10_24 = 10;
                                    break block84;
                                }
                                var10_24 = 8;
                            }
                            if (var1_1 != 0 && var9_16) {
                                this = this.i;
                                var1_2 = CameraMode.toLabelString((int)var1_1);
                                v6 = var2_6 = v7;
                                var2_6("Camera device id is ");
                                v6.append((String)this);
                                v6.append(". Ultra HDR is not currently supported in ");
                                v7.append(var1_2);
                                v7.append(" camera mode.");
                                throw new IllegalArgumentException(v7.toString());
                            }
                            if (var1_1 != 0 && var10_24 == 10) {
                                this = this.i;
                                var1_3 = CameraMode.toLabelString((int)var1_1);
                                v8 = var2_6 = v9;
                                var2_6("Camera device id is ");
                                v8.append((String)this);
                                v8.append(". 10 bit dynamic range is not currently supported in ");
                                v9.append(var1_3);
                                v9.append(" camera mode.");
                                throw new IllegalArgumentException(v9.toString());
                            }
                            var4_9 = SupportedSurfaceCombination.FeatureSettings.of((int)var1_1, (int)var10_24, (boolean)var4_8, (boolean)var9_16);
                            var9_17 = v10;
                            v10 = new ArrayList<SurfaceConfig>();
                            var10_25 /* !! */  = var2_6.iterator();
                            while (var10_25 /* !! */ .hasNext()) {
                                var9_17.add(((AttachedSurfaceInfo)var10_25 /* !! */ .next()).getSurfaceConfig());
                            }
                            var10_25 /* !! */  = v11;
                            v11 = new CompareSizesByArea();
                            for (Object var12_31 : var3_7.keySet()) {
                                var13_34 = (List)var3_7.get(var12_31);
                                var14_39 = var13_34 != null && var13_34.isEmpty() == false;
                                v12 = var12_31;
                                Preconditions.checkArgument((boolean)var14_39, (Object)("No available output size is found for " + var12_31 + "."));
                                var12_31 = (Size)Collections.min(var13_34, var10_25 /* !! */ );
                                var13_33 = v12.getInputFormat();
                                var9_17.add(SurfaceConfig.transformSurfaceConfig((int)var4_9.getCameraMode(), (int)var13_33, (Size)var12_31, (SurfaceSizeDefinition)this.a(var13_33)));
                            }
                            var9_18 = this.a((SupportedSurfaceCombination.FeatureSettings)var4_9, var9_17);
                            if (!var9_18) break block89;
                            var10_25 /* !! */  = null;
                            var11_28 = var2_6.iterator();
                            while (var11_28.hasNext()) {
                                var12_31 = ((AttachedSurfaceInfo)var11_28.next()).getTargetFrameRate();
                                if (var10_25 /* !! */  == null) {
                                    var10_25 /* !! */  = var12_31;
                                    continue;
                                }
                                if (var12_31 == null) continue;
                                try {
                                    var10_25 /* !! */  = var10_25 /* !! */ .intersect((Range)var12_31);
                                }
                                catch (IllegalArgumentException v13) {}
                            }
                            var11_28 = var7_12.iterator();
                            while (var11_28.hasNext()) {
                                var12_31 = ((UseCaseConfig)var6_11.get((Integer)var11_28.next())).getTargetFrameRate(null);
                                if (var10_25 /* !! */  == null) {
                                    var10_25 /* !! */  = var12_31;
                                    continue;
                                }
                                if (var12_31 == null) continue;
                                try {
                                    var10_25 /* !! */  = var10_25 /* !! */ .intersect((Range)var12_31);
                                }
                                catch (IllegalArgumentException v14) {}
                            }
                            var11_28 = v15;
                            v15 = new HashMap<K, V>();
                            for (UseCaseConfig var13_35 : var3_7.keySet()) {
                                var14_41 = v16;
                                v16 = new ArrayList<Object>();
                                var15_46 = v17;
                                v17 = new HashMap();
                                for (Object var17_52 : (List)var3_7.get(var13_35)) {
                                    var18_56 = var13_35.getInputFormat();
                                    var19_58 = SurfaceConfig.transformSurfaceConfig((int)var4_9.getCameraMode(), (int)var18_56, (Size)var17_52, (SurfaceSizeDefinition)this.a(var18_56)).getConfigSize();
                                    var20_63 = 0x7FFFFFFF;
                                    if (var10_25 /* !! */  != null) {
                                        var20_63 = scc.a(this.k, var18_56, (Size)var17_52);
                                    }
                                    if ((var18_55 = (Set)var15_46.get(var19_58)) == null) {
                                        var18_55 = v18;
                                        v18 = new HashSet<E>();
                                        var15_46.put(var19_58, var18_55);
                                    }
                                    if (var18_55.contains(var20_63)) continue;
                                    var14_41.add(var17_52);
                                    var18_55.add(var20_63);
                                }
                                var11_28.put(var13_35, var14_41);
                            }
                            var3_7 = v19;
                            v19 = new ArrayList<E>();
                            var12_31 = var7_12.iterator();
                            while (var12_31.hasNext()) {
                                v20 = (UseCaseConfig)var6_11.get((Integer)var12_31.next());
                                var13_36 = (List)var11_28.get(v20);
                                var14_42 = v20.getInputFormat();
                                var15_46 = null;
                                switch (this.v.get(this.i, this.k)) {
                                    default: {
                                        break;
                                    }
                                    case 3: {
                                        var15_46 = null;
                                        break;
                                    }
                                    case 2: {
                                        var15_46 = this.a(256).getMaximumSize(256);
                                        var16_50 = v21;
                                        v22 = var15_46;
                                        var15_47 = v22.getWidth();
                                        v21 = new Rational(var15_47, v22.getHeight());
                                        var15_46 = var16_50;
                                        break;
                                    }
                                    case 1: {
                                        var15_46 = AspectRatioUtil.ASPECT_RATIO_16_9;
                                        break;
                                    }
                                    case 0: {
                                        var15_46 = AspectRatioUtil.ASPECT_RATIO_4_3;
                                    }
                                }
                                if (var15_46 != null) {
                                    v23 = var13_36;
                                    var13_36 = v24;
                                    v24 = new ArrayList<E>();
                                    var16_50 = v25;
                                    v25 = new ArrayList<E>();
                                    for (Set var18_55 : v23) {
                                        if (AspectRatioUtil.hasMatchingAspectRatio((Size)var18_55, (Rational)var15_46)) {
                                            var13_36.add(var18_55);
                                            continue;
                                        }
                                        var16_50.add(var18_55);
                                    }
                                    var16_50.addAll(0, var13_36);
                                    var13_36 = var16_50;
                                }
                                var3_7.add(this.w.insertOrPrioritize(SurfaceConfig.getConfigType((int)var14_42), (List)var13_36));
                            }
                            var11_29 = 1;
                            var12_31 = var3_7.iterator();
                            while (var12_31.hasNext()) {
                                var11_29 = ((List)var12_31.next()).size() * var11_29;
                            }
                            if (var11_29 == 0) break block90;
                            var12_31 = v26;
                            v26 = new ArrayList<E>();
                            for (var13_37 = 0; var13_37 < var11_29; ++var13_37) {
                                var14_43 = v27;
                                v27 = new ArrayList<E>();
                                var12_31.add(var14_43);
                            }
                            var13_37 = var11_29 / ((List)var3_7.get(0)).size();
                            var15_48 = var11_29;
                            for (var14_44 = 0; var14_44 < var3_7.size(); ++var14_44) {
                                var16_50 = (List)var3_7.get(var14_44);
                                for (var17_53 = 0; var17_53 < var11_29; ++var17_53) {
                                    ((List)var12_31.get(var17_53)).add((Size)var16_50.get(var17_53 % var15_48 / var13_37));
                                }
                                if (var14_44 < var3_7.size() - 1) {
                                    var15_48 = var13_37 / ((List)var3_7.get(var14_44 + 1)).size();
                                } else {
                                    v28 = var15_48;
                                    var15_48 = var13_37;
                                    var13_37 = v28;
                                }
                                v29 = var13_37;
                                var13_37 = var15_48;
                                var15_48 = v29;
                            }
                            v30 = var2_6;
                            var3_7 = v31;
                            v31 = new HashMap<K, V>();
                            var11_30 = v32;
                            v32 = new HashMap<UseCaseConfig, StreamSpec>();
                            var13_38 = v33;
                            v33 = new HashMap<K, V>();
                            var14_45 = v34;
                            v34 = new HashMap<K, V>();
                            var15_49 = null;
                            var16_51 = 0x7FFFFFFF;
                            var17_54 = null;
                            var18_57 = 0x7FFFFFFF;
                            var19_59 = StreamUseCaseUtil.containsZslUseCase((List)v30, (List)var6_11);
                            var20_64 = null;
                            var21_65 = 0x7FFFFFFF;
                            var22_67 = v30.iterator();
                            while (var22_67.hasNext()) {
                                v35 = var21_65;
                                v36 = (AttachedSurfaceInfo)var22_67.next();
                                var21_65 = v36.getImageFormat();
                                var23_70 /* !! */  = v36.getSize();
                                var21_65 = Math.min(v35, scc.a(this.k, var21_65, var23_70 /* !! */ ));
                            }
                            if (this.q && !var19_59) {
                                var19_60 = var12_31.iterator();
                                while (var19_60.hasNext()) {
                                    var20_64 = (List)var19_60.next();
                                    var20_64 = (List)this.a((int)var1_1, (List)var2_6, (List)var20_64, (ArrayList)var6_11, (ArrayList)var7_12, (int)var21_65, var13_38, var14_45).first;
                                    if (!StreamUseCaseUtil.shouldUseStreamUseCase((SupportedSurfaceCombination.FeatureSettings)var4_9)) {
                                        while (true) {
                                            var20_64 = null;
                                            break;
                                        }
                                    } else {
                                        var22_67 = this.h.iterator();
                                        do {
                                            if (!var22_67.hasNext()) ** continue;
                                        } while ((var23_70 /* !! */  = ((SurfaceCombination)var22_67.next()).getOrderedSupportedSurfaceConfigList(var20_64)) == null);
                                        var20_64 = var23_70 /* !! */ ;
                                    }
                                    if (var20_64 != null && !StreamUseCaseUtil.areCaptureTypesEligible(var13_38, var14_45, (List)var20_64)) {
                                        var20_64 = null;
                                    }
                                    if (var20_64 != null) {
                                        if (StreamUseCaseUtil.areStreamUseCasesAvailableForSurfaceConfigs((CameraCharacteristicsCompat)this.k, (List)var20_64)) break;
                                        var20_64 = null;
                                    }
                                    var13_38.clear();
                                    var14_45.clear();
                                }
                                if (var20_64 == null && !var9_18) {
                                    throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.i + ".  May be attempting to bind too many use cases. Existing surfaces: " + var2_6 + " New configs: " + var6_11);
                                }
                            }
                            var9_18 = false;
                            var12_32 = 0;
                            var19_61 = var12_31.iterator();
                            while (var19_61.hasNext()) {
                                var22_67 = (List)var19_61.next();
                                v37 = this.a(var1_1, (List)var2_6, (List)var22_67, (ArrayList)var6_11, (ArrayList)var7_12, var21_65, null, null);
                                var23_70 /* !! */  = (List)v37.first;
                                var24_71 = (Integer)v37.second;
                                var25_73 = true;
                                if (var10_25 /* !! */  != null && var21_65 > var24_71 && var24_71 < (Integer)var10_25 /* !! */ .getLower()) {
                                    var25_73 = false;
                                }
                                if (!var9_18 && this.a((SupportedSurfaceCombination.FeatureSettings)var4_9, (List)var23_70 /* !! */ )) {
                                    if (var16_51 == 0x7FFFFFFF || var16_51 < var24_71) {
                                        var15_49 = var22_67;
                                        var16_51 = var24_71;
                                    }
                                    if (var25_73) {
                                        var9_18 = true;
                                        if (var12_32 != 0) {
                                            var16_51 = var24_71;
                                            var15_49 = var22_67;
                                            break;
                                        }
                                        var15_49 = var22_67;
                                        var16_51 = var24_71;
                                    }
                                }
                                if (var20_64 == null || var12_32 != 0) continue;
                                if (!StreamUseCaseUtil.shouldUseStreamUseCase((SupportedSurfaceCombination.FeatureSettings)var4_9)) {
                                    while (true) {
                                        var23_70 /* !! */  = null;
                                        break;
                                    }
                                } else {
                                    var26_74 = this.h.iterator();
                                    do {
                                        if (!var26_74.hasNext()) ** continue;
                                    } while ((var27_76 = ((SurfaceCombination)var26_74.next()).getOrderedSupportedSurfaceConfigList((List)var23_70 /* !! */ )) == null);
                                    var23_70 /* !! */  = var27_76;
                                }
                                if (var23_70 /* !! */  == null) continue;
                                if (var18_57 == 0x7FFFFFFF || var18_57 < var24_71) {
                                    var17_54 = var22_67;
                                    var18_57 = var24_71;
                                }
                                if (!var25_73) continue;
                                var12_32 = 1;
                                if (var9_18) {
                                    var17_54 = var22_67;
                                    var18_57 = var24_71;
                                    break;
                                }
                                var17_54 = var22_67;
                                var18_57 = var24_71;
                            }
                            if (var15_49 == null) break block91;
                            var1_4 /* !! */  = null;
                            if (var10_25 /* !! */  == null || var10_25 /* !! */ .equals((Object)(var1_4 /* !! */  = StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED)) || (var4_9 = (Range[])this.k.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES)) == null) break block92;
                            var9_19 = v38;
                            v38 = new Range((Comparable)Integer.valueOf(Math.min((Integer)var10_25 /* !! */ .getLower(), var16_51)), (Comparable)Integer.valueOf(Math.min((Integer)var10_25 /* !! */ .getUpper(), var16_51)));
                            var10_26 = 0;
                            for (Object var21_66 : var4_9) {
                                block85: {
                                    block86: {
                                        block87: {
                                            block94: {
                                                block93: {
                                                    if (var16_51 < (Integer)var21_66.getLower()) continue;
                                                    if (var1_4 /* !! */ .equals((Object)StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED)) {
                                                        var1_4 /* !! */  = var21_66;
                                                    }
                                                    if (var21_66.equals((Object)var9_19)) {
                                                        var1_4 /* !! */  = var21_66;
                                                        break;
                                                    }
                                                    var22_68 = scc.a(var21_66.intersect(var9_19));
                                                    if (var10_26 == 0) {
                                                        var10_26 = var22_68;
                                                        break block85;
                                                    }
                                                    if (var22_68 < var10_26) break block86;
                                                    v39 = var21_66;
                                                    v40 = var9_19;
                                                    var22_69 = scc.a(var1_4 /* !! */ .intersect(var9_19));
                                                    var24_72 = scc.a(v39.intersect(v40));
                                                    v41 = var22_69;
                                                    v42 = v41;
                                                    v43 = v41;
                                                    v44 /* !! */  = var1_4 /* !! */ ;
                                                    var26_75 = var24_72 / (double)scc.a((Range)var21_66);
                                                    var28_77 = v42 / (double)scc.a(v44 /* !! */ );
                                                    if (!(v45 > v43)) break block93;
                                                    if (var26_75 >= 0.5 || var26_75 >= var28_77) lbl-1000:
                                                    // 4 sources

                                                    {
                                                        while (true) {
                                                            var1_4 /* !! */  = var21_66;
                                                            ** GOTO lbl383
                                                            break;
                                                        }
                                                    }
                                                    break block87;
                                                }
                                                if (var24_72 != var22_69) break block94;
                                                if (var26_75 > var28_77) ** GOTO lbl-1000
                                                if (var26_75 != var28_77) break block87;
                                                if ((Integer)var21_66.getLower() <= (Integer)var1_4 /* !! */ .getLower()) break block87;
                                                ** GOTO lbl-1000
                                            }
                                            if (!(var28_77 < 0.5) || !(var26_75 > var28_77)) ** break;
                                            ** continue;
                                        }
                                        try {
                                            var10_26 = scc.a(var9_19.intersect(var1_4 /* !! */ ));
                                        }
                                        catch (IllegalArgumentException v46) {
                                            if (var10_26 != 0 || scc.a((Range)var21_66, var9_19) >= scc.a(var1_4 /* !! */ , var9_19) && (scc.a((Range)var21_66, var9_19) != scc.a(var1_4 /* !! */ , var9_19) || (Integer)var21_66.getLower() <= (Integer)var1_4 /* !! */ .getUpper() && scc.a((Range)var21_66) >= scc.a(var1_4 /* !! */ ))) continue;
                                        }
                                    }
                                    var21_66 = var1_4 /* !! */ ;
                                }
                                var1_4 /* !! */  = var21_66;
                            }
                        }
                        var4_9 = var6_11.iterator();
                        while (var4_9.hasNext()) {
                            var9_20 = (UseCaseConfig)var4_9.next();
                            var10_27 = StreamSpec.builder((Size)((Size)var15_49.get(var7_12.indexOf(var6_11.indexOf(var9_20))))).setDynamicRange((DynamicRange)Preconditions.checkNotNull((Object)((DynamicRange)var8_13.get(var9_20)))).setImplementationOptions((Config)StreamUseCaseUtil.getStreamSpecImplementationOptions((UseCaseConfig)var9_20)).setZslDisabled(var5_10);
                            if (var1_4 /* !! */  != null) {
                                var10_27.setExpectedFrameRateRange(var1_4 /* !! */ );
                            }
                            var11_30.put(var9_20, var10_27.build());
                        }
                        if (var20_64 != null && var16_51 == var18_57 && var15_49.size() == var17_54.size()) {
                            for (var1_5 = 0; var1_5 < var15_49.size(); ++var1_5) {
                                if (((Size)var15_49.get(var1_5)).equals(var17_54.get(var1_5))) {
                                    continue;
                                }
                                break block88;
                            }
                            if (!StreamUseCaseUtil.populateStreamUseCaseStreamSpecOptionWithInteropOverride((CameraCharacteristicsCompat)this.k, (List)var2_6, var11_30, (Map)var3_7)) {
                                StreamUseCaseUtil.populateStreamUseCaseStreamSpecOptionWithSupportedSurfaceConfigs(var11_30, (Map)var3_7, var13_38, var14_45, (List)var20_64);
                            }
                        }
                    }
                    return new Pair(var11_30, var3_7);
                }
                throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.i + " and Hardware level: " + this.m + ". May be the specified resolution is too large and not supported. Existing surfaces: " + var2_6 + " New configs: " + var6_11);
            }
            throw new IllegalArgumentException("Failed to find supported resolutions.");
        }
        throw new IllegalArgumentException("No supported surface combination is found for camera device - Id : " + this.i + ".  May be attempting to bind too many use cases. Existing surfaces: " + var2_6 + " New configs: " + var6_11);
    }

    public final SurfaceSizeDefinition a(int n) {
        if (!this.t.contains(n)) {
            Integer n2;
            Size size;
            scc scc2 = this;
            Object object = scc2.s.getS720pSizeMap();
            Size size2 = SizeUtil.RESOLUTION_720P;
            if (scc2.p) {
                size = scc.a(this.k.getStreamConfigurationMapCompat().toStreamConfigurationMap(), n, false);
                n2 = n;
                if (size != null) {
                    size2 = Collections.min(Arrays.asList(size2, size), new CompareSizesByArea());
                }
                object.put(n2, size2);
            }
            scc scc3 = this;
            object = scc3.s.getS1440pSizeMap();
            size2 = SizeUtil.RESOLUTION_1440P;
            if (scc3.p) {
                size = scc.a(this.k.getStreamConfigurationMapCompat().toStreamConfigurationMap(), n, false);
                n2 = n;
                if (size != null) {
                    size2 = Collections.min(Arrays.asList(size2, size), new CompareSizesByArea());
                }
                object.put(n2, size2);
            }
            scc scc4 = this;
            object = scc4.s.getMaximumSizeMap();
            size2 = scc.a(scc4.k.getStreamConfigurationMapCompat().toStreamConfigurationMap(), n, true);
            if (size2 != null) {
                object.put(n, size2);
            }
            object = this.s.getUltraMaximumSizeMap();
            if (Build.VERSION.SDK_INT >= 31 && this.r && (size2 = (StreamConfigurationMap)this.k.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP_MAXIMUM_RESOLUTION)) != null) {
                Map map = object;
                object = n;
                map.put(object, scc.a((StreamConfigurationMap)size2, n, true));
            }
            this.t.add(n);
        }
        return this.s;
    }

    public final Pair a(int n, List list, List list2, ArrayList arrayList, ArrayList arrayList2, int n2, HashMap hashMap, HashMap hashMap2) {
        ArrayList arrayList3;
        List list3 = list;
        list = arrayList3;
        arrayList3 = new ArrayList();
        for (AttachedSurfaceInfo attachedSurfaceInfo : list3) {
            ((ArrayList)list).add(attachedSurfaceInfo.getSurfaceConfig());
            if (hashMap == null) continue;
            hashMap.put(((ArrayList)list).size() - 1, attachedSurfaceInfo);
        }
        for (int i = 0; i < list2.size(); ++i) {
            AttachedSurfaceInfo attachedSurfaceInfo;
            Size size = (Size)list2.get(i);
            attachedSurfaceInfo = (UseCaseConfig)arrayList.get((Integer)arrayList2.get(i));
            int n3 = attachedSurfaceInfo.getInputFormat();
            SurfaceSizeDefinition surfaceSizeDefinition = this.a(n3);
            ((ArrayList)list).add(SurfaceConfig.transformSurfaceConfig((int)n, (int)n3, (Size)size, (SurfaceSizeDefinition)surfaceSizeDefinition));
            if (hashMap2 != null) {
                hashMap2.put(((ArrayList)list).size() - 1, attachedSurfaceInfo);
            }
            int n4 = n2;
            n2 = attachedSurfaceInfo.getInputFormat();
            n2 = Math.min(n4, scc.a(this.k, n2, size));
        }
        return new Pair((Object)list, (Object)n2);
    }
}

