/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ImageFormat;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import androidx.camera.core.ImageProxy;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001J1\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lio/scanbot/sdk/ui/camera/util/PreviewImageUtil;", "", "", "nv21Image", "", "imageWidth", "imageHeight", "imageOrientation", "Landroid/graphics/Bitmap;", "convertNV21ToBitmap", "([BIII)Landroid/graphics/Bitmap;", "Landroidx/camera/core/ImageProxy;", "image", "convertYUV420toNV21", "(Landroidx/camera/core/ImageProxy;)[B", "convertYUV420toNV21Fast", "sdk-camera_release"}, xi=48)
public final class PreviewImageUtil {
    @NotNull
    public static final PreviewImageUtil INSTANCE = new PreviewImageUtil();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmStatic
    @NotNull
    public static final Bitmap convertNV21ToBitmap(@NotNull byte[] nv21Image, int imageWidth, int imageHeight, int imageOrientation) {
        Throwable throwable3;
        ByteArrayOutputStream byteArrayOutputStream;
        block10: {
            Bitmap bitmap;
            Throwable throwable2;
            block11: {
                Matrix matrix;
                Bitmap bitmap2;
                int n2;
                byte[] byArray;
                Rect rect;
                YuvImage yuvImage;
                void var2_5;
                void var1_4;
                ByteArrayOutputStream byteArrayOutputStream2;
                Object object;
                Intrinsics.checkNotNullParameter((Object)object, (String)"nv21Image");
                byteArrayOutputStream = byteArrayOutputStream2;
                byteArrayOutputStream2 = new ByteArrayOutputStream();
                throwable2 = null;
                try {
                    yuvImage = new YuvImage(object, 17, (int)var1_4, (int)var2_5, null);
                }
                catch (Throwable throwable3) {
                    break block10;
                }
                object = rect;
                {
                    rect = new Rect(0, 0, (int)var1_4, (int)var2_5);
                    yuvImage.compressToJpeg((Rect)object, 100, (OutputStream)byteArrayOutputStream);
                }
                {
                    byArray = byteArrayOutputStream2.toByteArray();
                    n2 = 0;
                }
                {
                    bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)n2, (int)byArray.length);
                    if (imageOrientation == 0) break block11;
                    bitmap2 = bitmap;
                }
                bitmap = matrix;
                {
                    bitmap();
                    {
                        void var3_6;
                        matrix.postRotate((float)var3_6);
                    }
                }
                bitmap = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)var1_4, (int)var2_5, (Matrix)bitmap, (boolean)false);
            }
            Intrinsics.checkNotNull((Object)bitmap);
            CloseableKt.closeFinally((Closeable)byteArrayOutputStream, throwable2);
            return bitmap;
        }
        try {
            throw throwable3;
        }
        catch (Throwable throwable4) {
            CloseableKt.closeFinally((Closeable)byteArrayOutputStream, (Throwable)throwable3);
            throw throwable4;
        }
    }

    public static /* synthetic */ Bitmap convertNV21ToBitmap$default(byte[] byArray, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        return PreviewImageUtil.convertNV21ToBitmap(byArray, n2, n3, n4);
    }

    @JvmStatic
    @NotNull
    public static final byte[] convertYUV420toNV21(@NotNull ImageProxy image) {
        ImageProxy imageProxy;
        ImageProxy imageProxy2 = image;
        Intrinsics.checkNotNullParameter((Object)imageProxy2, (String)"image");
        Rect rect = imageProxy2.getCropRect();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"getCropRect(...)");
        int n2 = imageProxy.getFormat();
        int n3 = rect.width();
        int n4 = rect.height();
        ImageProxy.PlaneProxy[] planeProxyArray = imageProxy2.getPlanes();
        int n5 = n2;
        Intrinsics.checkNotNullExpressionValue((Object)planeProxyArray, (String)"getPlanes(...)");
        n2 = n3 * n4;
        byte[] byArray = new byte[ImageFormat.getBitsPerPixel((int)n5) * n2 / 8];
        byte[] byArray2 = new byte[planeProxyArray[0].getRowStride()];
        int n6 = 0;
        int n7 = 1;
        int n8 = planeProxyArray.length;
        for (int i2 = 0; i2 < n8; ++i2) {
            if (i2 != 0) {
                if (i2 != 1) {
                    if (i2 == 2) {
                        n7 = n6 = 2;
                        n6 = n2;
                    }
                } else {
                    n6 = n2 + 1;
                    n7 = 2;
                }
            } else {
                n6 = 0;
                n7 = 1;
            }
            ByteBuffer byteBuffer = planeProxyArray[i2].getBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"getBuffer(...)");
            int n9 = planeProxyArray[i2].getRowStride();
            int n10 = planeProxyArray[i2].getPixelStride();
            int n11 = i2 == 0 ? 0 : 1;
            int n12 = n3 >> n11;
            int n13 = n4 >> n11;
            int n14 = n9 * (rect.top >> n11);
            byteBuffer.position(n10 * (rect.left >> n11) + n14);
            for (n11 = 0; n11 < n13; ++n11) {
                if (n10 == 1 && n7 == 1) {
                    byteBuffer.get(byArray, n6, n12);
                    n6 += n12;
                    n14 = n12;
                } else {
                    n14 = (n12 - 1) * n10 + 1;
                    byteBuffer.get(byArray2, 0, n14);
                    for (int i3 = 0; i3 < n12; ++i3) {
                        byArray[n6] = byArray2[i3 * n10];
                        n6 += n7;
                    }
                }
                if (n11 >= n13 - 1) continue;
                ByteBuffer byteBuffer2 = byteBuffer;
                byteBuffer2.position(byteBuffer2.position() + n9 - n14);
            }
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmStatic
    @NotNull
    public static final byte[] convertYUV420toNV21Fast(@NotNull ImageProxy image) {
        ImageProxy imageProxy;
        ImageProxy imageProxy2 = image;
        Intrinsics.checkNotNullParameter((Object)imageProxy2, (String)"image");
        int n2 = imageProxy2.getWidth();
        byte by = imageProxy.getHeight();
        int n3 = n2 * by;
        byte[] byArray = new byte[n3 / 4 * 2 + n3];
        ByteBuffer byteBuffer = imageProxy2.getPlanes()[0].getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"getBuffer(...)");
        ByteBuffer byteBuffer2 = imageProxy2.getPlanes()[1].getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"getBuffer(...)");
        ByteBuffer byteBuffer3 = imageProxy2.getPlanes()[2].getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"getBuffer(...)");
        int n4 = imageProxy2.getPlanes()[0].getRowStride();
        int n5 = imageProxy2.getPlanes()[0].getPixelStride() == 1 ? 1 : 0;
        if (_Assertions.ENABLED && n5 == 0) {
            throw new AssertionError((Object)"Assertion failed");
        }
        if (n4 == n2) {
            byteBuffer.get(byArray, 0, n3);
            n5 = n3;
        } else {
            long l2 = n4;
            long l3 = -l2;
            for (n5 = 0; n5 < n3; n5 += n2) {
                byteBuffer.position((int)(l3 += l2));
                byteBuffer.get(byArray, n5, n2);
            }
        }
        int n6 = imageProxy.getPlanes()[2].getRowStride();
        ImageProxy imageProxy3 = imageProxy;
        n4 = imageProxy3.getPlanes()[2].getPixelStride();
        int n7 = n6 == imageProxy3.getPlanes()[1].getRowStride() ? 1 : 0;
        int n8 = _Assertions.ENABLED;
        if (n8 != 0 && n7 == 0) {
            throw new AssertionError((Object)"Assertion failed");
        }
        byte by2 = n4 == imageProxy.getPlanes()[1].getPixelStride() ? (byte)1 : 0;
        if (n8 != 0 && by2 == 0) {
            throw new AssertionError((Object)"Assertion failed");
        }
        if (n4 == 2 && n6 == n2 && byteBuffer2.get(0) == byteBuffer3.get(1)) {
            block17: {
                ByteBuffer byteBuffer4 = byteBuffer3;
                byte by3 = byteBuffer4.get(1);
                by2 = by3;
                n7 = ~by3;
                try {
                    byteBuffer4.put(1, (byte)n7);
                }
                catch (ReadOnlyBufferException readOnlyBufferException) {}
                if (byteBuffer2.get(0) != n7) break block17;
                byte[] byArray2 = byArray;
                ByteBuffer byteBuffer5 = byteBuffer2;
                ByteBuffer byteBuffer6 = byteBuffer5;
                ByteBuffer byteBuffer7 = byteBuffer5;
                ByteBuffer byteBuffer8 = byteBuffer3;
                ByteBuffer byteBuffer9 = byteBuffer2;
                ByteBuffer byteBuffer10 = byteBuffer3;
                ByteBuffer byteBuffer11 = byteBuffer10;
                byteBuffer10.put(1, by2);
                byteBuffer11.position(0);
                byteBuffer9.position(0);
                byteBuffer8.get(byArray, n3, 1);
                ++n3;
                n7 = byteBuffer6.remaining();
                byteBuffer7.get(byArray, n3, n7);
                return byArray2;
            }
            byteBuffer3.put(1, by2);
        }
        by2 = 0;
        by /= 2;
        while (by2 < by) {
            n7 = n2 / 2;
            for (n3 = 0; n3 < n7; n5 += 2, ++n3) {
                n8 = n3 * n4;
                n8 = by2 * n6 + n8;
                int n9 = n5 + 1;
                byArray[n5] = byteBuffer3.get(n8);
                byArray[n9] = byteBuffer2.get(n8);
            }
            ++by2;
        }
        return byArray;
    }
}

