/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.Log;
import android.util.Rational;
import android.util.Size;
import androidx.camera.core.ImageProxy;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.exceptions.camera.CodecFailedException;
import io.scanbot.sdk.image.ImageRotation;
import io.scanbot.tools.utils.KotlinExtensionsKt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\bD\u0010EJ\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J!\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0013\u0010\u0018\u001a\u00020\u0017*\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J1\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00132\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ'\u0010!\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010#\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b#\u0010\u0006J'\u0010$\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010'\u001a\u00020&2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b'\u0010(J\u001f\u0010'\u001a\u00020&2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b'\u0010)J5\u0010-\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\u0013\u00a2\u0006\u0004\b-\u0010.J-\u0010/\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020\b\u00a2\u0006\u0004\b/\u00100J7\u00107\u001a\u0004\u0018\u00010\b2\u0006\u00102\u001a\u0002012\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\u00132\u0006\u00105\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u0013\u00a2\u0006\u0004\b7\u00108J\u001f\u00109\u001a\u00020&2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b9\u0010)J\u0017\u00109\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b9\u0010:J\u0017\u0010;\u001a\u00020&2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b;\u0010<J\u0017\u00109\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b9\u0010\u0006J\u0017\u0010=\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b=\u0010\u0006J'\u00109\u001a\u00020\u00042\u0006\u0010?\u001a\u00020>2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b9\u0010@R\u0014\u0010C\u001a\u00020A8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b9\u0010B\u00a8\u0006F"}, d2={"Lio/scanbot/sdk/ui/camera/util/CameraImageUtils;", "", "Landroidx/camera/core/ImageProxy;", "image", "", "imageToJpegByteArray", "(Landroidx/camera/core/ImageProxy;)[B", "data", "Landroid/graphics/Rect;", "cropRect", "cropByteArray", "([BLandroid/graphics/Rect;)[B", "Landroid/util/Size;", "sourceSize", "Landroid/util/Rational;", "aspectRatio", "computeCropRectFromAspectRatio", "(Landroid/util/Size;Landroid/util/Rational;)Landroid/graphics/Rect;", "rational", "", "rotation", "rotate", "(Landroid/util/Rational;I)Landroid/util/Rational;", "Lio/scanbot/sdk/image/ImageRotation;", "toImageRotation", "(I)Lio/scanbot/sdk/image/ImageRotation;", "nv21", "width", "height", "nv21ToJpeg", "([BIILandroid/graphics/Rect;)[B", "Landroid/graphics/Bitmap;", "src", "bitmapToNv21", "(Landroid/graphics/Bitmap;II)[B", "yuv420888toNv21", "nv21ToYuv420888", "([BII)[B", "", "isAspectRatioValid", "(Landroid/util/Rational;)Z", "(Landroid/util/Size;Landroid/util/Rational;)Z", "changeOrientation", "origRect", "padding", "calculateFinderRectWithPadding", "(IIZLandroid/graphics/Rect;I)Landroid/graphics/Rect;", "calculateSquareRect", "(IIZLandroid/graphics/Rect;)Landroid/graphics/Rect;", "Lio/scanbot/sdk/camera/FrameHandler$FrameCroppingMode;", "frameCroppingMode", "finderRect", "imageWidth", "imageHeight", "imageOrientation", "calculateModifiedRect", "(Lio/scanbot/sdk/camera/FrameHandler$FrameCroppingMode;Landroid/graphics/Rect;III)Landroid/graphics/Rect;", "a", "(Landroid/util/Rational;)Landroid/util/Rational;", "b", "(Landroidx/camera/core/ImageProxy;)Z", "c", "", "argb", "([III)[B", "", "Ljava/lang/String;", "TAG", "<init>", "()V", "sdk-camera_release"})
@SourceDebugExtension(value={"SMAP\nCameraImageUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraImageUtils.kt\nio/scanbot/sdk/ui/camera/util/CameraImageUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,506:1\n1#2:507\n*E\n"})
public final class CameraImageUtils {
    @NotNull
    public static final CameraImageUtils INSTANCE = new CameraImageUtils();
    @NotNull
    public static final String a = "ImageUtil";

    @JvmStatic
    @Nullable
    public static final byte[] imageToJpegByteArray(@NotNull ImageProxy image) throws CodecFailedException {
        ImageProxy imageProxy = image;
        Intrinsics.checkNotNullParameter((Object)imageProxy, (String)"image");
        byte[] byArray = null;
        int n2 = imageProxy.getFormat();
        if (n2 != 35) {
            if (n2 != 256) {
                Log.w((String)a, (String)("Unrecognized image format: " + var0.getFormat()));
            } else {
                byArray = INSTANCE.a(var0);
            }
        } else {
            byArray = INSTANCE.c(var0);
        }
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] cropByteArray(@NotNull byte[] data, @Nullable Rect cropRect) throws CodecFailedException {
        IllegalArgumentException illegalArgumentException2;
        block10: {
            block9: {
                block8: {
                    ByteArrayOutputStream byteArrayOutputStream;
                    BitmapFactory.Options options;
                    BitmapFactory.Options options2;
                    byte[] byArray;
                    Intrinsics.checkNotNullParameter((Object)byArray, (String)"data");
                    if (cropRect == null) {
                        return byArray;
                    }
                    int n2 = 0;
                    Object object = BitmapRegionDecoder.newInstance((byte[])byArray, (int)n2, (int)byArray.length, (boolean)false);
                    void v0 = options2;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newInstance(...)");
                    options2 = options;
                    options = new BitmapFactory.Options();
                    options2 = object.decodeRegion((Rect)v0, options2);
                    try {
                        object.recycle();
                        if (options2 == null) break block8;
                    }
                    catch (IOException iOException) {
                        break block9;
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        break block10;
                    }
                    object = byteArrayOutputStream;
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    if (options2.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)object)) {
                        options2.recycle();
                        byte[] byArray2 = ((ByteArrayOutputStream)object).toByteArray();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
                        return byArray2;
                    }
                    throw new CodecFailedException("Encode bitmap failed.", CodecFailedException.FailureType.ENCODE_FAILED);
                }
                throw new CodecFailedException("Decode byte array failed.", CodecFailedException.FailureType.DECODE_FAILED);
            }
            throw new CodecFailedException("Decode byte array failed.", CodecFailedException.FailureType.DECODE_FAILED);
        }
        throw new CodecFailedException("Decode byte array failed with illegal argument." + illegalArgumentException2, CodecFailedException.FailureType.DECODE_FAILED);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final Rect computeCropRectFromAspectRatio(@NotNull Size sourceSize, @NotNull Rational aspectRatio) {
        void var1_2;
        Size size;
        Intrinsics.checkNotNullParameter((Object)size, (String)"sourceSize");
        Intrinsics.checkNotNullParameter((Object)aspectRatio, (String)"aspectRatio");
        if (!INSTANCE.isAspectRatioValid((Rational)var1_2)) {
            Log.w((String)a, (String)"Invalid view ratio.");
            return null;
        }
        void v0 = var1_2;
        int n2 = size.getWidth();
        int n3 = size.getHeight();
        float f2 = n2;
        float f3 = n3;
        float f4 = f2 / f3;
        int n4 = 0;
        int n5 = 0;
        int n6 = v0.getNumerator();
        int n7 = v0.getDenominator();
        if (v0.floatValue() > f4) {
            int n8 = n3;
            n3 = Math.round(f2 / (float)n6 * (float)n7);
            n5 = (n8 - n3) / 2;
        } else {
            int n9 = n2;
            n2 = Math.round(f3 / (float)n7 * (float)n6);
            n4 = (n9 - n2) / 2;
        }
        n2 = n4 + n2;
        n3 = n5 + n3;
        return new Rect(n4, n5, n2, n3);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Rational rotate(@NotNull Rational rational, int rotation) {
        void var1_1;
        Rational rational2;
        Intrinsics.checkNotNullParameter((Object)rational2, (String)"rational");
        if (rotation == 90 || var1_1 == 270) {
            rational2 = INSTANCE.a(rational2);
        }
        return rational2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @NotNull
    public static final ImageRotation toImageRotation(int $this$toImageRotation) {
        ImageRotation imageRotation;
        if ($this$toImageRotation != 0) {
            int n2;
            if (n2 != 90) {
                if (n2 != 180) {
                    if (n2 != 270) throw new IllegalArgumentException("Unsupported rotation: " + n2);
                    imageRotation = ImageRotation.COUNTERCLOCKWISE_90;
                    return imageRotation;
                } else {
                    imageRotation = ImageRotation.CLOCKWISE_180;
                }
                return imageRotation;
            } else {
                imageRotation = ImageRotation.CLOCKWISE_90;
            }
            return imageRotation;
        } else {
            imageRotation = ImageRotation.NONE;
        }
        return imageRotation;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final byte[] nv21ToJpeg(@NotNull byte[] nv21, int width, int height, @Nullable Rect cropRect) throws CodecFailedException {
        Rect rect;
        void var2_2;
        void var1_1;
        YuvImage yuvImage;
        ByteArrayOutputStream byteArrayOutputStream;
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"nv21");
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        YuvImage yuvImage2 = yuvImage;
        yuvImage = new YuvImage(byArray, 17, (int)var1_1, (int)var2_2, null);
        if (cropRect == null) {
            Rect rect2;
            rect = rect2;
            rect2 = new Rect(0, 0, (int)var1_1, (int)var2_2);
        }
        if (yuvImage2.compressToJpeg(rect, 100, (OutputStream)byteArrayOutputStream2)) {
            byte[] byArray2 = byteArrayOutputStream2.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"toByteArray(...)");
            return byArray2;
        }
        throw new CodecFailedException("YuvImage failed to encode jpeg.", CodecFailedException.FailureType.ENCODE_FAILED);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final byte[] bitmapToNv21(@NotNull Bitmap src, int width, int height) throws CodecFailedException {
        void var2_2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"src");
        if (KotlinExtensionsKt.isEven((int)width) && KotlinExtensionsKt.isEven((int)var2_2)) {
            void var1_1;
            if (object.getWidth() >= var1_1 && object.getHeight() >= var2_2) {
                Bitmap bitmap = object;
                int[] nArray = new int[var1_1 * var2_2];
                object = nArray;
                bitmap.getPixels(nArray, 0, (int)var1_1, 0, 0, (int)var1_1, (int)var2_2);
                return INSTANCE.a((int[])object, (int)var1_1, (int)var2_2);
            }
            throw new CodecFailedException("Invalid source Bitmap image!");
        }
        throw new IllegalStateException("bitmapToNv21 needs even width and height of image!".toString());
    }

    @JvmStatic
    @NotNull
    public static final byte[] yuv420888toNv21(@NotNull ImageProxy image) {
        int n2;
        ImageProxy imageProxy;
        ImageProxy imageProxy2 = image;
        Intrinsics.checkNotNullParameter((Object)imageProxy2, (String)"image");
        ImageProxy.PlaneProxy planeProxy = imageProxy2.getPlanes()[0];
        ImageProxy imageProxy3 = imageProxy;
        ImageProxy.PlaneProxy planeProxy2 = imageProxy3.getPlanes()[1];
        ImageProxy.PlaneProxy planeProxy3 = imageProxy3.getPlanes()[2];
        ByteBuffer byteBuffer = planeProxy.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"getBuffer(...)");
        ByteBuffer byteBuffer2 = planeProxy2.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"getBuffer(...)");
        ByteBuffer byteBuffer3 = planeProxy3.getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"getBuffer(...)");
        byteBuffer.rewind();
        byteBuffer2.rewind();
        byteBuffer3.rewind();
        int n3 = byteBuffer.remaining();
        int n4 = 0;
        int n5 = imageProxy2.getWidth();
        byte[] byArray = new byte[imageProxy2.getHeight() * n5 / 2 + n3];
        int n6 = imageProxy2.getHeight();
        for (int i2 = 0; i2 < n6; ++i2) {
            byteBuffer.get(byArray, n4, imageProxy.getWidth());
            n4 = imageProxy.getWidth() + n4;
            n2 = byteBuffer.position() - imageProxy.getWidth();
            byteBuffer.position(Math.min(n3, planeProxy.getRowStride() + n2));
        }
        ImageProxy imageProxy4 = imageProxy;
        int n7 = imageProxy4.getHeight() / 2;
        int n8 = imageProxy4.getWidth() / 2;
        int n9 = planeProxy3.getRowStride();
        n3 = planeProxy2.getRowStride();
        int n10 = planeProxy3.getPixelStride();
        int n11 = planeProxy2.getPixelStride();
        byte[] byArray2 = new byte[n9];
        byte[] byArray3 = new byte[n3];
        for (n2 = 0; n2 < n7; ++n2) {
            byteBuffer3.get(byArray2, 0, Math.min(n9, byteBuffer3.remaining()));
            byteBuffer2.get(byArray3, 0, Math.min(n3, byteBuffer2.remaining()));
            int n12 = 0;
            int n13 = 0;
            for (int i3 = 0; i3 < n8; ++i3) {
                int n14 = n4 + 1;
                byArray[n4] = byArray2[n12];
                n4 += 2;
                byArray[n14] = byArray3[n13];
                n12 += n10;
                n13 += n11;
            }
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final byte[] nv21ToYuv420888(@NotNull byte[] nv21, int width, int height) {
        void var1_1;
        void var2_2;
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"nv21");
        byte[] byArray2 = new byte[(var1_1 *= var2_2) * 3 / 2];
        int n2 = var1_1 / 2;
        System.arraycopy(nv21, 0, byArray2, 0, (int)var1_1);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2 * 2 + var1_1;
            int n4 = n3 + 1;
            byArray2[n3] = byArray[n4];
            byArray2[n4] = byArray[n3];
        }
        return byArray2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAspectRatioValid(@Nullable Rational aspectRatio) {
        void var1_1;
        return aspectRatio != null && var1_1.floatValue() > 0.0f && !var1_1.isNaN();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isAspectRatioValid(@NotNull Size sourceSize, @Nullable Rational aspectRatio) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"sourceSize");
        return aspectRatio != null && var2_2.floatValue() > 0.0f && this.a((Size)var1_1, (Rational)var2_2) && !var2_2.isNaN();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Rect calculateFinderRectWithPadding(int width, int height, boolean changeOrientation, @NotNull Rect origRect, int padding) {
        Rect rect;
        void var1_2;
        int n2;
        int n3;
        int n4;
        void var4_6;
        Rect rect2 = origRect;
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"origRect");
        if (rect2.width() == var4_6.height()) {
            return var4_6;
        }
        void v1 = var4_6;
        int n5 = v1.left - n4;
        int n6 = v1.top - n4;
        int n7 = v1.right + n4;
        n4 = v1.bottom + n4;
        int n8 = n3 != 0 ? n2 : var1_2;
        if (n3 == 0) {
            var1_2 = n2;
        }
        if (n5 >= 0 && n6 >= 0 && n7 <= n8 && n4 <= var1_2) {
            Rect rect3;
            rect = rect3;
            rect3 = new Rect(n5, n6, n7, n4);
        } else {
            Rect rect4;
            n2 = 0;
            n3 = 0;
            int n9 = 0;
            int n10 = 0;
            if (n5 < 0) {
                n2 = Math.abs(n5);
            }
            if (n6 < 0) {
                n3 = Math.abs(n6);
            }
            if (n7 > n8) {
                n10 = n7 - n8;
            }
            if (n4 > var1_2) {
                n9 = n4 - var1_2;
            }
            rect = rect4;
            n5 = n5 + n2 - n10;
            n6 = n6 + n3 - n9;
            n2 = n7 - n10 + n2;
            n3 = n4 - n9 + n3;
            rect4 = new Rect(n5, n6, n2, n3);
        }
        return rect;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Rect calculateSquareRect(int width, int height, boolean changeOrientation, @NotNull Rect origRect) {
        Rect rect;
        int n2;
        int n3;
        void var1_2;
        void var4_6;
        Rect rect2 = origRect;
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"origRect");
        if (rect2.width() == var4_6.height()) {
            return var4_6;
        }
        void v1 = var4_6;
        int n4 = RangesKt.coerceAtMost((int)Math.max(v1.height(), var4_6.width()), (int)Math.min((int)var1_2, n3)) / 2;
        int n5 = v1.centerX();
        int n6 = v1.centerY();
        int n7 = n6;
        int n8 = n4;
        int n9 = n5;
        int n10 = n4;
        int n11 = n4;
        n4 = n5 - n4;
        n5 = n7 - n11;
        n7 = n9 + n10;
        int n12 = n6 + n8;
        int n13 = n2 != 0 ? n3 : var1_2;
        if (n2 == 0) {
            var1_2 = n3;
        }
        if (n4 >= 0 && n5 >= 0 && n7 <= n13 && n12 <= var1_2) {
            Rect rect3;
            rect = rect3;
            rect3 = new Rect(n4, n5, n7, n12);
        } else {
            Rect rect4;
            n3 = 0;
            n2 = 0;
            int n14 = 0;
            int n15 = 0;
            if (n4 < 0) {
                n3 = Math.abs(n4);
            }
            if (n5 < 0) {
                n2 = Math.abs(n5);
            }
            if (n7 > n13) {
                n15 = n7 - n13;
            }
            if (n12 > var1_2) {
                n14 = n12 - var1_2;
            }
            rect = rect4;
            n4 = n4 + n3 - n15;
            n5 = n5 + n2 - n14;
            n3 = n7 - n15 + n3;
            n2 = n12 - n14 + n2;
            rect4 = new Rect(n4, n5, n3, n2);
        }
        return rect;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Rect calculateModifiedRect(@NotNull FrameHandler.FrameCroppingMode frameCroppingMode, @NotNull Rect finderRect, int imageWidth, int imageHeight, int imageOrientation) {
        block5: {
            Rect rect;
            block2: {
                void var4_6;
                void var3_5;
                void var5_7;
                Object object;
                Integer n2;
                block4: {
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)n2, (String)"frameCroppingMode");
                        Intrinsics.checkNotNullParameter((Object)rect, (String)"finderRect");
                        if (frameCroppingMode instanceof FrameHandler.FrameCroppingMode.CropToFinder) break block2;
                        if (!(n2 instanceof FrameHandler.FrameCroppingMode.CropWithPadding)) break block3;
                        CameraImageUtils cameraImageUtils = object;
                        void v1 = n2;
                        object = 90;
                        n2 = 270;
                        boolean bl = CollectionsKt.listOf((Object[])new Integer[]{object, n2}).contains((int)var5_7);
                        int n3 = ((FrameHandler.FrameCroppingMode.CropWithPadding)v1).getPadding();
                        rect = cameraImageUtils.calculateFinderRectWithPadding((int)var3_5, (int)var4_6, bl, rect, n3);
                        break block2;
                    }
                    if (!(n2 instanceof FrameHandler.FrameCroppingMode.FullFrame)) break block4;
                    rect = null;
                    break block2;
                }
                if (!(n2 instanceof FrameHandler.FrameCroppingMode.SquareToFrameCropping)) break block5;
                Object object2 = object;
                object = 90;
                n2 = 270;
                rect = ((CameraImageUtils)object2).calculateSquareRect((int)var3_5, (int)var4_6, CollectionsKt.listOf((Object[])new Integer[]{object, n2}).contains((int)var5_7), rect);
            }
            return rect;
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean a(Size sourceSize, Rational aspectRatio) {
        int n2;
        float f2;
        void var2_4;
        Size size = sourceSize;
        int n3 = size.getWidth();
        int n4 = size.getHeight();
        void v1 = var2_4;
        int n5 = v1.getNumerator();
        float f3 = n5;
        return n4 != Math.round((float)n3 / f3 * (f2 = (float)(n2 = v1.getDenominator()))) || n3 != Math.round((float)n4 / f2 * f3);
    }

    public final Rational a(Rational rational) {
        CameraImageUtils cameraImageUtils;
        if (rational != null) {
            Rational rational2;
            CameraImageUtils cameraImageUtils2 = rational2;
            void v1 = cameraImageUtils;
            int n2 = v1.getDenominator();
            rational2 = new Rational(n2, v1.getNumerator());
            cameraImageUtils = cameraImageUtils2;
        }
        return cameraImageUtils;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean b(ImageProxy image) {
        void var1_1;
        Size size;
        CameraImageUtils cameraImageUtils = size;
        void v1 = var1_1;
        int n2 = v1.getWidth();
        size = new Size(n2, v1.getHeight());
        return Intrinsics.areEqual((Object)new Size(var1_1.getCropRect().width(), var1_1.getCropRect().height()), (Object)cameraImageUtils) ^ true;
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] a(ImageProxy image) throws CodecFailedException {
        void var1_1;
        CameraImageUtils cameraImageUtils = this_;
        void v1 = var1_1;
        ImageProxy.PlaneProxy[] planeProxyArray = v1.getPlanes();
        Intrinsics.checkNotNullExpressionValue((Object)planeProxyArray, (String)"getPlanes(...)");
        ByteBuffer byteBuffer = planeProxyArray[0].getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"getBuffer(...)");
        byteBuffer.rewind();
        byte[] byArray = new byte[byteBuffer.capacity()];
        Object this_ = byArray;
        byteBuffer.get(byArray);
        if (cameraImageUtils.b((ImageProxy)v1)) {
            this_ = CameraImageUtils.cropByteArray((byte[])this_, var1_1.getCropRect());
        }
        return this_;
    }

    public final byte[] c(ImageProxy image) throws CodecFailedException {
        Rect rect;
        CameraImageUtils cameraImageUtils = this_;
        void v1 = rect;
        Object this_ = CameraImageUtils.yuv420888toNv21((ImageProxy)v1);
        int n2 = v1.getWidth();
        int n3 = v1.getHeight();
        rect = cameraImageUtils.b((ImageProxy)v1) ? rect.getCropRect() : null;
        return CameraImageUtils.nv21ToJpeg((byte[])this_, n2, n3, rect);
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] a(int[] argb, int width, int height) {
        int n2;
        int n3 = width * n2;
        int n4 = 0;
        int n5 = 0;
        int n6 = n3 * 3 / 2;
        byte[] byArray = new byte[n6];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n7;
            for (int i3 = 0; i3 < n7; ++i3) {
                void var1_2;
                void v0 = var1_2[n5];
                int n8 = (v0 & 0xFF0000) >> 16;
                int n9 = (v0 & 0xFF00) >> 8;
                int n10 = v0 & 0xFF;
                int n11 = n8 * 66;
                n11 = n9 * 129 + n11;
                n11 = (n10 * 25 + n11 + 128 >> 8) + 16;
                int n12 = n8;
                n8 = (n12 * 112 - n9 * 94 - n10 * 18 + 128 >> 8) + 128;
                n9 = n12 * -38 - n9 * 74;
                n9 = (n10 * 112 + n9 + 128 >> 8) + 128;
                n10 = n4 + 1;
                if (n11 < 0) {
                    n11 = 0;
                } else if (n11 > 255) {
                    n11 = 255;
                }
                byArray[n4] = (byte)n11;
                if (i2 % 2 == 0 && n5 % 2 == 0 && n3 < n6 - 2) {
                    n4 = n3 + 1;
                    if (n9 < 0) {
                        n9 = 0;
                    } else if (n9 > 255) {
                        n9 = 255;
                    }
                    byArray[n3] = (byte)n9;
                    n3 += 2;
                    if (n8 < 0) {
                        n8 = 0;
                    } else if (n8 > 255) {
                        n8 = 255;
                    }
                    byArray[n4] = (byte)n8;
                }
                n4 = n5 + 1;
                int n13 = n4;
                n4 = n10;
                n5 = n13;
            }
        }
        return byArray;
    }
}

