/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.camera;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.hardware.Camera;
import android.media.MediaRecorder;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.commonsware.cwac.camera.CameraHost$RecordingHint;
import com.commonsware.cwac.camera.mta;
import com.commonsware.cwac.camera.mtc;
import com.commonsware.cwac.camera.mtf;
import com.commonsware.cwac.camera.mtg;
import com.commonsware.cwac.camera.mth;
import com.commonsware.cwac.camera.mtih;
import com.commonsware.cwac.camera.mtk;
import com.commonsware.cwac.camera.mtm;
import com.commonsware.cwac.camera.mtn;
import com.commonsware.cwac.camera.mtna;
import com.commonsware.cwac.camera.mto;
import com.commonsware.cwac.camera.mtob;
import com.commonsware.cwac.camera.mtpu;
import com.commonsware.cwac.camera.mtq;
import com.commonsware.cwac.camera.mtqc;
import com.commonsware.cwac.camera.mtr;
import com.commonsware.cwac.camera.mtt;
import com.commonsware.cwac.camera.mttv;
import com.commonsware.cwac.camera.mtx;
import com.commonsware.cwac.camera.mtxy;
import com.commonsware.cwac.camera.mty;
import com.commonsware.cwac.camera.mtz;
import java.io.IOException;

public abstract class mtjw
extends ViewGroup
implements Camera.AutoFocusCallback {
    public static final int[] mtf;
    public static final Handler mty;
    protected mtih previewStrategy;
    public Camera.Size mtc;
    public Camera mti = null;
    protected boolean inPreview = false;
    public mtc mtk = null;
    public final mtr mtg = null;
    public int mtq = -1;
    public int mts = -1;
    public int mte = -1;
    public MediaRecorder mtm = null;
    public Camera.Parameters mtx = null;
    public boolean mto = false;
    public boolean mtv = false;
    public mty mth;
    public int mtb;
    public WindowManager mtl;
    public boolean mtj = false;
    public boolean mtt = false;

    public mtjw(Context context) {
        super(context);
        mtr mtr2;
        mtr mtr3 = mtr2;
        mtr2 = new mtr(this, context);
        this.mtg = mtr3;
    }

    /*
     * WARNING - void declaration
     */
    private void setCameraPictureOrientation(Camera.Parameters params) {
        void var1_1;
        Camera.CameraInfo cameraInfo;
        mtjw mtjw2 = this;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)mtjw2.mte, (Camera.CameraInfo)cameraInfo2);
        if (mtjw2.mtj && !this.mtt) {
            mtjw mtjw3 = this;
            mtjw3.mts = mtjw3.mtc(mtjw3.mtl.getDefaultDisplay().getOrientation());
        } else {
            this.mts = cameraInfo2.facing == 1 ? (360 - this.mtq) % 360 : this.mtq;
        }
        if (this.mts % 90 != 0) {
            this.mts = 0;
        }
        var1_1.setRotation(this.mts);
    }

    static {
        HandlerThread handlerThread;
        mtf = new int[]{0, 90, 180, 270};
        HandlerThread handlerThread2 = handlerThread;
        new HandlerThread("CWAC_CAMERA", 10).start();
        mty = new Handler(handlerThread2.getLooper());
    }

    public mtc getCameraHost() {
        return this.mtk;
    }

    public void setCameraHost(mtc host) {
        mtxy mtxy2;
        mtih mtih2;
        this.mtk = mtih2;
        if (((mtpu)host.getDeviceProfile()).mti) {
            mtna mtna2;
            mtih2 = mtna2;
            mtna2 = new mtna(this);
            this.previewStrategy = mtih2;
            return;
        }
        mtih2 = mtxy2;
        mtxy2 = new mtxy(this);
        this.previewStrategy = mtih2;
    }

    public synchronized Camera.Parameters getCameraParameters() {
        Camera camera = this.mti;
        if (camera != null && this.mtx == null) {
            try {
                this.mtx = camera.getParameters();
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"getCameraParameters(). Could not work with camera parameters.");
            }
        }
        return this.mtx;
    }

    /*
     * WARNING - void declaration
     */
    public void setCameraParameters(Camera.Parameters parameters) {
        void var1_1;
        mty.post((Runnable)new mth(this, (Camera.Parameters)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultPreviewSize(Camera.Size newPreviewSize) {
        void var1_1;
        mty.post((Runnable)new mtt(this, (Camera.Size)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultPictureSize(Camera.Size newPictureSize) {
        void var1_1;
        mty.post((Runnable)new mtf(this, (Camera.Size)var1_1));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCameraParametersSync(Camera.Parameters parameters) {
        try {
            void var1_1;
            Camera camera = this.mti;
            if (camera != null && var1_1 != null) {
                camera.setParameters((Camera.Parameters)var1_1);
            }
            this.mtx = var1_1;
            return;
        }
        catch (RuntimeException runtimeException) {}
        Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setCameraParametersSync(). Could not set camera parameters.");
    }

    /*
     * WARNING - void declaration
     */
    public void onCameraOpen(Camera object) {
        block11: {
            void var2_4;
            try {
                this.previewStrategy.mtc();
                break block11;
            }
            catch (RuntimeException runtimeException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.getCameraHost().handleException((Exception)var2_4);
        }
        this.mtl = (WindowManager)this.getContext().getSystemService("window");
        if (this.mtj && !this.mtt) {
            this.mtg.enable();
        }
        this.mtc();
        if (Build.VERSION.SDK_INT >= 14 && this.getCameraHost() instanceof Camera.FaceDetectionListener) {
            object.setFaceDetectionListener((Camera.FaceDetectionListener)this.getCameraHost());
        }
        if (this.mth == null) {
            mty mty2;
            object = mty2;
            mty2 = new mty(this, this.getContext());
            this.mth = object;
        }
        if (this.mth.canDetectOrientation()) {
            this.mth.enable();
        }
        if (this.mtj) {
            this.mtc();
            if (!this.mtt) {
                this.mtg.enable();
            } else {
                object = this.getCameraParameters();
                if (object != null) {
                    this.setCameraPictureOrientation((Camera.Parameters)object);
                    this.setCameraParametersSync((Camera.Parameters)object);
                }
            }
        }
    }

    public void onResume() {
        this.mtg.mtc = -1;
        ViewGroup viewGroup = (ViewGroup)this.previewStrategy.mti().getParent();
        if (viewGroup != null) {
            viewGroup.removeAllViews();
        }
        mtjw mtjw2 = this;
        mtjw2.addView(mtjw2.previewStrategy.mti());
        mty.post((Runnable)new mta(this));
    }

    public void onPause() {
        mty.post((Runnable)new mtm((mtjw)((Object)object)));
        if (object.previewStrategy.mti() != null) {
            mtjw mtjw2 = object;
            mtjw2.removeView(mtjw2.previewStrategy.mti());
        }
        mtjw mtjw3 = object;
        mtjw3.mtg.disable();
        Object object = mtjw3.mth;
        if (object != null) {
            object.disable();
            return;
        }
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        n2 = View.resolveSize((int)this.getSuggestedMinimumWidth(), (int)n2);
        n = View.resolveSize((int)this.getSuggestedMinimumHeight(), (int)n);
        this.setMeasuredDimension(n2, n);
        if (n2 > 0 && n > 0) {
            mty.post((Runnable)new mtz(this, n2, n));
            return;
        }
    }

    public Camera.Size getPreviewSize() {
        return this.mtc;
    }

    /*
     * WARNING - void declaration
     */
    public void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.getChildCount() > 0) {
            int n;
            void var3_11;
            int n2;
            void var2_10;
            void var4_12;
            View view = this.getChildAt(0);
            var2_10 = var4_12 - var2_10;
            var3_11 = n2 - var3_11;
            Camera.Size size = this.mtc;
            if (size != null && size.height > 0 && size.width > 0) {
                if (this.getDisplayOrientation() != 90 && this.getDisplayOrientation() != 270) {
                    Camera.Size size2 = this.mtc;
                    n = size2.width;
                    n2 = size2.height;
                } else {
                    Camera.Size size3 = this.mtc;
                    n = size3.height;
                    n2 = size3.width;
                }
            } else {
                n2 = var3_11;
                n = var2_10;
            }
            if (n != 0 && n2 != 0) {
                void var6_16 = var2_10 * n2;
                void var7_17 = var3_11 * n;
                boolean bl = var6_16 > var7_17;
                boolean n3 = this.getCameraHost().useFullBleedPreview();
                if (bl && !n3 || !bl && n3) {
                    void v2 = var2_10;
                    void var0_2 = var7_17 / n2;
                    void var1_8 = (v2 - var0_2) / 2;
                    void var0_3 = (v2 + var0_2) / 2;
                    view.layout((int)var1_8, 0, (int)var0_3, (int)var3_11);
                    return;
                }
                void v3 = var3_11;
                void var0_4 = var6_16 / n;
                void var1_9 = (v3 - var0_4) / 2;
                void var0_5 = (v3 + var0_4) / 2;
                view.layout(0, (int)var1_9, (int)var2_10, (int)var0_5);
                return;
            }
        }
    }

    public int getDisplayOrientation() {
        return this.mtq;
    }

    /*
     * WARNING - void declaration
     */
    public void lockToLandscape(boolean lockPicture) {
        void var1_1;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(6);
        }
        mtjw mtjw2 = this;
        mtjw2.mtj = true;
        mtjw2.mtt = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void lockToPortrait(boolean lockPicture) {
        void var1_1;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(7);
        }
        mtjw mtjw2 = this;
        mtjw2.mtj = true;
        mtjw2.mtt = var1_1;
    }

    public void unlockOrientation() {
        this.mtj = false;
        this.mtt = false;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(-1);
        }
        mtjw mtjw2 = this;
        mtjw2.mtg.disable();
        mtjw2.post(new mtn(this));
    }

    public void restartPreview() {
        if (!this.inPreview) {
            this.startPreview();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void takePicture(boolean needBitmap, boolean needByteArray) {
        void var2_2;
        void var1_1;
        mtob mtob2;
        mtob mtob3 = mtob2;
        mtob3(this.getCameraHost());
        mtob3.mti = var1_1;
        mtob2.mtk = var2_2;
        this.takePicture(mtob2);
    }

    public abstract void takePicture(mtob var1);

    public boolean isRecording() {
        return this.mtm != null;
    }

    public void record() {
        if (Build.VERSION.SDK_INT >= 11) {
            MediaRecorder mediaRecorder;
            int n = this.mtq;
            if (n != 0 && n != 180) {
                throw new UnsupportedOperationException("Video recording supported only in landscape");
            }
            Camera.Parameters parameters = this.mti.getParameters();
            this.setCameraPictureOrientation(parameters);
            this.mti.setParameters(parameters);
            this.stopPreview();
            this.mti.unlock();
            parameters = mediaRecorder;
            try {
                this.mtm = parameters;
                new MediaRecorder().setCamera(this.mti);
                this.getCameraHost().configureRecorderAudio(this.mte, this.mtm);
                this.mtm.setVideoSource(1);
                this.getCameraHost().configureRecorderProfile(this.mte, this.mtm);
                this.getCameraHost().configureRecorderOutput(this.mte, this.mtm);
                this.mtm.setOrientationHint(this.mts);
                this.previewStrategy.mtc(this.mtm);
                this.mtm.prepare();
                this.mtm.start();
                return;
            }
            catch (IOException iOException) {
                this.mtm.release();
                this.mtm = null;
                throw iOException;
            }
        }
        throw new UnsupportedOperationException("Video recording supported only on API Level 11+");
    }

    public void stopRecording() {
        if (Build.VERSION.SDK_INT >= 11) {
            mtjw mtjw2 = this;
            MediaRecorder mediaRecorder = mtjw2.mtm;
            this.mtm = null;
            mediaRecorder.stop();
            mediaRecorder.release();
            mtjw2.mti.reconnect();
            return;
        }
        throw new UnsupportedOperationException("Video recording supported only on API Level 11+");
    }

    public boolean isAutoFocusAvailable() {
        return this.inPreview;
    }

    public void onAutoFocus(boolean bl, Camera camera) {
        this.mtv = false;
        if (this.getCameraHost() instanceof Camera.AutoFocusCallback) {
            this.getCameraHost().onAutoFocus(bl, camera);
            return;
        }
    }

    public String getFlashMode() {
        return this.mtx.getFlashMode();
    }

    /*
     * WARNING - void declaration
     */
    public void setFlashMode(String mode) {
        void var1_1;
        mty.post((Runnable)new mtk(this, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public mtqc zoomTo(int level) {
        if (this_.mti != null) {
            void var1_1;
            Camera.Parameters parameters = this_.getCameraParameters();
            if (var1_1 >= 0 && var1_1 <= parameters.getMaxZoom()) {
                return new mtqc(this_.mti, (int)var1_1);
            }
            Object this_ = (int)var1_1;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this_;
            throw new IllegalArgumentException(String.format("Invalid zoom level: %d", objectArray2));
        }
        throw new IllegalStateException("Yes, we have no camera, we have no camera today");
    }

    @TargetApi(value=14)
    public void startFaceDetection() {
        if (Build.VERSION.SDK_INT >= 14 && this.mti != null && !this.mto && this.getCameraParameters().getMaxNumDetectedFaces() > 0) {
            this.mti.startFaceDetection();
            this.mto = true;
            return;
        }
    }

    public void stopFaceDetection() {
        Camera camera;
        if (Build.VERSION.SDK_INT >= 14 && (camera = this.mti) != null && this.mto) {
            camera.stopFaceDetection();
            this.mto = false;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPreviewCallback(Camera.PreviewCallback callback) {
        void var1_1;
        mty.post((Runnable)new mtg(this, (Camera.PreviewCallback)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addPreviewCallbackBuffer(byte[] buffer) {
        void var1_1;
        mty.post((Runnable)new mtq(this, (byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setPreviewCallbackSync(Camera.PreviewCallback callback) {
        Camera camera = this.mti;
        if (camera != null) {
            try {
                void var1_1;
                camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)var1_1);
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setPreviewCallbackWithBuffer(). Could not set preview callback.", (Throwable)runtimeException);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addPreviewCallbackBufferSync(byte[] buffer) {
        void var1_1;
        mtjw this_ = this_.mti;
        if (this_ != null && var1_1 != null) {
            this_.addCallbackBuffer((byte[])var1_1);
            return;
        }
    }

    public boolean doesZoomReallyWork() {
        Camera.CameraInfo cameraInfo;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        mtjw mtjw2 = mttv2;
        cameraInfo2();
        Camera.getCameraInfo((int)mtjw2.getCameraHost().getCameraId(), (Camera.CameraInfo)cameraInfo2);
        mttv mttv2 = mtjw2.getCameraHost().getDeviceProfile();
        boolean bl = cameraInfo.facing == 1;
        return mttv2.mtc(bl);
    }

    /*
     * WARNING - void declaration
     */
    public void initPreview(int width, int height) {
        void var2_2;
        void var1_1;
        this.initPreview((int)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=14)
    public void initPreview(int w, int h, boolean firstRun) {
        void var2_2;
        void var1_1;
        mty.post((Runnable)new mtx(this, (int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initPreviewSync(int w, int h) {
        block7: {
            mto mto2;
            block8: {
                block6: {
                    Camera.Parameters parameters;
                    block5: {
                        if (this.mti == null) break block7;
                        try {
                            boolean bl;
                            mtjw mtjw2 = this;
                            parameters = mtjw2.getCameraParameters();
                            if (mtjw2.mtc == null) {
                                void var2_3;
                                this.mtc = this.getCameraHost().getPreviewSize(this.getDisplayOrientation(), bl ? 1 : 0, (int)var2_3, parameters);
                            }
                            Camera.Size size = this.mtc;
                            bl = size.width;
                            parameters.setPreviewSize(bl ? 1 : 0, size.height);
                            if (Build.VERSION.SDK_INT < 14) break block5;
                            bl = this.getCameraHost().getRecordingHint() != CameraHost$RecordingHint.STILL_ONLY;
                            parameters.setRecordingHint(bl);
                        }
                        catch (Exception exception) {
                            break block6;
                        }
                    }
                    mtjw mtjw3 = this;
                    mtjw3.setCameraParametersSync(mtjw3.getCameraHost().adjustPreviewParameters(parameters));
                    break block8;
                }
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"initPreview(). Could not work with camera parameters.");
            }
            mtjw mtjw4 = this;
            mto mto3 = mto2;
            mto2 = new mto(this);
            mtjw4.post(mto3);
            mtjw4.startPreviewSync();
        }
    }

    public abstract void startPreview();

    public void startPreviewSync() {
        block3: {
            Camera camera = this.mti;
            if (camera == null) break block3;
            try {
                camera.startPreview();
                this.inPreview = true;
                this.getCameraHost().autoFocusAvailable();
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"startPreviewSync(). Could not start preview.");
            }
        }
    }

    public abstract void stopPreview();

    public final void mti() {
        block3: {
            if (this.mti == null) break block3;
            try {
                mtjw mtjw2 = this;
                mtjw2.inPreview = false;
                mtjw2.getCameraHost().autoFocusUnavailable();
                mtjw2.mti.setPreviewCallback(null);
                mtjw2.mti.stopPreview();
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"stopPreviewSync(). Could not stop preview.");
            }
        }
    }

    public final void mtc() {
        Camera.CameraInfo cameraInfo;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Display display = this.mtl.getDefaultDisplay();
        int n = display.getRotation();
        int n2 = 0;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Camera.getCameraInfo((int)this.mte, (Camera.CameraInfo)cameraInfo2);
        display.getMetrics(displayMetrics);
        switch (n) {
            default: {
                break;
            }
            case 3: {
                n2 = 270;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 1: {
                n2 = 90;
                break;
            }
            case 0: {
                n2 = 0;
            }
        }
        this.mtq = cameraInfo2.facing == 1 ? (360 - (cameraInfo2.orientation + n2) % 360) % 360 : (cameraInfo2.orientation - n2 + 360) % 360;
        if (this.mti != null) {
            boolean bl = this.inPreview;
            if (bl) {
                this.mti();
            }
            try {
                this.mti.setDisplayOrientation(this.mtq);
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setCameraDisplayOrientation(). Could not set camera display orientation.");
            }
            if (bl) {
                this.startPreviewSync();
            }
        }
    }

    public final int mtc(int n) {
        Camera.CameraInfo cameraInfo;
        mtjw mtjw2 = mtjw3;
        mtjw mtjw3 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)mtjw2.mte, (Camera.CameraInfo)mtjw3);
        n = (n + 45) / 90 * 90;
        if (((Camera.CameraInfo)mtjw3).facing == 1) {
            return (((Camera.CameraInfo)mtjw3).orientation - n + 360) % 360;
        }
        return (((Camera.CameraInfo)mtjw3).orientation + n) % 360;
    }
}

