/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ImageFormat;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import androidx.camera.core.ImageProxy;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001J1\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lio/scanbot/sdk/ui/camera/util/PreviewImageUtil;", "", "", "nv21Image", "", "imageWidth", "imageHeight", "imageOrientation", "Landroid/graphics/Bitmap;", "convertNV21ToBitmap", "([BIII)Landroid/graphics/Bitmap;", "Landroidx/camera/core/ImageProxy;", "image", "convertYUV420toNV21", "(Landroidx/camera/core/ImageProxy;)[B", "convertYUV420toNV21Fast", "sdk-camera_release"}, xi=48)
public final class PreviewImageUtil {
    @NotNull
    public static final PreviewImageUtil INSTANCE = new PreviewImageUtil();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmStatic
    @NotNull
    public static final Bitmap convertNV21ToBitmap(@NotNull byte[] nv21Image, int imageWidth, int imageHeight, int imageOrientation) {
        Throwable throwable3;
        ByteArrayOutputStream byteArrayOutputStream;
        block10: {
            Bitmap bitmap;
            Throwable throwable2;
            block11: {
                Matrix matrix;
                Bitmap bitmap2;
                int n;
                byte[] byArray;
                Rect rect;
                YuvImage yuvImage;
                void var2_5;
                void var1_4;
                ByteArrayOutputStream byteArrayOutputStream2;
                Object object;
                Intrinsics.checkNotNullParameter((Object)object, (String)"nv21Image");
                byteArrayOutputStream = byteArrayOutputStream2;
                byteArrayOutputStream2 = new ByteArrayOutputStream();
                throwable2 = null;
                try {
                    yuvImage = new YuvImage(object, 17, (int)var1_4, (int)var2_5, null);
                }
                catch (Throwable throwable3) {
                    break block10;
                }
                object = rect;
                {
                    rect = new Rect(0, 0, (int)var1_4, (int)var2_5);
                    yuvImage.compressToJpeg((Rect)object, 100, (OutputStream)byteArrayOutputStream);
                }
                {
                    byArray = byteArrayOutputStream2.toByteArray();
                    n = 0;
                }
                {
                    bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)n, (int)byArray.length);
                    if (imageOrientation == 0) break block11;
                    bitmap2 = bitmap;
                }
                bitmap = matrix;
                {
                    bitmap();
                    {
                        void var3_6;
                        matrix.postRotate((float)var3_6);
                    }
                }
                bitmap = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)var1_4, (int)var2_5, (Matrix)bitmap, (boolean)false);
            }
            Intrinsics.checkNotNull((Object)bitmap);
            CloseableKt.closeFinally((Closeable)byteArrayOutputStream, throwable2);
            return bitmap;
        }
        try {
            throw throwable3;
        }
        catch (Throwable throwable4) {
            CloseableKt.closeFinally((Closeable)byteArrayOutputStream, (Throwable)throwable3);
            throw throwable4;
        }
    }

    public static /* synthetic */ Bitmap convertNV21ToBitmap$default(byte[] byArray, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        return PreviewImageUtil.convertNV21ToBitmap(byArray, n, n2, n3);
    }

    @JvmStatic
    @NotNull
    public static final byte[] convertYUV420toNV21(@NotNull ImageProxy image) {
        ImageProxy imageProxy;
        ImageProxy imageProxy2 = image;
        Intrinsics.checkNotNullParameter((Object)imageProxy2, (String)"image");
        Rect rect = imageProxy2.getCropRect();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"getCropRect(...)");
        int n = imageProxy.getFormat();
        int n2 = rect.width();
        int n3 = rect.height();
        ImageProxy.PlaneProxy[] planeProxyArray = imageProxy2.getPlanes();
        int n4 = n;
        Intrinsics.checkNotNullExpressionValue((Object)planeProxyArray, (String)"getPlanes(...)");
        n = n2 * n3;
        byte[] byArray = new byte[ImageFormat.getBitsPerPixel((int)n4) * n / 8];
        byte[] byArray2 = new byte[planeProxyArray[0].getRowStride()];
        int n5 = 0;
        int n6 = 1;
        int n7 = planeProxyArray.length;
        for (int i = 0; i < n7; ++i) {
            if (i != 0) {
                if (i != 1) {
                    if (i == 2) {
                        n6 = n5 = 2;
                        n5 = n;
                    }
                } else {
                    n5 = n + 1;
                    n6 = 2;
                }
            } else {
                n5 = 0;
                n6 = 1;
            }
            ByteBuffer byteBuffer = planeProxyArray[i].getBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"getBuffer(...)");
            int n8 = planeProxyArray[i].getRowStride();
            int n9 = planeProxyArray[i].getPixelStride();
            int n10 = i == 0 ? 0 : 1;
            int n11 = n2 >> n10;
            int n12 = n3 >> n10;
            int n13 = n8 * (rect.top >> n10);
            byteBuffer.position(n9 * (rect.left >> n10) + n13);
            for (n10 = 0; n10 < n12; ++n10) {
                if (n9 == 1 && n6 == 1) {
                    byteBuffer.get(byArray, n5, n11);
                    n5 += n11;
                    n13 = n11;
                } else {
                    n13 = (n11 - 1) * n9 + 1;
                    byteBuffer.get(byArray2, 0, n13);
                    for (int j = 0; j < n11; ++j) {
                        byArray[n5] = byArray2[j * n9];
                        n5 += n6;
                    }
                }
                if (n10 >= n12 - 1) continue;
                ByteBuffer byteBuffer2 = byteBuffer;
                byteBuffer2.position(byteBuffer2.position() + n8 - n13);
            }
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmStatic
    @NotNull
    public static final byte[] convertYUV420toNV21Fast(@NotNull ImageProxy image) {
        ImageProxy imageProxy;
        ImageProxy imageProxy2 = image;
        Intrinsics.checkNotNullParameter((Object)imageProxy2, (String)"image");
        int n = imageProxy2.getWidth();
        byte by = imageProxy.getHeight();
        int n2 = n * by;
        byte[] byArray = new byte[n2 / 4 * 2 + n2];
        ByteBuffer byteBuffer = imageProxy2.getPlanes()[0].getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"getBuffer(...)");
        ByteBuffer byteBuffer2 = imageProxy2.getPlanes()[1].getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"getBuffer(...)");
        ByteBuffer byteBuffer3 = imageProxy2.getPlanes()[2].getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer3, (String)"getBuffer(...)");
        int n3 = imageProxy2.getPlanes()[0].getRowStride();
        int n4 = imageProxy2.getPlanes()[0].getPixelStride() == 1 ? 1 : 0;
        if (_Assertions.ENABLED && n4 == 0) {
            throw new AssertionError((Object)"Assertion failed");
        }
        if (n3 == n) {
            byteBuffer.get(byArray, 0, n2);
            n4 = n2;
        } else {
            long l = n3;
            long l2 = -l;
            for (n4 = 0; n4 < n2; n4 += n) {
                byteBuffer.position((int)(l2 += l));
                byteBuffer.get(byArray, n4, n);
            }
        }
        int n5 = imageProxy.getPlanes()[2].getRowStride();
        ImageProxy imageProxy3 = imageProxy;
        n3 = imageProxy3.getPlanes()[2].getPixelStride();
        int n6 = n5 == imageProxy3.getPlanes()[1].getRowStride() ? 1 : 0;
        int n7 = _Assertions.ENABLED;
        if (n7 != 0 && n6 == 0) {
            throw new AssertionError((Object)"Assertion failed");
        }
        byte by2 = n3 == imageProxy.getPlanes()[1].getPixelStride() ? (byte)1 : 0;
        if (n7 != 0 && by2 == 0) {
            throw new AssertionError((Object)"Assertion failed");
        }
        if (n3 == 2 && n5 == n && byteBuffer2.get(0) == byteBuffer3.get(1)) {
            block17: {
                ByteBuffer byteBuffer4 = byteBuffer3;
                byte by3 = byteBuffer4.get(1);
                by2 = by3;
                n6 = ~by3;
                try {
                    byteBuffer4.put(1, (byte)n6);
                }
                catch (ReadOnlyBufferException readOnlyBufferException) {}
                if (byteBuffer2.get(0) != n6) break block17;
                byte[] byArray2 = byArray;
                ByteBuffer byteBuffer5 = byteBuffer2;
                ByteBuffer byteBuffer6 = byteBuffer5;
                ByteBuffer byteBuffer7 = byteBuffer5;
                ByteBuffer byteBuffer8 = byteBuffer3;
                ByteBuffer byteBuffer9 = byteBuffer2;
                ByteBuffer byteBuffer10 = byteBuffer3;
                ByteBuffer byteBuffer11 = byteBuffer10;
                byteBuffer10.put(1, by2);
                byteBuffer11.position(0);
                byteBuffer9.position(0);
                byteBuffer8.get(byArray, n2, 1);
                ++n2;
                n6 = byteBuffer6.remaining();
                byteBuffer7.get(byArray, n2, n6);
                return byArray2;
            }
            byteBuffer3.put(1, by2);
        }
        by2 = 0;
        by /= 2;
        while (by2 < by) {
            n6 = n / 2;
            for (n2 = 0; n2 < n6; n4 += 2, ++n2) {
                n7 = n2 * n3;
                n7 = by2 * n5 + n7;
                int n8 = n4 + 1;
                byArray[n4] = byteBuffer3.get(n7);
                byArray[n8] = byteBuffer2.get(n7);
            }
            ++by2;
        }
        return byArray;
    }
}

