/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.camera;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.hardware.Camera;
import android.media.MediaRecorder;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.commonsware.cwac.camera.CameraHost$RecordingHint;
import com.commonsware.cwac.camera.bxc;
import com.commonsware.cwac.camera.bxdg;
import com.commonsware.cwac.camera.bxdt;
import com.commonsware.cwac.camera.bxg;
import com.commonsware.cwac.camera.bxh;
import com.commonsware.cwac.camera.bxi;
import com.commonsware.cwac.camera.bxje;
import com.commonsware.cwac.camera.bxl;
import com.commonsware.cwac.camera.bxm;
import com.commonsware.cwac.camera.bxo;
import com.commonsware.cwac.camera.bxp;
import com.commonsware.cwac.camera.bxpr;
import com.commonsware.cwac.camera.bxq;
import com.commonsware.cwac.camera.bxqh;
import com.commonsware.cwac.camera.bxr;
import com.commonsware.cwac.camera.bxs;
import com.commonsware.cwac.camera.bxt;
import com.commonsware.cwac.camera.bxu;
import com.commonsware.cwac.camera.bxv;
import com.commonsware.cwac.camera.bxw;
import com.commonsware.cwac.camera.bxwb;
import com.commonsware.cwac.camera.bxzv;
import java.io.IOException;

public abstract class bxrl
extends ViewGroup
implements Camera.AutoFocusCallback {
    public static final int[] bxt;
    public static final Handler bxi;
    protected bxpr previewStrategy;
    public Camera.Size bxc;
    public Camera bxa = null;
    protected boolean inPreview = false;
    public bxc bxp = null;
    public final bxu bxv = null;
    public int bxs = -1;
    public int bxe = -1;
    public int bxd = -1;
    public MediaRecorder bxq = null;
    public Camera.Parameters bxm = null;
    public boolean bxl = false;
    public boolean bxb = false;
    public bxi bxo;
    public int bxx;
    public WindowManager bxf;
    public boolean bxn = false;
    public boolean bxr = false;

    public bxrl(Context context) {
        super(context);
        bxu bxu2;
        bxu bxu3 = bxu2;
        bxu2 = new bxu(this, context);
        this.bxv = bxu3;
    }

    /*
     * WARNING - void declaration
     */
    private void setCameraPictureOrientation(Camera.Parameters params) {
        void var1_1;
        Camera.CameraInfo cameraInfo;
        bxrl bxrl2 = this;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)bxrl2.bxd, (Camera.CameraInfo)cameraInfo2);
        if (bxrl2.bxn && !this.bxr) {
            bxrl bxrl3 = this;
            bxrl3.bxe = bxrl3.bxc(bxrl3.bxf.getDefaultDisplay().getOrientation());
        } else {
            this.bxe = cameraInfo2.facing == 1 ? (360 - this.bxs) % 360 : this.bxs;
        }
        if (this.bxe % 90 != 0) {
            this.bxe = 0;
        }
        var1_1.setRotation(this.bxe);
    }

    static {
        HandlerThread handlerThread;
        bxt = new int[]{0, 90, 180, 270};
        HandlerThread handlerThread2 = handlerThread;
        new HandlerThread("CWAC_CAMERA", 10).start();
        bxi = new Handler(handlerThread2.getLooper());
    }

    public bxc getCameraHost() {
        return this.bxp;
    }

    public void setCameraHost(bxc host) {
        bxzv bxzv2;
        bxpr bxpr2;
        this.bxp = bxpr2;
        if (((bxdg)host.getDeviceProfile()).bxa) {
            bxdt bxdt2;
            bxpr2 = bxdt2;
            bxdt2 = new bxdt(this);
            this.previewStrategy = bxpr2;
            return;
        }
        bxpr2 = bxzv2;
        bxzv2 = new bxzv(this);
        this.previewStrategy = bxpr2;
    }

    public synchronized Camera.Parameters getCameraParameters() {
        Camera camera = this.bxa;
        if (camera != null && this.bxm == null) {
            try {
                this.bxm = camera.getParameters();
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"getCameraParameters(). Could not work with camera parameters.");
            }
        }
        return this.bxm;
    }

    /*
     * WARNING - void declaration
     */
    public void setCameraParameters(Camera.Parameters parameters) {
        void var1_1;
        bxi.post((Runnable)new bxo(this, (Camera.Parameters)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultPreviewSize(Camera.Size newPreviewSize) {
        void var1_1;
        bxi.post((Runnable)new bxr(this, (Camera.Size)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultPictureSize(Camera.Size newPictureSize) {
        void var1_1;
        bxi.post((Runnable)new bxt(this, (Camera.Size)var1_1));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCameraParametersSync(Camera.Parameters parameters) {
        try {
            void var1_1;
            Camera camera = this.bxa;
            if (camera != null && var1_1 != null) {
                camera.setParameters((Camera.Parameters)var1_1);
            }
            this.bxm = var1_1;
            return;
        }
        catch (RuntimeException runtimeException) {}
        Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setCameraParametersSync(). Could not set camera parameters.");
    }

    /*
     * WARNING - void declaration
     */
    public void onCameraOpen(Camera object) {
        block11: {
            void var2_4;
            try {
                this.previewStrategy.bxc();
                break block11;
            }
            catch (RuntimeException runtimeException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.getCameraHost().handleException((Exception)var2_4);
        }
        this.bxf = (WindowManager)this.getContext().getSystemService("window");
        if (this.bxn && !this.bxr) {
            this.bxv.enable();
        }
        this.bxc();
        if (Build.VERSION.SDK_INT >= 14 && this.getCameraHost() instanceof Camera.FaceDetectionListener) {
            object.setFaceDetectionListener((Camera.FaceDetectionListener)this.getCameraHost());
        }
        if (this.bxo == null) {
            bxi bxi2;
            object = bxi2;
            bxi2 = new bxi(this, this.getContext());
            this.bxo = object;
        }
        if (this.bxo.canDetectOrientation()) {
            this.bxo.enable();
        }
        if (this.bxn) {
            this.bxc();
            if (!this.bxr) {
                this.bxv.enable();
            } else {
                object = this.getCameraParameters();
                if (object != null) {
                    this.setCameraPictureOrientation((Camera.Parameters)object);
                    this.setCameraParametersSync((Camera.Parameters)object);
                }
            }
        }
    }

    public void onResume() {
        this.bxv.bxc = -1;
        ViewGroup viewGroup = (ViewGroup)this.previewStrategy.bxa().getParent();
        if (viewGroup != null) {
            viewGroup.removeAllViews();
        }
        bxrl bxrl2 = this;
        bxrl2.addView(bxrl2.previewStrategy.bxa());
        bxi.post((Runnable)new bxg(this));
    }

    public void onPause() {
        bxi.post((Runnable)new bxq((bxrl)((Object)object)));
        if (object.previewStrategy.bxa() != null) {
            bxrl bxrl2 = object;
            bxrl2.removeView(bxrl2.previewStrategy.bxa());
        }
        bxrl bxrl3 = object;
        bxrl3.bxv.disable();
        Object object = bxrl3.bxo;
        if (object != null) {
            object.disable();
            return;
        }
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        n2 = View.resolveSize((int)this.getSuggestedMinimumWidth(), (int)n2);
        n = View.resolveSize((int)this.getSuggestedMinimumHeight(), (int)n);
        this.setMeasuredDimension(n2, n);
        if (n2 > 0 && n > 0) {
            bxi.post((Runnable)new bxw(this, n2, n));
            return;
        }
    }

    public Camera.Size getPreviewSize() {
        return this.bxc;
    }

    /*
     * WARNING - void declaration
     */
    public void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.getChildCount() > 0) {
            int n;
            void var3_11;
            int n2;
            void var2_10;
            void var4_12;
            View view = this.getChildAt(0);
            var2_10 = var4_12 - var2_10;
            var3_11 = n2 - var3_11;
            Camera.Size size = this.bxc;
            if (size != null && size.height > 0 && size.width > 0) {
                if (this.getDisplayOrientation() != 90 && this.getDisplayOrientation() != 270) {
                    Camera.Size size2 = this.bxc;
                    n = size2.width;
                    n2 = size2.height;
                } else {
                    Camera.Size size3 = this.bxc;
                    n = size3.height;
                    n2 = size3.width;
                }
            } else {
                n2 = var3_11;
                n = var2_10;
            }
            if (n != 0 && n2 != 0) {
                void var6_16 = var2_10 * n2;
                void var7_17 = var3_11 * n;
                boolean bl = var6_16 > var7_17;
                boolean n3 = this.getCameraHost().useFullBleedPreview();
                if (bl && !n3 || !bl && n3) {
                    void v2 = var2_10;
                    void var0_2 = var7_17 / n2;
                    void var1_8 = (v2 - var0_2) / 2;
                    void var0_3 = (v2 + var0_2) / 2;
                    view.layout((int)var1_8, 0, (int)var0_3, (int)var3_11);
                    return;
                }
                void v3 = var3_11;
                void var0_4 = var6_16 / n;
                void var1_9 = (v3 - var0_4) / 2;
                void var0_5 = (v3 + var0_4) / 2;
                view.layout(0, (int)var1_9, (int)var2_10, (int)var0_5);
                return;
            }
        }
    }

    public int getDisplayOrientation() {
        return this.bxs;
    }

    /*
     * WARNING - void declaration
     */
    public void lockToLandscape(boolean lockPicture) {
        void var1_1;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(6);
        }
        bxrl bxrl2 = this;
        bxrl2.bxn = true;
        bxrl2.bxr = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void lockToPortrait(boolean lockPicture) {
        void var1_1;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(7);
        }
        bxrl bxrl2 = this;
        bxrl2.bxn = true;
        bxrl2.bxr = var1_1;
    }

    public void unlockOrientation() {
        this.bxn = false;
        this.bxr = false;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(-1);
        }
        bxrl bxrl2 = this;
        bxrl2.bxv.disable();
        bxrl2.post(new bxh(this));
    }

    public void restartPreview() {
        if (!this.inPreview) {
            this.startPreview();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void takePicture(boolean needBitmap, boolean needByteArray) {
        void var2_2;
        void var1_1;
        bxje bxje2;
        bxje bxje3 = bxje2;
        bxje3(this.getCameraHost());
        bxje3.bxa = var1_1;
        bxje2.bxp = var2_2;
        this.takePicture(bxje2);
    }

    public abstract void takePicture(bxje var1);

    public boolean isRecording() {
        return this.bxq != null;
    }

    public void record() {
        if (Build.VERSION.SDK_INT >= 11) {
            MediaRecorder mediaRecorder;
            int n = this.bxs;
            if (n != 0 && n != 180) {
                throw new UnsupportedOperationException("Video recording supported only in landscape");
            }
            Camera.Parameters parameters = this.bxa.getParameters();
            this.setCameraPictureOrientation(parameters);
            this.bxa.setParameters(parameters);
            this.stopPreview();
            this.bxa.unlock();
            parameters = mediaRecorder;
            try {
                this.bxq = parameters;
                new MediaRecorder().setCamera(this.bxa);
                this.getCameraHost().configureRecorderAudio(this.bxd, this.bxq);
                this.bxq.setVideoSource(1);
                this.getCameraHost().configureRecorderProfile(this.bxd, this.bxq);
                this.getCameraHost().configureRecorderOutput(this.bxd, this.bxq);
                this.bxq.setOrientationHint(this.bxe);
                this.previewStrategy.bxc(this.bxq);
                this.bxq.prepare();
                this.bxq.start();
                return;
            }
            catch (IOException iOException) {
                this.bxq.release();
                this.bxq = null;
                throw iOException;
            }
        }
        throw new UnsupportedOperationException("Video recording supported only on API Level 11+");
    }

    public void stopRecording() {
        if (Build.VERSION.SDK_INT >= 11) {
            bxrl bxrl2 = this;
            MediaRecorder mediaRecorder = bxrl2.bxq;
            this.bxq = null;
            mediaRecorder.stop();
            mediaRecorder.release();
            bxrl2.bxa.reconnect();
            return;
        }
        throw new UnsupportedOperationException("Video recording supported only on API Level 11+");
    }

    public boolean isAutoFocusAvailable() {
        return this.inPreview;
    }

    public void onAutoFocus(boolean bl, Camera camera) {
        this.bxb = false;
        if (this.getCameraHost() instanceof Camera.AutoFocusCallback) {
            this.getCameraHost().onAutoFocus(bl, camera);
            return;
        }
    }

    public String getFlashMode() {
        return this.bxm.getFlashMode();
    }

    /*
     * WARNING - void declaration
     */
    public void setFlashMode(String mode) {
        void var1_1;
        bxi.post((Runnable)new bxp(this, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public bxwb zoomTo(int level) {
        if (this_.bxa != null) {
            void var1_1;
            Camera.Parameters parameters = this_.getCameraParameters();
            if (var1_1 >= 0 && var1_1 <= parameters.getMaxZoom()) {
                return new bxwb(this_.bxa, (int)var1_1);
            }
            Object this_ = (int)var1_1;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this_;
            throw new IllegalArgumentException(String.format("Invalid zoom level: %d", objectArray2));
        }
        throw new IllegalStateException("Yes, we have no camera, we have no camera today");
    }

    @TargetApi(value=14)
    public void startFaceDetection() {
        if (Build.VERSION.SDK_INT >= 14 && this.bxa != null && !this.bxl && this.getCameraParameters().getMaxNumDetectedFaces() > 0) {
            this.bxa.startFaceDetection();
            this.bxl = true;
            return;
        }
    }

    public void stopFaceDetection() {
        Camera camera;
        if (Build.VERSION.SDK_INT >= 14 && (camera = this.bxa) != null && this.bxl) {
            camera.stopFaceDetection();
            this.bxl = false;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPreviewCallback(Camera.PreviewCallback callback) {
        void var1_1;
        bxi.post((Runnable)new bxv(this, (Camera.PreviewCallback)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addPreviewCallbackBuffer(byte[] buffer) {
        void var1_1;
        bxi.post((Runnable)new bxs(this, (byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setPreviewCallbackSync(Camera.PreviewCallback callback) {
        Camera camera = this.bxa;
        if (camera != null) {
            try {
                void var1_1;
                camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)var1_1);
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setPreviewCallbackWithBuffer(). Could not set preview callback.", (Throwable)runtimeException);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addPreviewCallbackBufferSync(byte[] buffer) {
        void var1_1;
        bxrl this_ = this_.bxa;
        if (this_ != null && var1_1 != null) {
            this_.addCallbackBuffer((byte[])var1_1);
            return;
        }
    }

    public boolean doesZoomReallyWork() {
        Camera.CameraInfo cameraInfo;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        bxrl bxrl2 = bxqh2;
        cameraInfo2();
        Camera.getCameraInfo((int)bxrl2.getCameraHost().getCameraId(), (Camera.CameraInfo)cameraInfo2);
        bxqh bxqh2 = bxrl2.getCameraHost().getDeviceProfile();
        boolean bl = cameraInfo.facing == 1;
        return bxqh2.bxc(bl);
    }

    /*
     * WARNING - void declaration
     */
    public void initPreview(int width, int height) {
        void var2_2;
        void var1_1;
        this.initPreview((int)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=14)
    public void initPreview(int w, int h, boolean firstRun) {
        void var2_2;
        void var1_1;
        bxi.post((Runnable)new bxm(this, (int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initPreviewSync(int w, int h) {
        block7: {
            bxl bxl2;
            block8: {
                block6: {
                    Camera.Parameters parameters;
                    block5: {
                        if (this.bxa == null) break block7;
                        try {
                            boolean bl;
                            bxrl bxrl2 = this;
                            parameters = bxrl2.getCameraParameters();
                            if (bxrl2.bxc == null) {
                                void var2_3;
                                this.bxc = this.getCameraHost().getPreviewSize(this.getDisplayOrientation(), bl ? 1 : 0, (int)var2_3, parameters);
                            }
                            Camera.Size size = this.bxc;
                            bl = size.width;
                            parameters.setPreviewSize(bl ? 1 : 0, size.height);
                            if (Build.VERSION.SDK_INT < 14) break block5;
                            bl = this.getCameraHost().getRecordingHint() != CameraHost$RecordingHint.STILL_ONLY;
                            parameters.setRecordingHint(bl);
                        }
                        catch (Exception exception) {
                            break block6;
                        }
                    }
                    bxrl bxrl3 = this;
                    bxrl3.setCameraParametersSync(bxrl3.getCameraHost().adjustPreviewParameters(parameters));
                    break block8;
                }
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"initPreview(). Could not work with camera parameters.");
            }
            bxrl bxrl4 = this;
            bxl bxl3 = bxl2;
            bxl2 = new bxl(this);
            bxrl4.post(bxl3);
            bxrl4.startPreviewSync();
        }
    }

    public abstract void startPreview();

    public void startPreviewSync() {
        block3: {
            Camera camera = this.bxa;
            if (camera == null) break block3;
            try {
                camera.startPreview();
                this.inPreview = true;
                this.getCameraHost().autoFocusAvailable();
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"startPreviewSync(). Could not start preview.");
            }
        }
    }

    public abstract void stopPreview();

    public final void bxa() {
        block3: {
            if (this.bxa == null) break block3;
            try {
                bxrl bxrl2 = this;
                bxrl2.inPreview = false;
                bxrl2.getCameraHost().autoFocusUnavailable();
                bxrl2.bxa.setPreviewCallback(null);
                bxrl2.bxa.stopPreview();
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"stopPreviewSync(). Could not stop preview.");
            }
        }
    }

    public final void bxc() {
        Camera.CameraInfo cameraInfo;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Display display = this.bxf.getDefaultDisplay();
        int n = display.getRotation();
        int n2 = 0;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Camera.getCameraInfo((int)this.bxd, (Camera.CameraInfo)cameraInfo2);
        display.getMetrics(displayMetrics);
        switch (n) {
            default: {
                break;
            }
            case 3: {
                n2 = 270;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 1: {
                n2 = 90;
                break;
            }
            case 0: {
                n2 = 0;
            }
        }
        this.bxs = cameraInfo2.facing == 1 ? (360 - (cameraInfo2.orientation + n2) % 360) % 360 : (cameraInfo2.orientation - n2 + 360) % 360;
        if (this.bxa != null) {
            boolean bl = this.inPreview;
            if (bl) {
                this.bxa();
            }
            try {
                this.bxa.setDisplayOrientation(this.bxs);
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setCameraDisplayOrientation(). Could not set camera display orientation.");
            }
            if (bl) {
                this.startPreviewSync();
            }
        }
    }

    public final int bxc(int n) {
        Camera.CameraInfo cameraInfo;
        bxrl bxrl2 = bxrl3;
        bxrl bxrl3 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)bxrl2.bxd, (Camera.CameraInfo)bxrl3);
        n = (n + 45) / 90 * 90;
        if (((Camera.CameraInfo)bxrl3).facing == 1) {
            return (((Camera.CameraInfo)bxrl3).orientation - n + 360) % 360;
        }
        return (((Camera.CameraInfo)bxrl3).orientation + n) % 360;
    }
}

