/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.camera;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.hardware.Camera;
import android.media.MediaRecorder;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.commonsware.cwac.camera.CameraHost$RecordingHint;
import com.commonsware.cwac.camera.vmd;
import com.commonsware.cwac.camera.vme;
import com.commonsware.cwac.camera.vmf;
import com.commonsware.cwac.camera.vmfa;
import com.commonsware.cwac.camera.vmg;
import com.commonsware.cwac.camera.vmgw;
import com.commonsware.cwac.camera.vmim;
import com.commonsware.cwac.camera.vmjn;
import com.commonsware.cwac.camera.vml;
import com.commonsware.cwac.camera.vmm;
import com.commonsware.cwac.camera.vmo;
import com.commonsware.cwac.camera.vmoh;
import com.commonsware.cwac.camera.vmp;
import com.commonsware.cwac.camera.vmq;
import com.commonsware.cwac.camera.vmrr;
import com.commonsware.cwac.camera.vms;
import com.commonsware.cwac.camera.vmt;
import com.commonsware.cwac.camera.vmu;
import com.commonsware.cwac.camera.vmv;
import com.commonsware.cwac.camera.vmw;
import com.commonsware.cwac.camera.vmxp;
import com.commonsware.cwac.camera.vmy;
import java.io.IOException;

public abstract class vmke
extends ViewGroup
implements Camera.AutoFocusCallback {
    public static final int[] vmv;
    public static final Handler vmm;
    protected vmoh previewStrategy;
    public Camera.Size vml;
    public Camera vmn = null;
    protected boolean inPreview = false;
    public vml vmo = null;
    public final vmq vme = null;
    public int vmg = -1;
    public int vmh = -1;
    public int vmc = -1;
    public MediaRecorder vmf = null;
    public Camera.Parameters vmd = null;
    public boolean vmw = false;
    public boolean vma = false;
    public vmm vms;
    public int vmx;
    public WindowManager vmi;
    public boolean vmz = false;
    public boolean vmy = false;

    public vmke(Context context) {
        super(context);
        vmq vmq2;
        vmq vmq3 = vmq2;
        vmq2 = new vmq(this, context);
        this.vme = vmq3;
    }

    /*
     * WARNING - void declaration
     */
    private void setCameraPictureOrientation(Camera.Parameters params) {
        void var1_1;
        Camera.CameraInfo cameraInfo;
        vmke vmke2 = this;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)vmke2.vmc, (Camera.CameraInfo)cameraInfo2);
        if (vmke2.vmz && !this.vmy) {
            vmke vmke3 = this;
            vmke3.vmh = vmke3.vml(vmke3.vmi.getDefaultDisplay().getOrientation());
        } else {
            this.vmh = cameraInfo2.facing == 1 ? (360 - this.vmg) % 360 : this.vmg;
        }
        if (this.vmh % 90 != 0) {
            this.vmh = 0;
        }
        var1_1.setRotation(this.vmh);
    }

    static {
        HandlerThread handlerThread;
        vmv = new int[]{0, 90, 180, 270};
        HandlerThread handlerThread2 = handlerThread;
        new HandlerThread("CWAC_CAMERA", 10).start();
        vmm = new Handler(handlerThread2.getLooper());
    }

    public vml getCameraHost() {
        return this.vmo;
    }

    public void setCameraHost(vml host) {
        vmgw vmgw2;
        vmoh vmoh2;
        this.vmo = vmoh2;
        if (((vmim)host.getDeviceProfile()).vmn) {
            vmxp vmxp2;
            vmoh2 = vmxp2;
            vmxp2 = new vmxp(this);
            this.previewStrategy = vmoh2;
            return;
        }
        vmoh2 = vmgw2;
        vmgw2 = new vmgw(this);
        this.previewStrategy = vmoh2;
    }

    public synchronized Camera.Parameters getCameraParameters() {
        Camera camera = this.vmn;
        if (camera != null && this.vmd == null) {
            try {
                this.vmd = camera.getParameters();
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"getCameraParameters(). Could not work with camera parameters.");
            }
        }
        return this.vmd;
    }

    /*
     * WARNING - void declaration
     */
    public void setCameraParameters(Camera.Parameters parameters) {
        void var1_1;
        vmm.post((Runnable)new vms(this, (Camera.Parameters)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultPreviewSize(Camera.Size newPreviewSize) {
        void var1_1;
        vmm.post((Runnable)new vmy(this, (Camera.Size)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultPictureSize(Camera.Size newPictureSize) {
        void var1_1;
        vmm.post((Runnable)new vmv(this, (Camera.Size)var1_1));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCameraParametersSync(Camera.Parameters parameters) {
        try {
            void var1_1;
            Camera camera = this.vmn;
            if (camera != null && var1_1 != null) {
                camera.setParameters((Camera.Parameters)var1_1);
            }
            this.vmd = var1_1;
            return;
        }
        catch (RuntimeException runtimeException) {}
        Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setCameraParametersSync(). Could not set camera parameters.");
    }

    /*
     * WARNING - void declaration
     */
    public void onCameraOpen(Camera object) {
        block11: {
            void var2_4;
            try {
                this.previewStrategy.vml();
                break block11;
            }
            catch (RuntimeException runtimeException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.getCameraHost().handleException((Exception)var2_4);
        }
        this.vmi = (WindowManager)this.getContext().getSystemService("window");
        if (this.vmz && !this.vmy) {
            this.vme.enable();
        }
        this.vml();
        if (Build.VERSION.SDK_INT >= 14 && this.getCameraHost() instanceof Camera.FaceDetectionListener) {
            object.setFaceDetectionListener((Camera.FaceDetectionListener)this.getCameraHost());
        }
        if (this.vms == null) {
            vmm vmm2;
            object = vmm2;
            vmm2 = new vmm(this, this.getContext());
            this.vms = object;
        }
        if (this.vms.canDetectOrientation()) {
            this.vms.enable();
        }
        if (this.vmz) {
            this.vml();
            if (!this.vmy) {
                this.vme.enable();
            } else {
                object = this.getCameraParameters();
                if (object != null) {
                    this.setCameraPictureOrientation((Camera.Parameters)object);
                    this.setCameraParametersSync((Camera.Parameters)object);
                }
            }
        }
    }

    public void onResume() {
        this.vme.vml = -1;
        ViewGroup viewGroup = (ViewGroup)this.previewStrategy.vmn().getParent();
        if (viewGroup != null) {
            viewGroup.removeAllViews();
        }
        vmke vmke2 = this;
        vmke2.addView(vmke2.previewStrategy.vmn());
        vmm.post((Runnable)new vmu(this));
    }

    public void onPause() {
        vmm.post((Runnable)new vmf((vmke)((Object)object)));
        if (object.previewStrategy.vmn() != null) {
            vmke vmke2 = object;
            vmke2.removeView(vmke2.previewStrategy.vmn());
        }
        vmke vmke3 = object;
        vmke3.vme.disable();
        Object object = vmke3.vms;
        if (object != null) {
            object.disable();
            return;
        }
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        n2 = View.resolveSize((int)this.getSuggestedMinimumWidth(), (int)n2);
        n = View.resolveSize((int)this.getSuggestedMinimumHeight(), (int)n);
        this.setMeasuredDimension(n2, n);
        if (n2 > 0 && n > 0) {
            vmm.post((Runnable)new vmt(this, n2, n));
            return;
        }
    }

    public Camera.Size getPreviewSize() {
        return this.vml;
    }

    /*
     * WARNING - void declaration
     */
    public void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.getChildCount() > 0) {
            int n;
            void var3_11;
            int n2;
            void var2_10;
            void var4_12;
            View view = this.getChildAt(0);
            var2_10 = var4_12 - var2_10;
            var3_11 = n2 - var3_11;
            Camera.Size size = this.vml;
            if (size != null && size.height > 0 && size.width > 0) {
                if (this.getDisplayOrientation() != 90 && this.getDisplayOrientation() != 270) {
                    Camera.Size size2 = this.vml;
                    n = size2.width;
                    n2 = size2.height;
                } else {
                    Camera.Size size3 = this.vml;
                    n = size3.height;
                    n2 = size3.width;
                }
            } else {
                n2 = var3_11;
                n = var2_10;
            }
            if (n != 0 && n2 != 0) {
                void var6_16 = var2_10 * n2;
                void var7_17 = var3_11 * n;
                boolean bl = var6_16 > var7_17;
                boolean n3 = this.getCameraHost().useFullBleedPreview();
                if (bl && !n3 || !bl && n3) {
                    void v2 = var2_10;
                    void var0_2 = var7_17 / n2;
                    void var1_8 = (v2 - var0_2) / 2;
                    void var0_3 = (v2 + var0_2) / 2;
                    view.layout((int)var1_8, 0, (int)var0_3, (int)var3_11);
                    return;
                }
                void v3 = var3_11;
                void var0_4 = var6_16 / n;
                void var1_9 = (v3 - var0_4) / 2;
                void var0_5 = (v3 + var0_4) / 2;
                view.layout(0, (int)var1_9, (int)var2_10, (int)var0_5);
                return;
            }
        }
    }

    public int getDisplayOrientation() {
        return this.vmg;
    }

    /*
     * WARNING - void declaration
     */
    public void lockToLandscape(boolean lockPicture) {
        void var1_1;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(6);
        }
        vmke vmke2 = this;
        vmke2.vmz = true;
        vmke2.vmy = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void lockToPortrait(boolean lockPicture) {
        void var1_1;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(7);
        }
        vmke vmke2 = this;
        vmke2.vmz = true;
        vmke2.vmy = var1_1;
    }

    public void unlockOrientation() {
        this.vmz = false;
        this.vmy = false;
        Context context = this.getContext();
        if (context instanceof Activity) {
            ((Activity)context).setRequestedOrientation(-1);
        }
        vmke vmke2 = this;
        vmke2.vme.disable();
        vmke2.post(new vmp(this));
    }

    public void restartPreview() {
        if (!this.inPreview) {
            this.startPreview();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void takePicture(boolean needBitmap, boolean needByteArray) {
        void var2_2;
        void var1_1;
        vmfa vmfa2;
        vmfa vmfa3 = vmfa2;
        vmfa3(this.getCameraHost());
        vmfa3.vmn = var1_1;
        vmfa2.vmo = var2_2;
        this.takePicture(vmfa2);
    }

    public abstract void takePicture(vmfa var1);

    public boolean isRecording() {
        return this.vmf != null;
    }

    public void record() {
        if (Build.VERSION.SDK_INT >= 11) {
            MediaRecorder mediaRecorder;
            int n = this.vmg;
            if (n != 0 && n != 180) {
                throw new UnsupportedOperationException("Video recording supported only in landscape");
            }
            Camera.Parameters parameters = this.vmn.getParameters();
            this.setCameraPictureOrientation(parameters);
            this.vmn.setParameters(parameters);
            this.stopPreview();
            this.vmn.unlock();
            parameters = mediaRecorder;
            try {
                this.vmf = parameters;
                new MediaRecorder().setCamera(this.vmn);
                this.getCameraHost().configureRecorderAudio(this.vmc, this.vmf);
                this.vmf.setVideoSource(1);
                this.getCameraHost().configureRecorderProfile(this.vmc, this.vmf);
                this.getCameraHost().configureRecorderOutput(this.vmc, this.vmf);
                this.vmf.setOrientationHint(this.vmh);
                this.previewStrategy.vml(this.vmf);
                this.vmf.prepare();
                this.vmf.start();
                return;
            }
            catch (IOException iOException) {
                this.vmf.release();
                this.vmf = null;
                throw iOException;
            }
        }
        throw new UnsupportedOperationException("Video recording supported only on API Level 11+");
    }

    public void stopRecording() {
        if (Build.VERSION.SDK_INT >= 11) {
            vmke vmke2 = this;
            MediaRecorder mediaRecorder = vmke2.vmf;
            this.vmf = null;
            mediaRecorder.stop();
            mediaRecorder.release();
            vmke2.vmn.reconnect();
            return;
        }
        throw new UnsupportedOperationException("Video recording supported only on API Level 11+");
    }

    public boolean isAutoFocusAvailable() {
        return this.inPreview;
    }

    public void onAutoFocus(boolean bl, Camera camera) {
        this.vma = false;
        if (this.getCameraHost() instanceof Camera.AutoFocusCallback) {
            this.getCameraHost().onAutoFocus(bl, camera);
            return;
        }
    }

    public String getFlashMode() {
        return this.vmd.getFlashMode();
    }

    /*
     * WARNING - void declaration
     */
    public void setFlashMode(String mode) {
        void var1_1;
        vmm.post((Runnable)new vmo(this, (String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public vmrr zoomTo(int level) {
        if (this_.vmn != null) {
            void var1_1;
            Camera.Parameters parameters = this_.getCameraParameters();
            if (var1_1 >= 0 && var1_1 <= parameters.getMaxZoom()) {
                return new vmrr(this_.vmn, (int)var1_1);
            }
            Object this_ = (int)var1_1;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this_;
            throw new IllegalArgumentException(String.format("Invalid zoom level: %d", objectArray2));
        }
        throw new IllegalStateException("Yes, we have no camera, we have no camera today");
    }

    @TargetApi(value=14)
    public void startFaceDetection() {
        if (Build.VERSION.SDK_INT >= 14 && this.vmn != null && !this.vmw && this.getCameraParameters().getMaxNumDetectedFaces() > 0) {
            this.vmn.startFaceDetection();
            this.vmw = true;
            return;
        }
    }

    public void stopFaceDetection() {
        Camera camera;
        if (Build.VERSION.SDK_INT >= 14 && (camera = this.vmn) != null && this.vmw) {
            camera.stopFaceDetection();
            this.vmw = false;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPreviewCallback(Camera.PreviewCallback callback) {
        void var1_1;
        vmm.post((Runnable)new vme(this, (Camera.PreviewCallback)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addPreviewCallbackBuffer(byte[] buffer) {
        void var1_1;
        vmm.post((Runnable)new vmg(this, (byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void setPreviewCallbackSync(Camera.PreviewCallback callback) {
        Camera camera = this.vmn;
        if (camera != null) {
            try {
                void var1_1;
                camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)var1_1);
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setPreviewCallbackWithBuffer(). Could not set preview callback.", (Throwable)runtimeException);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addPreviewCallbackBufferSync(byte[] buffer) {
        void var1_1;
        vmke this_ = this_.vmn;
        if (this_ != null && var1_1 != null) {
            this_.addCallbackBuffer((byte[])var1_1);
            return;
        }
    }

    public boolean doesZoomReallyWork() {
        Camera.CameraInfo cameraInfo;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        vmke vmke2 = vmjn2;
        cameraInfo2();
        Camera.getCameraInfo((int)vmke2.getCameraHost().getCameraId(), (Camera.CameraInfo)cameraInfo2);
        vmjn vmjn2 = vmke2.getCameraHost().getDeviceProfile();
        boolean bl = cameraInfo.facing == 1;
        return vmjn2.vml(bl);
    }

    /*
     * WARNING - void declaration
     */
    public void initPreview(int width, int height) {
        void var2_2;
        void var1_1;
        this.initPreview((int)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=14)
    public void initPreview(int w, int h, boolean firstRun) {
        void var2_2;
        void var1_1;
        vmm.post((Runnable)new vmd(this, (int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initPreviewSync(int w, int h) {
        block7: {
            vmw vmw2;
            block8: {
                block6: {
                    Camera.Parameters parameters;
                    block5: {
                        if (this.vmn == null) break block7;
                        try {
                            boolean bl;
                            vmke vmke2 = this;
                            parameters = vmke2.getCameraParameters();
                            if (vmke2.vml == null) {
                                void var2_3;
                                this.vml = this.getCameraHost().getPreviewSize(this.getDisplayOrientation(), bl ? 1 : 0, (int)var2_3, parameters);
                            }
                            Camera.Size size = this.vml;
                            bl = size.width;
                            parameters.setPreviewSize(bl ? 1 : 0, size.height);
                            if (Build.VERSION.SDK_INT < 14) break block5;
                            bl = this.getCameraHost().getRecordingHint() != CameraHost$RecordingHint.STILL_ONLY;
                            parameters.setRecordingHint(bl);
                        }
                        catch (Exception exception) {
                            break block6;
                        }
                    }
                    vmke vmke3 = this;
                    vmke3.setCameraParametersSync(vmke3.getCameraHost().adjustPreviewParameters(parameters));
                    break block8;
                }
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"initPreview(). Could not work with camera parameters.");
            }
            vmke vmke4 = this;
            vmw vmw3 = vmw2;
            vmw2 = new vmw(this);
            vmke4.post(vmw3);
            vmke4.startPreviewSync();
        }
    }

    public abstract void startPreview();

    public void startPreviewSync() {
        block3: {
            Camera camera = this.vmn;
            if (camera == null) break block3;
            try {
                camera.startPreview();
                this.inPreview = true;
                this.getCameraHost().autoFocusAvailable();
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"startPreviewSync(). Could not start preview.");
            }
        }
    }

    public abstract void stopPreview();

    public final void vmn() {
        block3: {
            if (this.vmn == null) break block3;
            try {
                vmke vmke2 = this;
                vmke2.inPreview = false;
                vmke2.getCameraHost().autoFocusUnavailable();
                vmke2.vmn.setPreviewCallback(null);
                vmke2.vmn.stopPreview();
                return;
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"stopPreviewSync(). Could not stop preview.");
            }
        }
    }

    public final void vml() {
        Camera.CameraInfo cameraInfo;
        Camera.CameraInfo cameraInfo2 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Display display = this.vmi.getDefaultDisplay();
        int n = display.getRotation();
        int n2 = 0;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Camera.getCameraInfo((int)this.vmc, (Camera.CameraInfo)cameraInfo2);
        display.getMetrics(displayMetrics);
        switch (n) {
            default: {
                break;
            }
            case 3: {
                n2 = 270;
                break;
            }
            case 2: {
                n2 = 180;
                break;
            }
            case 1: {
                n2 = 90;
                break;
            }
            case 0: {
                n2 = 0;
            }
        }
        this.vmg = cameraInfo2.facing == 1 ? (360 - (cameraInfo2.orientation + n2) % 360) % 360 : (cameraInfo2.orientation - n2 + 360) % 360;
        if (this.vmn != null) {
            boolean bl = this.inPreview;
            if (bl) {
                this.vmn();
            }
            try {
                this.vmn.setDisplayOrientation(this.vmg);
            }
            catch (RuntimeException runtimeException) {
                Log.v((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"setCameraDisplayOrientation(). Could not set camera display orientation.");
            }
            if (bl) {
                this.startPreviewSync();
            }
        }
    }

    public final int vml(int n) {
        Camera.CameraInfo cameraInfo;
        vmke vmke2 = vmke3;
        vmke vmke3 = cameraInfo;
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)vmke2.vmc, (Camera.CameraInfo)vmke3);
        n = (n + 45) / 90 * 90;
        if (((Camera.CameraInfo)vmke3).facing == 1) {
            return (((Camera.CameraInfo)vmke3).orientation - n + 360) % 360;
        }
        return (((Camera.CameraInfo)vmke3).orientation + n) % 360;
    }
}

