/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util.bitmap;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0007J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0003J*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J,\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J$\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J$\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0007J\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0007J\u0012\u0010\"\u001a\u00020#2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007J\u0012\u0010$\u001a\u00020#2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\u0012\u0010%\u001a\u00020&2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J \u0010'\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004H\u0007\u00a8\u0006*"}, d2={"Lio/scanbot/sdk/util/bitmap/BitmapUtils;", "", "()V", "calculateInSampleSize", "", "options", "Landroid/graphics/BitmapFactory$Options;", "reqWidth", "reqHeight", "width", "height", "compress", "", "bitmap", "Landroid/graphics/Bitmap;", "format", "Landroid/graphics/Bitmap$CompressFormat;", "quality", "file", "Ljava/io/File;", "createPreview", "res", "Landroid/content/res/Resources;", "imageRes", "targetWidth", "targetHeight", "image", "", "decodeQuietly", "path", "", "drawableToBitmap", "drawable", "Landroid/graphics/drawable/Drawable;", "getBitmapBounds", "Landroid/graphics/Rect;", "getContentBounds", "isBitmapValid", "", "scaleIfNeeded", "maxHeight", "maxWidth", "sdk-common_release"})
@SourceDebugExtension(value={"SMAP\nBitmapUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitmapUtils.kt\nio/scanbot/sdk/util/bitmap/BitmapUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n1#2:226\n*E\n"})
public final class BitmapUtils {
    @NotNull
    public static final BitmapUtils INSTANCE = new BitmapUtils();

    private BitmapUtils() {
    }

    @JvmStatic
    @NotNull
    public static final Rect getBitmapBounds(@Nullable String path) {
        BitmapFactory.Options options;
        String string = options;
        new BitmapFactory.Options().inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)string);
        String string2 = string;
        int n = ((BitmapFactory.Options)string2).outWidth;
        int n2 = ((BitmapFactory.Options)string2).outHeight;
        return new Rect(0, 0, n, n2);
    }

    @JvmStatic
    public static final boolean isBitmapValid(@Nullable Bitmap bitmap) {
        Bitmap bitmap2;
        return bitmap != null && !bitmap2.isRecycled();
    }

    @JvmStatic
    @NotNull
    public static final Rect getContentBounds(@Nullable Bitmap bitmap) throws NullPointerException {
        if (bitmap != null) {
            Bitmap bitmap2;
            Bitmap bitmap3 = bitmap2;
            int n = bitmap3.getWidth();
            int n2 = bitmap3.getHeight();
            int n3 = 0;
            int n4 = 0;
            int n5 = bitmap3.getHeight();
            for (int i = 0; i < n5; ++i) {
                int n6 = bitmap2.getWidth();
                for (int j = 0; j < n6; ++j) {
                    if (bitmap2.getPixel(j, i) == 0) continue;
                    if (j < n) {
                        n = j;
                    }
                    if (i < n2) {
                        n2 = i;
                    }
                    if (j > n3) {
                        n3 = j;
                    }
                    if (i <= n4) continue;
                    n4 = i;
                }
            }
            return new Rect(n, n2, n3, n4);
        }
        throw new NullPointerException("Bitmap is null");
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void compress(@NotNull Bitmap bitmap, @NotNull Bitmap.CompressFormat format, int quality, @Nullable File file) throws IOException {
        void var3_3;
        FileOutputStream fileOutputStream;
        Object object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        FileOutputStream fileOutputStream2 = fileOutputStream;
        Bitmap bitmap2 = object;
        fileOutputStream2((File)var3_3);
        object = null;
        try {
            void var2_2;
            void var1_1;
            bitmap2.compress((Bitmap.CompressFormat)var1_1, (int)var2_2, (OutputStream)fileOutputStream2);
        }
        catch (Throwable throwable) {
            object = throwable;
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                CloseableKt.closeFinally((Closeable)fileOutputStream2, (Throwable)object);
                throw throwable2;
            }
        }
        CloseableKt.closeFinally((Closeable)fileOutputStream, (Throwable)object);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final Bitmap createPreview(@Nullable Resources res, int imageRes, int targetWidth, int targetHeight) {
        void var3_3;
        void var2_2;
        void var1_1;
        Resources resources;
        BitmapFactory.Options options;
        if (imageRes <= 0) {
            return null;
        }
        BitmapFactory.Options options2 = options;
        options2();
        options2.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)resources, (int)var1_1, (BitmapFactory.Options)options2);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, (int)var2_2, (int)var3_3);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)resources, (int)var1_1, (BitmapFactory.Options)options2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final Bitmap createPreview(@Nullable byte[] image, int targetWidth, int targetHeight) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        BitmapFactory.Options options;
        if (image == null) {
            return null;
        }
        BitmapFactory.Options options2 = options;
        options2();
        options2.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options2);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, (int)var1_1, (int)var2_2);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final Bitmap createPreview(@Nullable Bitmap image, int targetWidth, int targetHeight) {
        void var2_2;
        int n;
        Bitmap bitmap;
        if (image == null) {
            return null;
        }
        Bitmap bitmap2 = bitmap;
        void v1 = n;
        Bitmap bitmap3 = bitmap;
        n = bitmap3.getWidth();
        n = BitmapUtils.calculateInSampleSize((int)v1, (int)var2_2, n, bitmap3.getHeight());
        return Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)(bitmap2.getWidth() / n), (int)(bitmap.getHeight() / n), (boolean)false);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final int calculateInSampleSize(@NotNull BitmapFactory.Options options, int reqWidth, int reqHeight) {
        void var2_3;
        BitmapFactory.Options options2;
        BitmapFactory.Options options3 = options2;
        Intrinsics.checkNotNullParameter((Object)options3, (String)"options");
        int n = options3.outHeight;
        return BitmapUtils.calculateInSampleSize(reqWidth, (int)var2_3, options3.outWidth, n);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    private static final int calculateInSampleSize(int reqWidth, int reqHeight, int width, int height) {
        void var2_2;
        void var1_1;
        int n;
        int n2;
        void var3_3;
        int n3 = width > var3_3 ? 1 : 0;
        if (n3 == (n2 = n > var1_1 ? 1 : 0)) {
            void v0 = var3_3;
            var3_3 = var2_2;
            var2_2 = v0;
        }
        n3 = 1;
        if (var2_2 > var1_1 || var3_3 > n) {
            var2_2 /= 2;
            var3_3 /= 2;
            while (var2_2 / n3 > var1_1 && var3_3 / n3 > n) {
                n3 *= 2;
            }
        }
        return n3;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final Bitmap decodeQuietly(@Nullable String path, @Nullable BitmapFactory.Options options) {
        String string;
        if (path != null && string.length() != 0) {
            void var1_1;
            File file;
            File file2 = file;
            return new File(string).exists() && file2.isFile() ? BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)var1_1) : null;
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final Bitmap drawableToBitmap(@NotNull Drawable drawable) {
        Canvas canvas;
        Drawable drawable2;
        BitmapDrawable bitmapDrawable;
        Drawable drawable3 = drawable;
        Intrinsics.checkNotNullParameter((Object)drawable3, (String)"drawable");
        if (drawable3 instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable2).getBitmap() != null) {
            Bitmap bitmap = bitmapDrawable.getBitmap().copy(Bitmap.Config.ARGB_8888, true);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"copy(...)");
            return bitmap;
        }
        if (drawable2.getIntrinsicWidth() > 0 && drawable2.getIntrinsicHeight() > 0) {
            bitmapDrawable = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNull((Object)bitmapDrawable);
        } else {
            bitmapDrawable = Bitmap.Config.ARGB_8888;
            bitmapDrawable = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)bitmapDrawable);
            Intrinsics.checkNotNull((Object)bitmapDrawable);
        }
        Drawable drawable4 = drawable2;
        drawable2 = canvas;
        int n = new Canvas((Bitmap)bitmapDrawable).getWidth();
        int n2 = drawable2.getHeight();
        drawable4.setBounds(0, 0, n, n2);
        drawable4.draw((Canvas)drawable2);
        return bitmapDrawable;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Bitmap scaleIfNeeded(@NotNull Bitmap image, int maxHeight, int maxWidth) {
        void var2_3;
        Bitmap bitmap;
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkNotNullParameter((Object)bitmap2, (String)"image");
        if (maxHeight < bitmap2.getHeight() || var2_3 < bitmap.getWidth()) {
            void var1_2;
            float f = Math.min((float)var2_3 / (float)bitmap.getWidth(), (float)var1_2 / (float)bitmap.getHeight());
            int n = MathKt.roundToInt((float)(f * (float)bitmap.getWidth()));
            bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n, (int)MathKt.roundToInt((float)(f * (float)bitmap.getHeight())), (boolean)false);
            Intrinsics.checkNotNull((Object)bitmap);
        }
        return bitmap;
    }
}

