/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.creditcard;

import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.BaseResultHandler;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.creditcard.CreditCardScanner;
import io.scanbot.sdk.creditcard.CreditCardScanningResult;
import io.scanbot.sdk.security.SapSingleton;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.util.PolygonHelper;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0003$%&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J<\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\bJ\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\bJ\u001c\u0010\u001f\u001a\u00020\u000e2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/scanbot/sdk/creditcard/CreditCardScannerFrameHandler;", "Lio/scanbot/sdk/camera/FrameHandler;", "creditCardScanner", "Lio/scanbot/sdk/creditcard/CreditCardScanner;", "<init>", "(Lio/scanbot/sdk/creditcard/CreditCardScanner;)V", "handlers", "", "Lio/scanbot/sdk/creditcard/CreditCardScannerFrameHandler$ResultHandler;", "sapManager", "Lio/scanbot/sap/SapManager;", "logger", "Lio/scanbot/sdk/util/log/Logger;", "handleFrame", "", "previewFrame", "Lio/scanbot/sdk/camera/FrameHandler$Frame;", "mapPolygonToPointsArray", "", "Landroid/graphics/PointF;", "polygon", "frameWidth", "", "frameHeight", "orientation", "finderRect", "Landroid/graphics/RectF;", "addResultHandler", "", "handler", "removeResultHandler", "notifyHandlers", "result", "Lio/scanbot/sdk/camera/FrameHandlerResult;", "Lio/scanbot/sdk/creditcard/CreditCardScanningResult;", "Lio/scanbot/sdk/SdkLicenseError;", "ResultHandler", "CreditCardScannerResultHandler", "Companion", "sdk-creditcard_release"})
@SourceDebugExtension(value={"SMAP\nCreditCardScannerFrameHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreditCardScannerFrameHandler.kt\nio/scanbot/sdk/creditcard/CreditCardScannerFrameHandler\n+ 2 Rect.kt\nandroidx/core/graphics/RectKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n337#2:157\n1#3:158\n1563#4:159\n1634#4,3:160\n*S KotlinDebug\n*F\n+ 1 CreditCardScannerFrameHandler.kt\nio/scanbot/sdk/creditcard/CreditCardScannerFrameHandler\n*L\n67#1:157\n93#1:159\n93#1:160,3\n*E\n"})
public final class CreditCardScannerFrameHandler
extends FrameHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CreditCardScanner creditCardScanner;
    @NotNull
    private final Set<ResultHandler> handlers;
    @NotNull
    private final SapManager sapManager;
    @NotNull
    private final Logger logger;

    /*
     * WARNING - void declaration
     */
    public CreditCardScannerFrameHandler(@NotNull CreditCardScanner creditCardScanner) {
        void var1_1;
        CreditCardScannerFrameHandler creditCardScannerFrameHandler = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"creditCardScanner");
        creditCardScannerFrameHandler.creditCardScanner = var1_1;
        creditCardScannerFrameHandler.handlers = new LinkedHashSet<ResultHandler>();
        creditCardScannerFrameHandler.sapManager = SapSingleton.getInstance();
        creditCardScannerFrameHandler.logger = LoggerProvider.getLogger();
    }

    /*
     * WARNING - void declaration
     */
    private final List<PointF> mapPolygonToPointsArray(List<? extends PointF> polygon, int frameWidth, int frameHeight, int orientation, RectF finderRect) {
        Iterator iterator;
        ArrayList<PointF> arrayList;
        void var5_8;
        void var3_5;
        void var2_4;
        boolean bl = orientation % 180 == 0;
        void var4_7 = bl ? var2_4 : var3_5;
        if (bl) {
            var2_4 = var3_5;
        }
        void v0 = var5_8;
        float f = v0.width();
        float f2 = v0.height();
        float f3 = v0.left;
        float f4 = v0.top;
        ArrayList<PointF> arrayList2 = arrayList;
        arrayList = new ArrayList<PointF>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            PointF pointF = (PointF)iterator.next();
            arrayList2.add(new PointF((pointF.x * f + f3) / (float)var4_7, (pointF.y * f2 + f4) / (float)var2_4));
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean notifyHandlers(FrameHandlerResult<CreditCardScanningResult, SdkLicenseError> result) {
        void var1_1;
        CreditCardScannerFrameHandler creditCardScannerFrameHandler = this;
        return creditCardScannerFrameHandler.processResult(() -> CreditCardScannerFrameHandler.notifyHandlers$lambda$9(creditCardScannerFrameHandler, (FrameHandlerResult)var1_1));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean notifyHandlers$lambda$9(CreditCardScannerFrameHandler this$0, FrameHandlerResult $result) {
        CreditCardScannerFrameHandler creditCardScannerFrameHandler = this$0;
        boolean bl = false;
        Set<ResultHandler> set = creditCardScannerFrameHandler.handlers;
        synchronized (set) {
            Throwable throwable2;
            block4: {
                boolean bl2;
                try {
                    Iterator<ResultHandler> iterator = creditCardScannerFrameHandler.handlers.iterator();
                    while (iterator.hasNext()) {
                        void var1_2;
                        bl |= iterator.next().handle((FrameHandlerResult)var1_2);
                    }
                    bl2 = bl;
                    Set<ResultHandler> set2 = set;
                }
                catch (Throwable throwable2) {
                    break block4;
                }
                return bl2;
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final CreditCardScannerFrameHandler attach(@NotNull IScanbotCameraView cameraView, @NotNull CreditCardScanner creditCardScanner) {
        void var1_1;
        IScanbotCameraView iScanbotCameraView;
        return Companion.attach(iScanbotCameraView, (CreditCardScanner)var1_1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean handleFrame(@NotNull FrameHandler.Frame previewFrame) {
        FrameHandlerResult.Success success;
        List<PointF> list;
        block6: {
            CreditCardScanningResult creditCardScanningResult;
            block8: {
                block7: {
                    RectF rectF;
                    int n;
                    int n2;
                    int n3;
                    Rect rect;
                    block5: {
                        int n4;
                        int n5;
                        int n6;
                        CreditCardScannerFrameHandler creditCardScannerFrameHandler = this_;
                        Intrinsics.checkNotNullParameter((Object)list, (String)"previewFrame");
                        creditCardScannerFrameHandler.logger.logMethod();
                        if (!creditCardScannerFrameHandler.sapManager.checkLicenseStatus(SdkFeature.CreditCardRecognition).booleanValue()) {
                            this_.notifyHandlers((FrameHandlerResult<CreditCardScanningResult, SdkLicenseError>)new FrameHandlerResult.Failure((Object)new SdkLicenseError(this_.sapManager.getLicenseStatus().getLicenseStatusMessage())));
                            return false;
                        }
                        rect = list.getFinderRect();
                        System.currentTimeMillis();
                        if (rect != null) break block5;
                        void v1 = list;
                        byte[] byArray = v1.getFrame();
                        CreditCardScanningResult creditCardScanningResult2 = this_.creditCardScanner.scan(byArray, n6 = v1.getWidth(), n5 = v1.getHeight(), n4 = v1.getFrameOrientation());
                        if (creditCardScanningResult2 == null) return false;
                        List list2 = creditCardScanningResult2.getQuadNormalized();
                        if (list2 == null || (list = PolygonHelper.Companion.rotatePolygon(list2, -((float)list.getFrameOrientation()))) == null) {
                            list = CollectionsKt.emptyList();
                        }
                        list = CreditCardScanningResult.copy$default((CreditCardScanningResult)creditCardScanningResult2, null, null, null, null, (List)list, (int)15, null);
                        break block6;
                    }
                    void v2 = list;
                    byte[] byArray = v2.getFrame();
                    creditCardScanningResult = this_.creditCardScanner.scanInArea(byArray, n3 = v2.getWidth(), n2 = v2.getHeight(), n = v2.getFrameOrientation(), rect);
                    if (creditCardScanningResult == null) return false;
                    List list3 = creditCardScanningResult.getQuadNormalized();
                    if (list3 == null) break block7;
                    List<PointF> list4 = list;
                    int n7 = list4.getWidth();
                    n2 = list4.getHeight();
                    n = list4.getFrameOrientation();
                    RectF rectF2 = rectF;
                    rectF = new RectF(rect);
                    list = this_.mapPolygonToPointsArray(list3, n7, n2, n, rectF2);
                    if (list != null) break block8;
                }
                list = CollectionsKt.emptyList();
            }
            list = CreditCardScanningResult.copy$default((CreditCardScanningResult)creditCardScanningResult, null, null, null, null, (List)list, (int)15, null);
        }
        if (list == null) return false;
        CreditCardScannerFrameHandler creditCardScannerFrameHandler = this_;
        CreditCardScannerFrameHandler this_ = success;
        success = new FrameHandlerResult.Success((Object)list);
        boolean bl = creditCardScannerFrameHandler.notifyHandlers((FrameHandlerResult<CreditCardScanningResult, SdkLicenseError>)this_);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void addResultHandler(@NotNull ResultHandler handler) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"handler");
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.add((ResultHandler)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeResultHandler(@NotNull ResultHandler handler) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"handler");
        Set<ResultHandler> set = this.handlers;
        synchronized (set) {
            this.handlers.remove(var1_1);
            return;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lio/scanbot/sdk/creditcard/CreditCardScannerFrameHandler$Companion;", "", "<init>", "()V", "attach", "Lio/scanbot/sdk/creditcard/CreditCardScannerFrameHandler;", "cameraView", "Lio/scanbot/sdk/ui/camera/IScanbotCameraView;", "creditCardScanner", "Lio/scanbot/sdk/creditcard/CreditCardScanner;", "sdk-creditcard_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final CreditCardScannerFrameHandler attach(@NotNull IScanbotCameraView cameraView, @NotNull CreditCardScanner creditCardScanner) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"cameraView");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"creditCardScanner");
            Object object = (CreditCardScannerFrameHandler)cameraView.getAttachedFrameHandler(CreditCardScannerFrameHandler.class);
            if (object == null) {
                CreditCardScannerFrameHandler creditCardScannerFrameHandler;
                object = creditCardScannerFrameHandler;
                creditCardScannerFrameHandler = new CreditCardScannerFrameHandler((CreditCardScanner)var2_2);
            }
            var1_1.addFrameHandler((FrameHandler)object);
            return object;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk/creditcard/CreditCardScannerFrameHandler$CreditCardScannerResultHandler;", "Lio/scanbot/sdk/creditcard/CreditCardScannerFrameHandler$ResultHandler;", "<init>", "()V", "sdk-creditcard_release"})
    public static abstract class CreditCardScannerResultHandler
    implements ResultHandler {
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk/creditcard/CreditCardScannerFrameHandler$ResultHandler;", "Lio/scanbot/sdk/camera/BaseResultHandler;", "Lio/scanbot/sdk/creditcard/CreditCardScanningResult;", "Lio/scanbot/sdk/SdkLicenseError;", "sdk-creditcard_release"})
    public static interface ResultHandler
    extends BaseResultHandler<CreditCardScanningResult, SdkLicenseError> {
    }
}

