/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.tesseract.android;

import android.graphics.Bitmap;
import android.graphics.Rect;
import androidx.annotation.WorkerThread;
import com.googlecode.leptonica.android.Pix;
import com.googlecode.leptonica.android.Pixa;
import com.googlecode.leptonica.android.ReadFile;
import com.googlecode.tesseract.android.ResultIterator;
import com.googlecode.tesseract.android.TessPdfRenderer;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class TessBaseAPI {
    public static final String VAR_CHAR_WHITELIST = "tessedit_char_whitelist";
    public static final String VAR_CHAR_BLACKLIST = "tessedit_char_blacklist";
    public static final String VAR_SAVE_BLOB_CHOICES = "save_blob_choices";
    public static final String VAR_TRUE = "T";
    public static final String VAR_FALSE = "F";
    public static final int OEM_TESSERACT_ONLY = 0;
    @Deprecated
    public static final int OEM_LSTM_ONLY = 1;
    @Deprecated
    public static final int OEM_TESSERACT_LSTM_COMBINED = 2;
    public static final int OEM_DEFAULT = 3;
    private long mNativeData;
    private ProgressNotifier progressNotifier;
    private boolean mRecycled;

    public TessBaseAPI() {
        long l;
        TessBaseAPI tessBaseAPI = this;
        this.mNativeData = l = tessBaseAPI.nativeConstruct();
        if (l != 0L) {
            this.mRecycled = false;
            return;
        }
        throw new RuntimeException("Can't create TessBaseApi object");
    }

    /*
     * WARNING - void declaration
     */
    public TessBaseAPI(ProgressNotifier progressNotifier) {
        this();
        void var1_1;
        this.progressNotifier = var1_1;
    }

    private static native void nativeClassInit();

    private native long nativeConstruct();

    private native void nativeEnd(long var1);

    private native boolean nativeInit(long var1, String var3, String var4);

    private native boolean nativeInitOem(long var1, String var3, String var4, int var5);

    private native String nativeGetInitLanguagesAsString(long var1);

    private native void nativeClear(long var1);

    private native void nativeSetImageBytes(long var1, byte[] var3, int var4, int var5, int var6, int var7);

    private native void nativeSetImagePix(long var1, long var3);

    private native void nativeSetRectangle(long var1, int var3, int var4, int var5, int var6);

    private native String nativeGetUTF8Text(long var1);

    private native int nativeMeanConfidence(long var1);

    private native int[] nativeWordConfidences(long var1);

    private native boolean nativeSetVariable(long var1, String var3, String var4);

    private native void nativeSetDebug(long var1, boolean var3);

    private native int nativeGetPageSegMode(long var1);

    private native void nativeSetPageSegMode(long var1, int var3);

    private native long nativeGetThresholdedImage(long var1);

    private native long nativeGetRegions(long var1);

    private native long nativeGetTextlines(long var1);

    private native long nativeGetStrips(long var1);

    private native long nativeGetWords(long var1);

    private native long nativeGetConnectedComponents(long var1);

    private native long nativeGetResultIterator(long var1);

    private native String nativeGetBoxText(long var1, int var3);

    private native String nativeGetHOCRText(long var1, int var3);

    private native void nativeSetInputName(long var1, String var3);

    private native void nativeSetOutputName(long var1, String var3);

    private native void nativeReadConfigFile(long var1, String var3);

    private native String nativeGetVersion(long var1);

    private native void nativeStop(long var1);

    private native boolean nativeBeginDocument(long var1, String var3);

    private native boolean nativeEndDocument(long var1);

    private native boolean nativeAddPageToDocument(long var1, long var3, String var5, long var6);

    private native boolean nativeAddPixPageToDocument(long var1, long var3, long var5, long var7);

    private native byte[] nativeGetOutputBuffer(long var1);

    static {
        TessBaseAPI.nativeClassInit();
    }

    /*
     * WARNING - void declaration
     */
    public boolean init(String datapath, String language) {
        void var2_2;
        void var1_1;
        return this.init((String)var1_1, (String)var2_2, 3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean init(String datapath, String language, int ocrEngineMode) {
        if (datapath != null) {
            String string;
            Object object = File.separator;
            if (!string.endsWith((String)object)) {
                string = string + (String)object;
            }
            if (new File(string).exists()) {
                void var3_4;
                void var2_3;
                File file;
                object = file;
                file = new File(string);
                for (String string2 : var2_3.split("\\+")) {
                    File file2;
                    if (string2.startsWith("~")) continue;
                    File file3 = file2;
                    if (new File(object + File.separator + string2 + ".traineddata").exists()) continue;
                    throw new IllegalArgumentException("Data file not found at " + file3);
                }
                TessBaseAPI tessBaseAPI = this;
                boolean bl = tessBaseAPI.nativeInitOem(tessBaseAPI.mNativeData, string, (String)var2_3, (int)var3_4);
                if (bl) {
                    this.mRecycled = false;
                }
                return bl;
            }
            throw new IllegalArgumentException("Data path does not exist!");
        }
        throw new IllegalArgumentException("Data path must not be null!");
    }

    public String getInitLanguagesAsString() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            return tessBaseAPI.nativeGetInitLanguagesAsString(tessBaseAPI.mNativeData);
        }
        throw new IllegalStateException();
    }

    public void clear() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            tessBaseAPI.nativeClear(tessBaseAPI.mNativeData);
            return;
        }
        throw new IllegalStateException();
    }

    public void end() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            tessBaseAPI.nativeEnd(tessBaseAPI.mNativeData);
            tessBaseAPI.mRecycled = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean setVariable(String var, String value) {
        if (!this.mRecycled) {
            void var2_2;
            void var1_1;
            TessBaseAPI tessBaseAPI = this;
            return tessBaseAPI.nativeSetVariable(tessBaseAPI.mNativeData, (String)var1_1, (String)var2_2);
        }
        throw new IllegalStateException();
    }

    public int getPageSegMode() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            return tessBaseAPI.nativeGetPageSegMode(tessBaseAPI.mNativeData);
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    public void setPageSegMode(int mode) {
        if (!this.mRecycled) {
            void var1_1;
            TessBaseAPI tessBaseAPI = this;
            tessBaseAPI.nativeSetPageSegMode(tessBaseAPI.mNativeData, (int)var1_1);
            return;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    public void setDebug(boolean enabled) {
        if (!this.mRecycled) {
            void var1_1;
            TessBaseAPI tessBaseAPI = this;
            tessBaseAPI.nativeSetDebug(tessBaseAPI.mNativeData, (boolean)var1_1);
            return;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    public void setRectangle(Rect rect) {
        if (!this.mRecycled) {
            void var1_2;
            void v0 = var1_2;
            int n = v0.left;
            int n2 = v0.top;
            int n3 = v0.width();
            int n4 = v0.height();
            this.setRectangle(n, n2, n3, n4);
            return;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    public void setRectangle(int left, int top, int width, int height) {
        if (!this.mRecycled) {
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            TessBaseAPI tessBaseAPI = this;
            tessBaseAPI.nativeSetRectangle(tessBaseAPI.mNativeData, (int)var1_1, (int)var2_2, (int)var3_3, (int)var4_4);
            return;
        }
        throw new IllegalStateException();
    }

    @WorkerThread
    public void setImage(File file) {
        if (!this.mRecycled) {
            Pix pix;
            if ((pix = ReadFile.readFile((File)((Object)pix))) != null) {
                long l = this.mNativeData;
                long l2 = pix.getNativePix();
                this.nativeSetImagePix(l, l2);
                pix.recycle();
                return;
            }
            throw new RuntimeException("Failed to read image file");
        }
        throw new IllegalStateException();
    }

    @WorkerThread
    public void setImage(Bitmap bmp) {
        if (!this.mRecycled) {
            Pix pix;
            if ((pix = ReadFile.readBitmap((Bitmap)pix)) != null) {
                long l = this.mNativeData;
                long l2 = pix.getNativePix();
                this.nativeSetImagePix(l, l2);
                pix.recycle();
                return;
            }
            throw new RuntimeException("Failed to read bitmap");
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public void setImage(Pix image) {
        if (!this.mRecycled) {
            void var1_2;
            long l = this.mNativeData;
            long l2 = var1_2.getNativePix();
            this.nativeSetImagePix(l, l2);
            return;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public void setImage(byte[] imagedata, int width, int height, int bpp, int bpl) {
        if (!this.mRecycled) {
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            TessBaseAPI tessBaseAPI = this;
            tessBaseAPI.nativeSetImageBytes(tessBaseAPI.mNativeData, (byte[])var1_1, (int)var2_2, (int)var3_3, (int)var4_4, (int)var5_5);
            return;
        }
        throw new IllegalStateException();
    }

    @WorkerThread
    public String getUTF8Text() {
        if (!((TessBaseAPI)((Object)this_)).mRecycled) {
            TessBaseAPI tessBaseAPI = this_;
            String this_ = tessBaseAPI.nativeGetUTF8Text(tessBaseAPI.mNativeData);
            return this_ != null ? this_.trim() : null;
        }
        throw new IllegalStateException();
    }

    public int meanConfidence() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            return tessBaseAPI.nativeMeanConfidence(tessBaseAPI.mNativeData);
        }
        throw new IllegalStateException();
    }

    public int[] wordConfidences() {
        if (!((TessBaseAPI)this_).mRecycled) {
            TessBaseAPI tessBaseAPI = this_;
            int[] nArray = tessBaseAPI.nativeWordConfidences(tessBaseAPI.mNativeData);
            Object this_ = nArray;
            if (nArray == null) {
                this_ = new int[0];
            }
            return this_;
        }
        throw new IllegalStateException();
    }

    public Pix getThresholdedImage() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            return new Pix(tessBaseAPI.nativeGetThresholdedImage(tessBaseAPI.mNativeData));
        }
        throw new IllegalStateException();
    }

    public Pixa getRegions() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            return new Pixa(tessBaseAPI.nativeGetRegions(tessBaseAPI.mNativeData), 0, 0);
        }
        throw new IllegalStateException();
    }

    public Pixa getTextlines() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            return new Pixa(tessBaseAPI.nativeGetTextlines(tessBaseAPI.mNativeData), 0, 0);
        }
        throw new IllegalStateException();
    }

    public Pixa getStrips() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            return new Pixa(tessBaseAPI.nativeGetStrips(tessBaseAPI.mNativeData), 0, 0);
        }
        throw new IllegalStateException();
    }

    public Pixa getWords() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            return new Pixa(tessBaseAPI.nativeGetWords(tessBaseAPI.mNativeData), 0, 0);
        }
        throw new IllegalStateException();
    }

    public Pixa getConnectedComponents() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            return new Pixa(tessBaseAPI.nativeGetConnectedComponents(tessBaseAPI.mNativeData), 0, 0);
        }
        throw new IllegalStateException();
    }

    public ResultIterator getResultIterator() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            long l = tessBaseAPI.nativeGetResultIterator(tessBaseAPI.mNativeData);
            if (l == 0L) {
                return null;
            }
            return new ResultIterator(l);
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public String getHOCRText(int page) {
        if (!this.mRecycled) {
            void var1_1;
            TessBaseAPI tessBaseAPI = this;
            return tessBaseAPI.nativeGetHOCRText(tessBaseAPI.mNativeData, (int)var1_1);
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    public void setInputName(String name) {
        if (!this.mRecycled) {
            void var1_1;
            TessBaseAPI tessBaseAPI = this;
            tessBaseAPI.nativeSetInputName(tessBaseAPI.mNativeData, (String)var1_1);
            return;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    public void setOutputName(String name) {
        if (!this.mRecycled) {
            void var1_1;
            TessBaseAPI tessBaseAPI = this;
            tessBaseAPI.nativeSetOutputName(tessBaseAPI.mNativeData, (String)var1_1);
            return;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    public void readConfigFile(String filename) {
        if (!this.mRecycled) {
            void var1_1;
            TessBaseAPI tessBaseAPI = this;
            tessBaseAPI.nativeReadConfigFile(tessBaseAPI.mNativeData, (String)var1_1);
            return;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    public String getBoxText(int page) {
        if (!this.mRecycled) {
            void var1_1;
            TessBaseAPI tessBaseAPI = this;
            return tessBaseAPI.nativeGetBoxText(tessBaseAPI.mNativeData, (int)var1_1);
        }
        throw new IllegalStateException();
    }

    public String getVersion() {
        TessBaseAPI tessBaseAPI = this;
        return tessBaseAPI.nativeGetVersion(tessBaseAPI.mNativeData);
    }

    public void stop() {
        if (!this.mRecycled) {
            TessBaseAPI tessBaseAPI = this;
            tessBaseAPI.nativeStop(tessBaseAPI.mNativeData);
            return;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    public void onProgressValues(int percent, int left, int right, int top, int bottom, int textLeft, int textRight, int textTop, int textBottom) {
        if (this.progressNotifier != null) {
            void var1_1;
            ProgressValues progressValues;
            void var7_9;
            void var9_11;
            void var6_8;
            Rect rect;
            void var3_4;
            void var5_7;
            void var4_6;
            void var8_10;
            void var2_2;
            Rect rect2;
            Rect rect3 = rect2;
            void v1 = var2_2;
            var2_2 = var8_10 - var4_6;
            var4_6 = var8_10 - var5_7;
            rect2 = new Rect((int)v1, (int)var2_2, (int)var3_4, (int)var4_6);
            Rect rect4 = rect;
            rect = new Rect((int)var6_8, (int)var9_11, (int)var7_9, (int)var8_10);
            ProgressValues progressValues2 = progressValues;
            progressValues = new ProgressValues(this, (int)var1_1, rect3, rect4);
            this.progressNotifier.onProgressValues(progressValues2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean beginDocument(TessPdfRenderer tessPdfRenderer, String title) {
        void var2_2;
        void var1_1;
        return this.nativeBeginDocument(var1_1.getNativePdfRenderer(), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean beginDocument(TessPdfRenderer tessPdfRenderer) {
        void var1_1;
        return this.nativeBeginDocument(var1_1.getNativePdfRenderer(), "");
    }

    /*
     * WARNING - void declaration
     */
    public boolean endDocument(TessPdfRenderer tessPdfRenderer) {
        void var1_1;
        return this.nativeEndDocument(var1_1.getNativePdfRenderer());
    }

    /*
     * WARNING - void declaration
     */
    public boolean addPageToDocument(Pix imageToProcess, String imageToWrite, TessPdfRenderer tessPdfRenderer) {
        void var2_3;
        void var3_4;
        void var1_2;
        long l = this.mNativeData;
        long l2 = var1_2.getNativePix();
        long l3 = var3_4.getNativePdfRenderer();
        return this.nativeAddPageToDocument(l, l2, (String)var2_3, l3);
    }

    /*
     * WARNING - void declaration
     */
    public boolean addPageToDocument(Pix imageToProcess, Pix imageToWrite, TessPdfRenderer tessPdfRenderer) {
        void var3_5;
        void var2_3;
        void var1_2;
        long l = this.mNativeData;
        long l2 = var1_2.getNativePix();
        long l3 = var2_3.getNativePix();
        long l4 = var3_5.getNativePdfRenderer();
        return this.nativeAddPixPageToDocument(l, l2, l3, l4);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getOutputBuffer(TessPdfRenderer tessPdfRenderer) {
        void var1_1;
        return this.nativeGetOutputBuffer(var1_1.getNativePdfRenderer());
    }

    public long getNativeData() {
        return this.mNativeData;
    }

    public static interface ProgressNotifier {
        public void onProgressValues(ProgressValues var1);
    }

    public class ProgressValues {
        private final int percent;
        private final Rect wordRect;
        private final Rect textRect;
        final /* synthetic */ TessBaseAPI this$0;

        /*
         * WARNING - void declaration
         */
        public ProgressValues(TessBaseAPI this$0, int percent, Rect wordRect, Rect textRect) {
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.percent = var2_2;
            this.wordRect = var3_3;
            this.textRect = var4_4;
        }

        public int getPercent() {
            return this.percent;
        }

        public Rect getCurrentWordRect() {
            return this.wordRect;
        }

        public Rect getCurrentRect() {
            return this.textRect;
        }
    }

    public static final class PageIteratorLevel {
        public static final int RIL_BLOCK = 0;
        public static final int RIL_PARA = 1;
        public static final int RIL_TEXTLINE = 2;
        public static final int RIL_WORD = 3;
        public static final int RIL_SYMBOL = 4;

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Level {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OcrEngineMode {
    }

    public static final class PageSegMode {
        public static final int PSM_OSD_ONLY = 0;
        public static final int PSM_AUTO_OSD = 1;
        public static final int PSM_AUTO_ONLY = 2;
        public static final int PSM_AUTO = 3;
        public static final int PSM_SINGLE_COLUMN = 4;
        public static final int PSM_SINGLE_BLOCK_VERT_TEXT = 5;
        public static final int PSM_SINGLE_BLOCK = 6;
        public static final int PSM_SINGLE_LINE = 7;
        public static final int PSM_SINGLE_WORD = 8;
        public static final int PSM_CIRCLE_WORD = 9;
        public static final int PSM_SINGLE_CHAR = 10;
        public static final int PSM_SPARSE_TEXT = 11;
        public static final int PSM_SPARSE_TEXT_OSD = 12;
        public static final int PSM_RAW_LINE = 13;

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Mode {
        }
    }
}

