/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import android.graphics.Rect;
import android.util.Log;
import androidx.annotation.Size;
import com.googlecode.leptonica.android.Box;
import com.googlecode.leptonica.android.Pix;
import com.googlecode.leptonica.android.a;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public class Pixa
implements Iterable<Pix> {
    private static final String TAG = "Pixa";
    private final long mNativePixa;
    final int mWidth;
    final int mHeight;
    private boolean mRecycled;

    public long getNativePixa() {
        if (!this.mRecycled) {
            return this.mNativePixa;
        }
        throw new IllegalStateException();
    }

    public Pixa copy() {
        if (!this.mRecycled) {
            long l = Pixa.nativeCopy(this.mNativePixa);
            if (l != 0L) {
                Pixa pixa = this;
                int n = pixa.mWidth;
                int n2 = pixa.mHeight;
                return new Pixa(l, n, n2);
            }
            throw new OutOfMemoryError();
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    public Pixa sort(int field, int order) {
        if (!this.mRecycled) {
            void var2_4;
            void var1_2;
            long l = Pixa.nativeSort(this.mNativePixa, (int)var1_2, (int)var2_4);
            if (l != 0L) {
                Pixa pixa = this;
                int n = pixa.mWidth;
                int n2 = pixa.mHeight;
                return new Pixa(l, n, n2);
            }
            throw new OutOfMemoryError();
        }
        throw new IllegalStateException();
    }

    public int size() {
        if (!this.mRecycled) {
            return Pixa.nativeGetCount(this.mNativePixa);
        }
        throw new IllegalStateException();
    }

    public synchronized void recycle() {
        if (!this.mRecycled) {
            Pixa.nativeDestroy(this.mNativePixa);
            this.mRecycled = true;
        }
    }

    public void finalize() {
        Throwable throwable2;
        block5: {
            block4: {
                try {
                    if (this.mRecycled) break block4;
                }
                catch (Throwable throwable2) {}
                Pixa pixa = this;
                Log.w((String)TAG, (String)"Pixa was not terminated using recycle()");
                pixa.recycle();
                break block5;
            }
            super.finalize();
            return;
        }
        super.finalize();
        throw throwable2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean join(Pixa otherPixa) {
        if (!this.mRecycled) {
            void var1_1;
            return Pixa.nativeJoin(this.mNativePixa, var1_1.mNativePixa);
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    public void addPix(Pix pix, int mode) {
        if (!this.mRecycled) {
            void var2_2;
            void var1_1;
            Pixa.nativeAddPix(this.mNativePixa, var1_1.getNativePix(), (int)var2_2);
            return;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    public void addBox(Box box, int mode) {
        if (!this.mRecycled) {
            void var2_2;
            void var1_1;
            Pixa.nativeAddBox(this.mNativePixa, var1_1.getNativeBox(), (int)var2_2);
            return;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    public void add(Pix pix, Box box, int mode) {
        if (!this.mRecycled) {
            void var3_4;
            void var2_3;
            void var1_2;
            long l = var1_2.getNativePix();
            long l2 = var2_3.getNativeBox();
            Pixa.nativeAdd(this.mNativePixa, l, l2, (int)var3_4);
            return;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    public Box getBox(int index) {
        if (!this.mRecycled) {
            void var1_2;
            long l = Pixa.nativeGetBox(this.mNativePixa, (int)var1_2);
            if (l == 0L) {
                return null;
            }
            return new Box(l);
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    public Pix getPix(int index) {
        if (!this.mRecycled) {
            void var1_2;
            long l = Pixa.nativeGetPix(this.mNativePixa, (int)var1_2);
            if (l == 0L) {
                return null;
            }
            return new Pix(l);
        }
        throw new IllegalStateException();
    }

    public int getWidth() {
        if (!this.mRecycled) {
            return this.mWidth;
        }
        throw new IllegalStateException();
    }

    public int getHeight() {
        if (!this.mRecycled) {
            return this.mHeight;
        }
        throw new IllegalStateException();
    }

    public Rect getRect() {
        if (!this.mRecycled) {
            Pixa pixa = this;
            int n = pixa.mWidth;
            int n2 = pixa.mHeight;
            return new Rect(0, 0, n, n2);
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    public int[] getBoxGeometry(int index) {
        if (!((Pixa)this_).mRecycled) {
            void var1_1;
            Pixa pixa = this_;
            int[] nArray = new int[4];
            Object this_ = nArray;
            if (pixa.getBoxGeometry((int)var1_1, nArray)) {
                return this_;
            }
            return null;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    public boolean getBoxGeometry(int index, @Size(min=4L) int[] dimensions) {
        if (!this.mRecycled) {
            void var2_2;
            void var1_1;
            return Pixa.nativeGetBoxGeometry(this.mNativePixa, (int)var1_1, (int[])var2_2);
        }
        throw new IllegalStateException();
    }

    public Rect getBoxRect(int index) {
        Object object;
        Object this_;
        int[] nArray = ((Pixa)this_).getBoxGeometry((int)object);
        Object object2 = nArray;
        if (nArray == null) {
            return null;
        }
        Object object3 = object2;
        Object object32 = object3[0];
        object = object3[1];
        Object object4 = object3[2];
        Object object5 = object3[3];
        reference var2_4 = object32 + object4;
        reference var3_6 = object + object5;
        return new Rect((int)object32, (int)object, (int)var2_4, (int)var3_6);
    }

    public ArrayList<Rect> getBoxRects() {
        if (!this.mRecycled) {
            ArrayList<Rect> arrayList;
            int n = Pixa.nativeGetCount(this.mNativePixa);
            int[] nArray = new int[4];
            ArrayList<Rect> arrayList2 = arrayList;
            arrayList = new ArrayList<Rect>(n);
            for (int i = 0; i < n; ++i) {
                this.getBoxGeometry(i, nArray);
                int n2 = nArray[0];
                int n3 = nArray[1];
                int n4 = n3 + nArray[3];
                arrayList2.add(new Rect(n2, n3, n2 += nArray[2], n4));
            }
            return arrayList2;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    public void replacePix(int index, Pix pix, Box box) {
        if (!this.mRecycled) {
            void var1_2;
            void var3_5;
            void var2_3;
            long l = var2_3.getNativePix();
            long l2 = var3_5.getNativeBox();
            Pixa.nativeReplacePix(this.mNativePixa, (int)var1_2, l, l2);
            return;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    public void mergeAndReplacePix(int indexA, int indexB) {
        if (!this.mRecycled) {
            void var2_2;
            void var1_1;
            Pixa.nativeMergeAndReplacePix(this.mNativePixa, (int)var1_1, (int)var2_2);
            return;
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - void declaration
     */
    public boolean writeToFileRandomCmap(File file) {
        if (!((Pixa)((Object)this_)).mRecycled) {
            void var1_1;
            Pixa pixa = this_;
            String this_ = var1_1.getAbsolutePath();
            int n = pixa.mWidth;
            int n2 = pixa.mHeight;
            return Pixa.nativeWriteToFileRandomCmap(((Pixa)((Object)this_)).mNativePixa, this_, n, n2);
        }
        throw new IllegalStateException();
    }

    @Override
    public Iterator<Pix> iterator() {
        return new a(this);
    }

    public static Pixa createPixa(int size) {
        return Pixa.createPixa(size, 0, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static Pixa createPixa(int size, int width, int height) {
        long l = Pixa.nativeCreate(size);
        if (l != 0L) {
            void var2_2;
            void var1_1;
            return new Pixa(l, (int)var1_1, (int)var2_2);
        }
        throw new OutOfMemoryError();
    }

    /*
     * WARNING - void declaration
     */
    public Pixa(long nativePixa, int width, int height) {
        void var4_3;
        void var3_2;
        void var1_1;
        this.mNativePixa = var1_1;
        this.mWidth = var3_2;
        this.mHeight = var4_3;
        this.mRecycled = false;
    }

    private static native long nativeCreate(int var0);

    private static native long nativeCopy(long var0);

    private static native long nativeSort(long var0, int var2, int var3);

    private static native boolean nativeJoin(long var0, long var2);

    private static native int nativeGetCount(long var0);

    private static native void nativeDestroy(long var0);

    private static native void nativeAddPix(long var0, long var2, int var4);

    private static native void nativeAddBox(long var0, long var2, int var4);

    private static native void nativeAdd(long var0, long var2, long var4, int var6);

    private static native boolean nativeWriteToFileRandomCmap(long var0, String var2, int var3, int var4);

    private static native void nativeReplacePix(long var0, int var2, long var3, long var5);

    private static native void nativeMergeAndReplacePix(long var0, int var2, int var3);

    private static native long nativeGetBox(long var0, int var2);

    private static native long nativeGetPix(long var0, int var2);

    private static native boolean nativeGetBoxGeometry(long var0, int var2, int[] var3);
}

