/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.docprocessing;

import android.graphics.Bitmap;
import android.net.Uri;
import androidx.core.net.UriKt;
import io.scanbot.page.DocumentData;
import io.scanbot.page.PageData;
import io.scanbot.sdk.docprocessing.Page;
import io.scanbot.sdk.persistence.document.DocumentStorage;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.persistence.page.PageFileStorage;
import io.scanbot.sdk.persistence.page.PageFileType;
import io.scanbot.sdk.persistence.page.PageStorageProcessor;
import io.scanbot.sdk.scanbotsdkpersistence.a;
import io.scanbot.sdk.scanbotsdkpersistence.b;
import io.scanbot.sdk.scanbotsdkpersistence.c;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FileAlreadyExistsException;
import kotlin.io.FilesKt;
import kotlin.io.NoSuchFileException;
import kotlin.io.OnErrorAction;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0012\u0018\u0000 a2\u00020\u0001:\u0001aB!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tB)\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\b\u0010\fB;\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\b\u0010\u0011J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0015\u001a\u00020\r\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\n\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020 \u00a2\u0006\u0004\b\u001e\u0010!J\u0015\u0010\u001e\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b\u001e\u0010$J\u001d\u0010%\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\n\u00a2\u0006\u0004\b%\u0010&J\u001d\u0010%\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\n\u00a2\u0006\u0004\b%\u0010'J\u0015\u0010)\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u0016\u00a2\u0006\u0004\b)\u0010*J\u0015\u0010)\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\n\u00a2\u0006\u0004\b)\u0010,J\u0015\u0010)\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\r\u00a2\u0006\u0004\b)\u0010.J\r\u00100\u001a\u00020/\u00a2\u0006\u0004\b0\u00101J\u001d\u00104\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\n2\u0006\u00103\u001a\u00020\n\u00a2\u0006\u0004\b4\u00105J\u001b\u00106\u001a\u00020/2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0012\u00a2\u0006\u0004\b6\u00107J\r\u00108\u001a\u00020/\u00a2\u0006\u0004\b8\u00101J\r\u00109\u001a\u00020/\u00a2\u0006\u0004\b9\u00101J\u0019\u0010:\u001a\u0004\u0018\u00010\u00002\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b:\u0010;J\r\u0010<\u001a\u00020\u0000\u00a2\u0006\u0004\b<\u0010=J!\u0010@\u001a\u00020\u00002\b\b\u0002\u0010>\u001a\u00020\r2\b\b\u0002\u0010?\u001a\u00020\u000f\u00a2\u0006\u0004\b@\u0010AJ\r\u0010B\u001a\u00020\r\u00a2\u0006\u0004\bB\u0010CR#\u0010I\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00120D8\u0006\u00a2\u0006\f\n\u0004\bE\u0010F\u001a\u0004\bG\u0010HR\u0017\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00160\u00128F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010\u0014R$\u0010\u0015\u001a\u00020\r2\u0006\u0010L\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bM\u0010C\"\u0004\bN\u0010OR$\u0010U\u001a\u00020P2\u0006\u0010L\u001a\u00020P8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR$\u0010\u000b\u001a\u00020\n2\u0006\u0010L\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bV\u0010W\"\u0004\bX\u0010YR\u0011\u0010[\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\bZ\u0010WR\u0011\u0010^\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b\\\u0010]R\u0011\u0010`\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b_\u0010]\u00a8\u0006b"}, d2={"Lio/scanbot/sdk/docprocessing/Document;", "", "Lio/scanbot/sdk/persistence/document/DocumentStorage;", "documentStorage", "Lio/scanbot/sdk/persistence/page/PageFileStorage;", "pageFileStorage", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "fileIOProcessor", "<init>", "(Lio/scanbot/sdk/persistence/document/DocumentStorage;Lio/scanbot/sdk/persistence/page/PageFileStorage;Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;)V", "", "documentImageSizeLimit", "(Lio/scanbot/sdk/persistence/document/DocumentStorage;Lio/scanbot/sdk/persistence/page/PageFileStorage;Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;I)V", "", "documentId", "", "createIfNotExist", "(Lio/scanbot/sdk/persistence/document/DocumentStorage;Lio/scanbot/sdk/persistence/page/PageFileStorage;Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;Ljava/lang/String;ZI)V", "", "pageIds", "()Ljava/util/List;", "uuid", "Lio/scanbot/sdk/docprocessing/Page;", "pageWithId", "(Ljava/lang/String;)Lio/scanbot/sdk/docprocessing/Page;", "index", "pageAtIndex", "(I)Lio/scanbot/sdk/docprocessing/Page;", "", "image", "addPage", "([B)Lio/scanbot/sdk/docprocessing/Page;", "Landroid/graphics/Bitmap;", "(Landroid/graphics/Bitmap;)Lio/scanbot/sdk/docprocessing/Page;", "Landroid/net/Uri;", "imageUri", "(Landroid/net/Uri;)Lio/scanbot/sdk/docprocessing/Page;", "insertPage", "([BI)Lio/scanbot/sdk/docprocessing/Page;", "(Landroid/graphics/Bitmap;I)Lio/scanbot/sdk/docprocessing/Page;", "page", "removePage", "(Lio/scanbot/sdk/docprocessing/Page;)Z", "atIndex", "(I)Z", "pageUuid", "(Ljava/lang/String;)Z", "", "removeAllPages", "()V", "sourceIndex", "destinationIndex", "movePage", "(II)Z", "sortPagesById", "(Ljava/util/List;)V", "delete", "saveSync", "loadSync", "(Z)Lio/scanbot/sdk/docprocessing/Document;", "clone", "()Lio/scanbot/sdk/docprocessing/Document;", "newUuid", "overwrite", "duplicate", "(Ljava/lang/String;Z)Lio/scanbot/sdk/docprocessing/Document;", "toJson", "()Ljava/lang/String;", "Lkotlinx/coroutines/flow/StateFlow;", "e", "Lkotlinx/coroutines/flow/StateFlow;", "getPagesFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "pagesFlow", "getPages", "pages", "value", "getUuid", "setUuid", "(Ljava/lang/String;)V", "", "getCreationTimeStamp", "()J", "setCreationTimeStamp", "(J)V", "creationTimeStamp", "getDocumentImageSizeLimit", "()I", "setDocumentImageSizeLimit", "(I)V", "getPageCount", "pageCount", "getPdfUri", "()Landroid/net/Uri;", "pdfUri", "getTiffUri", "tiffUri", "Companion", "sdk-persistence_release"}, xi=48)
@SourceDebugExtension(value={"SMAP\nDocument.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Document.kt\nio/scanbot/sdk/docprocessing/Document\n+ 2 Uri.kt\nandroidx/core/net/UriKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,568:1\n36#2:569\n36#2:570\n36#2:573\n36#2:574\n1869#3,2:571\n1563#3:575\n1634#3,3:576\n1869#3,2:580\n1563#3:582\n1634#3,3:583\n1563#3:586\n1634#3,3:587\n1563#3:590\n1634#3,3:591\n774#3:594\n865#3,2:595\n785#3:597\n796#3:598\n1878#3,2:599\n797#3,2:601\n1880#3:603\n799#3:604\n774#3:605\n865#3,2:606\n1#4:579\n*S KotlinDebug\n*F\n+ 1 Document.kt\nio/scanbot/sdk/docprocessing/Document\n*L\n82#1:569\n83#1:570\n69#1:573\n72#1:574\n62#1:571,2\n124#1:575\n124#1:576,3\n264#1:580,2\n379#1:582\n379#1:583,3\n441#1:586\n441#1:587,3\n458#1:590\n458#1:591,3\n207#1:594\n207#1:595,2\n217#1:597\n217#1:598\n217#1:599,2\n217#1:601,2\n217#1:603\n217#1:604\n227#1:605\n227#1:606,2\n*E\n"})
public final class Document {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final Mutex g = MutexKt.Mutex$default((boolean)false, (int)1, null);
    public final DocumentStorage a;
    public final PageFileStorage b;
    public final FileIOProcessor c;
    public final MutableStateFlow d;
    public final MutableStateFlow e;
    public DocumentData f;

    @NotNull
    public final StateFlow<List<Page>> getPagesFlow() {
        return this.e;
    }

    @NotNull
    public final List<Page> getPages() {
        return (List)this.d.getValue();
    }

    @NotNull
    public final String getUuid() {
        return this.f.getUuid();
    }

    /*
     * WARNING - void declaration
     */
    public final void setUuid(@NotNull String value) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"value");
        this.a((String)var1_1);
    }

    public final long getCreationTimeStamp() {
        return this.f.getCreationTimestamp();
    }

    /*
     * WARNING - void declaration
     */
    public final void setCreationTimeStamp(long value) {
        void var1_1;
        Document document = this;
        document.a(() -> Document.a(document, (long)var1_1));
    }

    public final int getDocumentImageSizeLimit() {
        return this.f.getDocumentImageSizeLimit();
    }

    /*
     * WARNING - void declaration
     */
    public final void setDocumentImageSizeLimit(int value) {
        void var1_1;
        Document document = this_;
        document.a(() -> Document.a(document, (int)var1_1));
        Iterator this_ = document.getPages().iterator();
        while (this_.hasNext()) {
            Page.apply$default((Page)this_.next(), null, null, null, 7, null);
        }
    }

    public final int getPageCount() {
        return this.getPages().size();
    }

    @NotNull
    public final Uri getPdfUri() {
        Uri uri = Uri.fromFile((File)this.a.getDocumentPdfFile(this.getUuid()));
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.fromFile(this)");
        return uri;
    }

    @NotNull
    public final Uri getTiffUri() {
        Uri uri = Uri.fromFile((File)this.a.getDocumentTiffFile(this.getUuid()));
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.fromFile(this)");
        return uri;
    }

    @NotNull
    public final List<String> pageIds() {
        ArrayList<String> arrayList;
        Iterator this_ = ((Document)((Object)this_)).getPages();
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)this_), (int)10));
        this_ = this_.iterator();
        while (this_.hasNext()) {
            arrayList2.add(((Page)this_.next()).getUuid());
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Page pageWithId(@NotNull String uuid) {
        Object var2_2;
        block1: {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)var1_1, (String)"uuid");
            for (Object e : ((Document)this).getPages()) {
                var2_2 = e;
                if (!Intrinsics.areEqual((Object)((Page)e).getUuid(), (Object)var1_1)) continue;
                break block1;
            }
            var2_2 = null;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Page pageAtIndex(int index) {
        void var1_1;
        return (Page)CollectionsKt.getOrNull(this.getPages(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Page addPage(@NotNull byte[] image) {
        void var1_1;
        Document document = this;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"image");
        return (Page)document.a(() -> Document.a(document, (byte[])v1));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Page addPage(@NotNull Bitmap image) {
        void var1_1;
        Document document = this;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"image");
        return (Page)document.a(() -> Document.a(document, (Bitmap)v1));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Page addPage(@NotNull Uri imageUri) {
        void var1_1;
        Document document = this;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"imageUri");
        return (Page)document.a(() -> Document.a(document, (Uri)v1));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Page insertPage(@NotNull byte[] image, int index) {
        void var2_2;
        void var1_1;
        Document document = this;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"image");
        return (Page)document.a(() -> Document.a(document, (byte[])v1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Page insertPage(@NotNull Bitmap image, int index) {
        void var2_2;
        void var1_1;
        Document document = this;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"image");
        return (Page)document.a(() -> Document.a(document, (Bitmap)v1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean removePage(@NotNull Page page) {
        void var1_1;
        Document document = this;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"page");
        return (Boolean)document.a(() -> Document.a(document, (Page)v1));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean removePage(int atIndex) {
        void var1_1;
        Document document = this;
        return (Boolean)document.a(() -> Document.b(document, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean removePage(@NotNull String pageUuid) {
        void var1_1;
        Document document = this;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"pageUuid");
        return (Boolean)document.a(() -> Document.b(document, (String)v1));
    }

    public final void removeAllPages() {
        Document document = this;
        document.a(() -> Document.a(document));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean movePage(int sourceIndex, int destinationIndex) {
        void var2_2;
        void var1_1;
        return (Boolean)this.a(() -> Document.a((int)var1_1, (int)var2_2, this));
    }

    public final void sortPagesById(@NotNull List<String> pageIds) {
        List<String> list = pageIds;
        Intrinsics.checkNotNullParameter(list, (String)"pageIds");
        if (list.size() == this.getPages().size()) {
            ArrayList<Object> arrayList;
            ArrayList<Object> arrayList2;
            void v1 = arrayList2;
            arrayList2 = arrayList;
            arrayList = new ArrayList<Object>();
            for (String string : v1) {
                Object var5_5;
                block4: {
                    for (Object t : this.getPages()) {
                        var5_5 = t;
                        if (!Intrinsics.areEqual((Object)((Page)t).getUuid(), (Object)string)) continue;
                        break block4;
                    }
                    var5_5 = null;
                }
                Page page = var5_5;
                if (page != null) {
                    arrayList2.add(page);
                    continue;
                }
                throw new IllegalArgumentException("Page with id " + string + " not found.");
            }
            this.d.setValue(arrayList2);
            return;
        }
        throw new IllegalStateException("The number of page ids must be equal to the number of pages.");
    }

    public final void delete() {
        this.a.delete(this.getUuid());
    }

    public final void saveSync() {
        c c2;
        Document this_ = () -> Document.b(this_);
        c c3 = c2;
        c2 = new c((Function0)this_, null);
        BuildersKt.runBlocking$default(null, (Function2)c3, (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Document loadSync(boolean createIfNotExist) {
        c c2;
        void var1_1;
        Document this_ = () -> Document.a(this_, (boolean)var1_1);
        c c3 = c2;
        c2 = new c((Function0)this_, null);
        return (Document)BuildersKt.runBlocking$default(null, (Function2)c3, (int)1, null);
    }

    @NotNull
    public final Document clone() {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return this.a.getDocumentDir(string).exists() ? this.clone() : this.duplicate(string, false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Document duplicate(@NotNull String newUuid, boolean overwrite) {
        ArrayList arrayList;
        Document document;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)newUuid, (String)"newUuid");
        FilesKt.copyTo$default((File)this.a.getDocumentDir(this.getUuid()), (File)this.a.getDocumentDir((String)var1_1), (boolean)var2_2, (int)0, (int)4, null);
        Iterator iterator = UriKt.toFile((Uri)this.getPdfUri());
        Serializable serializable = UriKt.toFile((Uri)this.getTiffUri());
        Document document2 = document;
        document2(this.a, this.b, this.c, (String)var1_1, false, this.getDocumentImageSizeLimit());
        document.a(() -> Document.a(document, (String)var1_1));
        if (this.c.getUseEncryption()) {
            if (((File)((Object)iterator)).exists()) {
                FilesKt.copyTo$default((File)((Object)iterator), (File)UriKt.toFile((Uri)document2.getPdfUri()), (boolean)var2_2, (int)0, (int)4, null);
            }
            if (((File)serializable).exists()) {
                FilesKt.copyTo$default((File)serializable, (File)UriKt.toFile((Uri)document2.getTiffUri()), (boolean)var2_2, (int)0, (int)4, null);
            }
        } else {
            if (((File)((Object)iterator)).exists()) {
                this.c.copy((File)((Object)iterator), UriKt.toFile((Uri)document2.getPdfUri()));
            }
            if (((File)serializable).exists()) {
                this.c.copy((File)serializable, UriKt.toFile((Uri)document2.getTiffUri()));
            }
        }
        iterator = this.getPages();
        serializable = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object object = (Page)iterator.next();
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            Object object2 = this.b.getPageStorage().getPageDir(string, (String)var1_1);
            if (this.c.getUseEncryption()) {
                FilesKt.copyRecursively$default((File)this.b.getPageStorage().getPageDir(((Page)object).getUuid(), this.getUuid()), (File)object2, (boolean)var2_2, null, (int)4, null);
            } else {
                Document.a(this.b.getPageStorage().getPageDir(((Page)object).getUuid(), this.getUuid()), (File)object2, (boolean)var2_2, SetsKt.setOf((Object)"json"), this.c);
            }
            PageData pageData = ((Page)object).getPageData$sdk_persistence_release();
            String string2 = string;
            object = this.b.getImageURI(string, document2.getUuid(), PageFileType.ORIGINAL).getPath();
            Intrinsics.checkNotNull((Object)object);
            object2 = this.b.getImageURI(string, document2.getUuid(), PageFileType.UNFILTERED_DOCUMENT).getPath();
            Intrinsics.checkNotNull((Object)object2);
            PageFileType pageFileType = PageFileType.DOCUMENT;
            String string3 = this.b.getImageURI(string, document2.getUuid(), pageFileType).getPath();
            Intrinsics.checkNotNull((Object)string3);
            string = this.b.getPreviewImageURI(string, document2.getUuid(), pageFileType).getPath();
            Intrinsics.checkNotNull((Object)string);
            ((ArrayList)serializable).add(document2.a(PageData.copy$default(pageData, string2, null, null, null, null, null, (String)object, string3, (String)object2, string, 62, null)));
        }
        return document2;
    }

    @NotNull
    public final String toJson() {
        c c2;
        Document this_ = () -> Document.c(this_);
        c c3 = c2;
        c2 = new c((Function0)this_, null);
        String string = ((JSONObject)BuildersKt.runBlocking$default(null, (Function2)c3, (int)1, null)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final Page a(PageData pageData) {
        Document document = this;
        return (Page)document.a(() -> Document.a(document, pageData));
    }

    public final Object a(Function0 object) {
        c c2;
        Document document = () -> Document.a((Function0)object, document);
        object = c2;
        c2 = new c((Function0)document, null);
        return BuildersKt.runBlocking$default(null, (Function2)object, (int)1, null);
    }

    public final void b() {
        ArrayList<PageData> arrayList;
        File file = this.a.getDocumentJsonFile(this.f.getUuid());
        if (file.exists()) {
            file.delete();
        }
        Document document = this;
        file.getParentFile().mkdirs();
        DocumentData documentData = document.f;
        Object object = document.getPages();
        ArrayList<PageData> arrayList2 = arrayList;
        arrayList = new ArrayList<PageData>(CollectionsKt.collectionSizeOrDefault(object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            arrayList2.add(((Page)object.next()).getPageData$sdk_persistence_release());
        }
        Document document2 = this;
        documentData.setPages(arrayList2);
        documentData = document2.f;
        object = document2.getPdfUri().getPath();
        if (object == null) {
            object = "";
        }
        Document document3 = this;
        documentData.setPdfURI((String)object);
        documentData = document3.f;
        object = document3.getTiffUri().getPath();
        if (object == null) {
            object = "";
        }
        documentData.setTiffURI((String)object);
        String string = DocumentData.toJson$default(this.f, null, 1, null).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        FilesKt.writeBytes((File)file, (byte[])byArray);
    }

    public final Page b(PageData pageData) {
        b b2;
        Document document = documentData;
        b b3 = b2;
        b2 = new b((Document)((Object)documentData));
        DocumentData documentData = document.f;
        FileIOProcessor fileIOProcessor = document.c;
        PageFileStorage pageFileStorage = document.b;
        return new Page(b3, documentData, pageData, fileIOProcessor, pageFileStorage);
    }

    public final PageStorageProcessor.Configuration a() {
        PageStorageProcessor.Configuration configuration = PageStorageProcessor.Configuration.Companion.DEFAULT();
        boolean bl = false;
        boolean bl2 = false;
        if (((Document)this).getDocumentImageSizeLimit() == 0) {
            PageStorageProcessor.Configuration.Size size;
            this = size;
            size = new PageStorageProcessor.Configuration.Size(0, 0, 3, null);
        } else {
            PageStorageProcessor.Configuration.Size size;
            PageStorageProcessor.Configuration.Size size2 = size;
            Object object = this;
            int n = ((Document)object).getDocumentImageSizeLimit();
            size = new PageStorageProcessor.Configuration.Size(n, ((Document)object).getDocumentImageSizeLimit());
            this = size2;
        }
        return PageStorageProcessor.Configuration.copy$default(configuration, bl, bl2, (PageStorageProcessor.Configuration.Size)this, 0.0f, 0, null, 59, null);
    }

    public final void a(String string) {
        File file;
        block6: {
            boolean bl;
            block5: {
                block4: {
                    bl = true;
                    file = this.a.getDocumentDir(string);
                    if (file.exists() && file.isFile()) {
                        throw new FileAlreadyExistsException(file, null, "New document uuid {" + string + "} is already taken by a file and cannot be used: " + file.getAbsolutePath(), 2, null);
                    }
                    if (!file.exists()) break block4;
                    FilesKt.deleteRecursively((File)file);
                    break block5;
                }
                if (file.exists()) break block6;
            }
            Document document = this;
            document.a(() -> Document.a(document, file, bl, string));
            return;
        }
        throw new FileAlreadyExistsException(file, null, "New document uuid {" + string + "} is already taken as a directory name: " + file.getAbsolutePath() + ". Use 'overwrite = true' to replace it.", 2, null);
    }

    public Document(DocumentStorage object, PageFileStorage object2, FileIOProcessor object3, String string, int n) {
        Document document = this;
        this.a = object;
        this.b = object2;
        document.c = object3;
        object2 = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        document.d = object2;
        document.e = object2;
        long l = System.currentTimeMillis();
        object3 = CollectionsKt.emptyList();
        Uri uri = Uri.fromFile((File)object.getDocumentPdfFile(string));
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.fromFile(this)");
        String string2 = uri.getPath();
        if (string2 == null) {
            string2 = "";
        }
        Uri uri2 = Uri.fromFile((File)object.getDocumentTiffFile(string));
        Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"Uri.fromFile(this)");
        object = uri2.getPath();
        if (object == null) {
            object = "";
        }
        this.f = object2 = new DocumentData(string, l, (List<PageData>)object3, n, string2, (String)object);
    }

    /*
     * WARNING - void declaration
     */
    public Document(@NotNull DocumentStorage documentStorage, @NotNull PageFileStorage pageFileStorage, @NotNull FileIOProcessor fileIOProcessor) {
        void var3_3;
        void var2_2;
        void var1_1;
        Document document = this_;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentStorage");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"fileIOProcessor");
        String this_ = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)this_, (String)"toString(...)");
        document((DocumentStorage)var1_1, (PageFileStorage)var2_2, (FileIOProcessor)var3_3, this_, 0);
    }

    /*
     * WARNING - void declaration
     */
    public Document(@NotNull DocumentStorage documentStorage, @NotNull PageFileStorage pageFileStorage, @NotNull FileIOProcessor fileIOProcessor, int documentImageSizeLimit) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Document document = this_;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentStorage");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"fileIOProcessor");
        String this_ = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)this_, (String)"toString(...)");
        document((DocumentStorage)var1_1, (PageFileStorage)var2_2, (FileIOProcessor)var3_3, this_, (int)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    public Document(@NotNull DocumentStorage documentStorage, @NotNull PageFileStorage pageFileStorage, @NotNull FileIOProcessor fileIOProcessor, @NotNull String documentId, boolean createIfNotExist, int documentImageSizeLimit) {
        void var5_5;
        void var6_6;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Document document = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"documentStorage");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"fileIOProcessor");
        Intrinsics.checkNotNullParameter((Object)var4_4, (String)"documentId");
        document((DocumentStorage)var1_1, (PageFileStorage)var2_2, (FileIOProcessor)var3_3, (String)var4_4, (int)var6_6);
        document.loadSync((boolean)var5_5);
    }

    public /* synthetic */ Document(DocumentStorage documentStorage, PageFileStorage pageFileStorage, FileIOProcessor fileIOProcessor, String string, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        this(documentStorage, pageFileStorage, fileIOProcessor, string, bl, n);
    }

    public static /* synthetic */ Document loadSync$default(Document document, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return document.loadSync(bl);
    }

    public static /* synthetic */ Document duplicate$default(Document document, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = UUID.randomUUID().toString();
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return document.duplicate(string, bl);
    }

    public static final Unit a(Document document, long l) {
        document.f.setCreationTimestamp(l);
        return Unit.INSTANCE;
    }

    public static final Unit a(Document document, int n) {
        document.f.setDocumentImageSizeLimit(n);
        return Unit.INSTANCE;
    }

    public static final Page a(Document document, byte[] object) {
        Document document2 = document;
        byte[] byArray = object;
        Document document3 = document;
        object = document3.a();
        Page page = document2.b(document2.b.add$sdk_persistence_release(byArray, (PageStorageProcessor.Configuration)object, document3.f.getUuid()));
        object = page;
        MutableStateFlow mutableStateFlow = document.d;
        mutableStateFlow.setValue((Object)CollectionsKt.plus((Collection)((Collection)mutableStateFlow.getValue()), (Object)object));
        return page;
    }

    public static final Page a(Document document, Bitmap object) {
        Document document2 = document;
        Bitmap bitmap = object;
        Document document3 = document;
        object = document3.a();
        object = document2.b(document2.b.add$sdk_persistence_release(bitmap, (PageStorageProcessor.Configuration)object, document3.f.getUuid()));
        MutableStateFlow mutableStateFlow = document.d;
        mutableStateFlow.setValue((Object)CollectionsKt.plus((Collection)((Collection)mutableStateFlow.getValue()), (Object)object));
        return object;
    }

    public static final Page a(Document document, Uri object) {
        Document document2 = document;
        Uri uri = object;
        Document document3 = document;
        object = document3.a();
        object = document2.b(document2.b.add$sdk_persistence_release(uri, (PageStorageProcessor.Configuration)object, document3.f.getUuid()));
        MutableStateFlow mutableStateFlow = document.d;
        mutableStateFlow.setValue((Object)CollectionsKt.plus((Collection)((Collection)mutableStateFlow.getValue()), (Object)object));
        return object;
    }

    public static final Page a(Document document, PageData object) {
        object = document.b((PageData)object);
        MutableStateFlow mutableStateFlow = document.d;
        mutableStateFlow.setValue((Object)CollectionsKt.plus((Collection)((Collection)mutableStateFlow.getValue()), (Object)object));
        return object;
    }

    public static final Page a(Document document, byte[] object, int n) {
        Document document2 = document;
        byte[] byArray = object;
        Document document3 = document;
        object = document3.a();
        Page page = document2.b(document2.b.add$sdk_persistence_release(byArray, (PageStorageProcessor.Configuration)object, document3.f.getUuid()));
        object = page;
        MutableStateFlow mutableStateFlow = document.d;
        List list = CollectionsKt.toMutableList(document.getPages());
        list.add(n, object);
        mutableStateFlow.setValue((Object)list);
        return page;
    }

    public static final Page a(Document document, Bitmap object, int n) {
        Document document2 = document;
        Bitmap bitmap = object;
        Document document3 = document;
        object = document3.a();
        object = document2.b(document2.b.add$sdk_persistence_release(bitmap, (PageStorageProcessor.Configuration)object, document3.f.getUuid()));
        MutableStateFlow mutableStateFlow = document.d;
        List list = CollectionsKt.toMutableList(document.getPages());
        list.add(n, object);
        mutableStateFlow.setValue((Object)list);
        return object;
    }

    public static final boolean a(Document object, Page page) {
        ArrayList arrayList;
        Object object2 = object;
        object = ((Document)object).getUuid();
        boolean bl = ((Document)object2).b.remove$sdk_persistence_release(page.getUuid(), (String)object);
        MutableStateFlow mutableStateFlow = ((Document)object2).d;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        for (Object t : ((Document)object2).getPages()) {
            if (Intrinsics.areEqual((Object)((Page)t).getUuid(), (Object)page.getUuid())) continue;
            arrayList2.add(t);
        }
        mutableStateFlow.setValue(arrayList2);
        return bl;
    }

    public static final boolean b(Document object, int n) {
        ArrayList arrayList;
        Page page = (Page)CollectionsKt.getOrNull(((Document)object).getPages(), (int)n);
        if (page == null) {
            return false;
        }
        Object object2 = object;
        object = ((Document)object).getUuid();
        boolean bl = ((Document)object2).b.remove$sdk_persistence_release(page.getUuid(), (String)object);
        page = ((Document)object2).d;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        int n2 = 0;
        for (Object t : ((Document)object2).getPages()) {
            int n3 = n2 + 1;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Page cfr_ignored_0 = (Page)t;
            if (n2 != n) {
                arrayList2.add(t);
            }
            n2 = n3;
        }
        page.setValue(arrayList2);
        return bl;
    }

    public static final boolean b(Document object, String string) {
        ArrayList arrayList;
        ArrayList arrayList2;
        block3: {
            for (Object t : ((Document)object).getPages()) {
                arrayList2 = (ArrayList)t;
                if (!Intrinsics.areEqual((Object)((Page)t).getUuid(), (Object)string)) continue;
                break block3;
            }
            arrayList2 = null;
        }
        Object object2 = (Page)((Object)arrayList2);
        if (object2 == null) {
            return false;
        }
        Object object3 = object;
        object = ((Document)object).getUuid();
        boolean bl = ((Document)object3).b.remove$sdk_persistence_release(((Page)object2).getUuid(), (String)object);
        object2 = ((Document)object3).d;
        arrayList2 = arrayList;
        arrayList = new ArrayList();
        for (Object t : ((Document)object3).getPages()) {
            if (Intrinsics.areEqual((Object)((Page)t).getUuid(), (Object)string)) continue;
            arrayList2.add(t);
        }
        object2.setValue(arrayList2);
        return bl;
    }

    public static final Unit a(Document document) {
        Document document2 = document;
        document2.b.removeAll$sdk_persistence_release(document.getUuid());
        document2.d.setValue((Object)CollectionsKt.emptyList());
        return Unit.INSTANCE;
    }

    public static final boolean a(int n, int n2, Document document) {
        if (n == n2) {
            return false;
        }
        Page page = (Page)CollectionsKt.getOrNull(document.getPages(), (int)n);
        if (page == null) {
            return false;
        }
        MutableStateFlow mutableStateFlow = document.d;
        List list = CollectionsKt.toMutableList(document.getPages());
        list.remove(n);
        list.add(n2, page);
        mutableStateFlow.setValue((Object)list);
        return true;
    }

    public static final Unit b(Document document) {
        document.b();
        return Unit.INSTANCE;
    }

    public static final Document a(Document document, boolean bl) {
        Object object = document.a.getDocumentJsonFile(document.f.getUuid());
        if (!((File)object).exists()) {
            if (bl) {
                document.b();
            } else {
                document = null;
            }
        } else {
            ArrayList<Page> arrayList;
            DocumentData documentData;
            DocumentData documentData2;
            DocumentData documentData3 = documentData2 = documentData;
            documentData3(new JSONObject(FilesKt.readText$default((File)object, null, (int)1, null)));
            document.f = documentData3;
            documentData2 = document.d;
            object = documentData.getPages();
            ArrayList<Page> arrayList2 = arrayList;
            arrayList = new ArrayList<Page>(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            object = object.iterator();
            while (object.hasNext()) {
                arrayList2.add(document.b((PageData)object.next()));
            }
            documentData2.setValue(arrayList2);
        }
        return document;
    }

    public static final Unit a(Document document, File file, boolean bl, String string) {
        if (document.c.getUseEncryption()) {
            Document document2 = document;
            File file2 = file;
            file = document.c;
            Document.a(document2.a.getDocumentDir(document.getUuid()), file2, bl, SetsKt.setOf((Object)"json"), (FileIOProcessor)file);
            document2.a.delete(document.getUuid());
            document2.f.setUuid(string);
        } else {
            Document document3 = document;
            document3.a.getDocumentDir(document.getUuid()).renameTo(file);
            document3.f.setUuid(string);
        }
        return Unit.INSTANCE;
    }

    public static final Unit a(Document document, String string) {
        document.f.setUuid(string);
        return Unit.INSTANCE;
    }

    public static final JSONObject c(Document document) {
        return DocumentData.toJson$default(document.f, null, 1, null);
    }

    public static final Object a(Function0 function0, Document document) {
        Object object = function0.invoke();
        document.b();
        return object;
    }

    public static final Unit a(Function2 function2, File file, IOException iOException) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"f");
        Intrinsics.checkNotNullParameter((Object)iOException, (String)"e");
        if (function2.invoke((Object)file, (Object)iOException) != OnErrorAction.TERMINATE) {
            return Unit.INSTANCE;
        }
        throw iOException;
    }

    public static final /* synthetic */ Mutex access$getMutex$cp() {
        return g;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object access$processAndSave(Document $this, Function0 action) {
        void var1_1;
        return $this.a((Function0)var1_1);
    }

    public static final /* synthetic */ int access$getDEFAULT_DOCUMENT_IMAGE_SIZE_LIMIT$cp() {
        return 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean a(File var0, File var1_1, boolean var2_2, Set var3_3, FileIOProcessor var4_4) {
        var5_5 = io.scanbot.sdk.scanbotsdkpersistence.a.a;
        if (!var0.exists()) {
            v0 = new NoSuchFileException(var0, null, "The source file doesn't exist.", 2, null);
            Intrinsics.checkNotNullParameter((Object)var0, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)v0, (String)"exception");
            throw v0;
        }
        try {
            var5_5 = FilesKt.walkTopDown((File)var0).onFail((Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, a(kotlin.jvm.functions.Function2 java.io.File java.io.IOException ), (Ljava/io/File;Ljava/io/IOException;)Lkotlin/Unit;)((Function2)var5_5)).iterator();
lbl9:
            // 4 sources

            while (true) {
                if (var5_5.hasNext() == false) return true;
                var6_6 = (File)var5_5.next();
                break;
            }
        }
        catch (IOException v1) {
            return false;
        }
        {
            if (!var6_6.exists()) ** GOTO lbl-1000
            var7_7 = FilesKt.toRelativeString((File)var6_6, (File)var0);
        }
        var8_8 = v2;
        {
            if (!new File(var1_1, var7_7).exists() || var6_6.isDirectory() && var8_8.isDirectory() || var2_2 && (var8_8.isDirectory() != false ? FilesKt.deleteRecursively((File)var8_8) != false : var8_8.delete() != false)) ** GOTO lbl23
        }
        {
            v3 = new FileAlreadyExistsException(var6_6, var8_8, "The destination file already exists.");
            Intrinsics.checkNotNullParameter((Object)var8_8, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)v3, (String)"exception");
            throw v3;
lbl23:
            // 1 sources

            if (!var6_6.isDirectory()) ** GOTO lbl-1000
            var8_8.mkdirs();
        }
        ** GOTO lbl9
lbl-1000:
        // 1 sources

        {
            if (!var3_3.contains(FilesKt.getExtension((File)var6_6))) ** GOTO lbl33
            if (FilesKt.copyTo$default((File)var6_6, (File)var8_8, (boolean)var2_2, (int)0, (int)4, null).length() == var6_6.length()) ** GOTO lbl9
        }
        {
            v4 = new IOException("Source file wasn't copied completely, length of destination file differs.");
            Intrinsics.checkNotNullParameter((Object)var6_6, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)v4, (String)"exception");
            throw v4;
lbl33:
            // 1 sources

            var4_4.copy(var6_6, var8_8);
            ** continue;
        }
lbl-1000:
        // 1 sources

        {
            v5 = new NoSuchFileException(var6_6, null, "The source file doesn't exist.", 2, null);
            Intrinsics.checkNotNullParameter((Object)var6_6, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)v5, (String)"exception");
            throw v5;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001R\u001a\u0010\u0003\u001a\u00020\u00028\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/docprocessing/Document$Companion;", "", "", "DEFAULT_DOCUMENT_IMAGE_SIZE_LIMIT", "I", "getDEFAULT_DOCUMENT_IMAGE_SIZE_LIMIT", "()I", "sdk-persistence_release"}, xi=48)
    public static final class Companion {
        public Companion(DefaultConstructorMarker $constructor_marker) {
        }

        public final int getDEFAULT_DOCUMENT_IMAGE_SIZE_LIMIT() {
            return Document.access$getDEFAULT_DOCUMENT_IMAGE_SIZE_LIMIT$cp();
        }
    }
}

