/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.barcode.configuration;

import com.google.gson.Gson;
import io.scanbot.sdk.ui.configuration.json.GsonHelper;
import io.scanbot.sdk.ui.configuration.json.JsonBarcodeDialogFormat;
import io.scanbot.sdk.ui.configuration.json.JsonBarcodeImageGenerationType;
import io.scanbot.sdk.ui.configuration.json.JsonColor;
import io.scanbot.sdk.ui.configuration.json.JsonConfirmationDialogConfiguration;
import io.scanbot.sdk.ui.view.barcode.common.configuration.CommonBarcodeScannerConfiguration;
import io.scanbot.sdk.ui.view.barcode.configuration.BarcodeImageGenerationType;
import io.scanbot.sdk.ui.view.barcode.configuration.BarcodeScannerConfigurationParams;
import io.scanbot.sdk.ui.view.barcode.configuration.json.BarcodeJsonExtensionsKt;
import io.scanbot.sdk.ui.view.barcode.configuration.json.BarcodeScannerJsonConfiguration;
import io.scanbot.sdk.ui.view.barcode.dialog.BarcodeConfirmationDialogConfiguration;
import io.scanbot.sdk.ui.view.barcode.dialog.BarcodeDialogFormat;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000f\u00a8\u0006\u0013"}, d2={"Lio/scanbot/sdk/ui/view/barcode/configuration/BarcodeScannerConfiguration;", "Lio/scanbot/sdk/ui/view/barcode/common/configuration/CommonBarcodeScannerConfiguration;", "()V", "modifyFromJsonConfiguration", "", "jsonConfig", "Lio/scanbot/sdk/ui/view/barcode/configuration/json/BarcodeScannerJsonConfiguration;", "setBarcodeImageGenerationType", "imageType", "Lio/scanbot/sdk/ui/view/barcode/configuration/BarcodeImageGenerationType;", "setConfirmationDialogConfiguration", "configuration", "Lio/scanbot/sdk/ui/view/barcode/dialog/BarcodeConfirmationDialogConfiguration;", "setDelayAfterFocusCompleteMs", "delay", "", "setDelayAfterScanMs", "milliseconds", "Companion", "rtu-ui-barcode_release"})
public final class BarcodeScannerConfiguration
extends CommonBarcodeScannerConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void setDelayAfterFocusCompleteMs(long delay) {
        Long l = delay;
        this.getScanningConfiguration().put(BarcodeScannerConfigurationParams.DELAY_AFTER_FOCUS_COMPLETE_MS.getKey(), l);
    }

    public final void setDelayAfterScanMs(long milliseconds) {
        Long l = milliseconds;
        this.getScanningConfiguration().put(BarcodeScannerConfigurationParams.DELAY_AFTER_SCAN.getKey(), l);
    }

    public final void setBarcodeImageGenerationType(@NotNull BarcodeImageGenerationType imageType) {
        Intrinsics.checkNotNullParameter((Object)((Object)imageType), (String)"imageType");
        this.getScanningConfiguration().put(BarcodeScannerConfigurationParams.BARCODE_IMAGE_GENERATION_TYPE.getKey(), (Serializable)((Object)imageType));
    }

    public final void setConfirmationDialogConfiguration(@NotNull BarcodeConfirmationDialogConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.getScanningConfiguration().put(BarcodeScannerConfigurationParams.BARCODE_CONFIRMATION_DIALOG_CONFIGURATION.getKey(), configuration);
    }

    @Override
    public void modifyFromJsonConfiguration(@NotNull BarcodeScannerJsonConfiguration jsonConfig) {
        block6: {
            BarcodeDialogFormat barcodeDialogFormat;
            Intrinsics.checkNotNullParameter((Object)jsonConfig, (String)"jsonConfig");
            super.modifyFromJsonConfiguration(jsonConfig);
            JsonBarcodeImageGenerationType jsonBarcodeImageGenerationType = jsonConfig.getBarcodeImageGenerationType();
            if (jsonBarcodeImageGenerationType != null) {
                JsonBarcodeImageGenerationType it = jsonBarcodeImageGenerationType;
                boolean bl = false;
                this.setBarcodeImageGenerationType(BarcodeJsonExtensionsKt.toSdk(it));
            }
            Double d = jsonConfig.getDelayAfterScan();
            if (d != null) {
                double it = ((Number)d).doubleValue();
                boolean bl = false;
                this.setDelayAfterScanMs((long)(it * (double)1000));
            }
            JsonConfirmationDialogConfiguration jsonConfirmationDialogConfiguration = jsonConfig.getConfirmationDialogConfiguration();
            if (jsonConfirmationDialogConfiguration == null) break block6;
            JsonConfirmationDialogConfiguration it = jsonConfirmationDialogConfiguration;
            boolean bl = false;
            Boolean bl2 = it.getResultWithConfirmationEnabled();
            boolean bl3 = bl2 != null ? bl2 : false;
            String string2 = it.getDialogTitle();
            String string3 = it.getDialogMessage();
            String string4 = it.getConfirmButtonTitle();
            String string5 = it.getRetryButtonTitle();
            JsonColor jsonColor = it.getDialogButtonsAccentColor();
            Integer n = jsonColor != null ? Integer.valueOf(jsonColor.toSdk()) : null;
            Boolean bl4 = it.getConfirmButtonFilled();
            boolean bl5 = bl4 != null ? bl4 : false;
            JsonColor jsonColor2 = it.getConfirmButtonFilledTextColor();
            Integer n2 = jsonColor2 != null ? Integer.valueOf(jsonColor2.toSdk()) : null;
            JsonBarcodeDialogFormat jsonBarcodeDialogFormat = it.getDialogTextFormat();
            switch (jsonBarcodeDialogFormat == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonBarcodeDialogFormat.ordinal()]) {
                case 1: {
                    barcodeDialogFormat = BarcodeDialogFormat.CODE;
                    break;
                }
                case 2: {
                    barcodeDialogFormat = BarcodeDialogFormat.TYPE_AND_CODE;
                    break;
                }
                default: {
                    barcodeDialogFormat = BarcodeDialogFormat.TYPE_AND_CODE;
                }
            }
            this.setConfirmationDialogConfiguration(new BarcodeConfirmationDialogConfiguration(bl3, string2, string3, string4, string5, n, bl5, n2, barcodeDialogFormat));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/scanbot/sdk/ui/view/barcode/configuration/BarcodeScannerConfiguration$Companion;", "", "()V", "fromJson", "Lio/scanbot/sdk/ui/view/barcode/configuration/BarcodeScannerConfiguration;", "input", "", "rtu-ui-barcode_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BarcodeScannerConfiguration fromJson(@NotNull String input) {
            BarcodeScannerConfiguration barcodeScannerConfiguration;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Gson gson = GsonHelper.INSTANCE.prepareGson();
            BarcodeScannerJsonConfiguration jsonConfig = (BarcodeScannerJsonConfiguration)gson.fromJson(input, BarcodeScannerJsonConfiguration.class);
            BarcodeScannerConfiguration $this$fromJson_u24lambda_u2d0 = barcodeScannerConfiguration = new BarcodeScannerConfiguration();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)jsonConfig, (String)"jsonConfig");
            $this$fromJson_u24lambda_u2d0.modifyFromJsonConfiguration(jsonConfig);
            return barcodeScannerConfiguration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonBarcodeDialogFormat.values().length];
            nArray[JsonBarcodeDialogFormat.CODE.ordinal()] = 1;
            nArray[JsonBarcodeDialogFormat.TYPE_AND_CODE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

