/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.PerformanceHintManager;
import android.preference.PreferenceManager;
import android.util.Log;
import io.scanbot.common.util.NativeLogger;
import io.scanbot.common.util.PerformanceHintSessionAdapter;
import io.scanbot.common.util.TensorFlowUtils;
import io.scanbot.sap.IScanbotSDKLicenseErrorHandler;
import io.scanbot.sap.SDKLicenseErrorHandler;
import io.scanbot.sdk.Initializable;
import io.scanbot.sdk.SDKLicenseErrorHandlerImpl;
import io.scanbot.sdk.ScanbotSDK;
import io.scanbot.sdk.ScanbotSdkInitializerCommonApi;
import io.scanbot.sdk.SdkInitializer;
import io.scanbot.sdk.blob.BlobFactory;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.blob.BlobType;
import io.scanbot.sdk.di.ScanbotSdkModule;
import io.scanbot.sdk.di.SdkStorageModule;
import io.scanbot.sdk.docprocessing.draft.DocumentDraftExtractor;
import io.scanbot.sdk.documentscanner.DocumentScannerEngineMode;
import io.scanbot.sdk.entity.Blob;
import io.scanbot.sdk.image.ImageRef;
import io.scanbot.sdk.licensing.LicenseInfo;
import io.scanbot.sdk.ocr.intelligence.OcrSettings;
import io.scanbot.sdk.pdf.PdfImagesExtractor;
import io.scanbot.sdk.pdf.PdfImagesExtractorSettings;
import io.scanbot.sdk.persistence.FileStorageSettings;
import io.scanbot.sdk.persistence.fileio.CoreStreamProvider;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.persistence.page.PageStorageSettings;
import io.scanbot.sdk.security.SapSingleton;
import io.scanbot.sdk.util.log.DebugLog;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk.util.log.StubLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 E2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0002EFB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\nJ\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u0016\u0010/\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\b\u00101\u001a\u00020!H\u0002J\u0010\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u00102\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.2\u0006\u00102\u001a\u000200J\u000e\u00103\u001a\u00020\u00002\u0006\u0010*\u001a\u000204J\u0016\u0010\u001e\u001a\u00020\u00002\u000e\b\u0002\u00105\u001a\b\u0012\u0004\u0012\u00020!0 J\u0010\u00106\u001a\u00020!2\u0006\u0010-\u001a\u00020.H\u0002J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0005J\u0010\u00107\u001a\u00020!2\u0006\u0010-\u001a\u00020.H\u0002J\u0016\u00108\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.2\u0006\u00108\u001a\u000209J\u0010\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\u0005H\u0016J\u001a\u0010<\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u00052\n\b\u0002\u0010>\u001a\u0004\u0018\u00010?J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020CJ\u0018\u0010D\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006G"}, d2={"Lio/scanbot/sdk/ScanbotSDKInitializer;", "Lio/scanbot/sdk/SdkInitializer;", "Lio/scanbot/sdk/ScanbotSdkInitializerCommonApi;", "()V", "allowGpuAcceleration", "", "allowXnnpackAcceleration", "documentDraftExtractor", "Lio/scanbot/sdk/docprocessing/draft/DocumentDraftExtractor;", "documentScannerEngineMode", "Lio/scanbot/sdk/documentscanner/DocumentScannerEngineMode;", "enableNativeLogging", "enablePerformanceHintApi", "fileStorageSettings", "Lio/scanbot/sdk/persistence/FileStorageSettings;", "licenseErrorHandler", "Lio/scanbot/sap/IScanbotSDKLicenseErrorHandler;", "licenseSet", "logger", "Lio/scanbot/sdk/util/log/Logger;", "getLogger", "()Lio/scanbot/sdk/util/log/Logger;", "setLogger", "(Lio/scanbot/sdk/util/log/Logger;)V", "mainScope", "Lkotlinx/coroutines/CoroutineScope;", "ocrSettings", "Lio/scanbot/sdk/ocr/intelligence/OcrSettings;", "pdfImagesExtractorSettings", "Lio/scanbot/sdk/pdf/PdfImagesExtractorSettings;", "precompileGpuMlModels", "precompilingGpuMlModelsCallback", "Lkotlin/Function0;", "", "prepareOCRLanguagesBlobs", "useLog", "getUseLog", "()Z", "setUseLog", "(Z)V", "enable", "extractor", "type", "initialize", "Lio/scanbot/sdk/licensing/LicenseInfo;", "application", "Landroid/app/Application;", "license", "", "loadNativeLibraries", "ocrBlobsPath", "pdfImagesExtractorType", "Lio/scanbot/sdk/pdf/PdfImagesExtractor$Type;", "precompilingCallback", "prepareBlobs", "prepareTensorFlow", "sdkFilesDirectory", "Ljava/io/File;", "setPerformanceHintApiEnabled", "enabled", "useFileEncryption", "enableFileEncryption", "fileIOProcessor", "Lio/scanbot/sdk/persistence/fileio/FileIOProcessor;", "useOcrSettings", "usePageStorageSettings", "pageStorageSettings", "Lio/scanbot/sdk/persistence/page/PageStorageSettings;", "withLogging", "Companion", "PrepareBlobsTask", "sdk-bundle_release"})
@SourceDebugExtension(value={"SMAP\nScanbotSDKInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScanbotSDKInitializer.kt\nio/scanbot/sdk/ScanbotSDKInitializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,401:1\n1#2:402\n*E\n"})
public final class ScanbotSDKInitializer
implements SdkInitializer,
ScanbotSdkInitializerCommonApi<ScanbotSDKInitializer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static boolean initialized;
    @NotNull
    private static final ExecutorCoroutineDispatcher singleThreadDispatcher;
    private boolean enableNativeLogging;
    private boolean useLog;
    @Nullable
    private Logger logger;
    private boolean licenseSet;
    private boolean prepareOCRLanguagesBlobs;
    private boolean allowXnnpackAcceleration = true;
    private boolean allowGpuAcceleration = true;
    private boolean enablePerformanceHintApi = true;
    private boolean precompileGpuMlModels;
    private Function0<Unit> precompilingGpuMlModelsCallback;
    @Nullable
    private DocumentScannerEngineMode documentScannerEngineMode;
    @NotNull
    private OcrSettings ocrSettings = new OcrSettings.Builder().build();
    @Nullable
    private IScanbotSDKLicenseErrorHandler licenseErrorHandler;
    @Nullable
    private DocumentDraftExtractor documentDraftExtractor;
    @NotNull
    private PdfImagesExtractorSettings pdfImagesExtractorSettings = new PdfImagesExtractorSettings(PdfImagesExtractor.Type.ANDROID_PDF_WRITER);
    @NotNull
    private FileStorageSettings fileStorageSettings = new FileStorageSettings.Builder().useFileEncryption(false).build();
    @NotNull
    private final CoroutineScope mainScope = CoroutineScopeKt.MainScope();

    public static /* synthetic */ ScanbotSDKInitializer useFileEncryption$default(ScanbotSDKInitializer scanbotSDKInitializer, boolean bl, FileIOProcessor fileIOProcessor, int n, Object object) {
        if ((n & 2) != 0) {
            fileIOProcessor = null;
        }
        return scanbotSDKInitializer.useFileEncryption(bl, fileIOProcessor);
    }

    public static /* synthetic */ ScanbotSDKInitializer precompileGpuMlModels$default(ScanbotSDKInitializer scanbotSDKInitializer, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = a.a;
        }
        return scanbotSDKInitializer.precompileGpuMlModels((Function0<Unit>)function0);
    }

    private final void loadNativeLibraries() {
        System.loadLibrary("tflite");
        System.loadLibrary("scanbotsdk");
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareBlobs(Application application) {
        void var1_1;
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (Application)var1_1, null){
            int a;
            final /* synthetic */ ScanbotSDKInitializer b;
            final /* synthetic */ Application c;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.b = var1_1;
                this.c = var2_2;
                super(2, (Continuation)var3_3);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                if (object2.a == 0) {
                    ResultKt.throwOnFailure((Object)object);
                    b b2 = object2;
                    Object object2 = b2.b;
                    new PrepareBlobsTask((ScanbotSDKInitializer)object2, b2.c).prepareBlobs();
                    return Unit.INSTANCE;
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                void var2_2;
                var b2 = object;
                Object object = b2.b;
                return new /* invalid duplicate definition of identical inner class */;
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object a(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                void var2_2;
                void var1_1;
                return (this.create(var1_1, (Continuation<?>)var2_2)).invokeSuspend(Unit.INSTANCE);
            }
        };
        BuildersKt.launch$default((CoroutineScope)this.mainScope, (CoroutineContext)singleThreadDispatcher, null, (Function2)function22, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareTensorFlow(Application application) {
        ScanbotSDKInitializer scanbotSDKInitializer = this;
        boolean bl = scanbotSDKInitializer.allowXnnpackAcceleration;
        TensorFlowUtils.Companion.prepareTensorFlow(bl, scanbotSDKInitializer.allowGpuAcceleration);
        if (this.precompileGpuMlModels) {
            void var1_1;
            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
            Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
            function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Application)var1_1, this, null){
                int a;
                final /* synthetic */ Application b;
                final /* synthetic */ ScanbotSDKInitializer c;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.b = var1_1;
                    this.c = var2_2;
                    super(2, (Continuation)var3_3);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    int n = this.a;
                    if (n != 0) {
                        if (n != 1) throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        ResultKt.throwOnFailure((Object)object);
                        return Unit.INSTANCE;
                    } else {
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2;
                        ResultKt.throwOnFailure((Object)object);
                        String string = this.b.getCodeCacheDir().getAbsolutePath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                        TensorFlowUtils.Companion.precompilePrograms(string);
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
                        function2 = new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.c, null){
                            int a;
                            final /* synthetic */ ScanbotSDKInitializer b;
                            {
                                void var2_2;
                                void var1_1;
                                this.b = var1_1;
                                super(2, (Continuation)var2_2);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                if (a2.a == 0) {
                                    ResultKt.throwOnFailure((Object)object);
                                    a a2 = a2.b.precompilingGpuMlModelsCallback;
                                    if (a2 == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"precompilingGpuMlModelsCallback");
                                        a2 = null;
                                    }
                                    a2.invoke();
                                    return Unit.INSTANCE;
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                void var2_2;
                                return new /* invalid duplicate definition of identical inner class */;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Nullable
                            public final Object a(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                void var2_2;
                                void var1_1;
                                return (this.create(var1_1, (Continuation<?>)var2_2)).invokeSuspend(Unit.INSTANCE);
                            }
                        };
                        this.a = 1;
                        if (BuildersKt.withContext((CoroutineContext)Dispatchers.getMain(), (Function2)function22, (Continuation)this) != object2) return Unit.INSTANCE;
                        return object2;
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    void var2_2;
                    var c2 = c3;
                    c c3 = c2.b;
                    return new /* invalid duplicate definition of identical inner class */;
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final Object a(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    void var2_2;
                    void var1_1;
                    return (this.create(var1_1, (Continuation<?>)var2_2)).invokeSuspend(Unit.INSTANCE);
                }
            };
            BuildersKt.launch$default((CoroutineScope)this.mainScope, (CoroutineContext)singleThreadDispatcher, null, (Function2)function22, (int)2, null);
        }
    }

    @JvmStatic
    public static boolean isInitialized() {
        return Companion.isInitialized();
    }

    static {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
        singleThreadDispatcher = ExecutorsKt.from((ExecutorService)executorService);
    }

    protected final boolean getUseLog() {
        return this.useLog;
    }

    /*
     * WARNING - void declaration
     */
    protected final void setUseLog(boolean bl) {
        void var1_1;
        this.useLog = var1_1;
    }

    @Nullable
    protected final Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    protected final void setLogger(@Nullable Logger logger) {
        void var1_1;
        this.logger = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ScanbotSDKInitializer withLogging(boolean useLog, boolean enableNativeLogging) {
        void var2_3;
        void var1_1;
        if (useLog) {
            Log.w((String)"Scanbot SDK", (String)"Logging enabled in non-debug build, consider switching it off");
        }
        ScanbotSDKInitializer scanbotSDKInitializer = this;
        scanbotSDKInitializer.useLog = var1_1;
        scanbotSDKInitializer.enableNativeLogging = var2_3;
        if (var1_1 == false) {
            StubLogger stubLogger;
            StubLogger stubLogger2 = stubLogger;
            stubLogger = new StubLogger();
            this.logger = stubLogger2;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer license(@NotNull Application application, @NotNull String license) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"application");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"license");
        PreferenceManager.getDefaultSharedPreferences((Context)var1_1).edit().putString("SCANBOT_SDK_LICENSE_KEY", (String)var2_2).apply();
        this.licenseSet = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer licenseErrorHandler(@NotNull IScanbotSDKLicenseErrorHandler licenseErrorHandler) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"licenseErrorHandler");
        this.licenseErrorHandler = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer ocrBlobsPath(@NotNull Application application, @NotNull String ocrBlobsPath) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"application");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"ocrBlobsPath");
        PreferenceManager.getDefaultSharedPreferences((Context)var1_1).edit().putString("SCANBOT_SDK_OCR_BLOBS_PATH", (String)var2_2).apply();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer prepareOCRLanguagesBlobs(boolean prepareOCRLanguagesBlobs) {
        void var1_1;
        this.prepareOCRLanguagesBlobs = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer useOcrSettings(@NotNull OcrSettings ocrSettings) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"ocrSettings");
        this.ocrSettings = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer documentScannerEngineMode(@NotNull DocumentScannerEngineMode type) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"type");
        this.documentScannerEngineMode = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer useFileEncryption(boolean enableFileEncryption, @Nullable FileIOProcessor fileIOProcessor) {
        void var1_1;
        FileStorageSettings.Builder builder = new FileStorageSettings.Builder().useFileEncryption((boolean)var1_1);
        if (fileIOProcessor != null) {
            void var2_3;
            builder.useCustomFileIOProcessor((FileIOProcessor)var2_3);
        }
        ScanbotSDKInitializer scanbotSDKInitializer = scanbotSDKInitializer2;
        ScanbotSDKInitializer scanbotSDKInitializer2 = builder.build();
        scanbotSDKInitializer.fileStorageSettings = scanbotSDKInitializer2;
        SdkStorageModule.Companion.setFileStorageSettings((FileStorageSettings)scanbotSDKInitializer2);
        return scanbotSDKInitializer;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer allowXnnpackAcceleration(boolean enable) {
        void var1_1;
        this.allowXnnpackAcceleration = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer allowGpuAcceleration(boolean enable) {
        void var1_1;
        this.allowGpuAcceleration = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer precompileGpuMlModels(@NotNull Function0<Unit> precompilingCallback) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"precompilingCallback");
        this.precompilingGpuMlModelsCallback = var1_1;
        this.precompileGpuMlModels = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer pdfImagesExtractorType(@NotNull PdfImagesExtractor.Type type) {
        void var1_1;
        ScanbotSDKInitializer scanbotSDKInitializer = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"type");
        scanbotSDKInitializer.pdfImagesExtractorSettings = scanbotSDKInitializer.pdfImagesExtractorSettings.copy((PdfImagesExtractor.Type)var1_1);
        return scanbotSDKInitializer;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public LicenseInfo initialize(@NotNull Application application) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"application");
        Logger logger = this_.logger;
        if (logger == null) {
            if (this_.useLog) {
                DebugLog debugLog;
                logger = debugLog;
                debugLog = new DebugLog((Context)var1_1);
            } else {
                StubLogger stubLogger;
                logger = stubLogger;
                stubLogger = new StubLogger();
            }
        }
        LoggerProvider.setLogger((Logger)logger);
        if (!this_.licenseSet) {
            PreferenceManager.getDefaultSharedPreferences((Context)var1_1).edit().remove("SCANBOT_SDK_LICENSE_KEY").apply();
        }
        ScanbotSDKInitializer scanbotSDKInitializer = this_;
        scanbotSDKInitializer.loadNativeLibraries();
        logger = LoggerProvider.getLogger();
        if (scanbotSDKInitializer.enableNativeLogging) {
            NativeLogger.setNativeLogger((Logger)logger);
        }
        Logger logger2 = logger;
        SapSingleton.initializeSapManager((Context)var1_1);
        Object object = SapSingleton.getInstance();
        object.setLicenseErrorHandler((SDKLicenseErrorHandler)new SDKLicenseErrorHandlerImpl(this_.licenseErrorHandler, logger));
        initialized = true;
        this_.prepareBlobs((Application)var1_1);
        this_.prepareTensorFlow((Application)var1_1);
        logger = object.getLicenseInfo();
        logger2.i("ScanbotSDKInitializer", logger.getLicenseStatusMessage());
        if (this_.enablePerformanceHintApi && Build.VERSION.SDK_INT >= 31) {
            object = PerformanceHintSessionAdapter.Companion;
            Object object2 = var1_1.getSystemService("performance_hint");
            object2 = object2 instanceof PerformanceHintManager ? (PerformanceHintManager)object2 : null;
            object.setPerformanceHintManager((PerformanceHintManager)object2);
        }
        object = ScanbotSdkModule.Companion;
        ((ScanbotSdkModule.Companion)object).setDocumentDraftExtractor(this_.documentDraftExtractor);
        ((ScanbotSdkModule.Companion)object).setOcrSettings(this_.ocrSettings);
        ((ScanbotSdkModule.Companion)object).setDocumentScannerEngineMode(this_.documentScannerEngineMode);
        ((ScanbotSdkModule.Companion)object).setPdfImagesExtractorSettings(this_.pdfImagesExtractorSettings);
        ScanbotSDKInitializer this_ = new ScanbotSDK((Application)var1_1).fileIOProcessor();
        if (this_.getUseEncryption()) {
            ImageRef.CREATOR.setStorageCryptingProvider((CoreStreamProvider)this_);
        }
        return logger;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer documentDraftExtractor(@NotNull DocumentDraftExtractor extractor) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"extractor");
        this.documentDraftExtractor = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer sdkFilesDirectory(@NotNull Application application, @NotNull File sdkFilesDirectory) {
        void var2_2;
        void var1_1;
        File file = sdkFilesDirectory;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"application");
        Intrinsics.checkNotNullParameter((Object)file, (String)"sdkFilesDirectory");
        if (!file.exists() && !var2_2.mkdirs()) {
            throw new IOException("Can't create custom SDK files directory, please provide the absolute path by using either the File(getFilesDir(), \"custom_dir/path\") or File(getExternalFilesDir(null), \"custom_dir/path\"");
        }
        PreferenceManager.getDefaultSharedPreferences((Context)var1_1).edit().putString("CUSTOM_SDK_FILES_PATH", var2_2.getPath()).apply();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ScanbotSDKInitializer logger(@NotNull Logger logger) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"logger");
        this.logger = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ScanbotSDKInitializer setPerformanceHintApiEnabled(boolean enabled) {
        void var1_1;
        this.enablePerformanceHintApi = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ScanbotSDKInitializer usePageStorageSettings(@NotNull PageStorageSettings pageStorageSettings) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"pageStorageSettings");
        SdkStorageModule.Companion.setPageStorageSettings((PageStorageSettings)var1_1);
        return this;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/scanbot/sdk/ScanbotSDKInitializer$Companion;", "Lio/scanbot/sdk/Initializable;", "()V", "initialized", "", "singleThreadDispatcher", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "isInitialized", "sdk-bundle_release"})
    public static final class Companion
    implements Initializable {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @JvmStatic
        public boolean isInitialized() {
            return initialized;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0082\bJ\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J.\u0010\u0011\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J&\u0010\u0011\u001a\u00020\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u001c\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lio/scanbot/sdk/ScanbotSDKInitializer$PrepareBlobsTask;", "", "application", "Landroid/app/Application;", "(Lio/scanbot/sdk/ScanbotSDKInitializer;Landroid/app/Application;)V", "getApplication", "()Landroid/app/Application;", "cleanupBlob", "", "blobLazySafeGetter", "Lkotlin/Function0;", "Ljava/io/File;", "isDirectory", "", "cleanupDeprecatedBlobs", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "fetchBlobs", "types", "", "Lio/scanbot/sdk/blob/BlobType;", "blobFactory", "Lio/scanbot/sdk/blob/BlobFactory;", "logger", "Lio/scanbot/sdk/util/log/Logger;", "blobs", "", "Lio/scanbot/sdk/entity/Blob;", "prepareBlobs", "sdk-bundle_release"})
    @SourceDebugExtension(value={"SMAP\nScanbotSDKInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScanbotSDKInitializer.kt\nio/scanbot/sdk/ScanbotSDKInitializer$PrepareBlobsTask\n*L\n1#1,401:1\n383#1,16:402\n383#1,16:418\n383#1,16:434\n383#1,16:450\n383#1,16:466\n383#1,16:482\n383#1,16:498\n383#1,16:514\n383#1,16:530\n383#1,16:546\n383#1,16:562\n383#1,16:578\n383#1,16:594\n*S KotlinDebug\n*F\n+ 1 ScanbotSDKInitializer.kt\nio/scanbot/sdk/ScanbotSDKInitializer$PrepareBlobsTask\n*L\n366#1:402,16\n367#1:418,16\n368#1:434,16\n369#1:450,16\n370#1:466,16\n371#1:482,16\n372#1:498,16\n373#1:514,16\n374#1:530,16\n375#1:546,16\n376#1:562,16\n377#1:578,16\n378#1:594,16\n*E\n"})
    public final class PrepareBlobsTask {
        @NotNull
        private final Application application;
        final /* synthetic */ ScanbotSDKInitializer this$0;

        /*
         * WARNING - void declaration
         */
        public PrepareBlobsTask(@NotNull ScanbotSDKInitializer this$0, Application application) {
            void var1_1;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"application");
            this.this$0 = var1_1;
            this.application = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private final void fetchBlobs(List<? extends BlobType> types, BlobFactory blobFactory, BlobManager blobManager, Logger logger) {
            void var3_3;
            void var4_4;
            ArrayList<Blob> arrayList;
            ArrayList<Blob> arrayList2 = arrayList;
            arrayList = new ArrayList<Blob>();
            for (BlobType blobType : types) {
                try {
                    void var2_2;
                    arrayList2.addAll(var2_2.getBlobsForType(blobType));
                }
                catch (IOException iOException) {
                    var4_4.logException((Throwable)iOException);
                    var4_4.e("PrepareBlobsTask", "Could not fetch " + blobType + " blobs!");
                }
            }
            this.fetchBlobs(arrayList2, (BlobManager)var3_3, (Logger)var4_4);
        }

        /*
         * WARNING - void declaration
         */
        private final void fetchBlobs(Collection<Blob> blobs, BlobManager blobManager, Logger logger) {
            for (Blob blob : blobs) {
                try {
                    void var2_2;
                    var2_2.fetch(blob);
                }
                catch (IOException iOException) {
                    void var3_3;
                    var3_3.logException((Throwable)iOException);
                    var3_3.e("PrepareBlobsTask", "Could not fetch blob! /n Blob local path: " + blob.getLocalPath() + " /n Blob remote path: " + blob.getRemotePath());
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void cleanupDeprecatedBlobs(BlobManager blobManager) {
            void var1_1;
            try {
                blobManager.getDocumentDetectorModelFile().delete();
            }
            catch (IOException iOException) {}
            try {
                var1_1.getBarcodeBinarizationModelFile().delete();
            }
            catch (IOException iOException) {}
            try {
                var1_1.getFilterPredictionModelFile().delete();
            }
            catch (IOException iOException) {}
            try {
                var1_1.getBarcodeScanningModelFile().delete();
            }
            catch (IOException iOException) {}
            try {
                var1_1.getMrzCascadeFile().delete();
            }
            catch (IOException iOException) {}
            try {
                var1_1.getMrzTrainedDataFile().delete();
            }
            catch (IOException iOException) {}
            try {
                FilesKt.deleteRecursively((File)var1_1.getIdCardScannerModelsFolderFile());
            }
            catch (IOException iOException) {}
            try {
                FilesKt.deleteRecursively((File)var1_1.getTextPatternScannerModelsFolderFile());
            }
            catch (IOException iOException) {}
            try {
                FilesKt.deleteRecursively((File)var1_1.getDcModelsFolderFile());
            }
            catch (IOException iOException) {}
            try {
                var1_1.getBlurEstimatorModelFile().delete();
            }
            catch (IOException iOException) {}
            try {
                var1_1.getCheckDigitPredictionModelFile().delete();
            }
            catch (IOException iOException) {}
            try {
                var1_1.getBanksDataFile().delete();
            }
            catch (IOException iOException) {}
            try {
                FilesKt.deleteRecursively((File)var1_1.getImageProcessorModelsFolderFile());
            }
            catch (IOException iOException) {}
        }

        private final void cleanupBlob(Function0<? extends File> blobLazySafeGetter, boolean isDirectory) {
            File file;
            boolean $i$f$cleanupBlob = false;
            try {
                file = (File)blobLazySafeGetter.invoke();
            }
            catch (IOException e2) {
                return;
            }
            File blobFile = file;
            try {
                if (isDirectory) {
                    FilesKt.deleteRecursively((File)blobFile);
                } else {
                    blobFile.delete();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @NotNull
        public final Application getApplication() {
            return this.application;
        }

        public final void prepareBlobs() {
            ScanbotSDK scanbotSDK = new ScanbotSDK(this.application);
            BlobManager blobManager = scanbotSDK.createBlobManager();
            BlobFactory blobFactory = scanbotSDK.createBlobFactory();
            Logger logger = LoggerProvider.getLogger();
            if (this.this$0.prepareOCRLanguagesBlobs) {
                this.fetchBlobs(CollectionsKt.listOf((Object[])new BlobType[]{BlobType.OCR_BLOBS, BlobType.PDF_FONT}), blobFactory, blobManager, logger);
            }
            this.cleanupDeprecatedBlobs(blobManager);
        }
    }
}

