package org.jetbrains.dokka.base.parsers.factories

import org.jetbrains.dokka.model.doc.*
import org.jetbrains.dokka.links.DRI
import java.lang.NullPointerException

object DocTagsFromStringFactory {
    fun getInstance(name: String, children: List<DocTag> = emptyList(), params: Map<String, String> = emptyMap(), body: String? = null, dri: DRI? = null) =
        when(name) {
            "a" -> A(children, params)
            "big" -> Big(children, params)
            "b" -> B(children, params)
            "blockquote" -> BlockQuote(children, params)
            "br" -> Br
            "cite" -> Cite(children, params)
            "code" -> if(params.isEmpty()) CodeInline(children, params) else CodeBlock(children, params)
            "dd" -> Dd(children, params)
            "dfn" -> Dfn(children, params)
            "dir" -> Dir(children, params)
            "div" -> Div(children, params)
            "dl" -> Dl(children, params)
            "dt" -> Dt(children, params)
            "Em" -> Em(children, params)
            "font" -> Font(children, params)
            "footer" -> Footer(children, params)
            "frame" -> Frame(children, params)
            "frameset" -> FrameSet(children, params)
            "h1" -> H1(children, params)
            "h2" -> H2(children, params)
            "h3" -> H3(children, params)
            "h4" -> H4(children, params)
            "h5" -> H5(children, params)
            "h6" -> H6(children, params)
            "head" -> Head(children, params)
            "header" -> Header(children, params)
            "html" -> Html(children, params)
            "i" -> I(children, params)
            "iframe" -> IFrame(children, params)
            "img" -> Img(children, params)
            "input" -> Input(children, params)
            "li" -> Li(children, params)
            "link" -> Link(children, params)
            "listing" -> Listing(children, params)
            "main" -> Main(children, params)
            "menu" -> Menu(children, params)
            "meta" -> Meta(children, params)
            "nav" -> Nav(children, params)
            "noframes" -> NoFrames(children, params)
            "noscript" -> NoScript(children, params)
            "ol" -> Ol(children, params)
            "p" -> P(children, params)
            "pre" -> Pre(children, params)
            "script" -> Script(children, params)
            "section" -> Section(children, params)
            "small" -> Small(children, params)
            "span" -> Span(children, params)
            "strong" -> Strong(children, params)
            "sub" -> Sub(children, params)
            "sup" -> Sup(children, params)
            "table" -> Table(children, params)
            "#text" -> Text(body ?: throw NullPointerException("Text body should be at least empty string passed to DocNodes factory!"), children, params)
            "tBody" -> TBody(children, params)
            "td" -> Td(children, params)
            "tFoot" -> TFoot(children, params)
            "th" -> Th(children, params)
            "tHead" -> THead(children, params)
            "title" -> Title(children, params)
            "tr" -> Tr(children, params)
            "tt" -> Tt(children, params)
            "u" -> U(children, params)
            "ul" -> Ul(children, params)
            "var" -> Var(children, params)
            "documentationlink" -> DocumentationLink(dri ?: throw NullPointerException("DRI cannot be passed null while constructing documentation link!"), children, params)
            "hr" -> HorizontalRule
            else -> CustomDocTag(children, params, name)
        }
}
