/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui_v2.di.components;

import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import coil.fetch.Fetcher;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import io.scanbot.sdk.docprocessing.DocumentApi;
import io.scanbot.sdk.persistence.document.DocumentStorage;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.persistence.page.PageFileStorage;
import io.scanbot.sdk.ui_v2.common.coroutines.IDispatchersProvider;
import io.scanbot.sdk.ui_v2.common.utils.ScanbotImageFetcherFactoryInjector;
import io.scanbot.sdk.ui_v2.common.utils.ScanbotImageFetcherFactoryInjector_MembersInjector;
import io.scanbot.sdk.ui_v2.common.utils.ScanbotImageUri;
import io.scanbot.sdk.ui_v2.common.viewmodel.ViewModelInjector;
import io.scanbot.sdk.ui_v2.common.viewmodel.ViewModelInjector_MembersInjector;
import io.scanbot.sdk.ui_v2.di.components.DocumentBaseComponent;
import io.scanbot.sdk.ui_v2.di.components.SDKUIComponent;
import io.scanbot.sdk.ui_v2.di.modules.DispatchersModule;
import io.scanbot.sdk.ui_v2.di.modules.DispatchersModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.DocumentBaseModule;
import io.scanbot.sdk.ui_v2.di.modules.DocumentBaseModule_ProvideDocumentScanningBaseViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.DocumentBaseModule_ProvideDocumentScanningFlow$rtu_ui_v2_bundle_releaseFactory;
import io.scanbot.sdk.ui_v2.di.modules.DocumentBaseModule_ProvideNativeConfiguration$rtu_ui_v2_bundle_releaseFactory;
import io.scanbot.sdk.ui_v2.di.modules.ImageFetcherFactoryModule;
import io.scanbot.sdk.ui_v2.di.modules.ImageFetcherFactoryModule_BindImageFetcherFactoryFactory;
import io.scanbot.sdk.ui_v2.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui_v2.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import io.scanbot.sdk.ui_v2.document.configuration.DocumentNativeConfiguration;
import io.scanbot.sdk.ui_v2.document.configuration.DocumentScanningFlow;
import io.scanbot.sdk.ui_v2.document.screen.DocumentScannerHostViewModel;
import java.util.Collections;
import java.util.Map;

@DaggerGenerated
public final class DaggerDocumentBaseComponent {
    private DaggerDocumentBaseComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DocumentBaseModule documentBaseModule;
        private ViewModelFactoryModule viewModelFactoryModule;
        private ImageFetcherFactoryModule imageFetcherFactoryModule;
        private DispatchersModule dispatchersModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder documentBaseModule(DocumentBaseModule documentBaseModule) {
            this.documentBaseModule = (DocumentBaseModule)Preconditions.checkNotNull((Object)documentBaseModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder imageFetcherFactoryModule(ImageFetcherFactoryModule imageFetcherFactoryModule) {
            this.imageFetcherFactoryModule = (ImageFetcherFactoryModule)Preconditions.checkNotNull((Object)imageFetcherFactoryModule);
            return this;
        }

        public Builder dispatchersModule(DispatchersModule dispatchersModule) {
            this.dispatchersModule = (DispatchersModule)Preconditions.checkNotNull((Object)dispatchersModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public DocumentBaseComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.documentBaseModule, DocumentBaseModule.class);
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            if (this.imageFetcherFactoryModule == null) {
                this.imageFetcherFactoryModule = new ImageFetcherFactoryModule();
            }
            if (this.dispatchersModule == null) {
                this.dispatchersModule = new DispatchersModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new DocumentBaseComponentImpl(this.documentBaseModule, this.viewModelFactoryModule, this.imageFetcherFactoryModule, this.dispatchersModule, this.sDKUIComponent);
        }
    }

    private static final class DocumentBaseComponentImpl
    implements DocumentBaseComponent {
        private final ViewModelFactoryModule viewModelFactoryModule;
        private final ImageFetcherFactoryModule imageFetcherFactoryModule;
        private final SDKUIComponent sDKUIComponent;
        private final DocumentBaseComponentImpl documentBaseComponentImpl = this;
        Provider<DocumentScanningFlow> provideDocumentScanningFlow$rtu_ui_v2_bundle_releaseProvider;
        Provider<DocumentNativeConfiguration> provideNativeConfiguration$rtu_ui_v2_bundle_releaseProvider;
        Provider<IDispatchersProvider> provideBarcodeCameraViewModelProvider;
        Provider<DocumentStorage> documentStorageProvider;
        Provider<PageFileStorage> pageFileStorageProvider;
        Provider<FileIOProcessor> fileIOProcessorProvider;
        Provider<DocumentApi> documentApiProvider;
        Provider<ViewModel> provideDocumentScanningBaseViewModelProvider;

        DocumentBaseComponentImpl(DocumentBaseModule documentBaseModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, ImageFetcherFactoryModule imageFetcherFactoryModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.viewModelFactoryModule = viewModelFactoryModuleParam;
            this.imageFetcherFactoryModule = imageFetcherFactoryModuleParam;
            this.sDKUIComponent = sDKUIComponentParam;
            this.initialize(documentBaseModuleParam, viewModelFactoryModuleParam, imageFetcherFactoryModuleParam, dispatchersModuleParam, sDKUIComponentParam);
        }

        Map<Class<? extends ViewModel>, javax.inject.Provider<ViewModel>> mapOfClassOfAndProviderOfViewModel() {
            return Collections.singletonMap(DocumentScannerHostViewModel.class, this.provideDocumentScanningBaseViewModelProvider);
        }

        ViewModelProvider.Factory viewModelProviderFactory() {
            return ViewModelFactoryModule_BindViewModelFactoryFactory.bindViewModelFactory(this.viewModelFactoryModule, this.mapOfClassOfAndProviderOfViewModel());
        }

        Fetcher.Factory<ScanbotImageUri> fetcherFactoryOfScanbotImageUri() {
            return ImageFetcherFactoryModule_BindImageFetcherFactoryFactory.bindImageFetcherFactory(this.imageFetcherFactoryModule, (FileIOProcessor)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.fileIOProcessor()));
        }

        private void initialize(DocumentBaseModule documentBaseModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, ImageFetcherFactoryModule imageFetcherFactoryModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.provideDocumentScanningFlow$rtu_ui_v2_bundle_releaseProvider = DoubleCheck.provider((Provider)DocumentBaseModule_ProvideDocumentScanningFlow$rtu_ui_v2_bundle_releaseFactory.create(documentBaseModuleParam));
            this.provideNativeConfiguration$rtu_ui_v2_bundle_releaseProvider = DoubleCheck.provider((Provider)DocumentBaseModule_ProvideNativeConfiguration$rtu_ui_v2_bundle_releaseFactory.create(documentBaseModuleParam));
            this.provideBarcodeCameraViewModelProvider = DispatchersModule_ProvideBarcodeCameraViewModelFactory.create(dispatchersModuleParam);
            this.documentStorageProvider = new DocumentStorageProvider(sDKUIComponentParam);
            this.pageFileStorageProvider = new PageFileStorageProvider(sDKUIComponentParam);
            this.fileIOProcessorProvider = new FileIOProcessorProvider(sDKUIComponentParam);
            this.documentApiProvider = new DocumentApiProvider(sDKUIComponentParam);
            this.provideDocumentScanningBaseViewModelProvider = DocumentBaseModule_ProvideDocumentScanningBaseViewModelFactory.create(documentBaseModuleParam, this.provideDocumentScanningFlow$rtu_ui_v2_bundle_releaseProvider, this.provideNativeConfiguration$rtu_ui_v2_bundle_releaseProvider, this.provideBarcodeCameraViewModelProvider, this.documentStorageProvider, this.pageFileStorageProvider, this.fileIOProcessorProvider, this.documentApiProvider);
        }

        @Override
        public void inject(ViewModelInjector component) {
            this.injectViewModelInjector(component);
        }

        @Override
        public void inject(ScanbotImageFetcherFactoryInjector scanbotImageFetcherFactoryInjector) {
            this.injectScanbotImageFetcherFactoryInjector(scanbotImageFetcherFactoryInjector);
        }

        private ViewModelInjector injectViewModelInjector(ViewModelInjector instance) {
            ViewModelInjector_MembersInjector.injectFactory((ViewModelInjector)instance, (ViewModelProvider.Factory)this.viewModelProviderFactory());
            return instance;
        }

        private ScanbotImageFetcherFactoryInjector injectScanbotImageFetcherFactoryInjector(ScanbotImageFetcherFactoryInjector instance2) {
            ScanbotImageFetcherFactoryInjector_MembersInjector.injectImageFetcherFactory((ScanbotImageFetcherFactoryInjector)instance2, this.fetcherFactoryOfScanbotImageUri());
            return instance2;
        }

        private static final class DocumentStorageProvider
        implements Provider<DocumentStorage> {
            private final SDKUIComponent sDKUIComponent;

            DocumentStorageProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public DocumentStorage get() {
                return (DocumentStorage)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.documentStorage());
            }
        }

        private static final class PageFileStorageProvider
        implements Provider<PageFileStorage> {
            private final SDKUIComponent sDKUIComponent;

            PageFileStorageProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public PageFileStorage get() {
                return (PageFileStorage)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.pageFileStorage());
            }
        }

        private static final class FileIOProcessorProvider
        implements Provider<FileIOProcessor> {
            private final SDKUIComponent sDKUIComponent;

            FileIOProcessorProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public FileIOProcessor get() {
                return (FileIOProcessor)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.fileIOProcessor());
            }
        }

        private static final class DocumentApiProvider
        implements Provider<DocumentApi> {
            private final SDKUIComponent sDKUIComponent;

            DocumentApiProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public DocumentApi get() {
                return (DocumentApi)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.documentApi());
            }
        }
    }
}

