/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui_v2.di.components;

import android.content.Context;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import io.scanbot.sdk.textpattern.TextPatternScanner;
import io.scanbot.sdk.ui_v2.common.coroutines.IDispatchersProvider;
import io.scanbot.sdk.ui_v2.common.viewmodel.ViewModelInjector;
import io.scanbot.sdk.ui_v2.common.viewmodel.ViewModelInjector_MembersInjector;
import io.scanbot.sdk.ui_v2.di.components.SDKUIComponent;
import io.scanbot.sdk.ui_v2.di.components.TextPatternCameraComponent;
import io.scanbot.sdk.ui_v2.di.modules.DispatchersModule;
import io.scanbot.sdk.ui_v2.di.modules.DispatchersModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.TextPatternModule;
import io.scanbot.sdk.ui_v2.di.modules.TextPatternModule_ProvideTextPatternScannerConfiguration$rtu_ui_v2_bundle_releaseFactory;
import io.scanbot.sdk.ui_v2.di.modules.TextPatternModule_ProvideTextPatternViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui_v2.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import io.scanbot.sdk.ui_v2.textpattern.configuration.TextPatternScannerScreenConfiguration;
import io.scanbot.sdk.ui_v2.textpattern.screen.BaseTextPatternViewModel;
import java.util.Collections;
import java.util.Map;

@DaggerGenerated
public final class DaggerTextPatternCameraComponent {
    private DaggerTextPatternCameraComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TextPatternModule textPatternModule;
        private ViewModelFactoryModule viewModelFactoryModule;
        private DispatchersModule dispatchersModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder textPatternModule(TextPatternModule textPatternModule) {
            this.textPatternModule = (TextPatternModule)Preconditions.checkNotNull((Object)textPatternModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder dispatchersModule(DispatchersModule dispatchersModule) {
            this.dispatchersModule = (DispatchersModule)Preconditions.checkNotNull((Object)dispatchersModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public TextPatternCameraComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.textPatternModule, TextPatternModule.class);
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            if (this.dispatchersModule == null) {
                this.dispatchersModule = new DispatchersModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new TextPatternCameraComponentImpl(this.textPatternModule, this.viewModelFactoryModule, this.dispatchersModule, this.sDKUIComponent);
        }
    }

    private static final class TextPatternCameraComponentImpl
    implements TextPatternCameraComponent {
        private final ViewModelFactoryModule viewModelFactoryModule;
        private final TextPatternCameraComponentImpl textPatternCameraComponentImpl = this;
        Provider<TextPatternScannerScreenConfiguration> provideTextPatternScannerConfiguration$rtu_ui_v2_bundle_releaseProvider;
        Provider<TextPatternScanner> textPatternScannerProvider;
        Provider<IDispatchersProvider> provideBarcodeCameraViewModelProvider;
        Provider<Context> provideContextProvider;
        Provider<ViewModel> provideTextPatternViewModelProvider;

        TextPatternCameraComponentImpl(TextPatternModule textPatternModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.viewModelFactoryModule = viewModelFactoryModuleParam;
            this.initialize(textPatternModuleParam, viewModelFactoryModuleParam, dispatchersModuleParam, sDKUIComponentParam);
        }

        Map<Class<? extends ViewModel>, javax.inject.Provider<ViewModel>> mapOfClassOfAndProviderOfViewModel() {
            return Collections.singletonMap(BaseTextPatternViewModel.class, this.provideTextPatternViewModelProvider);
        }

        ViewModelProvider.Factory viewModelProviderFactory() {
            return ViewModelFactoryModule_BindViewModelFactoryFactory.bindViewModelFactory(this.viewModelFactoryModule, this.mapOfClassOfAndProviderOfViewModel());
        }

        private void initialize(TextPatternModule textPatternModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.provideTextPatternScannerConfiguration$rtu_ui_v2_bundle_releaseProvider = DoubleCheck.provider((Provider)TextPatternModule_ProvideTextPatternScannerConfiguration$rtu_ui_v2_bundle_releaseFactory.create(textPatternModuleParam));
            this.textPatternScannerProvider = new TextPatternScannerProvider(sDKUIComponentParam);
            this.provideBarcodeCameraViewModelProvider = DispatchersModule_ProvideBarcodeCameraViewModelFactory.create(dispatchersModuleParam);
            this.provideContextProvider = new ProvideContextProvider(sDKUIComponentParam);
            this.provideTextPatternViewModelProvider = TextPatternModule_ProvideTextPatternViewModelFactory.create(textPatternModuleParam, this.provideTextPatternScannerConfiguration$rtu_ui_v2_bundle_releaseProvider, this.textPatternScannerProvider, this.provideBarcodeCameraViewModelProvider, this.provideContextProvider);
        }

        @Override
        public void inject(ViewModelInjector component) {
            this.injectViewModelInjector(component);
        }

        private ViewModelInjector injectViewModelInjector(ViewModelInjector instance) {
            ViewModelInjector_MembersInjector.injectFactory((ViewModelInjector)instance, (ViewModelProvider.Factory)this.viewModelProviderFactory());
            return instance;
        }

        private static final class TextPatternScannerProvider
        implements Provider<TextPatternScanner> {
            private final SDKUIComponent sDKUIComponent;

            TextPatternScannerProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public TextPatternScanner get() {
                return (TextPatternScanner)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.textPatternScanner());
            }
        }

        private static final class ProvideContextProvider
        implements Provider<Context> {
            private final SDKUIComponent sDKUIComponent;

            ProvideContextProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public Context get() {
                return (Context)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideContext());
            }
        }
    }
}

