/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui_v2.di.components;

import android.content.Context;
import android.os.Bundle;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.MapBuilder;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import io.scanbot.sdk.analytics.IScanbotAnalyticsTracker;
import io.scanbot.sdk.document.DocumentScanner;
import io.scanbot.sdk.persistence.fileio.FileIOProcessor;
import io.scanbot.sdk.process.DocumentQualityAnalyzer;
import io.scanbot.sdk.ui_v2.common.coroutines.IDispatchersProvider;
import io.scanbot.sdk.ui_v2.common.viewmodel.ViewModelInjector;
import io.scanbot.sdk.ui_v2.common.viewmodel.ViewModelInjector_MembersInjector;
import io.scanbot.sdk.ui_v2.di.components.DocumentCameraComponent;
import io.scanbot.sdk.ui_v2.di.components.SDKUIComponent;
import io.scanbot.sdk.ui_v2.di.modules.DispatchersModule;
import io.scanbot.sdk.ui_v2.di.modules.DispatchersModule_ProvideBarcodeCameraViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.DocumentModule;
import io.scanbot.sdk.ui_v2.di.modules.DocumentModule_ProvideAcknowledgementViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.DocumentModule_ProvideArgumentsBundle$rtu_ui_v2_bundle_releaseFactory;
import io.scanbot.sdk.ui_v2.di.modules.DocumentModule_ProvideBaseDocumentViewModel$rtu_ui_v2_bundle_releaseFactory;
import io.scanbot.sdk.ui_v2.di.modules.DocumentModule_ProvideCroppingViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.DocumentModule_ProvideDocumentScanningCameraViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.DocumentModule_ProvideDocumentScanningFlow$rtu_ui_v2_bundle_releaseFactory;
import io.scanbot.sdk.ui_v2.di.modules.DocumentModule_ProvideReorderViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.DocumentModule_ProvideReviewViewModelFactory;
import io.scanbot.sdk.ui_v2.di.modules.ViewModelFactoryModule;
import io.scanbot.sdk.ui_v2.di.modules.ViewModelFactoryModule_BindViewModelFactoryFactory;
import io.scanbot.sdk.ui_v2.document.configuration.DocumentScanningFlow;
import io.scanbot.sdk.ui_v2.document.screen.DocumentScannerHostViewModel;
import io.scanbot.sdk.ui_v2.document.screen.acknowledgement.AcknowledgementViewModel;
import io.scanbot.sdk.ui_v2.document.screen.camera.DocumentCameraViewModel;
import io.scanbot.sdk.ui_v2.document.screen.crop.CroppingViewModel;
import io.scanbot.sdk.ui_v2.document.screen.reorder.ReorderViewModel;
import io.scanbot.sdk.ui_v2.document.screen.review.ReviewViewModel;
import java.util.Map;

@DaggerGenerated
public final class DaggerDocumentCameraComponent {
    private DaggerDocumentCameraComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DocumentModule documentModule;
        private ViewModelFactoryModule viewModelFactoryModule;
        private DispatchersModule dispatchersModule;
        private SDKUIComponent sDKUIComponent;

        private Builder() {
        }

        public Builder documentModule(DocumentModule documentModule) {
            this.documentModule = (DocumentModule)Preconditions.checkNotNull((Object)documentModule);
            return this;
        }

        public Builder viewModelFactoryModule(ViewModelFactoryModule viewModelFactoryModule) {
            this.viewModelFactoryModule = (ViewModelFactoryModule)Preconditions.checkNotNull((Object)viewModelFactoryModule);
            return this;
        }

        public Builder dispatchersModule(DispatchersModule dispatchersModule) {
            this.dispatchersModule = (DispatchersModule)Preconditions.checkNotNull((Object)dispatchersModule);
            return this;
        }

        public Builder sDKUIComponent(SDKUIComponent sDKUIComponent) {
            this.sDKUIComponent = (SDKUIComponent)Preconditions.checkNotNull((Object)sDKUIComponent);
            return this;
        }

        public DocumentCameraComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.documentModule, DocumentModule.class);
            if (this.viewModelFactoryModule == null) {
                this.viewModelFactoryModule = new ViewModelFactoryModule();
            }
            if (this.dispatchersModule == null) {
                this.dispatchersModule = new DispatchersModule();
            }
            Preconditions.checkBuilderRequirement((Object)this.sDKUIComponent, SDKUIComponent.class);
            return new DocumentCameraComponentImpl(this.documentModule, this.viewModelFactoryModule, this.dispatchersModule, this.sDKUIComponent);
        }
    }

    private static final class DocumentCameraComponentImpl
    implements DocumentCameraComponent {
        private final ViewModelFactoryModule viewModelFactoryModule;
        private final DocumentCameraComponentImpl documentCameraComponentImpl = this;
        private Provider<DocumentScannerHostViewModel> provideBaseDocumentViewModel$rtu_ui_v2_bundle_releaseProvider;
        private Provider<DocumentScanningFlow> provideDocumentScanningFlow$rtu_ui_v2_bundle_releaseProvider;
        private Provider<DocumentScanner> documentScannerProvider;
        private Provider<DocumentQualityAnalyzer> documentQualityAnalyzerProvider;
        private Provider<IDispatchersProvider> provideBarcodeCameraViewModelProvider;
        private Provider<IScanbotAnalyticsTracker> analyticsTrackerProvider;
        private Provider<Context> provideContextProvider;
        private Provider<Bundle> provideArgumentsBundle$rtu_ui_v2_bundle_releaseProvider;
        private Provider<ViewModel> provideDocumentScanningCameraViewModelProvider;
        private Provider<ViewModel> provideAcknowledgementViewModelProvider;
        private Provider<ViewModel> provideReorderViewModelProvider;
        private Provider<ViewModel> provideCroppingViewModelProvider;
        private Provider<FileIOProcessor> fileIOProcessorProvider;
        private Provider<ViewModel> provideReviewViewModelProvider;

        private DocumentCameraComponentImpl(DocumentModule documentModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.viewModelFactoryModule = viewModelFactoryModuleParam;
            this.initialize(documentModuleParam, viewModelFactoryModuleParam, dispatchersModuleParam, sDKUIComponentParam);
        }

        private Map<Class<? extends ViewModel>, javax.inject.Provider<ViewModel>> mapOfClassOfAndProviderOfViewModel() {
            return MapBuilder.newMapBuilder((int)5).put(DocumentCameraViewModel.class, this.provideDocumentScanningCameraViewModelProvider).put(AcknowledgementViewModel.class, this.provideAcknowledgementViewModelProvider).put(ReorderViewModel.class, this.provideReorderViewModelProvider).put(CroppingViewModel.class, this.provideCroppingViewModelProvider).put(ReviewViewModel.class, this.provideReviewViewModelProvider).build();
        }

        private ViewModelProvider.Factory viewModelProviderFactory() {
            return ViewModelFactoryModule_BindViewModelFactoryFactory.bindViewModelFactory(this.viewModelFactoryModule, this.mapOfClassOfAndProviderOfViewModel());
        }

        private void initialize(DocumentModule documentModuleParam, ViewModelFactoryModule viewModelFactoryModuleParam, DispatchersModule dispatchersModuleParam, SDKUIComponent sDKUIComponentParam) {
            this.provideBaseDocumentViewModel$rtu_ui_v2_bundle_releaseProvider = DoubleCheck.provider((Provider)DocumentModule_ProvideBaseDocumentViewModel$rtu_ui_v2_bundle_releaseFactory.create(documentModuleParam));
            this.provideDocumentScanningFlow$rtu_ui_v2_bundle_releaseProvider = DoubleCheck.provider((Provider)DocumentModule_ProvideDocumentScanningFlow$rtu_ui_v2_bundle_releaseFactory.create(documentModuleParam));
            this.documentScannerProvider = new DocumentScannerProvider(sDKUIComponentParam);
            this.documentQualityAnalyzerProvider = new DocumentQualityAnalyzerProvider(sDKUIComponentParam);
            this.provideBarcodeCameraViewModelProvider = DispatchersModule_ProvideBarcodeCameraViewModelFactory.create(dispatchersModuleParam);
            this.analyticsTrackerProvider = new AnalyticsTrackerProvider(sDKUIComponentParam);
            this.provideContextProvider = new ProvideContextProvider(sDKUIComponentParam);
            this.provideArgumentsBundle$rtu_ui_v2_bundle_releaseProvider = DoubleCheck.provider((Provider)DocumentModule_ProvideArgumentsBundle$rtu_ui_v2_bundle_releaseFactory.create(documentModuleParam));
            this.provideDocumentScanningCameraViewModelProvider = DocumentModule_ProvideDocumentScanningCameraViewModelFactory.create(documentModuleParam, this.provideBaseDocumentViewModel$rtu_ui_v2_bundle_releaseProvider, this.provideDocumentScanningFlow$rtu_ui_v2_bundle_releaseProvider, this.documentScannerProvider, this.documentQualityAnalyzerProvider, this.provideBarcodeCameraViewModelProvider, this.analyticsTrackerProvider, this.provideContextProvider, this.provideArgumentsBundle$rtu_ui_v2_bundle_releaseProvider);
            this.provideAcknowledgementViewModelProvider = DocumentModule_ProvideAcknowledgementViewModelFactory.create(documentModuleParam, this.provideBaseDocumentViewModel$rtu_ui_v2_bundle_releaseProvider, this.provideDocumentScanningFlow$rtu_ui_v2_bundle_releaseProvider, this.provideBarcodeCameraViewModelProvider, this.analyticsTrackerProvider, this.provideArgumentsBundle$rtu_ui_v2_bundle_releaseProvider);
            this.provideReorderViewModelProvider = DocumentModule_ProvideReorderViewModelFactory.create(documentModuleParam, this.provideBaseDocumentViewModel$rtu_ui_v2_bundle_releaseProvider, this.provideDocumentScanningFlow$rtu_ui_v2_bundle_releaseProvider, this.provideBarcodeCameraViewModelProvider);
            this.provideCroppingViewModelProvider = DocumentModule_ProvideCroppingViewModelFactory.create(documentModuleParam, this.provideBaseDocumentViewModel$rtu_ui_v2_bundle_releaseProvider, this.provideDocumentScanningFlow$rtu_ui_v2_bundle_releaseProvider, this.documentScannerProvider, this.documentQualityAnalyzerProvider, this.provideBarcodeCameraViewModelProvider, this.provideArgumentsBundle$rtu_ui_v2_bundle_releaseProvider);
            this.fileIOProcessorProvider = new FileIOProcessorProvider(sDKUIComponentParam);
            this.provideReviewViewModelProvider = DocumentModule_ProvideReviewViewModelFactory.create(documentModuleParam, this.provideBaseDocumentViewModel$rtu_ui_v2_bundle_releaseProvider, this.provideDocumentScanningFlow$rtu_ui_v2_bundle_releaseProvider, this.provideBarcodeCameraViewModelProvider, this.fileIOProcessorProvider, this.provideArgumentsBundle$rtu_ui_v2_bundle_releaseProvider);
        }

        @Override
        public void inject(ViewModelInjector component) {
            this.injectViewModelInjector(component);
        }

        private ViewModelInjector injectViewModelInjector(ViewModelInjector instance) {
            ViewModelInjector_MembersInjector.injectFactory((ViewModelInjector)instance, (ViewModelProvider.Factory)this.viewModelProviderFactory());
            return instance;
        }

        private static final class DocumentScannerProvider
        implements Provider<DocumentScanner> {
            private final SDKUIComponent sDKUIComponent;

            DocumentScannerProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public DocumentScanner get() {
                return (DocumentScanner)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.documentScanner());
            }
        }

        private static final class DocumentQualityAnalyzerProvider
        implements Provider<DocumentQualityAnalyzer> {
            private final SDKUIComponent sDKUIComponent;

            DocumentQualityAnalyzerProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public DocumentQualityAnalyzer get() {
                return (DocumentQualityAnalyzer)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.documentQualityAnalyzer());
            }
        }

        private static final class AnalyticsTrackerProvider
        implements Provider<IScanbotAnalyticsTracker> {
            private final SDKUIComponent sDKUIComponent;

            AnalyticsTrackerProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public IScanbotAnalyticsTracker get() {
                return (IScanbotAnalyticsTracker)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.analyticsTracker());
            }
        }

        private static final class ProvideContextProvider
        implements Provider<Context> {
            private final SDKUIComponent sDKUIComponent;

            ProvideContextProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public Context get() {
                return (Context)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.provideContext());
            }
        }

        private static final class FileIOProcessorProvider
        implements Provider<FileIOProcessor> {
            private final SDKUIComponent sDKUIComponent;

            FileIOProcessorProvider(SDKUIComponent sDKUIComponent) {
                this.sDKUIComponent = sDKUIComponent;
            }

            public FileIOProcessor get() {
                return (FileIOProcessor)Preconditions.checkNotNullFromComponent((Object)this.sDKUIComponent.fileIOProcessor());
            }
        }
    }
}

