/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui_v2.document.utils;

import android.content.ClipData;
import android.content.ContentResolver;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import io.scanbot.common.Result;
import io.scanbot.common.ResultKt;
import io.scanbot.sdk.image.ImageInfo;
import io.scanbot.sdk.image.ImageRef;
import io.scanbot.sdk.imagemanipulation.ScanbotSdkImageManipulator;
import io.scanbot.sdk.ui.camera.util.CameraImageUtils;
import io.scanbot.sdk.ui_v2.document.utils.GalleryUtilsKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\b\u001a\u00020\t*\u00020\t2\u0006\u0010\n\u001a\u00020\u0001\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\f2\u0006\u0010\n\u001a\u00020\u0001\u001a.\u0010\r\u001a\u0004\u0018\u00010\t*\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\b\u0002\u0010\u0010\u001a\u0012\u0012\b\u0012\u00060\u0012j\u0002`\u0013\u0012\u0004\u0012\u00020\u00140\u0011\u001a.\u0010\u0015\u001a\u0004\u0018\u00010\f*\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\b\u0002\u0010\u0010\u001a\u0012\u0012\b\u0012\u00060\u0012j\u0002`\u0013\u0012\u0004\u0012\u00020\u00140\u0011\u00a8\u0006\u0016"}, d2={"exifToGrad", "", "exifOrientation", "getUrisFromGalleryResult", "", "Landroid/net/Uri;", "data", "Landroid/content/Intent;", "preprocessBitmap", "Landroid/graphics/Bitmap;", "orientation", "preprocessImportedImage", "Lio/scanbot/sdk/image/ImageRef;", "toBitmap", "contentResolver", "Landroid/content/ContentResolver;", "onException", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "", "toImageRef", "rtu-ui-v2-document_release"})
@SourceDebugExtension(value={"SMAP\nGalleryUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GalleryUtils.kt\nio/scanbot/sdk/ui_v2/document/utils/GalleryUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1#2:152\n*E\n"})
public final class GalleryUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Uri> getUrisFromGalleryResult(@NotNull Intent data2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (data2.getClipData() != null) {
            void var3_4;
            ClipData mClipData;
            ClipData clipData = mClipData = data2.getClipData();
            int count = clipData != null ? clipData.getItemCount() : 0;
            List result = new ArrayList();
            for (int i = 0; i < count; ++i) {
                Uri imageUri;
                ClipData it;
                if (mClipData == null) continue;
                boolean bl = false;
                ClipData.Item item = it.getItemAt(i);
                Object object = imageUri = item != null ? item.getUri() : null;
                if (imageUri == null) continue;
                result.add(imageUri);
            }
            list = var3_4;
        } else {
            Uri imageUri = data2.getData();
            list = CollectionsKt.listOfNotNull((Object)imageUri);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final Bitmap toBitmap(@NotNull Uri $this$toBitmap, @NotNull ContentResolver contentResolver, @NotNull Function1<? super Exception, Unit> onException) {
        Intrinsics.checkNotNullParameter((Object)$this$toBitmap, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contentResolver, (String)"contentResolver");
        Intrinsics.checkNotNullParameter(onException, (String)"onException");
        try {
            Bitmap bitmap2;
            Object object;
            Bitmap bitmap3 = null;
            InputStream input = contentResolver.openInputStream($this$toBitmap);
            int orientation = 0;
            Closeable closeable = input;
            Object object2 = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                if (Build.VERSION.SDK_INT >= 24) {
                    InputStream inputStream = input;
                    Intrinsics.checkNotNull((Object)inputStream);
                    ExifInterface exif = new ExifInterface(inputStream);
                    orientation = GalleryUtilsKt.exifToGrad(exif.getAttributeInt("Orientation", 0));
                }
                object = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
            }
            InputStream inputNew = contentResolver.openInputStream($this$toBitmap);
            object2 = inputNew;
            object = null;
            try {
                InputStream it = (InputStream)object2;
                boolean bl = false;
                bitmap2 = BitmapFactory.decodeStream((InputStream)inputNew);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
            }
            bitmap3 = bitmap2;
            bitmap3 = GalleryUtilsKt.preprocessBitmap(bitmap3, orientation);
            return bitmap3;
        }
        catch (IOException e) {
            onException.invoke((Object)e);
            return null;
        }
    }

    public static /* synthetic */ Bitmap toBitmap$default(Uri uri, ContentResolver contentResolver, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = toBitmap.1.INSTANCE;
        }
        return GalleryUtilsKt.toBitmap(uri, contentResolver, (Function1<? super Exception, Unit>)function1);
    }

    @Nullable
    public static final ImageRef toImageRef(@NotNull Uri $this$toImageRef, @NotNull ContentResolver contentResolver, @NotNull Function1<? super Exception, Unit> onException) {
        Intrinsics.checkNotNullParameter((Object)$this$toImageRef, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contentResolver, (String)"contentResolver");
        Intrinsics.checkNotNullParameter(onException, (String)"onException");
        try {
            ImageRef imageRef2 = null;
            int orientation = 0;
            InputStream inputStream = contentResolver.openInputStream($this$toImageRef);
            if (inputStream != null) {
                InputStream inputNew = inputStream;
                boolean bl = false;
                imageRef2 = ImageRef.CREATOR.fromInputStream$default((ImageRef.CREATOR)ImageRef.CREATOR, (InputStream)inputNew, null, (int)2, null);
            }
            ImageRef imageRef3 = imageRef2;
            imageRef2 = imageRef3 != null ? GalleryUtilsKt.preprocessImportedImage(imageRef3, orientation) : null;
            return imageRef2;
        }
        catch (IOException e) {
            onException.invoke((Object)e);
            return null;
        }
    }

    public static /* synthetic */ ImageRef toImageRef$default(Uri uri, ContentResolver contentResolver, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = toImageRef.1.INSTANCE;
        }
        return GalleryUtilsKt.toImageRef(uri, contentResolver, (Function1<? super Exception, Unit>)function1);
    }

    @NotNull
    public static final Bitmap preprocessBitmap(@NotNull Bitmap $this$preprocessBitmap, int orientation) {
        Bitmap bitmap2;
        Intrinsics.checkNotNullParameter((Object)$this$preprocessBitmap, (String)"<this>");
        Bitmap bitmapToProcess = $this$preprocessBitmap;
        boolean bl = false;
        int width = bitmapToProcess.getWidth();
        int height = bitmapToProcess.getHeight();
        if (orientation != 0 || width > 4096 || height > 4096) {
            Matrix matrix = new Matrix();
            if (orientation != 0) {
                matrix.setRotate((float)orientation, (float)width / 2.0f, (float)height / 2.0f);
            }
            if (width > 4096 || height > 4096) {
                float scale2 = width > height ? (float)4096 / (float)width : (float)4096 / (float)height;
                matrix.postScale(scale2, scale2);
            }
            bitmap2 = Bitmap.createBitmap((Bitmap)bitmapToProcess, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)false);
        } else {
            bitmap2 = bitmapToProcess;
        }
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"let(...)");
        return bitmap2;
    }

    @NotNull
    public static final ImageRef preprocessImportedImage(@NotNull ImageRef $this$preprocessImportedImage, int orientation) {
        ImageInfo imageInfo;
        block12: {
            block11: {
                ImageRef imageRef2;
                Intrinsics.checkNotNullParameter((Object)$this$preprocessImportedImage, (String)"<this>");
                imageInfo = (ImageInfo)ResultKt.getOrNull((Result)$this$preprocessImportedImage.info());
                if (imageInfo == null) break block11;
                ImageInfo imageInfo2 = imageInfo;
                boolean bl = false;
                int width = imageInfo2.getWidth();
                int height = imageInfo2.getHeight();
                ImageRef imageRefProcessed = null;
                imageRefProcessed = $this$preprocessImportedImage;
                if (orientation != 0 || width > 4096 || height > 4096) {
                    ImageRef it;
                    ScanbotSdkImageManipulator processor = ScanbotSdkImageManipulator.Companion.create();
                    if (orientation != 0) {
                        ImageRef imageRef3 = (ImageRef)ResultKt.getOrNull((Result)processor.rotate($this$preprocessImportedImage, CameraImageUtils.toImageRotation((int)orientation)));
                        if (imageRef3 != null) {
                            it = imageRef3;
                            boolean bl2 = false;
                            imageRefProcessed.close();
                            imageRefProcessed = it;
                        }
                    }
                    if (width > 4096 || height > 4096) {
                        ImageRef imageRef4 = (ImageRef)ResultKt.getOrNull((Result)processor.resize(imageRefProcessed, 4096));
                        if (imageRef4 != null) {
                            it = imageRef4;
                            boolean bl3 = false;
                            imageRefProcessed.close();
                            imageRefProcessed = it;
                        }
                    }
                    imageRef2 = imageRefProcessed;
                } else {
                    imageRef2 = $this$preprocessImportedImage;
                }
                imageInfo = imageRef2;
                if (imageRef2 != null) break block12;
            }
            imageInfo = $this$preprocessImportedImage;
        }
        return imageInfo;
    }

    private static final int exifToGrad(int exifOrientation) {
        return switch (exifOrientation) {
            case 6 -> 90;
            case 3 -> 180;
            case 8 -> 270;
            default -> 0;
        };
    }
}

