/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.barcode_scanner.di.components;

import android.content.Context;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.Preconditions;
import io.reactivex.Scheduler;
import io.scanbot.sdk.barcode.entity.FormattedBarcodeDataMapper;
import io.scanbot.sdk.persistence.BarcodeFileStorage;
import io.scanbot.sdk.persistence.fileio.ImageFileIOProcessor;
import io.scanbot.sdk.ui.barcode_scanner.di.components.BarcodeScannerSDKUIComponent;
import io.scanbot.sdk.ui.barcode_scanner.di.components.BatchBarcodeCameraComponent;
import io.scanbot.sdk.ui.barcode_scanner.di.modules.BatchBarcodeModule;
import io.scanbot.sdk.ui.barcode_scanner.di.modules.BatchBarcodeModule_ProvideFormattedBarcodeDataMapper$scanbot_barcode_scanner_sdk_ui_releaseFactory;
import io.scanbot.sdk.ui.barcode_scanner.di.modules.BatchBarcodeModule_ProvideLastScannedBarcodeHolder$scanbot_barcode_scanner_sdk_ui_releaseFactory;
import io.scanbot.sdk.ui.barcode_scanner.view.barcode.batch.BatchBarcodeCameraFragment;
import io.scanbot.sdk.ui.di.modules.NavigatorModule;
import io.scanbot.sdk.ui.di.modules.NavigatorModule_ProvidesNavigatorFactory;
import io.scanbot.sdk.ui.utils.navigator.Navigator;
import io.scanbot.sdk.ui.view.barcode.BarcodeCameraPresenter;
import io.scanbot.sdk.ui.view.barcode.BarcodeScanningSession;
import io.scanbot.sdk.ui.view.barcode.BaseBarcodeCameraFragment;
import io.scanbot.sdk.ui.view.barcode.BaseBarcodeCameraFragment_MembersInjector;
import io.scanbot.sdk.ui.view.barcode.batch.BatchBarcodeListPresenter;
import io.scanbot.sdk.ui.view.barcode.batch.InternalBatchBarcodeCameraFragment;
import io.scanbot.sdk.ui.view.barcode.batch.InternalBatchBarcodeCameraFragment_MembersInjector;
import io.scanbot.sdk.ui.view.interactor.CheckCameraPermissionUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveBarcodePreviewFrameUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveBarcodeTakenPictureUseCase;
import javax.inject.Provider;

@DaggerGenerated
public final class DaggerBatchBarcodeCameraComponent
implements BatchBarcodeCameraComponent {
    private final BarcodeScannerSDKUIComponent barcodeScannerSDKUIComponent;
    private Provider<BarcodeScanningSession> provideLastScannedBarcodeHolder$scanbot_barcode_scanner_sdk_ui_releaseProvider;
    private Provider<Navigator> providesNavigatorProvider;
    private Provider<FormattedBarcodeDataMapper> provideFormattedBarcodeDataMapper$scanbot_barcode_scanner_sdk_ui_releaseProvider;

    private DaggerBatchBarcodeCameraComponent(NavigatorModule navigatorModuleParam, BatchBarcodeModule batchBarcodeModuleParam, BarcodeScannerSDKUIComponent barcodeScannerSDKUIComponentParam) {
        this.barcodeScannerSDKUIComponent = barcodeScannerSDKUIComponentParam;
        this.initialize(navigatorModuleParam, batchBarcodeModuleParam, barcodeScannerSDKUIComponentParam);
    }

    public static Builder builder() {
        return new Builder();
    }

    private CheckCameraPermissionUseCase checkCameraPermissionUseCase() {
        return new CheckCameraPermissionUseCase((Context)Preconditions.checkNotNullFromComponent((Object)this.barcodeScannerSDKUIComponent.provideContext()));
    }

    private SaveBarcodeTakenPictureUseCase saveBarcodeTakenPictureUseCase() {
        return new SaveBarcodeTakenPictureUseCase((BarcodeFileStorage)Preconditions.checkNotNullFromComponent((Object)this.barcodeScannerSDKUIComponent.barcodeFileStorage()), (ImageFileIOProcessor)Preconditions.checkNotNullFromComponent((Object)this.barcodeScannerSDKUIComponent.imageFileIOProcessor()));
    }

    private SaveBarcodePreviewFrameUseCase saveBarcodePreviewFrameUseCase() {
        return new SaveBarcodePreviewFrameUseCase((BarcodeFileStorage)Preconditions.checkNotNullFromComponent((Object)this.barcodeScannerSDKUIComponent.barcodeFileStorage()), (ImageFileIOProcessor)Preconditions.checkNotNullFromComponent((Object)this.barcodeScannerSDKUIComponent.imageFileIOProcessor()));
    }

    private BarcodeCameraPresenter barcodeCameraPresenter() {
        return new BarcodeCameraPresenter(this.checkCameraPermissionUseCase(), this.saveBarcodeTakenPictureUseCase(), this.saveBarcodePreviewFrameUseCase(), (BarcodeScanningSession)this.provideLastScannedBarcodeHolder$scanbot_barcode_scanner_sdk_ui_releaseProvider.get(), (Navigator)this.providesNavigatorProvider.get());
    }

    private BatchBarcodeListPresenter batchBarcodeListPresenter() {
        return new BatchBarcodeListPresenter((Navigator)this.providesNavigatorProvider.get(), (FormattedBarcodeDataMapper)this.provideFormattedBarcodeDataMapper$scanbot_barcode_scanner_sdk_ui_releaseProvider.get(), (BarcodeScanningSession)this.provideLastScannedBarcodeHolder$scanbot_barcode_scanner_sdk_ui_releaseProvider.get(), (Scheduler)Preconditions.checkNotNullFromComponent((Object)this.barcodeScannerSDKUIComponent.provideBackgroundTaskScheduler()));
    }

    private void initialize(NavigatorModule navigatorModuleParam, BatchBarcodeModule batchBarcodeModuleParam, BarcodeScannerSDKUIComponent barcodeScannerSDKUIComponentParam) {
        this.provideLastScannedBarcodeHolder$scanbot_barcode_scanner_sdk_ui_releaseProvider = DoubleCheck.provider((Provider)BatchBarcodeModule_ProvideLastScannedBarcodeHolder$scanbot_barcode_scanner_sdk_ui_releaseFactory.create(batchBarcodeModuleParam));
        this.providesNavigatorProvider = DoubleCheck.provider((Provider)NavigatorModule_ProvidesNavigatorFactory.create((NavigatorModule)navigatorModuleParam));
        this.provideFormattedBarcodeDataMapper$scanbot_barcode_scanner_sdk_ui_releaseProvider = DoubleCheck.provider((Provider)BatchBarcodeModule_ProvideFormattedBarcodeDataMapper$scanbot_barcode_scanner_sdk_ui_releaseFactory.create(batchBarcodeModuleParam));
    }

    @Override
    public void inject(BatchBarcodeCameraFragment batchBarcodeCameraFragment) {
        this.injectBatchBarcodeCameraFragment(batchBarcodeCameraFragment);
    }

    private BatchBarcodeCameraFragment injectBatchBarcodeCameraFragment(BatchBarcodeCameraFragment instance) {
        BaseBarcodeCameraFragment_MembersInjector.injectCheckCameraPermissionUseCase((BaseBarcodeCameraFragment)instance, (CheckCameraPermissionUseCase)this.checkCameraPermissionUseCase());
        BaseBarcodeCameraFragment_MembersInjector.injectBarcodeCameraPresenter((BaseBarcodeCameraFragment)instance, (BarcodeCameraPresenter)this.barcodeCameraPresenter());
        InternalBatchBarcodeCameraFragment_MembersInjector.injectBatchBarcodeListPresenter((InternalBatchBarcodeCameraFragment)instance, (BatchBarcodeListPresenter)this.batchBarcodeListPresenter());
        return instance;
    }

    public static final class Builder {
        private NavigatorModule navigatorModule;
        private BatchBarcodeModule batchBarcodeModule;
        private BarcodeScannerSDKUIComponent barcodeScannerSDKUIComponent;

        private Builder() {
        }

        public Builder navigatorModule(NavigatorModule navigatorModule) {
            this.navigatorModule = (NavigatorModule)Preconditions.checkNotNull((Object)navigatorModule);
            return this;
        }

        public Builder batchBarcodeModule(BatchBarcodeModule batchBarcodeModule) {
            this.batchBarcodeModule = (BatchBarcodeModule)Preconditions.checkNotNull((Object)batchBarcodeModule);
            return this;
        }

        public Builder barcodeScannerSDKUIComponent(BarcodeScannerSDKUIComponent barcodeScannerSDKUIComponent) {
            this.barcodeScannerSDKUIComponent = (BarcodeScannerSDKUIComponent)Preconditions.checkNotNull((Object)barcodeScannerSDKUIComponent);
            return this;
        }

        public BatchBarcodeCameraComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.navigatorModule, NavigatorModule.class);
            Preconditions.checkBuilderRequirement((Object)this.batchBarcodeModule, BatchBarcodeModule.class);
            Preconditions.checkBuilderRequirement((Object)this.barcodeScannerSDKUIComponent, BarcodeScannerSDKUIComponent.class);
            return new DaggerBatchBarcodeCameraComponent(this.navigatorModule, this.batchBarcodeModule, this.barcodeScannerSDKUIComponent);
        }
    }
}

