/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import android.app.Application;
import android.content.Context;
import android.preference.PreferenceManager;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.doo.snap.util.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/scanbot/sdk/persistence/BarcodeFileStorage;", "", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "getApplication", "()Landroid/app/Application;", "sdkBarcodeImagesFolderName", "", "getBarcodeImagesDirectory", "Ljava/io/File;", "sdk-base_release"})
public final class BarcodeFileStorage {
    private final String sdkBarcodeImagesFolderName = "barcode_images";
    @NotNull
    private final Application application;

    @NotNull
    public final File getBarcodeImagesDirectory() throws IOException {
        String sdkFilesDirPath = PreferenceManager.getDefaultSharedPreferences((Context)((Context)this.application)).getString("CUSTOM_SDK_FILES_PATH", "");
        if (sdkFilesDirPath != null) {
            CharSequence charSequence = sdkFilesDirPath;
            boolean bl = false;
            if (charSequence.length() > 0) {
                if (!FileUtils.ensureDirExists(sdkFilesDirPath)) {
                    throw (Throwable)new IOException("Barcode images SDK files path cannot be empty.");
                }
                File file = FileUtils.getFilesDirOrShowError(sdkFilesDirPath, this.sdkBarcodeImagesFolderName);
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"getFilesDirOrShowError(s\u2026kBarcodeImagesFolderName)");
                return file;
            }
        }
        File file = FileUtils.getAppFilesDirOrShowError((Context)this.application, "scanbot-sdk");
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"getAppFilesDirOrShowErro\u2026n, SCANBOT_SDK_FILES_DIR)");
        File file2 = FileUtils.getFilesDirOrShowError(file.getPath(), this.sdkBarcodeImagesFolderName);
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"getFilesDirOrShowError(g\u2026kBarcodeImagesFolderName)");
        return file2;
    }

    @NotNull
    public final Application getApplication() {
        return this.application;
    }

    public BarcodeFileStorage(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        this.application = application;
        this.sdkBarcodeImagesFolderName = "barcode_images";
    }
}

