/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.camera;

import android.content.Context;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.RequiresApi;
import com.commonsware.cwac.camera.PictureTransaction;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.camera.CameraHost;
import io.scanbot.sdk.camera.CameraOpenCallback;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.camera.CameraStateCallback;
import io.scanbot.sdk.camera.CameraTakePictureCallback;
import io.scanbot.sdk.camera.CameraView;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.camera.PictureCallback;
import io.scanbot.sdk.camera.PreviewBuffer;
import io.scanbot.sdk.camera.SnapFlashView;
import io.scanbot.sdk.security.SapSingleton;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import io.scanbot.sdk.util.snap.Utils;
import io.scanbot.sdk.util.thread.ExecutionUtils;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u00012\u00020\u0002:\u0002ijB\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020!H\u0016J\u0010\u0010/\u001a\u00020-2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020-2\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020-2\u0006\u00106\u001a\u00020+H\u0016J\b\u00107\u001a\u00020-H\u0016J\b\u00108\u001a\u00020-H\u0016J'\u00109\u001a\u0004\u0018\u0001H:\"\b\b\u0000\u0010:*\u0002012\f\u0010;\u001a\b\u0012\u0004\u0012\u0002H:0<H\u0016\u00a2\u0006\u0002\u0010=J\u0010\u0010>\u001a\u00020-2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010?\u001a\u00020-2\u0006\u0010@\u001a\u00020\u001aH\u0016J\u0010\u0010A\u001a\u00020-2\u0006\u0010@\u001a\u00020\u001aH\u0016J\b\u0010B\u001a\u00020-H\u0002J\b\u0010C\u001a\u00020-H\u0002J\b\u0010D\u001a\u00020-H\u0002J\b\u0010E\u001a\u00020-H\u0014J0\u0010F\u001a\u00020-2\u0006\u0010G\u001a\u00020\u001a2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020I2\u0006\u0010K\u001a\u00020I2\u0006\u0010L\u001a\u00020IH\u0014J\u0006\u0010M\u001a\u00020-J\u0006\u0010N\u001a\u00020-J\b\u0010O\u001a\u00020-H\u0002J\u0010\u0010P\u001a\u00020-2\u0006\u0010.\u001a\u00020!H\u0016J\u0010\u0010Q\u001a\u00020-2\u0006\u00100\u001a\u000201H\u0016J\u0010\u0010R\u001a\u00020-2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010S\u001a\u00020-2\u0006\u00106\u001a\u00020+H\u0016J\u0010\u0010T\u001a\u00020-2\u0006\u0010U\u001a\u00020\u001aH\u0016J\u000e\u0010V\u001a\u00020-2\u0006\u0010W\u001a\u00020\u001aJ\u0010\u0010X\u001a\u00020-2\u0006\u0010Y\u001a\u00020ZH\u0016J\u0012\u0010[\u001a\u00020-2\n\u0010\\\u001a\u00060$R\u00020%J\u0010\u0010]\u001a\u00020-2\u0006\u0010^\u001a\u00020_H\u0016J\u0012\u0010`\u001a\u00020-2\n\u0010a\u001a\u00060$R\u00020%J\u0010\u0010b\u001a\u00020-2\u0006\u0010W\u001a\u00020\u001aH\u0007J\u0006\u0010c\u001a\u00020-J\u0006\u0010d\u001a\u00020-J\u0010\u0010e\u001a\u00020-2\u0006\u0010f\u001a\u00020\u001aH\u0016J\b\u0010g\u001a\u00020-H\u0016J\u0010\u0010h\u001a\u00020-2\u0006\u0010h\u001a\u00020\u001aH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\"\u001a\u000e\u0012\n\u0012\b\u0018\u00010$R\u00020%0#8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001d\u0010(\u001a\u000e\u0012\n\u0012\b\u0018\u00010$R\u00020%0#8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010'R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020+0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006k"}, d2={"Lio/scanbot/sdk/camera/ScanbotCameraView;", "Landroid/widget/FrameLayout;", "Lio/scanbot/sdk/ui/camera/IScanbotCameraView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "cameraHost", "Lio/scanbot/sdk/camera/CameraHost;", "cameraView", "Lio/scanbot/sdk/camera/CameraView;", "delayAfterFocusCompleteMs", "", "getDelayAfterFocusCompleteMs", "()J", "setDelayAfterFocusCompleteMs", "(J)V", "logger", "Lio/scanbot/sdk/util/log/Logger;", "previewBuffer", "Lio/scanbot/sdk/camera/PreviewBuffer;", "getPreviewBuffer", "()Lio/scanbot/sdk/camera/PreviewBuffer;", "resumed", "", "snapAnimationView", "Lio/scanbot/sdk/camera/SnapFlashView;", "state", "Lio/scanbot/sdk/camera/ScanbotCameraView$State;", "stateCallbacks", "", "Lio/scanbot/sdk/camera/CameraStateCallback;", "supportedPictureSizes", "", "Landroid/hardware/Camera$Size;", "Landroid/hardware/Camera;", "getSupportedPictureSizes", "()Ljava/util/List;", "supportedPreviewSizes", "getSupportedPreviewSizes", "takePictureCallbacks", "Lio/scanbot/sdk/camera/CameraTakePictureCallback;", "addCameraStateCallback", "", "cameraStateCallback", "addFrameHandler", "frameHandler", "Lio/scanbot/sdk/camera/FrameHandler;", "addPictureCallback", "pictureCallback", "Lio/scanbot/sdk/camera/PictureCallback;", "addTakePictureCallback", "cameraTakePictureCallback", "autoFocus", "continuousFocus", "getAttachedFrameHandler", "T", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lio/scanbot/sdk/camera/FrameHandler;", "initView", "lockToLandscape", "lockPicture", "lockToPortrait", "notifyPausedState", "notifyResumedState", "notifyTakePictureCancelled", "onDetachedFromWindow", "onLayout", "changed", "left", "", "top", "right", "bottom", "onPause", "onResume", "performSnapping", "removeCameraStateCallback", "removeFrameHandler", "removePictureCallback", "removeTakePictureCallback", "setAutoFocusOnTouch", "autoFocusOnTouch", "setAutoFocusSound", "enabled", "setCameraOpenCallback", "cameraOpenCallback", "Lio/scanbot/sdk/camera/CameraOpenCallback;", "setPictureSize", "pictureSize", "setPreviewMode", "mode", "Lio/scanbot/sdk/camera/CameraPreviewMode;", "setPreviewSize", "previewSize", "setShutterSound", "startPreview", "stopPreview", "takePicture", "acquireFocus", "unlockOrientation", "useFlash", "AutofocusCallbackImpl", "State", "sdk-base_release"})
public final class ScanbotCameraView
extends FrameLayout
implements IScanbotCameraView {
    private CameraView cameraView;
    private CameraHost cameraHost;
    private SnapFlashView snapAnimationView;
    private boolean resumed;
    private State state;
    private final Set<CameraStateCallback> stateCallbacks;
    private final Set<CameraTakePictureCallback> takePictureCallbacks;
    private final Logger logger;
    private long delayAfterFocusCompleteMs;

    @Override
    public long getDelayAfterFocusCompleteMs() {
        return this.delayAfterFocusCompleteMs;
    }

    @Override
    public void setDelayAfterFocusCompleteMs(long l) {
        this.delayAfterFocusCompleteMs = l;
    }

    private final void initView(Context context) {
        SapSingleton.getInstance().checkLicenseStatus(SdkFeature.NoSdkFeature);
        this.snapAnimationView = new SnapFlashView(context, null, 2, null);
        this.cameraView = new CameraView(context);
        CameraHost cameraHost = this.cameraHost = new CameraHost(context);
        if (cameraHost == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraHost");
        }
        cameraHost.setShutterCallback(new Camera.ShutterCallback(this){
            final /* synthetic */ ScanbotCameraView this$0;

            public final void onShutter() {
                ScanbotCameraView.access$getSnapAnimationView$p(this.this$0).playSelf();
            }
            {
                this.this$0 = scanbotCameraView;
            }
        });
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        CameraHost cameraHost2 = this.cameraHost;
        if (cameraHost2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraHost");
        }
        cameraView.setCameraHost((com.commonsware.cwac.camera.CameraHost)cameraHost2);
        CameraView cameraView2 = this.cameraView;
        if (cameraView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        cameraView2.setAutofocusCallback(new AutofocusCallbackImpl());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        layoutParams.gravity = 17;
        CameraView cameraView3 = this.cameraView;
        if (cameraView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        this.addView((View)cameraView3, 0, (ViewGroup.LayoutParams)layoutParams);
        SnapFlashView snapFlashView = this.snapAnimationView;
        if (snapFlashView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"snapAnimationView");
        }
        this.addView((View)snapFlashView, 1, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    /*
     * WARNING - void declaration
     */
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.logger.logMethod();
        super.onLayout(changed, left, top, right, bottom);
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        View view = cameraView.getChildAt(0);
        if (view == null) {
            return;
        }
        View cameraSurface = view;
        int childCount = this.getChildCount();
        int surfaceWidthSpec = View.MeasureSpec.makeMeasureSpec((int)cameraSurface.getWidth(), (int)Integer.MIN_VALUE);
        int surfaceHeightSpec = View.MeasureSpec.makeMeasureSpec((int)cameraSurface.getHeight(), (int)Integer.MIN_VALUE);
        int n = 1;
        int n2 = childCount;
        while (n < n2) {
            void i;
            View view2 = this.getChildAt((int)i);
            if (!(view2 instanceof CameraView)) {
                view2.measure(surfaceWidthSpec, surfaceHeightSpec);
                view2.layout(cameraSurface.getLeft(), cameraSurface.getTop(), cameraSurface.getRight(), cameraSurface.getBottom());
            }
            ++i;
        }
    }

    @NotNull
    public final PreviewBuffer getPreviewBuffer() {
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        return cameraView.getPreviewBuffer();
    }

    public final void onResume() {
        ExecutionUtils.ensureMainThread();
        this.logger.logMethod();
        if (this.resumed) {
            return;
        }
        this.resumed = SapSingleton.getInstance().checkLicenseStatusSilently(SdkFeature.NoSdkFeature);
        this.state = State.IDLE;
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        cameraView.onResume();
        this.notifyResumedState();
    }

    public final void onPause() {
        ExecutionUtils.ensureMainThread();
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.resumed = false;
        this.state = State.IDLE;
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        cameraView.onPause();
        this.notifyPausedState();
    }

    private final void notifyResumedState() {
        for (CameraStateCallback callback : this.stateCallbacks) {
            callback.onResume();
        }
    }

    private final void notifyPausedState() {
        for (CameraStateCallback callback : this.stateCallbacks) {
            callback.onPause();
        }
    }

    private final void notifyTakePictureCancelled() {
        for (CameraTakePictureCallback callback : this.takePictureCallbacks) {
            callback.onTakePictureCancelled();
        }
    }

    public final void startPreview() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.state = State.IDLE;
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        cameraView.startPreview();
    }

    public final void stopPreview() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        this.state = State.IDLE;
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        cameraView.stopPreview();
    }

    @Override
    public void takePicture(boolean acquireFocus) {
        this.logger.logMethod();
        if (!SapSingleton.getInstance().checkLicenseStatus(SdkFeature.NoSdkFeature).booleanValue()) {
            return;
        }
        if (this.state != State.IDLE) {
            this.state = State.IDLE;
            this.notifyTakePictureCancelled();
            if (!this.resumed) {
                return;
            }
        }
        if (acquireFocus) {
            this.state = State.PENDING_SHOOT;
            this.autoFocus();
        } else {
            this.performSnapping();
        }
    }

    private final void performSnapping() {
        this.state = State.SHOOTING;
        try {
            CameraView cameraView = this.cameraView;
            if (cameraView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
            }
            Camera.Parameters cameraParameters = cameraView.getCameraParameters();
            CameraHost cameraHost = this.cameraHost;
            if (cameraHost == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cameraHost");
            }
            PictureTransaction pictureTransaction = new PictureTransaction((com.commonsware.cwac.camera.CameraHost)cameraHost).needBitmap(false).needByteArray(true).useSingleShotMode(true);
            if (cameraParameters != null) {
                pictureTransaction = pictureTransaction.flashMode(cameraParameters.getFlashMode());
            }
            CameraView cameraView2 = this.cameraView;
            if (cameraView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
            }
            PictureTransaction pictureTransaction2 = pictureTransaction;
            Intrinsics.checkNotNullExpressionValue((Object)pictureTransaction2, (String)"pictureTransaction");
            cameraView2.takePicture(pictureTransaction2);
        }
        catch (IllegalStateException e) {
            this.state = State.IDLE;
            this.notifyTakePictureCancelled();
        }
    }

    @Override
    public void useFlash(boolean useFlash) {
        Camera.Parameters parameters;
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        if (Utils.isFlashSupported(parameters = cameraView.getCameraParameters())) {
            CameraView cameraView2 = this.cameraView;
            if (cameraView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
            }
            cameraView2.setFlashMode(useFlash ? "torch" : "off");
        }
    }

    @Override
    public void setAutoFocusOnTouch(boolean autoFocusOnTouch) {
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        cameraView.setAutoFocusOnTouch(autoFocusOnTouch);
    }

    @Override
    public void autoFocus() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        cameraView.autoFocus();
    }

    @Override
    public void continuousFocus() {
        this.logger.logMethod();
        if (!this.resumed) {
            return;
        }
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        cameraView.continuousFocus();
    }

    @Override
    public void addPictureCallback(@NotNull PictureCallback pictureCallback) {
        Intrinsics.checkNotNullParameter((Object)pictureCallback, (String)"pictureCallback");
        this.logger.logMethod();
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        cameraView.addPictureCallback(pictureCallback);
    }

    @Override
    public void removePictureCallback(@NotNull PictureCallback pictureCallback) {
        Intrinsics.checkNotNullParameter((Object)pictureCallback, (String)"pictureCallback");
        this.logger.logMethod();
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        cameraView.removePictureCallback(pictureCallback);
    }

    @Override
    public void addCameraStateCallback(@NotNull CameraStateCallback cameraStateCallback2) {
        Intrinsics.checkNotNullParameter((Object)cameraStateCallback2, (String)"cameraStateCallback");
        this.logger.logMethod();
        this.stateCallbacks.add(cameraStateCallback2);
    }

    @Override
    public void removeCameraStateCallback(@NotNull CameraStateCallback cameraStateCallback2) {
        Intrinsics.checkNotNullParameter((Object)cameraStateCallback2, (String)"cameraStateCallback");
        this.logger.logMethod();
        this.stateCallbacks.remove(cameraStateCallback2);
    }

    @Override
    public void addTakePictureCallback(@NotNull CameraTakePictureCallback cameraTakePictureCallback2) {
        Intrinsics.checkNotNullParameter((Object)cameraTakePictureCallback2, (String)"cameraTakePictureCallback");
        this.logger.logMethod();
        this.takePictureCallbacks.add(cameraTakePictureCallback2);
    }

    @Override
    public void removeTakePictureCallback(@NotNull CameraTakePictureCallback cameraTakePictureCallback2) {
        Intrinsics.checkNotNullParameter((Object)cameraTakePictureCallback2, (String)"cameraTakePictureCallback");
        this.logger.logMethod();
        this.takePictureCallbacks.remove(cameraTakePictureCallback2);
    }

    @Override
    public void setCameraOpenCallback(@NotNull CameraOpenCallback cameraOpenCallback) {
        Intrinsics.checkNotNullParameter((Object)cameraOpenCallback, (String)"cameraOpenCallback");
        this.logger.logMethod();
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        cameraView.setCameraOpenCallback(cameraOpenCallback);
    }

    @NotNull
    public final List<Camera.Size> getSupportedPictureSizes() {
        Object object;
        block5: {
            block4: {
                Camera.Parameters cameraParameters;
                this.logger.logMethod();
                CameraView cameraView = this.cameraView;
                if (cameraView == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
                }
                if ((object = (cameraParameters = cameraView.getCameraParameters())) == null) break block4;
                Camera.Parameters parameters = object;
                boolean bl = false;
                boolean bl2 = false;
                Camera.Parameters it = parameters;
                boolean bl3 = false;
                object = it.getSupportedPictureSizes();
                if (object != null) break block5;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final List<Camera.Size> getSupportedPreviewSizes() {
        Camera.Parameters cameraParameters;
        this.logger.logMethod();
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        Camera.Parameters parameters = cameraParameters = cameraView.getCameraParameters();
        Intrinsics.checkNotNullExpressionValue((Object)parameters, (String)"cameraParameters");
        List list = parameters.getSupportedPreviewSizes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"cameraParameters.supportedPreviewSizes");
        return list;
    }

    public final void setPictureSize(@NotNull Camera.Size pictureSize) {
        Camera.Parameters cameraParameters;
        Intrinsics.checkNotNullParameter((Object)pictureSize, (String)"pictureSize");
        this.logger.logMethod();
        CameraHost cameraHost = this.cameraHost;
        if (cameraHost == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraHost");
        }
        cameraHost.setDefaultPictureSize(pictureSize);
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        if ((cameraParameters = cameraView.getCameraParameters()) != null) {
            cameraParameters.setPictureSize(pictureSize.width, pictureSize.height);
            CameraView cameraView2 = this.cameraView;
            if (cameraView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
            }
            cameraView2.setCameraParameters(cameraParameters);
        }
    }

    public final void setPreviewSize(@NotNull Camera.Size previewSize) {
        Camera.Parameters cameraParameters;
        Intrinsics.checkNotNullParameter((Object)previewSize, (String)"previewSize");
        this.logger.logMethod();
        CameraHost cameraHost = this.cameraHost;
        if (cameraHost == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraHost");
        }
        cameraHost.setDefaultPreviewSize(previewSize);
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        if ((cameraParameters = cameraView.getCameraParameters()) != null) {
            cameraParameters.setPreviewSize(previewSize.width, previewSize.height);
            CameraView cameraView2 = this.cameraView;
            if (cameraView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
            }
            cameraView2.setCameraParameters(cameraParameters);
        }
    }

    public final void setAutoFocusSound(boolean enabled) {
        this.logger.logMethod();
        CameraHost cameraHost = this.cameraHost;
        if (cameraHost == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraHost");
        }
        cameraHost.setAutoFocusSound(enabled);
    }

    @RequiresApi(api=17)
    public final void setShutterSound(boolean enabled) {
        this.logger.logMethod();
        CameraHost cameraHost = this.cameraHost;
        if (cameraHost == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraHost");
        }
        cameraHost.setShutterSound(enabled);
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        cameraView.setShutterSound(enabled);
    }

    @Override
    public void setPreviewMode(@NotNull CameraPreviewMode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.logger.logMethod();
        CameraHost cameraHost = this.cameraHost;
        if (cameraHost == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraHost");
        }
        cameraHost.setPreviewMode(mode);
    }

    @Override
    public void lockToPortrait(boolean lockPicture) {
        this.logger.logMethod();
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        cameraView.lockToPortrait(lockPicture);
    }

    @Override
    public void lockToLandscape(boolean lockPicture) {
        this.logger.logMethod();
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        cameraView.lockToLandscape(lockPicture);
    }

    @Override
    public void unlockOrientation() {
        this.logger.logMethod();
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        cameraView.unlockOrientation();
    }

    @Override
    @Nullable
    public <T extends FrameHandler> T getAttachedFrameHandler(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        return cameraView.getPreviewBuffer().getAttachedFrameHandler(clazz);
    }

    @Override
    public void addFrameHandler(@NotNull FrameHandler frameHandler) {
        Intrinsics.checkNotNullParameter((Object)frameHandler, (String)"frameHandler");
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        cameraView.getPreviewBuffer().addFrameHandler(frameHandler);
    }

    @Override
    public void removeFrameHandler(@NotNull FrameHandler frameHandler) {
        Intrinsics.checkNotNullParameter((Object)frameHandler, (String)"frameHandler");
        CameraView cameraView = this.cameraView;
        if (cameraView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraView");
        }
        cameraView.getPreviewBuffer().removeFrameHandler(frameHandler);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        SnapFlashView snapFlashView = this.snapAnimationView;
        if (snapFlashView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"snapAnimationView");
        }
        snapFlashView.cancel();
    }

    public ScanbotCameraView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.state = State.IDLE;
        this.stateCallbacks = new LinkedHashSet();
        this.takePictureCallbacks = new LinkedHashSet();
        this.logger = LoggerProvider.getLogger();
        this.delayAfterFocusCompleteMs = 20L;
        this.initView(context);
    }

    public ScanbotCameraView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.state = State.IDLE;
        this.stateCallbacks = new LinkedHashSet();
        this.takePictureCallbacks = new LinkedHashSet();
        this.logger = LoggerProvider.getLogger();
        this.delayAfterFocusCompleteMs = 20L;
        this.initView(context);
    }

    public static final /* synthetic */ State access$getState$p(ScanbotCameraView $this) {
        return $this.state;
    }

    public static final /* synthetic */ void access$setState$p(ScanbotCameraView $this, State state) {
        $this.state = state;
    }

    public static final /* synthetic */ void access$performSnapping(ScanbotCameraView $this) {
        $this.performSnapping();
    }

    public static final /* synthetic */ void access$notifyTakePictureCancelled(ScanbotCameraView $this) {
        $this.notifyTakePictureCancelled();
    }

    public static final /* synthetic */ SnapFlashView access$getSnapAnimationView$p(ScanbotCameraView $this) {
        SnapFlashView snapFlashView = $this.snapAnimationView;
        if (snapFlashView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"snapAnimationView");
        }
        return snapFlashView;
    }

    public static final /* synthetic */ void access$setSnapAnimationView$p(ScanbotCameraView $this, SnapFlashView snapFlashView) {
        $this.snapAnimationView = snapFlashView;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lio/scanbot/sdk/camera/ScanbotCameraView$AutofocusCallbackImpl;", "Lio/scanbot/sdk/camera/CameraView$AutofocusCallback;", "(Lio/scanbot/sdk/camera/ScanbotCameraView;)V", "onAutoFocusCompleted", "", "sdk-base_release"})
    private final class AutofocusCallbackImpl
    implements CameraView.AutofocusCallback {
        @Override
        public void onAutoFocusCompleted() {
            ScanbotCameraView.this.logger.logMethod();
            ScanbotCameraView.this.postDelayed(new Runnable(this){
                final /* synthetic */ AutofocusCallbackImpl this$0;

                public final void run() {
                    if (ScanbotCameraView.access$getState$p(this.this$0.ScanbotCameraView.this) == State.PENDING_SHOOT) {
                        ScanbotCameraView.access$performSnapping(this.this$0.ScanbotCameraView.this);
                    } else {
                        ScanbotCameraView.access$setState$p(this.this$0.ScanbotCameraView.this, State.IDLE);
                        ScanbotCameraView.access$notifyTakePictureCancelled(this.this$0.ScanbotCameraView.this);
                    }
                }
                {
                    this.this$0 = autofocusCallbackImpl;
                }
            }, ScanbotCameraView.this.getDelayAfterFocusCompleteMs());
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/camera/ScanbotCameraView$State;", "", "(Ljava/lang/String;I)V", "IDLE", "PENDING_SHOOT", "SHOOTING", "sdk-base_release"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State IDLE;
        public static final /* enum */ State PENDING_SHOOT;
        public static final /* enum */ State SHOOTING;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = IDLE = new State();
            stateArray[1] = PENDING_SHOOT = new State();
            stateArray[2] = SHOOTING = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }
}

