/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util;

import android.content.ContentResolver;
import android.database.CharArrayBuffer;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.net.Uri;
import android.os.Bundle;
import io.scanbot.sdk.util.log.LoggerProvider;

public class CursorUtil {
    public static void closeQuietly(Cursor cursor) {
        try {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        catch (Exception e) {
            LoggerProvider.getLogger().logException(e);
        }
    }

    public static boolean hasElements(Cursor cursor) {
        return cursor != null && cursor.getCount() > 0;
    }

    public static Cursor emptyCursor() {
        return EmptyCursor.EMPTY_CURSOR;
    }

    private static class EmptyCursor
    implements Cursor {
        static final EmptyCursor EMPTY_CURSOR = new EmptyCursor();

        private EmptyCursor() {
        }

        public int getCount() {
            return 0;
        }

        public int getPosition() {
            return 0;
        }

        public boolean move(int i) {
            return false;
        }

        public boolean moveToPosition(int i) {
            return false;
        }

        public boolean moveToFirst() {
            return false;
        }

        public boolean moveToLast() {
            return false;
        }

        public boolean moveToNext() {
            return false;
        }

        public boolean moveToPrevious() {
            return false;
        }

        public boolean isFirst() {
            return false;
        }

        public boolean isLast() {
            return false;
        }

        public boolean isBeforeFirst() {
            return false;
        }

        public boolean isAfterLast() {
            return false;
        }

        public int getColumnIndex(String s) {
            return 0;
        }

        public int getColumnIndexOrThrow(String s) throws IllegalArgumentException {
            throw new IllegalArgumentException("EmptyCursor doesn't have any columns");
        }

        public String getColumnName(int i) {
            return null;
        }

        public String[] getColumnNames() {
            return new String[0];
        }

        public int getColumnCount() {
            return 0;
        }

        public byte[] getBlob(int i) {
            return new byte[0];
        }

        public String getString(int i) {
            return null;
        }

        public void copyStringToBuffer(int i, CharArrayBuffer charArrayBuffer) {
        }

        public short getShort(int i) {
            return 0;
        }

        public int getInt(int i) {
            return 0;
        }

        public long getLong(int i) {
            return 0L;
        }

        public float getFloat(int i) {
            return 0.0f;
        }

        public double getDouble(int i) {
            return 0.0;
        }

        public int getType(int i) {
            return 0;
        }

        public boolean isNull(int i) {
            return false;
        }

        public void deactivate() {
        }

        public boolean requery() {
            return false;
        }

        public void close() {
        }

        public boolean isClosed() {
            return false;
        }

        public void registerContentObserver(ContentObserver contentObserver) {
        }

        public void unregisterContentObserver(ContentObserver contentObserver) {
        }

        public void registerDataSetObserver(DataSetObserver dataSetObserver) {
        }

        public void unregisterDataSetObserver(DataSetObserver dataSetObserver) {
        }

        public void setNotificationUri(ContentResolver contentResolver, Uri uri) {
        }

        public Uri getNotificationUri() {
            return null;
        }

        public boolean getWantsAllOnMoveCalls() {
            return false;
        }

        public void setExtras(Bundle extras) {
        }

        public Bundle getExtras() {
            return null;
        }

        public Bundle respond(Bundle bundle) {
            return null;
        }
    }
}

