/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\r\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0007H\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0007J\u001a\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0007J\u001a\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0007J\u0012\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0007J\u001c\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0007J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/scanbot/sdk/util/FileUtils;", "", "()V", "FILE_NAME_ANTIPATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "FILE_NAME_EXCEPTIONS_REGULAR_EXPRESSION", "", "MAX_FILE_NAME_LENGTH", "", "SCANBOT_SDK_FILES_DIR", "ensureDirExists", "", "directoryPath", "fail", "Ljava/io/File;", "getAppFilesDirOrShowError", "context", "Landroid/content/Context;", "directoryName", "getExternalCacheDirOrShowError", "getExternalFilesDirOrShowError", "getExternalStorageDirOrShowError", "getFilesDirOrShowError", "parentDirPath", "isFileNameSafe", "name", "", "sdk-base_release"})
public final class FileUtils {
    private static final String FILE_NAME_EXCEPTIONS_REGULAR_EXPRESSION = "[\\\\|?*<\\\">+\\[\\]/':]";
    private static final Pattern FILE_NAME_ANTIPATTERN;
    private static final int MAX_FILE_NAME_LENGTH = 250;
    @NotNull
    public static final String SCANBOT_SDK_FILES_DIR = "scanbot-sdk";
    public static final FileUtils INSTANCE;

    @JvmStatic
    public static final boolean isFileNameSafe(@NotNull CharSequence name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (TextUtils.isEmpty((CharSequence)name) || name.length() > 250) {
            return false;
        }
        Matcher matcher = FILE_NAME_ANTIPATTERN.matcher(name);
        return !matcher.find();
    }

    @JvmStatic
    @NotNull
    public static final File getExternalFilesDirOrShowError(@NotNull Context context, @Nullable String directoryName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File externalFilesDir = null;
        try {
            externalFilesDir = context.getExternalFilesDir(null);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (externalFilesDir == null) {
            return INSTANCE.fail();
        }
        File result = new File(externalFilesDir, directoryName);
        return !result.exists() && !result.mkdirs() ? INSTANCE.fail() : result;
    }

    @JvmStatic
    @NotNull
    public static final File getExternalStorageDirOrShowError(@Nullable String directoryName) throws IOException {
        File file = Environment.getExternalStorageDirectory();
        if (file == null) {
            return INSTANCE.fail();
        }
        File externalFilesDir = file;
        File result = new File(externalFilesDir, directoryName);
        return !result.exists() && !result.mkdirs() ? INSTANCE.fail() : result;
    }

    @JvmStatic
    @NotNull
    public static final File getAppFilesDirOrShowError(@NotNull Context context, @Nullable String directoryName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File internalFilesDir = null;
        try {
            internalFilesDir = context.getFilesDir();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (internalFilesDir == null) {
            return INSTANCE.fail();
        }
        File result = new File(internalFilesDir, directoryName);
        return !result.exists() && !result.mkdirs() ? INSTANCE.fail() : result;
    }

    @JvmStatic
    @NotNull
    public static final File getExternalCacheDirOrShowError(@NotNull Context context, @Nullable String directoryName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File file = context.getExternalCacheDir();
        if (file == null) {
            return INSTANCE.fail();
        }
        File externalCacheDir = file;
        File result = new File(externalCacheDir, directoryName);
        return !result.exists() && !result.mkdirs() ? INSTANCE.fail() : result;
    }

    @JvmStatic
    public static final boolean ensureDirExists(@Nullable String directoryPath) {
        if (TextUtils.isEmpty((CharSequence)directoryPath)) {
            return false;
        }
        File dir = new File(directoryPath);
        return dir.exists() || dir.mkdirs();
    }

    @JvmStatic
    @NotNull
    public static final File getFilesDirOrShowError(@Nullable String parentDirPath, @Nullable String directoryName) throws IOException {
        File filesDir = new File(parentDirPath);
        File result = new File(filesDir, directoryName);
        return !result.exists() && !result.mkdirs() ? INSTANCE.fail() : result;
    }

    private final File fail() throws IOException {
        throw (Throwable)new IOException("can't get external directory");
    }

    private FileUtils() {
    }

    static {
        FileUtils fileUtils;
        INSTANCE = fileUtils = new FileUtils();
        FILE_NAME_ANTIPATTERN = Pattern.compile(FILE_NAME_EXCEPTIONS_REGULAR_EXPRESSION, 2);
    }
}

