/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.ui.camera.FinderAspectRatio;
import io.scanbot.sdk.ui.camera.FinderOverlayView;
import io.scanbot.sdk.ui.camera.UiZoomDelegate;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 #2\u00020\u0001:\u0001$B\u0019\u0012\u0006\u0010\u001e\u001a\u00020\u001d\u0012\b\u0010 \u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0004\b!\u0010\"J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\n\u0010\tJ\u000f\u0010\u000b\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u000b\u0010\tR\u0016\u0010\u000f\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR*\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f8\u0006@FX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u00178\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001c\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u000e\u00a8\u0006%"}, d2={"Lio/scanbot/sdk/ui/camera/ZoomFinderOverlayView;", "Lio/scanbot/sdk/ui/camera/FinderOverlayView;", "Lio/scanbot/sdk/ui/camera/UiZoomDelegate;", "delegate", "", "addCameraZoomDelegate", "(Lio/scanbot/sdk/ui/camera/UiZoomDelegate;)V", "removeCameraZoomDelegate", "onAttachedToWindow", "()V", "onDetachedFromWindow", "setInitialFinderViewSize", "", "t", "F", "maxZoomLevel", "value", "v", "getZoomLevel", "()F", "setZoomLevel", "(F)V", "zoomLevel", "", "s", "Ljava/util/Set;", "zoomDelegates", "u", "requiredZoomLevel", "Landroid/content/Context;", "context", "Landroid/util/AttributeSet;", "attr", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "r", "Companion", "sdk-base_release"})
public final class ZoomFinderOverlayView
extends FinderOverlayView {
    public static final float MAX_ZOOM = 10.0f;
    public static final float DEFAULT_HEIGHT = 100.0f;
    public static final double DEFAULT_ASPECT_RATIO = 6.0;
    @NotNull
    private static final Companion r = new Companion(null);
    private final Set<UiZoomDelegate> s;
    private float t;
    private float u;
    private float v;

    /*
     * WARNING - void declaration
     */
    public ZoomFinderOverlayView(@NotNull Context context, @Nullable AttributeSet attr) {
        LinkedHashSet linkedHashSet;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"context");
        super((Context)var1_1, (AttributeSet)var2_2);
        LinkedHashSet this_ = linkedHashSet;
        linkedHashSet = new LinkedHashSet();
        v1.s = this_;
        v1.t = 1.0f;
        v1.u = 1.0f;
        v1.v = 1.0f;
    }

    public final float getZoomLevel() {
        return this.v;
    }

    public final void setZoomLevel(float value) {
        float f2;
        ZoomFinderOverlayView zoomFinderOverlayView = this;
        this.u = f2;
        f2 = RangesKt.coerceIn((float)f2, (float)1.0f, (float)this.t);
        zoomFinderOverlayView.setScaleX(f2);
        zoomFinderOverlayView.setScaleY(f2);
        Iterator iterator = zoomFinderOverlayView.s.iterator();
        while (iterator.hasNext()) {
            ((UiZoomDelegate)iterator.next()).setUiZoomLevel(f2);
        }
        this.v = f2;
    }

    /*
     * WARNING - void declaration
     */
    public final void addCameraZoomDelegate(@NotNull UiZoomDelegate delegate) {
        void var1_1;
        ZoomFinderOverlayView zoomFinderOverlayView = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"delegate");
        zoomFinderOverlayView.s.add((UiZoomDelegate)var1_1);
        delegate.setUiZoomLevel(zoomFinderOverlayView.v);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeCameraZoomDelegate(@NotNull UiZoomDelegate delegate) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"delegate");
        this.s.remove(var1_1);
    }

    public void onAttachedToWindow() {
        ZoomFinderOverlayView zoomFinderOverlayView = this;
        super.onAttachedToWindow();
        ViewParent viewParent = zoomFinderOverlayView.getParent();
        if (viewParent != null) {
            viewParent = (ViewGroup)viewParent;
            int n = viewParent.getChildCount();
            for (int i2 = 0; i2 < n; ++i2) {
                View view = viewParent.getChildAt(i2);
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"getChildAt(index)");
                if (!(view instanceof UiZoomDelegate)) continue;
                this.addCameraZoomDelegate((UiZoomDelegate)view);
            }
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
    }

    public void onDetachedFromWindow() {
        ZoomFinderOverlayView zoomFinderOverlayView = this;
        super.onDetachedFromWindow();
        zoomFinderOverlayView.s.clear();
    }

    @Override
    public void setInitialFinderViewSize() {
        int n;
        int n2;
        int n3;
        if (this.getInitialPreviewMode() == CameraPreviewMode.FIT_IN) {
            double d2 = this.getInitialPreviewWidth() != 0 && this.getInitialPreviewHeight() != 0 ? (double)this.getInitialPreviewWidth() / (double)this.getInitialPreviewHeight() : (double)this.getMeasuredWidth() / (double)this.getMeasuredHeight();
            double d3 = (double)this.getMeasuredWidth() / (double)this.getMeasuredHeight() - d2;
            double d4 = d3 == 0.0 ? 0 : (d3 < 0.0 ? -1 : 1);
            n3 = d4 < 0 ? this.getMeasuredWidth() : (int)((double)this.getMeasuredHeight() * d2);
            n2 = d4 < 0 ? (int)((double)this.getMeasuredWidth() / d2) : this.getMeasuredHeight();
        } else {
            ZoomFinderOverlayView zoomFinderOverlayView = this;
            n3 = zoomFinderOverlayView.getMeasuredWidth();
            n2 = zoomFinderOverlayView.getMeasuredHeight();
        }
        int n4 = n2;
        n2 = n3 - this.getMinFinderPadding() * 2;
        int n5 = n4 - this.getMinFinderPadding() * 2;
        Object object = this.getRequiredAspectRatiosInternal();
        double d5 = object != null && (object = (FinderAspectRatio)CollectionsKt.firstOrNull(object)) != null ? ((FinderAspectRatio)object).getWidth() / ((FinderAspectRatio)object).getHeight() : 6.0;
        if (this.getFixedFinderHeightInPx() < 0) {
            Resources resources = this.getResources();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
            DisplayMetrics displayMetrics = resources.getDisplayMetrics();
            n = (int)TypedValue.applyDimension((int)1, (float)100.0f, (DisplayMetrics)displayMetrics);
        } else {
            n = this.getFixedFinderHeightInPx();
        }
        ZoomFinderOverlayView zoomFinderOverlayView = this;
        double d6 = n;
        double d7 = d6 * d5;
        double d8 = RangesKt.coerceAtMost((double)d7, (double)n2);
        double d9 = d8 / d7 * d6;
        float f2 = RangesKt.coerceIn((float)((float)n2 / (float)d8), (float)1.0f, (float)10.0f);
        zoomFinderOverlayView.t = f2 = RangesKt.coerceIn((float)(n5 / n), (float)1.0f, (float)f2);
        zoomFinderOverlayView.setZoomLevel(RangesKt.coerceIn((float)zoomFinderOverlayView.u, (float)1.0f, (float)f2));
        int n6 = (zoomFinderOverlayView.getMeasuredHeight() - (int)d9) / 2;
        int n7 = (zoomFinderOverlayView.getMeasuredWidth() - (int)d8) / 2;
        zoomFinderOverlayView.setPadding(n7, n6, n7, n6);
        zoomFinderOverlayView.adjustDescriptionPosition(n6);
        zoomFinderOverlayView.invalidate();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\t\u0010\nR\u0016\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0016\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00020\u00058\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lio/scanbot/sdk/ui/camera/ZoomFinderOverlayView$Companion;", "", "", "DEFAULT_ASPECT_RATIO", "D", "", "DEFAULT_HEIGHT", "F", "MAX_ZOOM", "<init>", "()V", "sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

