/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.blob;

import android.content.res.AssetManager;
import android.net.Uri;
import io.scanbot.sdk.blob.BlobFactory;
import io.scanbot.sdk.blob.BlobType;
import io.scanbot.sdk.entity.Blob;
import io.scanbot.sdk.entity.Language;
import io.scanbot.sdk.exceptions.files.blobManager.BlobsDirectoryException;
import io.scanbot.sdk.exceptions.files.blobManager.BlobsException;
import io.scanbot.sdk.persistence.BlobStoreStrategy;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u00106\u001a\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u00020:09J\u0018\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020:2\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u00020<2\u0006\u0010=\u001a\u00020:H\u0002J\u000e\u0010A\u001a\u00020<2\u0006\u0010=\u001a\u00020:J\u000e\u0010B\u001a\u00020<2\u0006\u0010C\u001a\u00020DJ\u0010\u0010E\u001a\u00020\u000f2\u0006\u0010C\u001a\u00020DH\u0002J\u000e\u0010F\u001a\u0002072\u0006\u0010=\u001a\u00020:R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0011R\u001a\u0010\u0016\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0017\u0010\u0014\u001a\u0004\b\u0018\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001a\u0010\u0014\u001a\u0004\b\u001b\u0010\u0011R\u001a\u0010\u001c\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001d\u0010\u0014\u001a\u0004\b\u001e\u0010\u0011R\u001a\u0010\u001f\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b \u0010\u0014\u001a\u0004\b!\u0010\u0011R\u001a\u0010\"\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b#\u0010\u0014\u001a\u0004\b$\u0010\u0011R\u001a\u0010%\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b&\u0010\u0014\u001a\u0004\b'\u0010\u0011R\u001a\u0010(\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b)\u0010\u0014\u001a\u0004\b*\u0010\u0011R\u001a\u0010+\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b,\u0010\u0014\u001a\u0004\b-\u0010\u0011R\u0011\u0010.\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0011R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00102\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0011R\u0011\u00104\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0011\u00a8\u0006G"}, d2={"Lio/scanbot/sdk/blob/BlobManager;", "", "blobStoreStrategy", "Lio/scanbot/sdk/persistence/BlobStoreStrategy;", "assetManager", "Landroid/content/res/AssetManager;", "blobFactory", "Lio/scanbot/sdk/blob/BlobFactory;", "(Lio/scanbot/sdk/persistence/BlobStoreStrategy;Landroid/content/res/AssetManager;Lio/scanbot/sdk/blob/BlobFactory;)V", "allLanguagesWithAvailableOcrBlobs", "", "Lio/scanbot/sdk/entity/Language;", "getAllLanguagesWithAvailableOcrBlobs", "()Ljava/util/Set;", "banksDataFile", "Ljava/io/File;", "getBanksDataFile", "()Ljava/io/File;", "barcodeBinarizationModelFile", "getBarcodeBinarizationModelFile$annotations", "()V", "getBarcodeBinarizationModelFile", "barcodeDetectionModelFile", "getBarcodeDetectionModelFile$annotations", "getBarcodeDetectionModelFile", "blurEstimatorModelFile", "getBlurEstimatorModelFile$annotations", "getBlurEstimatorModelFile", "checkDigitPredictionModelFile", "getCheckDigitPredictionModelFile$annotations", "getCheckDigitPredictionModelFile", "dcModelsFolderFile", "getDcModelsFolderFile$annotations", "getDcModelsFolderFile", "documentDetectorModelFile", "getDocumentDetectorModelFile$annotations", "getDocumentDetectorModelFile", "filterPredictionModelFile", "getFilterPredictionModelFile$annotations", "getFilterPredictionModelFile", "genericTextRecognizerModelsFolderFile", "getGenericTextRecognizerModelsFolderFile$annotations", "getGenericTextRecognizerModelsFolderFile", "idCardScannerModelsFolderFile", "getIdCardScannerModelsFolderFile$annotations", "getIdCardScannerModelsFolderFile", "imageProcessorModelsFolderFile", "getImageProcessorModelsFolderFile", "logger", "Lio/scanbot/sdk/util/log/Logger;", "mrzCascadeFile", "getMrzCascadeFile", "ocrBlobsDirectory", "getOcrBlobsDirectory", "allBlobsAvailable", "", "blobs", "", "Lio/scanbot/sdk/entity/Blob;", "copyFromAssets", "", "blob", "blobUri", "Landroid/net/Uri;", "ensureDirectoryCreated", "fetch", "forceFetch", "blobType", "Lio/scanbot/sdk/blob/BlobType;", "getLocalFileStrict", "isBlobAvailable", "sdk-base_release"})
public final class BlobManager {
    @NotNull
    private final BlobStoreStrategy a;
    @NotNull
    private final AssetManager b;
    @NotNull
    private final BlobFactory c;
    @NotNull
    private final Logger d;

    /*
     * WARNING - void declaration
     */
    public BlobManager(@NotNull BlobStoreStrategy blobStoreStrategy, @NotNull AssetManager assetManager, @NotNull BlobFactory blobFactory) {
        void var3_3;
        void var2_2;
        void var1_1;
        BlobManager blobManager = this;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"blobStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"assetManager");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"blobFactory");
        this.a = var1_1;
        this.b = var2_2;
        blobManager.c = var3_3;
        blobManager.d = LoggerProvider.getLogger();
    }

    @Deprecated(message="barcodeDetectionModel is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getBarcodeDetectionModelFile$annotations() {
    }

    @Deprecated(message="barcodeBinarizationModel is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getBarcodeBinarizationModelFile$annotations() {
    }

    @Deprecated(message="blurEstimatorModel file is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getBlurEstimatorModelFile$annotations() {
    }

    @Deprecated(message="filterPredictionModelFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getFilterPredictionModelFile$annotations() {
    }

    @Deprecated(message="check_digit_model files are outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getCheckDigitPredictionModelFile$annotations() {
    }

    @Deprecated(message="dc_forms_models files are outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getDcModelsFolderFile$annotations() {
    }

    @Deprecated(message="idCardScannerModelsFolderFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getIdCardScannerModelsFolderFile$annotations() {
    }

    @Deprecated(message="genericTextRecognizerModelsFolderFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getGenericTextRecognizerModelsFolderFile$annotations() {
    }

    @Deprecated(message="documentDetectorModelFile is outdated and removed from the library assets.", level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getDocumentDetectorModelFile$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    private final File a(BlobType blobType) throws IOException {
        void var1_1;
        File this_ = ((BlobManager)((Object)this_)).a.getLocalFileFor((BlobType)var1_1);
        if (this_.exists()) {
            return this_;
        }
        throw new BlobsException("Can't get file for blob type: " + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void a(Blob blob, Uri blobUri) throws IOException {
        String string = blobUri.getPath();
        if (string != null) {
            void var1_1;
            FileUtils.copyInputStreamToFile((InputStream)this.b.open(string), (File)new File(var1_1.getLocalPath()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void a(Blob blob) throws IOException {
        void var1_1;
        File file = new File(var1_1.getLocalPath()).getParentFile();
        if (!file.exists() && !file.mkdirs()) {
            throw new BlobsDirectoryException("Can't create destination directory");
        }
    }

    public final boolean allBlobsAvailable(@NotNull Collection<Blob> blobs) throws IOException {
        Collection<Blob> collection = blobs;
        Intrinsics.checkNotNullParameter(collection, (String)"blobs");
        Iterator<Blob> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.isBlobAvailable(iterator.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isBlobAvailable(@NotNull Blob blob) throws IOException {
        boolean bl;
        block5: {
            block4: {
                void var1_1;
                File file;
                Intrinsics.checkNotNullParameter((Object)blob, (String)"blob");
                File file2 = file;
                file2(var1_1.getLocalPath());
                InputStream inputStream = ((BlobManager)((Object)inputStream)).b.open(var1_1.getRemotePath());
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"assetManager.open(blob.remotePath)");
                try {
                    if (!file.exists()) break block4;
                }
                catch (Throwable throwable) {
                    inputStream.close();
                    throw throwable;
                }
                long l = inputStream.available();
                if (l != file2.length()) break block4;
                bl = true;
                break block5;
            }
            bl = false;
        }
        inputStream.close();
        return bl;
    }

    @NotNull
    public final Set<Language> getAllLanguagesWithAvailableOcrBlobs() throws IOException {
        BlobManager blobManager = this_;
        EnumSet<Language> this_ = EnumSet.noneOf(Language.class);
        Intrinsics.checkNotNullExpressionValue(this_, (String)"noneOf(Language::class.java)");
        File[] fileArray = blobManager.a.getOcrDataDirectory().listFiles();
        if (fileArray == null) {
            return this_;
        }
        for (Object object : fileArray) {
            if (object.isDirectory()) continue;
            String string = FilenameUtils.removeExtension((String)object.getName());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tessBlobName");
            object = Language.Companion.languageByTessTag(string);
            if (object == null) continue;
            this_.add((Language)((Object)object));
        }
        return this_;
    }

    @NotNull
    public final File getOcrBlobsDirectory() throws IOException {
        File this_ = ((BlobManager)((Object)this_)).a.getOcrDataDirectory();
        if (!this_.exists() && !this_.mkdirs()) {
            throw new BlobsDirectoryException("Can't get OCR blobs directory");
        }
        return this_;
    }

    @NotNull
    public final File getBanksDataFile() throws IOException {
        return this.a(BlobType.BANKS_DATA);
    }

    @NotNull
    public final File getBarcodeDetectionModelFile() {
        return this.a.getLocalFileFor(BlobType.BARCODE_DETECTION_MODEL);
    }

    @NotNull
    public final File getBarcodeBinarizationModelFile() {
        return this.a.getLocalFileFor(BlobType.BARCODE_BINARIZATION_MODEL);
    }

    @NotNull
    public final File getBlurEstimatorModelFile() throws IOException {
        return this.a.getLocalFileFor(BlobType.BLUR_ESTIMATOR_MODEL);
    }

    @NotNull
    public final File getMrzCascadeFile() throws IOException {
        return this.a(BlobType.MRZ_CASCADE);
    }

    @NotNull
    public final File getFilterPredictionModelFile() throws IOException {
        return this.a.getLocalFileFor(BlobType.FILTER_PREDICTION_MODEL);
    }

    @NotNull
    public final File getCheckDigitPredictionModelFile() throws IOException {
        return this.a.getLocalFileFor(BlobType.CHECK_DIGIT_RECOGNITION_MODEL);
    }

    @NotNull
    public final File getDcModelsFolderFile() {
        return this.a.getLocalFileFor(BlobType.DC_FORM_MODELS);
    }

    @NotNull
    public final File getIdCardScannerModelsFolderFile() {
        return this.a.getLocalFileFor(BlobType.IDCARD_SCANNER_MODELS);
    }

    @NotNull
    public final File getGenericTextRecognizerModelsFolderFile() {
        return this.a.getLocalFileFor(BlobType.GENERIC_TEXT_RECOGNIZER_MODELS);
    }

    @NotNull
    public final File getDocumentDetectorModelFile() {
        return this.a.getLocalFileFor(BlobType.DOC_DETECTOR_MODEL);
    }

    @NotNull
    public final File getImageProcessorModelsFolderFile() throws IOException {
        return this.a.getLocalFileFor(BlobType.IMAGE_PROCESSOR_MODELS);
    }

    /*
     * WARNING - void declaration
     */
    public final void fetch(@NotNull Blob blob) throws IOException {
        void var1_1;
        void v0 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v0, (String)"blob");
        if (this_.isBlobAvailable((Blob)v0)) {
            return;
        }
        BlobManager blobManager = this_;
        void v2 = var1_1;
        this_.a((Blob)var1_1);
        BlobManager this_ = Uri.parse((String)v2.getRemotePath());
        Intrinsics.checkNotNullExpressionValue((Object)this_, (String)"blobUri");
        blobManager.a((Blob)v2, (Uri)this_);
    }

    public final void forceFetch(@NotNull BlobType blobType) throws IOException {
        Iterator<Blob> iterator;
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"blobType");
        iterator = this.c.getBlobsForType((BlobType)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            this.fetch(iterator.next());
        }
    }
}

