/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ImageFormat;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import androidx.camera.core.ImageProxy;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\bH\u0007J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lio/scanbot/sdk/ui/camera/util/PreviewImageUtil;", "", "()V", "convertNV21ToBitmap", "Landroid/graphics/Bitmap;", "nv21Image", "", "imageWidth", "", "imageHeight", "imageOrientation", "convertYUV420toNV21", "image", "Landroidx/camera/core/ImageProxy;", "sdk-camera_release"})
public final class PreviewImageUtil {
    @NotNull
    public static final PreviewImageUtil INSTANCE = new PreviewImageUtil();

    private PreviewImageUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Bitmap convertNV21ToBitmap(@NotNull byte[] nv21Image, int imageWidth, int imageHeight, int imageOrientation) {
        Bitmap bitmap;
        Throwable throwable;
        ByteArrayOutputStream byteArrayOutputStream;
        block12: {
            void var3_6;
            Matrix matrix;
            Rect rect;
            YuvImage yuvImage;
            void var2_5;
            void var1_4;
            ByteArrayOutputStream byteArrayOutputStream2;
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"nv21Image");
            byteArrayOutputStream = byteArrayOutputStream2;
            byteArrayOutputStream2 = new ByteArrayOutputStream();
            throwable = null;
            try {
                yuvImage = new YuvImage(byArray, 17, (int)var1_4, (int)var2_5, null);
                rect = new Rect(0, 0, (int)var1_4, (int)var2_5);
            }
            catch (Throwable throwable2) {
                try {
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    CloseableKt.closeFinally((Closeable)byteArrayOutputStream, (Throwable)throwable2);
                    throw throwable3;
                }
            }
            yuvImage.compressToJpeg(rect, 100, (OutputStream)byteArrayOutputStream);
            byte[] byArray2 = byteArrayOutputStream2.toByteArray();
            int n2 = 0;
            bitmap = BitmapFactory.decodeByteArray((byte[])byArray2, (int)n2, (int)byArray2.length);
            if (imageOrientation == 0) break block12;
            Bitmap bitmap2 = bitmap;
            bitmap = matrix;
            bitmap();
            float f2 = (float)var3_6;
            matrix.postRotate(f2);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)var1_4, (int)var2_5, (Matrix)bitmap, (boolean)false);
        }
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"resultBitmap");
        CloseableKt.closeFinally((Closeable)byteArrayOutputStream, throwable);
        return bitmap;
    }

    public static /* synthetic */ Bitmap convertNV21ToBitmap$default(byte[] byArray, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        return PreviewImageUtil.convertNV21ToBitmap(byArray, n2, n3, n4);
    }

    @JvmStatic
    @NotNull
    public static final byte[] convertYUV420toNV21(@NotNull ImageProxy image) {
        ImageProxy imageProxy;
        ImageProxy imageProxy2 = image;
        Intrinsics.checkNotNullParameter((Object)imageProxy2, (String)"image");
        Rect rect = imageProxy2.getCropRect();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"image.cropRect");
        int n2 = imageProxy.getFormat();
        int n3 = rect.width();
        int n4 = rect.height();
        ImageProxy.PlaneProxy[] planeProxyArray = imageProxy2.getPlanes();
        Intrinsics.checkNotNullExpressionValue((Object)planeProxyArray, (String)"image.planes");
        int n5 = n3 * n4;
        byte[] byArray = new byte[n5 * ImageFormat.getBitsPerPixel((int)n2) / 8];
        byte[] byArray2 = new byte[planeProxyArray[0].getRowStride()];
        int n6 = 0;
        int n7 = 1;
        int n8 = 0;
        int n9 = planeProxyArray.length;
        while (n8 < n9) {
            int n10 = n8;
            int n11 = n10 + 1;
            if (n10 != 0) {
                if (n8 != 1) {
                    if (n8 == 2) {
                        n7 = 2;
                        n6 = n5;
                    }
                } else {
                    n6 = n5 + 1;
                    n7 = 2;
                }
            } else {
                n6 = 0;
                n7 = 1;
            }
            ByteBuffer byteBuffer = planeProxyArray[n8].getBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"planes[i].buffer");
            int n12 = planeProxyArray[n8].getRowStride();
            int n13 = planeProxyArray[n8].getPixelStride();
            int n14 = n8 == 0 ? 0 : 1;
            int n15 = n3 >> n14;
            int n16 = n4 >> n14;
            byteBuffer.position(n12 * (rect.top >> n14) + n13 * (rect.left >> n14));
            n14 = 0;
            while (n14 < n16) {
                int n17;
                int n18 = n14 + 1;
                if (n13 == 1 && n7 == 1) {
                    byteBuffer.get(byArray, n6, n15);
                    n6 += n15;
                    n17 = n15;
                } else {
                    n17 = (n15 - 1) * n13 + 1;
                    byteBuffer.get(byArray2, 0, n17);
                    int n19 = 0;
                    while (n19 < n15) {
                        byArray[n6] = byArray2[n19++ * n13];
                        n6 += n7;
                    }
                }
                if (n14 < n16 - 1) {
                    ByteBuffer byteBuffer2 = byteBuffer;
                    byteBuffer2.position(byteBuffer2.position() + n12 - n17);
                }
                n14 = n18;
            }
            n8 = n11;
        }
        return byArray;
    }
}

