/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.chequescanner;

import io.scanbot.chequescanner.model.Result;
import io.scanbot.sap.SapManager;
import io.scanbot.sap.SdkFeature;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.camera.BaseResultHandler;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.chequescanner.ChequeScanner;
import io.scanbot.sdk.security.SapSingleton;
import io.scanbot.sdk.ui.camera.IScanbotCameraView;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0003\u001a\u001b\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001c\u0010\u0014\u001a\u00020\t2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0002J\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/scanbot/sdk/chequescanner/ChequeScannerFrameHandler;", "Lio/scanbot/sdk/camera/FrameHandler;", "chequeScanner", "Lio/scanbot/sdk/chequescanner/ChequeScanner;", "(Lio/scanbot/sdk/chequescanner/ChequeScanner;)V", "handlers", "", "Lio/scanbot/sdk/chequescanner/ChequeScannerFrameHandler$ResultHandler;", "isEnabled", "", "logger", "Lio/scanbot/sdk/util/log/Logger;", "sapManager", "Lio/scanbot/sap/SapManager;", "addResultHandler", "", "handler", "handleFrame", "previewFrame", "Lio/scanbot/sdk/camera/FrameHandler$Frame;", "notifyHandlers", "result", "Lio/scanbot/sdk/camera/FrameHandlerResult;", "Lio/scanbot/chequescanner/model/Result;", "Lio/scanbot/sdk/SdkLicenseError;", "removeResultHandler", "ChequeScannerResultHandler", "Companion", "ResultHandler", "sdk-cheque_release"})
public final class ChequeScannerFrameHandler
implements FrameHandler {
    private final Set<ResultHandler> handlers;
    private final SapManager sapManager;
    private final Logger logger;
    @JvmField
    public boolean isEnabled;
    private final ChequeScanner chequeScanner;
    public static final Companion Companion = new Companion(null);

    public synchronized boolean handleFrame(@NotNull FrameHandler.Frame previewFrame) {
        boolean bl;
        Result recognitionResult;
        Intrinsics.checkNotNullParameter((Object)previewFrame, (String)"previewFrame");
        this.logger.logMethod();
        if (!this.isEnabled) {
            return false;
        }
        if (!this.sapManager.checkLicenseStatus(SdkFeature.Cheque).booleanValue()) {
            this.notifyHandlers((FrameHandlerResult<Result, SdkLicenseError>)((FrameHandlerResult)new FrameHandlerResult.Failure((Object)new SdkLicenseError())));
            return false;
        }
        Result result = recognitionResult = this.chequeScanner.recognizeCheque(previewFrame.getFrame(), previewFrame.getWidth(), previewFrame.getHeight(), previewFrame.getFrameOrientation());
        if (result != null) {
            Result result2 = result;
            boolean bl2 = false;
            boolean bl3 = false;
            Result it = result2;
            boolean bl4 = false;
            bl = this.notifyHandlers((FrameHandlerResult<Result, SdkLicenseError>)((FrameHandlerResult)new FrameHandlerResult.Success((Object)it)));
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addResultHandler(@NotNull ResultHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Set<ResultHandler> set = this.handlers;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            bl2 = this.handlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeResultHandler(@NotNull ResultHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Set<ResultHandler> set = this.handlers;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            bl2 = this.handlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean notifyHandlers(FrameHandlerResult<Result, SdkLicenseError> result) {
        boolean handled = false;
        Set<ResultHandler> set = this.handlers;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (set) {
            boolean bl3 = false;
            for (ResultHandler handler : this.handlers) {
                handled |= handler.handle(result);
            }
            Unit unit = Unit.INSTANCE;
        }
        return handled;
    }

    public ChequeScannerFrameHandler(@NotNull ChequeScanner chequeScanner) {
        Intrinsics.checkNotNullParameter((Object)chequeScanner, (String)"chequeScanner");
        this.chequeScanner = chequeScanner;
        this.handlers = new LinkedHashSet();
        this.sapManager = SapSingleton.getInstance();
        this.logger = LoggerProvider.getLogger();
        this.isEnabled = true;
    }

    @JvmStatic
    @NotNull
    public static final ChequeScannerFrameHandler attach(@NotNull IScanbotCameraView cameraView, @NotNull ChequeScanner chequeScanner) {
        return Companion.attach(cameraView, chequeScanner);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a8\u0006\u0004"}, d2={"Lio/scanbot/sdk/chequescanner/ChequeScannerFrameHandler$ResultHandler;", "Lio/scanbot/sdk/camera/BaseResultHandler;", "Lio/scanbot/chequescanner/model/Result;", "Lio/scanbot/sdk/SdkLicenseError;", "sdk-cheque_release"})
    public static interface ResultHandler
    extends BaseResultHandler<Result, SdkLicenseError> {
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/scanbot/sdk/chequescanner/ChequeScannerFrameHandler$ChequeScannerResultHandler;", "Lio/scanbot/sdk/chequescanner/ChequeScannerFrameHandler$ResultHandler;", "()V", "sdk-cheque_release"})
    public static abstract class ChequeScannerResultHandler
    implements ResultHandler {
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lio/scanbot/sdk/chequescanner/ChequeScannerFrameHandler$Companion;", "", "()V", "attach", "Lio/scanbot/sdk/chequescanner/ChequeScannerFrameHandler;", "cameraView", "Lio/scanbot/sdk/ui/camera/IScanbotCameraView;", "chequeScanner", "Lio/scanbot/sdk/chequescanner/ChequeScanner;", "sdk-cheque_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ChequeScannerFrameHandler attach(@NotNull IScanbotCameraView cameraView, @NotNull ChequeScanner chequeScanner) {
            Intrinsics.checkNotNullParameter((Object)cameraView, (String)"cameraView");
            Intrinsics.checkNotNullParameter((Object)chequeScanner, (String)"chequeScanner");
            ChequeScannerFrameHandler chequeScannerFrameHandler = (ChequeScannerFrameHandler)cameraView.getAttachedFrameHandler(ChequeScannerFrameHandler.class);
            if (chequeScannerFrameHandler == null) {
                chequeScannerFrameHandler = new ChequeScannerFrameHandler(chequeScanner);
            }
            ChequeScannerFrameHandler frameHandler = chequeScannerFrameHandler;
            cameraView.addFrameHandler((FrameHandler)frameHandler);
            return frameHandler;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

