/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util.pdf;

import android.graphics.Rect;
import android.graphics.RectF;
import io.scanbot.sdk.process.PDFPageSize;
import io.scanbot.sdk.util.pdf.PdfUtils$WhenMappings;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\"\u0010\u0017\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014H\u0007J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\b\u0010\u001d\u001a\u00020\u000eH\u0007J\u0018\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0007J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/scanbot/sdk/util/pdf/PdfUtils;", "", "()V", "A4_HEIGHT_INCHES", "", "A4_HEIGHT_UNITS", "A4_WIDTH_INCHES", "A4_WIDTH_UNITS", "UNIT_SIZE_INCHES", "US_LETTER_HEIGHT_INCHES", "US_LETTER_HEIGHT_UNITS", "US_LETTER_WIDTH_INCHES", "US_LETTER_WIDTH_UNITS", "a4PhysicalBounds", "Landroid/graphics/RectF;", "bounds", "calculateA4PageBounds", "rotatedRect", "calculateFixedA4PageBounds", "width", "", "height", "calculateFixedUSLetterPageBounds", "calculatePageBounds", "pageSize", "Lio/scanbot/sdk/process/PDFPageSize;", "Landroid/graphics/Rect;", "rotation", "calculateUSLetterPageBounds", "defaultPhysicalBounds", "fitToPhysicalBounds", "physicalBounds", "usLetterPhysicalBounds", "sdk-common_release"})
public final class PdfUtils {
    private static final float UNIT_SIZE_INCHES = 0.013888889f;
    private static final float A4_HEIGHT_INCHES = 11.692f;
    private static final float A4_WIDTH_INCHES = 8.27f;
    private static final float A4_HEIGHT_UNITS = 841.82404f;
    private static final float A4_WIDTH_UNITS = 595.44f;
    private static final float US_LETTER_HEIGHT_INCHES = 10.98f;
    private static final float US_LETTER_WIDTH_INCHES = 8.5f;
    private static final float US_LETTER_HEIGHT_UNITS = 790.55994f;
    private static final float US_LETTER_WIDTH_UNITS = 612.0f;
    public static final PdfUtils INSTANCE;

    @JvmStatic
    @NotNull
    public static final RectF defaultPhysicalBounds() {
        return new RectF(0.0f, 0.0f, 11.692f, 11.692f);
    }

    @JvmStatic
    @NotNull
    public static final RectF a4PhysicalBounds(@NotNull RectF bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        boolean isPortrait = bounds.width() <= bounds.height();
        return isPortrait ? new RectF(0.0f, 0.0f, 8.27f, 11.692f) : new RectF(0.0f, 0.0f, 11.692f, 8.27f);
    }

    @JvmStatic
    @NotNull
    public static final RectF usLetterPhysicalBounds(@NotNull RectF bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        boolean isPortrait = bounds.width() <= bounds.height();
        return isPortrait ? new RectF(0.0f, 0.0f, 8.5f, 10.98f) : new RectF(0.0f, 0.0f, 10.98f, 8.5f);
    }

    @JvmStatic
    @NotNull
    public static final RectF fitToPhysicalBounds(@NotNull RectF bounds, @NotNull RectF physicalBounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)physicalBounds, (String)"physicalBounds");
        float f = physicalBounds.width() / (bounds.width() * 0.013888889f);
        float f2 = physicalBounds.height() / (bounds.height() * 0.013888889f);
        boolean bl = false;
        float scaleFactor = Math.min(f, f2);
        return new RectF(0.0f, 0.0f, bounds.width() * scaleFactor, bounds.height() * scaleFactor);
    }

    /*
     * Enabled aggressive block sorting
     */
    @JvmStatic
    @NotNull
    public static final RectF calculatePageBounds(@Nullable PDFPageSize pageSize, @NotNull Rect bounds, int rotation) {
        RectF rectF;
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Locale defaultLocale = Locale.getDefault();
        int width = 0;
        int height = 0;
        if (rotation == 90 || rotation == 270) {
            width = bounds.height();
            height = bounds.width();
        } else {
            width = bounds.width();
            height = bounds.height();
        }
        RectF rotatedRect = new RectF(0.0f, 0.0f, (float)width, (float)height);
        PDFPageSize pDFPageSize = pageSize;
        if (pDFPageSize != null) {
            switch (PdfUtils$WhenMappings.$EnumSwitchMapping$0[pDFPageSize.ordinal()]) {
                case 1: {
                    rectF = INSTANCE.calculateA4PageBounds(rotatedRect);
                    return rectF;
                }
                case 2: {
                    rectF = INSTANCE.calculateFixedA4PageBounds(width, height);
                    return rectF;
                }
                case 3: {
                    rectF = INSTANCE.calculateUSLetterPageBounds(rotatedRect);
                    return rectF;
                }
                case 4: {
                    rectF = INSTANCE.calculateFixedUSLetterPageBounds(width, height);
                    return rectF;
                }
                case 5: {
                    if (defaultLocale == Locale.US) {
                        rectF = INSTANCE.calculateUSLetterPageBounds(rotatedRect);
                        return rectF;
                    }
                    rectF = INSTANCE.calculateA4PageBounds(rotatedRect);
                    return rectF;
                }
                case 6: {
                    float imageRatio = (float)width / (float)height;
                    float a4Ratio = width <= height ? 0.7073212f : 1.4137849f;
                    float usLetterRatio = width <= height ? 0.7741349f : 1.2917646f;
                    float f = imageRatio - a4Ratio;
                    boolean bl = false;
                    float f2 = Math.abs(f);
                    f = imageRatio - usLetterRatio;
                    bl = false;
                    if (f2 <= Math.abs(f)) {
                        rectF = INSTANCE.calculateA4PageBounds(rotatedRect);
                        return rectF;
                    }
                    rectF = INSTANCE.calculateUSLetterPageBounds(rotatedRect);
                    return rectF;
                }
                case 7: {
                    rectF = new RectF(0.0f, 0.0f, (float)width, (float)height);
                    return rectF;
                }
            }
        }
        rectF = rotatedRect;
        return rectF;
    }

    private final RectF calculateFixedUSLetterPageBounds(int width, int height) {
        float usLetterPageWidth = width <= height ? 612.0f : 790.55994f;
        float usLetterPageHeight = width <= height ? 790.55994f : 612.0f;
        return new RectF(0.0f, 0.0f, usLetterPageWidth, usLetterPageHeight);
    }

    private final RectF calculateFixedA4PageBounds(int width, int height) {
        float a4PageWidth = width <= height ? 595.44f : 841.82404f;
        float a4PageHeight = width <= height ? 841.82404f : 595.44f;
        return new RectF(0.0f, 0.0f, a4PageWidth, a4PageHeight);
    }

    private final RectF calculateUSLetterPageBounds(RectF rotatedRect) {
        return PdfUtils.fitToPhysicalBounds(rotatedRect, PdfUtils.usLetterPhysicalBounds(rotatedRect));
    }

    private final RectF calculateA4PageBounds(RectF rotatedRect) {
        return PdfUtils.fitToPhysicalBounds(rotatedRect, PdfUtils.a4PhysicalBounds(rotatedRect));
    }

    private PdfUtils() {
    }

    static {
        PdfUtils pdfUtils;
        INSTANCE = pdfUtils = new PdfUtils();
    }
}

