/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.util.bitmap;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b5\u00106J\u0019\u0010\u0005\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\n\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\f\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0007\u00a2\u0006\u0004\b\f\u0010\rJ3\u0010\u0015\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J3\u0010\u001c\u001a\u0004\u0018\u00010\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ+\u0010\u001c\u001a\u0004\u0018\u00010\u00072\b\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u001c\u0010 J+\u0010\u001c\u001a\u0004\u0018\u00010\u00072\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u001c\u0010!J'\u0010&\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b&\u0010'J/\u0010*\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u0010H\u0003\u00a2\u0006\u0004\b*\u0010+J%\u0010,\u001a\u0004\u0018\u00010\u00072\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\u0010#\u001a\u0004\u0018\u00010\"H\u0007\u00a2\u0006\u0004\b,\u0010-J\u0019\u00100\u001a\u0004\u0018\u00010\u00072\u0006\u0010/\u001a\u00020.H\u0007\u00a2\u0006\u0004\b0\u00101J'\u00104\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b4\u0010!\u00a8\u00067"}, d2={"Lio/scanbot/sdk/util/bitmap/BitmapUtils;", "", "", "path", "Landroid/graphics/Rect;", "getBitmapBounds", "(Ljava/lang/String;)Landroid/graphics/Rect;", "Landroid/graphics/Bitmap;", "bitmap", "", "isBitmapValid", "(Landroid/graphics/Bitmap;)Z", "getContentBounds", "(Landroid/graphics/Bitmap;)Landroid/graphics/Rect;", "Landroid/graphics/Bitmap$CompressFormat;", "format", "", "quality", "Ljava/io/File;", "file", "", "compress", "(Landroid/graphics/Bitmap;Landroid/graphics/Bitmap$CompressFormat;ILjava/io/File;)V", "Landroid/content/res/Resources;", "res", "imageRes", "targetWidth", "targetHeight", "createPreview", "(Landroid/content/res/Resources;III)Landroid/graphics/Bitmap;", "", "image", "([BII)Landroid/graphics/Bitmap;", "(Landroid/graphics/Bitmap;II)Landroid/graphics/Bitmap;", "Landroid/graphics/BitmapFactory$Options;", "options", "reqWidth", "reqHeight", "calculateInSampleSize", "(Landroid/graphics/BitmapFactory$Options;II)I", "width", "height", "a", "(IIII)I", "decodeQuietly", "(Ljava/lang/String;Landroid/graphics/BitmapFactory$Options;)Landroid/graphics/Bitmap;", "Landroid/graphics/drawable/Drawable;", "drawable", "drawableToBitmap", "(Landroid/graphics/drawable/Drawable;)Landroid/graphics/Bitmap;", "maxHeight", "maxWidth", "scaleIfNeeded", "<init>", "()V", "sdk-common_release"})
public final class BitmapUtils {
    @NotNull
    public static final BitmapUtils INSTANCE = new BitmapUtils();

    private BitmapUtils() {
    }

    @JvmStatic
    @NotNull
    public static final Rect getBitmapBounds(@Nullable String path) {
        String string;
        BitmapFactory.Options options;
        Rect rect = new Rect();
        BitmapFactory.Options options2 = options;
        options2();
        options2.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options2);
        int n = options.outWidth;
        int n2 = options.outHeight;
        rect.set(0, 0, n, n2);
        return rect;
    }

    @JvmStatic
    public static final boolean isBitmapValid(@Nullable Bitmap bitmap) {
        Bitmap bitmap2;
        return bitmap != null && !bitmap2.isRecycled();
    }

    @JvmStatic
    @NotNull
    public static final Rect getContentBounds(@Nullable Bitmap bitmap) throws NullPointerException {
        if (bitmap != null) {
            int n;
            Bitmap bitmap2;
            Bitmap bitmap3 = bitmap2;
            int n2 = bitmap3.getWidth();
            int n3 = bitmap3.getHeight();
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = bitmap3.getHeight();
            if (n7 > 0) {
                while (true) {
                    int n8 = n6 + 1;
                    n = 0;
                    int n9 = bitmap2.getWidth();
                    if (n9 > 0) {
                        while (true) {
                            int n10 = n;
                            int n11 = n10 + 1;
                            if (bitmap2.getPixel(n10, n6) != 0) {
                                if (n < n2) {
                                    n2 = n;
                                }
                                if (n6 < n3) {
                                    n3 = n6;
                                }
                                if (n <= n4) {
                                    n = n4;
                                }
                                if (n6 > n5) {
                                    n5 = n6;
                                }
                            } else {
                                n = n4;
                            }
                            if (n11 < n9) {
                                n4 = n;
                                n = n11;
                                continue;
                            }
                            break;
                        }
                    } else {
                        n = n4;
                    }
                    if (n8 < n7) {
                        n4 = n;
                        n6 = n8;
                        continue;
                    }
                    break;
                }
            } else {
                n = n4;
            }
            return new Rect(n2, n3, n, n5);
        }
        throw new NullPointerException("Bitmap is null");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmStatic
    public static final void compress(@NotNull Bitmap bitmap, @Nullable Bitmap.CompressFormat format, int quality, @Nullable File file) throws IOException {
        Throwable throwable2;
        FileOutputStream fileOutputStream;
        block5: {
            FileOutputStream fileOutputStream2;
            void v3;
            void v2;
            Bitmap bitmap2;
            FileOutputStream fileOutputStream3;
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            Object var4_4 = null;
            fileOutputStream = fileOutputStream3;
            try {
                void var3_3;
                void var2_2;
                void var1_1;
                Bitmap bitmap22;
                bitmap2 = bitmap22;
                v2 = var1_1;
                v3 = var2_2;
                FileOutputStream fileOutputStream4 = fileOutputStream;
                fileOutputStream2 = fileOutputStream4;
                fileOutputStream4((File)var3_3);
            }
            catch (Throwable throwable2) {
                fileOutputStream = var4_4;
                break block5;
            }
            try {
                bitmap2.compress((Bitmap.CompressFormat)v2, (int)v3, (OutputStream)fileOutputStream2);
            }
            catch (Throwable throwable2) {
                break block5;
            }
            IOUtils.closeQuietly((OutputStream)fileOutputStream3);
            return;
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
        throw throwable2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final Bitmap createPreview(@Nullable Resources res, int imageRes, int targetWidth, int targetHeight) {
        void var3_3;
        void var2_2;
        void var1_1;
        Resources resources;
        BitmapFactory.Options options;
        if (imageRes <= 0) {
            return null;
        }
        BitmapFactory.Options options2 = options;
        options2();
        options2.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)resources, (int)var1_1, (BitmapFactory.Options)options2);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, (int)var2_2, (int)var3_3);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)resources, (int)var1_1, (BitmapFactory.Options)options2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final Bitmap createPreview(@Nullable byte[] image, int targetWidth, int targetHeight) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        BitmapFactory.Options options;
        if (image == null) {
            return null;
        }
        BitmapFactory.Options options2 = options;
        options2();
        options2.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options2);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options, (int)var1_1, (int)var2_2);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final Bitmap createPreview(@Nullable Bitmap image, int targetWidth, int targetHeight) {
        void var2_2;
        int n;
        Bitmap bitmap;
        if (image == null) {
            return null;
        }
        Bitmap bitmap2 = bitmap;
        void v1 = n;
        Bitmap bitmap3 = bitmap;
        n = bitmap3.getWidth();
        n = BitmapUtils.a((int)v1, (int)var2_2, n, bitmap3.getHeight());
        return Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)(bitmap2.getWidth() / n), (int)(bitmap.getHeight() / n), (boolean)false);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final int calculateInSampleSize(@NotNull BitmapFactory.Options options, int reqWidth, int reqHeight) {
        void var2_3;
        BitmapFactory.Options options2;
        BitmapFactory.Options options3 = options2;
        Intrinsics.checkNotNullParameter((Object)options3, (String)"options");
        int n = options3.outHeight;
        return BitmapUtils.a(reqWidth, (int)var2_3, options3.outWidth, n);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    private static final int a(int reqWidth, int reqHeight, int width, int height) {
        void var2_2;
        void var1_1;
        int n;
        int n2;
        void var3_3;
        int n3 = width > var3_3 ? 1 : 0;
        if (n3 != (n2 = n > var1_1)) {
            void v0 = var2_2;
            var2_2 = var3_3;
            var3_3 = v0;
        }
        n3 = 1;
        if (var3_3 > var1_1 || var2_2 > n) {
            void v1 = var2_2;
            var2_2 = var3_3 / 2;
            var3_3 = v1 / 2;
            while (var2_2 / n3 > var1_1 && var3_3 / n3 > n) {
                n3 *= 2;
            }
        }
        return n3;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final Bitmap decodeQuietly(@Nullable String path, @Nullable BitmapFactory.Options options) {
        void var1_1;
        String string;
        File file;
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        File file2 = file;
        return new File(string).exists() && file2.isFile() ? BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)var1_1) : null;
    }

    @JvmStatic
    @Nullable
    public static final Bitmap drawableToBitmap(@NotNull Drawable drawable) {
        Canvas canvas;
        Drawable drawable2;
        BitmapDrawable bitmapDrawable;
        Drawable drawable3 = drawable;
        Intrinsics.checkNotNullParameter((Object)drawable3, (String)"drawable");
        if (drawable3 instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable2).getBitmap() != null) {
            return bitmapDrawable.getBitmap().copy(Bitmap.Config.ARGB_8888, true);
        }
        if (drawable2.getIntrinsicWidth() > 0 && drawable2.getIntrinsicHeight() > 0) {
            bitmapDrawable = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNullExpressionValue((Object)bitmapDrawable, (String)"{\n            Bitmap.cre\u2026nfig.ARGB_8888)\n        }");
        } else {
            bitmapDrawable = Bitmap.Config.ARGB_8888;
            bitmapDrawable = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)bitmapDrawable);
            Intrinsics.checkNotNullExpressionValue((Object)bitmapDrawable, (String)"{\n            Bitmap.cre\u2026ed of 1x1 pixel\n        }");
        }
        Drawable drawable4 = drawable2;
        drawable2 = canvas;
        int n = new Canvas((Bitmap)bitmapDrawable).getWidth();
        int n2 = drawable2.getHeight();
        drawable4.setBounds(0, 0, n, n2);
        drawable4.draw((Canvas)drawable2);
        return bitmapDrawable;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Bitmap scaleIfNeeded(@NotNull Bitmap image, int maxHeight, int maxWidth) {
        void var2_3;
        Bitmap bitmap;
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkNotNullParameter((Object)bitmap2, (String)"image");
        if (maxHeight < bitmap2.getHeight() || var2_3 < bitmap.getWidth()) {
            void var1_2;
            float f = Math.min((float)var2_3 / (float)bitmap.getWidth(), (float)var1_2 / (float)bitmap.getHeight());
            int n = MathKt.roundToInt((float)(f * (float)bitmap.getWidth()));
            bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n, (int)MathKt.roundToInt((float)(f * (float)bitmap.getHeight())), (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"{\n            val ratio \u2026 height, false)\n        }");
        }
        return bitmap;
    }
}

