/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.PointF;
import android.util.AttributeSet;
import io.scanbot.sdk.camera.CameraPreviewMode;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.contourdetector.ContourDetectorFrameHandler;
import io.scanbot.sdk.core.contourdetector.DetectionStatus;
import io.scanbot.sdk.core.contourdetector.PageAspectRatio;
import io.scanbot.sdk.ui.camera.AdaptiveFinderOverlayViewKt;
import io.scanbot.sdk.ui.camera.FinderAspectRatio;
import io.scanbot.sdk.ui.camera.FinderOverlayView;
import io.scanbot.sdk.util.PolygonHelper;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u0012\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d\u00a2\u0006\u0004\b\u001f\u0010 JD\u0010\u000e\u001a\u00020\r2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0002H\u0004J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0002R\u0016\u0010\u0014\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0013R\u0017\u0010\u001a\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006!"}, d2={"Lio/scanbot/sdk/ui/camera/AdaptiveFinderOverlayView;", "Lio/scanbot/sdk/ui/camera/FinderOverlayView;", "", "Lio/scanbot/sdk/ui/camera/FinderAspectRatio;", "requiredAspectRatios", "Lio/scanbot/sdk/core/contourdetector/DetectionStatus;", "detectionStatus", "", "frameWidth", "frameHeight", "frameOrientation", "Landroid/graphics/PointF;", "polygon", "", "handleDetectionResult", "paddingLeftRight", "paddingTopBottom", "a", "Landroid/animation/AnimatorSet;", "Landroid/animation/AnimatorSet;", "finderAnimation", "Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler$ResultHandler;", "b", "Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler$ResultHandler;", "getContourDetectorFrameHandler", "()Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler$ResultHandler;", "contourDetectorFrameHandler", "Landroid/content/Context;", "context", "Landroid/util/AttributeSet;", "attr", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "sdk-docdetection_release"})
public class AdaptiveFinderOverlayView
extends FinderOverlayView {
    @NotNull
    public AnimatorSet a;
    @NotNull
    public final ContourDetectorFrameHandler.ResultHandler b;

    /*
     * WARNING - void declaration
     */
    public AdaptiveFinderOverlayView(@NotNull Context context, @Nullable AttributeSet attr) {
        void var2_2;
        void var1_1;
        AdaptiveFinderOverlayView adaptiveFinderOverlayView = this;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"context");
        super((Context)v1, (AttributeSet)var2_2);
        adaptiveFinderOverlayView.a = new AnimatorSet();
        adaptiveFinderOverlayView.b = arg_0 -> AdaptiveFinderOverlayView.a(adaptiveFinderOverlayView, arg_0);
    }

    public static final boolean a(AdaptiveFinderOverlayView this$0, FrameHandlerResult result) {
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        FrameHandlerResult frameHandlerResult = result;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)frameHandlerResult, (String)"result");
        if (frameHandlerResult instanceof FrameHandlerResult.Success) {
            ContourDetectorFrameHandler.DetectedFrame detectedFrame;
            detectedFrame = (ContourDetectorFrameHandler.DetectedFrame)((FrameHandlerResult.Success)detectedFrame).getValue();
            List<FinderAspectRatio> list = detectedFrame.requiredPageAspectRatios;
            list = list == null ? CollectionsKt.emptyList() : AdaptiveFinderOverlayViewKt.toFinderAspectRatios((List<PageAspectRatio>)list);
            AdaptiveFinderOverlayView adaptiveFinderOverlayView2 = adaptiveFinderOverlayView;
            ContourDetectorFrameHandler.DetectedFrame detectedFrame2 = detectedFrame;
            adaptiveFinderOverlayView = detectedFrame2.detectionStatus;
            int n = detectedFrame2.frameWidth;
            int n2 = detectedFrame2.frameHeight;
            int n3 = detectedFrame2.frameOrientation;
            List<PointF> list2 = detectedFrame2.polygon;
            adaptiveFinderOverlayView2.handleDetectionResult(list, (DetectionStatus)adaptiveFinderOverlayView, n, n2, n3, list2);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final void a(AdaptiveFinderOverlayView this$0, int $paddingLeftRight, int $paddingTopBottom) {
        void var2_2;
        void var1_1;
        AdaptiveFinderOverlayView adaptiveFinderOverlayView = this$0;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        adaptiveFinderOverlayView.a((int)var1_1, (int)var2_2);
    }

    public static final void a(AdaptiveFinderOverlayView this$0, ValueAnimator valueAnimator) {
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Object object = valueAnimator.getAnimatedValue();
        if (object != null) {
            adaptiveFinderOverlayView.setOverlayRightPadding((Integer)object);
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
    }

    public static final void b(AdaptiveFinderOverlayView this$0, ValueAnimator valueAnimator) {
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Object object = valueAnimator.getAnimatedValue();
        if (object != null) {
            adaptiveFinderOverlayView.setOverlayLeftPadding((Integer)object);
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
    }

    public static final void c(AdaptiveFinderOverlayView this$0, ValueAnimator valueAnimator) {
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Object object = valueAnimator.getAnimatedValue();
        if (object != null) {
            adaptiveFinderOverlayView.setOverlayTopPadding((Integer)object);
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
    }

    public static final void d(AdaptiveFinderOverlayView this$0, ValueAnimator valueAnimator) {
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Object object = valueAnimator.getAnimatedValue();
        if (object != null) {
            AdaptiveFinderOverlayView adaptiveFinderOverlayView2 = adaptiveFinderOverlayView;
            adaptiveFinderOverlayView2.setOverlayBottomPadding((Integer)object);
            adaptiveFinderOverlayView2.initPaintAndRect();
            adaptiveFinderOverlayView2.invalidate();
            adaptiveFinderOverlayView2.resizeContentViews();
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
    }

    @NotNull
    public final ContourDetectorFrameHandler.ResultHandler getContourDetectorFrameHandler() {
        return this.b;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void handleDetectionResult(@NotNull List<FinderAspectRatio> requiredAspectRatios, @NotNull DetectionStatus detectionStatus, int frameWidth, int frameHeight, int frameOrientation, @NotNull List<? extends PointF> polygon) {
        void var1_16;
        void var1_10;
        int n;
        double d;
        void var4_22;
        void var3_19;
        int n2;
        void var5_26;
        List list;
        void var6_28;
        void var2_17;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"requiredAspectRatios");
        Intrinsics.checkNotNullParameter((Object)var2_17, (String)"detectionStatus");
        Intrinsics.checkNotNullParameter((Object)var6_28, (String)"polygon");
        if (this.getFixedFinderWidthInPx() > 0 && this.getFixedFinderHeightInPx() > 0) {
            return;
        }
        if (var1_1.isEmpty() ^ true) {
            this.setRequiredAspectRatiosInternal((List)var1_1);
        }
        if ((list = this.getRequiredAspectRatios()) == null) return;
        if (list.isEmpty()) return;
        if (this.a.isRunning()) {
            return;
        }
        if (!(var6_28.isEmpty() ^ true)) return;
        if (var2_17 != DetectionStatus.OK && var2_17 != DetectionStatus.OK_BUT_BAD_ANGLES && var2_17 != DetectionStatus.OK_BUT_BAD_ASPECT_RATIO && var2_17 != DetectionStatus.OK_BUT_TOO_SMALL) {
            if (var2_17 != DetectionStatus.OK_OFF_CENTER) return;
        }
        if (this.getInitialPreviewMode() == CameraPreviewMode.FIT_IN) {
            n2 = var5_26 % 180;
            void var7_29 = n2 == 0 ? var3_19 : var4_22;
            n2 = n2 == 0 ? var4_22 : var3_19;
            d = (double)var7_29 / (double)n2;
            double d2 = (double)this.getMeasuredWidth() / (double)this.getMeasuredHeight() - d;
            double d3 = d2 == 0.0 ? 0 : (d2 < 0.0 ? -1 : 1);
            n2 = (int)d3;
            n = d3 < 0 ? this.getMeasuredWidth() : (int)((double)this.getMeasuredHeight() * d);
            n2 = n2 < 0 ? (int)((double)this.getMeasuredWidth() / d) : this.getMeasuredHeight();
        } else {
            AdaptiveFinderOverlayView adaptiveFinderOverlayView = this;
            n = adaptiveFinderOverlayView.getMeasuredWidth();
            n2 = adaptiveFinderOverlayView.getMeasuredHeight();
        }
        int n3 = n2 - this.getMinFinderPadding() * 2;
        d = n - this.getMinFinderPadding() * 2;
        double d4 = n3;
        double d5 = d / d4;
        float f = PolygonHelper.Companion.approximatePolygonAspectRatio((List)var6_28, (int)var3_19, (int)var4_22, (int)var5_26);
        Iterator iterator = list.iterator();
        if (!iterator.hasNext()) {
            Object var1_5 = null;
        } else {
            void var4_24;
            Iterator iterator2 = iterator;
            Object t = iterator2.next();
            if (iterator2.hasNext()) {
                FinderAspectRatio finderAspectRatio = (FinderAspectRatio)t;
                double d6 = f;
                double d7 = Math.abs(d6 - finderAspectRatio.getWidth() / finderAspectRatio.getHeight());
                do {
                    Object t2;
                    FinderAspectRatio finderAspectRatio2;
                    double d8;
                    if (Double.compare(d7, d8 = Math.abs(d6 - (finderAspectRatio2 = (FinderAspectRatio)(t2 = iterator.next())).getWidth() / finderAspectRatio2.getHeight())) <= 0) continue;
                    Object t3 = t2;
                    d7 = d8;
                } while (iterator.hasNext());
            }
            void var1_6 = var4_24;
        }
        FinderAspectRatio finderAspectRatio = (FinderAspectRatio)var1_10;
        double d9 = finderAspectRatio == null ? d5 : finderAspectRatio.getWidth() / finderAspectRatio.getHeight();
        if (d9 < d5) {
            AdaptiveFinderOverlayView adaptiveFinderOverlayView = this;
            d9 = d4 * d9;
            int n5 = adaptiveFinderOverlayView.getMinFinderPadding();
            n5 = (adaptiveFinderOverlayView.getMeasuredHeight() - n2) / 2 + n5;
            n2 = (int)(((double)n - d9) / (double)2);
            n2 = (this.getMeasuredWidth() - n) / 2 + n2;
        } else {
            AdaptiveFinderOverlayView adaptiveFinderOverlayView = this;
            d9 = d / d9;
            int n7 = (int)(((double)n2 - d9) / (double)2);
            n7 = (adaptiveFinderOverlayView.getMeasuredHeight() - n2) / 2 + n7;
            n2 = adaptiveFinderOverlayView.getMinFinderPadding();
            n2 = (adaptiveFinderOverlayView.getMeasuredWidth() - n) / 2 + n2;
        }
        AdaptiveFinderOverlayView adaptiveFinderOverlayView = this;
        adaptiveFinderOverlayView.post(() -> AdaptiveFinderOverlayView.a(adaptiveFinderOverlayView, n2, (int)var1_16));
    }

    /*
     * WARNING - void declaration
     */
    public final void a(int paddingLeftRight, int paddingTopBottom) {
        void var2_3;
        void var1_1;
        if (this.getOverlayRightPadding() == var1_1 && this.getOverlayLeftPadding() == var1_1 && this.getOverlayTopPadding() == var2_3 && this.getOverlayBottomPadding() == var2_3) {
            return;
        }
        AdaptiveFinderOverlayView adaptiveFinderOverlayView = this;
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{this.getOverlayRightPadding(), var1_1});
        valueAnimator.addUpdateListener(arg_0 -> AdaptiveFinderOverlayView.a(this, arg_0));
        ValueAnimator valueAnimator2 = ValueAnimator.ofInt((int[])new int[]{this.getOverlayLeftPadding(), var1_1});
        valueAnimator2.addUpdateListener(arg_0 -> AdaptiveFinderOverlayView.b(this, arg_0));
        ValueAnimator valueAnimator3 = ValueAnimator.ofInt((int[])new int[]{this.getOverlayTopPadding(), var2_3});
        valueAnimator3.addUpdateListener(arg_0 -> AdaptiveFinderOverlayView.c(this, arg_0));
        ValueAnimator valueAnimator4 = ValueAnimator.ofInt((int[])new int[]{this.getOverlayBottomPadding(), var2_3});
        valueAnimator4.addUpdateListener(arg_0 -> AdaptiveFinderOverlayView.d(this, arg_0));
        adaptiveFinderOverlayView.a.end();
        adaptiveFinderOverlayView.a.cancel();
        this.a = new AnimatorSet();
        this.a.playTogether(new Animator[]{valueAnimator, valueAnimator2, valueAnimator3, valueAnimator4});
        this.a.setDuration(200L);
        this.a.start();
    }
}

