/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.camera;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.LayoutTransition;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.PointF;
import android.util.AttributeSet;
import androidx.core.graphics.Insets;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.contourdetector.ContourDetectorFrameHandler;
import io.scanbot.sdk.core.contourdetector.DetectionStatus;
import io.scanbot.sdk.ui.camera.AdaptiveFinderOverlayViewKt;
import io.scanbot.sdk.ui.camera.FinderAspectRatio;
import io.scanbot.sdk.ui.camera.FinderOverlayView;
import io.scanbot.sdk.util.PolygonHelper;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, bv={}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u0012\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d\u00a2\u0006\u0004\b\u001f\u0010 JD\u0010\u000e\u001a\u00020\r2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0002H\u0004J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002R\u0016\u0010\u0014\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0013R\u0017\u0010\u001a\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006!"}, d2={"Lio/scanbot/sdk/ui/camera/AdaptiveFinderOverlayView;", "Lio/scanbot/sdk/ui/camera/FinderOverlayView;", "", "Lio/scanbot/sdk/ui/camera/FinderAspectRatio;", "requiredAspectRatios", "Lio/scanbot/sdk/core/contourdetector/DetectionStatus;", "detectionStatus", "", "frameWidth", "frameHeight", "frameOrientation", "Landroid/graphics/PointF;", "polygon", "", "handleDetectionResult", "Landroidx/core/graphics/Insets;", "insets", "a", "Landroid/animation/AnimatorSet;", "Landroid/animation/AnimatorSet;", "finderAnimation", "Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler$ResultHandler;", "b", "Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler$ResultHandler;", "getContourDetectorFrameHandler", "()Lio/scanbot/sdk/contourdetector/ContourDetectorFrameHandler$ResultHandler;", "contourDetectorFrameHandler", "Landroid/content/Context;", "context", "Landroid/util/AttributeSet;", "attr", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "sdk-docdetection_release"})
public class AdaptiveFinderOverlayView
extends FinderOverlayView {
    @NotNull
    public AnimatorSet a;
    @NotNull
    public final ContourDetectorFrameHandler.ResultHandler b;

    /*
     * WARNING - void declaration
     */
    public AdaptiveFinderOverlayView(@NotNull Context context, @Nullable AttributeSet attr) {
        void var2_2;
        void var1_1;
        AdaptiveFinderOverlayView adaptiveFinderOverlayView = this;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"context");
        super((Context)v1, (AttributeSet)var2_2);
        adaptiveFinderOverlayView.a = new AnimatorSet();
        LayoutTransition layoutTransition = new LayoutTransition();
        layoutTransition.enableTransitionType(4);
        adaptiveFinderOverlayView.setLayoutTransition(layoutTransition);
        adaptiveFinderOverlayView.b = arg_0 -> AdaptiveFinderOverlayView.a(adaptiveFinderOverlayView, arg_0);
    }

    public static final boolean a(AdaptiveFinderOverlayView this$0, FrameHandlerResult result) {
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        FrameHandlerResult frameHandlerResult = result;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)frameHandlerResult, (String)"result");
        if (frameHandlerResult instanceof FrameHandlerResult.Success) {
            ContourDetectorFrameHandler.DetectedFrame detectedFrame;
            detectedFrame = (ContourDetectorFrameHandler.DetectedFrame)((FrameHandlerResult.Success)detectedFrame).getValue();
            List<FinderAspectRatio> list = detectedFrame.requiredPageAspectRatios;
            if (list == null || (list = AdaptiveFinderOverlayViewKt.toFinderAspectRatios(list)) == null) {
                list = CollectionsKt.emptyList();
            }
            AdaptiveFinderOverlayView adaptiveFinderOverlayView2 = adaptiveFinderOverlayView;
            ContourDetectorFrameHandler.DetectedFrame detectedFrame2 = detectedFrame;
            adaptiveFinderOverlayView = detectedFrame2.detectionStatus;
            int n = detectedFrame2.frameWidth;
            int n2 = detectedFrame2.frameHeight;
            int n3 = detectedFrame2.frameOrientation;
            List<PointF> list2 = detectedFrame2.polygon;
            adaptiveFinderOverlayView2.handleDetectionResult(list, (DetectionStatus)adaptiveFinderOverlayView, n, n2, n3, list2);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final void a(AdaptiveFinderOverlayView this$0, Insets $calculatedInset) {
        void var1_1;
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"$calculatedInset");
        this$0.a((Insets)var1_1);
    }

    public static final void a(AdaptiveFinderOverlayView this$0, ValueAnimator valueAnimator) {
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Object object = valueAnimator.getAnimatedValue();
        if (object != null) {
            adaptiveFinderOverlayView.setOverlayRightPadding((Integer)object);
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
    }

    public static final void b(AdaptiveFinderOverlayView this$0, ValueAnimator valueAnimator) {
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Object object = valueAnimator.getAnimatedValue();
        if (object != null) {
            adaptiveFinderOverlayView.setOverlayLeftPadding((Integer)object);
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
    }

    public static final void c(AdaptiveFinderOverlayView this$0, ValueAnimator valueAnimator) {
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Object object = valueAnimator.getAnimatedValue();
        if (object != null) {
            adaptiveFinderOverlayView.setOverlayTopPadding((Integer)object);
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
    }

    public static final void d(AdaptiveFinderOverlayView this$0, ValueAnimator valueAnimator) {
        AdaptiveFinderOverlayView adaptiveFinderOverlayView;
        Intrinsics.checkNotNullParameter((Object)((Object)adaptiveFinderOverlayView), (String)"this$0");
        Object object = valueAnimator.getAnimatedValue();
        if (object != null) {
            AdaptiveFinderOverlayView adaptiveFinderOverlayView2 = adaptiveFinderOverlayView;
            adaptiveFinderOverlayView2.setOverlayBottomPadding((Integer)object);
            adaptiveFinderOverlayView2.initPaintAndRect();
            adaptiveFinderOverlayView2.invalidate();
            adaptiveFinderOverlayView2.resizeContentViews();
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
    }

    @NotNull
    public final ContourDetectorFrameHandler.ResultHandler getContourDetectorFrameHandler() {
        return this.b;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void handleDetectionResult(@NotNull List<FinderAspectRatio> requiredAspectRatios, @NotNull DetectionStatus detectionStatus, int frameWidth, int frameHeight, int frameOrientation, @NotNull List<? extends PointF> polygon) {
        void var3_13;
        void var5_20;
        void var4_17;
        void var3_6;
        FinderAspectRatio finderAspectRatio;
        void var2_4;
        List list;
        Intrinsics.checkNotNullParameter((Object)list, (String)"requiredAspectRatios");
        Intrinsics.checkNotNullParameter((Object)var2_4, (String)"detectionStatus");
        Intrinsics.checkNotNullParameter((Object)finderAspectRatio, (String)"polygon");
        if (this.getFixedFinderWidthInPx() > 0 && this.getFixedFinderHeightInPx() > 0) {
            return;
        }
        if (list.isEmpty() ^ true) {
            this.setRequiredAspectRatiosInternal(list);
        }
        if ((list = this.getRequiredAspectRatios()) == null) return;
        if (list.isEmpty()) return;
        if (this.a.isRunning()) {
            return;
        }
        if (!(finderAspectRatio.isEmpty() ^ true)) return;
        if (var2_4 != DetectionStatus.OK && var2_4 != DetectionStatus.OK_BUT_BAD_ANGLES && var2_4 != DetectionStatus.OK_BUT_BAD_ASPECT_RATIO && var2_4 != DetectionStatus.OK_BUT_TOO_SMALL) {
            if (var2_4 != DetectionStatus.OK_OFF_CENTER) return;
        }
        Pair pair = this.calculatePreviewFrameSize();
        int n = ((Number)pair.component1()).intValue();
        int n2 = ((Number)pair.component2()).intValue();
        int n3 = n2;
        int n4 = n;
        AdaptiveFinderOverlayView adaptiveFinderOverlayView = this;
        n3 = (adaptiveFinderOverlayView.getMeasuredHeight() - n3) / 2;
        n = (adaptiveFinderOverlayView.getMeasuredWidth() - n) / 2;
        Pair pair2 = adaptiveFinderOverlayView.calculateTotalPaddings(n, n3);
        int n5 = ((Number)pair2.component2()).intValue();
        int n6 = n4 - ((Number)pair2.component1()).intValue();
        n5 = n2 - n5;
        double d = (double)n6 / (double)n5;
        float f = PolygonHelper.Companion.approximatePolygonAspectRatio((List)finderAspectRatio, (int)var3_6, (int)var4_17, (int)var5_20);
        Iterator iterator = list.iterator();
        if (!iterator.hasNext()) {
            Object var3_8 = null;
        } else {
            void var5_22;
            Iterator iterator2 = iterator;
            Object t = iterator2.next();
            if (iterator2.hasNext()) {
                FinderAspectRatio finderAspectRatio2 = (FinderAspectRatio)t;
                double d2 = f;
                double d3 = Math.abs(d2 - finderAspectRatio2.getWidth() / finderAspectRatio2.getHeight());
                do {
                    Object t2;
                    double d4;
                    if (Double.compare(d3, d4 = Math.abs(d2 - (finderAspectRatio = (FinderAspectRatio)(t2 = iterator.next())).getWidth() / finderAspectRatio.getHeight())) <= 0) continue;
                    Object t3 = t2;
                    d3 = d4;
                } while (iterator.hasNext());
            }
            void var3_9 = var5_22;
        }
        FinderAspectRatio finderAspectRatio3 = (FinderAspectRatio)var3_13;
        if (finderAspectRatio3 != null) {
            d = finderAspectRatio3.getWidth() / finderAspectRatio3.getHeight();
        }
        AdaptiveFinderOverlayView adaptiveFinderOverlayView2 = this;
        Pair pair3 = adaptiveFinderOverlayView2.calculateTargetSize(d, n5, n6);
        int n7 = ((Number)pair3.component1()).intValue();
        int n8 = ((Number)pair3.component2()).intValue();
        n8 = (n5 - n8) / 2;
        int n10 = adaptiveFinderOverlayView2.getFinderInsets().top + n8;
        n10 = Math.max(adaptiveFinderOverlayView2.getSafeAreaInsets().top, n3) + n10;
        n8 = adaptiveFinderOverlayView2.getFinderInsets().bottom + n8;
        n3 = Math.max(adaptiveFinderOverlayView2.getSafeAreaInsets().bottom, n3) + n8;
        int n11 = (n6 - n7) / 2;
        n8 = adaptiveFinderOverlayView2.getFinderInsets().left + n11;
        int n12 = Math.max(adaptiveFinderOverlayView2.getSafeAreaInsets().left, n) + n8;
        AdaptiveFinderOverlayView adaptiveFinderOverlayView3 = this;
        int n13 = adaptiveFinderOverlayView3.getFinderInsets().right + n11;
        n13 = Math.max(adaptiveFinderOverlayView3.getSafeAreaInsets().right, n) + n13;
        Insets.of((int)n12, (int)n10, (int)n13, (int)n3);
        Insets insets = Insets.of((int)n12, (int)n10, (int)n13, (int)n3);
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"of(paddingLeft, paddingT\u2026dingRight, paddingBottom)");
        adaptiveFinderOverlayView2.post(() -> AdaptiveFinderOverlayView.a(adaptiveFinderOverlayView2, insets));
    }

    public final void a(Insets insets) {
        ValueAnimator valueAnimator;
        if (this.getOverlayRightPadding() == valueAnimator.right && this.getOverlayLeftPadding() == valueAnimator.left && this.getOverlayTopPadding() == valueAnimator.top && this.getOverlayBottomPadding() == valueAnimator.bottom) {
            return;
        }
        AdaptiveFinderOverlayView adaptiveFinderOverlayView = this;
        ValueAnimator valueAnimator2 = ValueAnimator.ofInt((int[])new int[]{this.getOverlayRightPadding(), valueAnimator.right});
        valueAnimator2.addUpdateListener(arg_0 -> AdaptiveFinderOverlayView.a(this, arg_0));
        ValueAnimator valueAnimator3 = ValueAnimator.ofInt((int[])new int[]{this.getOverlayLeftPadding(), valueAnimator.left});
        valueAnimator3.addUpdateListener(arg_0 -> AdaptiveFinderOverlayView.b(this, arg_0));
        ValueAnimator valueAnimator4 = ValueAnimator.ofInt((int[])new int[]{this.getOverlayTopPadding(), valueAnimator.top});
        valueAnimator4.addUpdateListener(arg_0 -> AdaptiveFinderOverlayView.c(this, arg_0));
        valueAnimator = ValueAnimator.ofInt((int[])new int[]{this.getOverlayBottomPadding(), valueAnimator.bottom});
        valueAnimator.addUpdateListener(arg_0 -> AdaptiveFinderOverlayView.d(this, arg_0));
        adaptiveFinderOverlayView.a.end();
        adaptiveFinderOverlayView.a.cancel();
        this.a = new AnimatorSet();
        this.a.playTogether(new Animator[]{valueAnimator2, valueAnimator3, valueAnimator4, valueAnimator});
        this.a.setDuration(200L);
        this.a.start();
    }
}

