/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.docprocessing.compose;

import android.graphics.Rect;
import android.graphics.RectF;
import crl.android.pdfwriter.PDFWriter;
import io.scanbot.sdk.docprocessing.compose.Composer;
import io.scanbot.sdk.docprocessing.compose.ComposerConfig;
import io.scanbot.sdk.docprocessing.compose.PdfConfig;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.PDFPageSize;
import io.scanbot.sdk.util.bitmap.BitmapUtils;
import io.scanbot.sdk.util.pdf.PdfUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J*\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/scanbot/sdk/docprocessing/compose/SimpleComposer;", "Lio/scanbot/sdk/docprocessing/compose/Composer;", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "pageFileStorage", "Lio/scanbot/sdk/persistence/PageFileStorage;", "(Lio/scanbot/sdk/persistence/DocumentStoreStrategy;Lio/scanbot/sdk/persistence/PageFileStorage;)V", "composeDocument", "", "document", "Lio/scanbot/sdk/entity/Document;", "pages", "", "Lio/scanbot/sdk/persistence/Page;", "composerConfig", "Lio/scanbot/sdk/docprocessing/compose/ComposerConfig;", "composePDF", "pdfWriter", "Lcrl/android/pdfwriter/PDFWriter;", "pageSize", "Lio/scanbot/sdk/process/PDFPageSize;", "writeDocumentToFile", "sdk-docprocessing_release"})
public final class SimpleComposer
implements Composer {
    private final DocumentStoreStrategy documentStoreStrategy;
    private final PageFileStorage pageFileStorage;

    @Override
    public void composeDocument(@NotNull Document document, @NotNull List<Page> pages, @NotNull ComposerConfig composerConfig) throws IOException {
        PdfConfig pdfConfig;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(pages, (String)"pages");
        Intrinsics.checkNotNullParameter((Object)composerConfig, (String)"composerConfig");
        if (document.size > 0L) {
            throw (Throwable)new IOException("Document already exists");
        }
        PDFWriter pdfWriter = new PDFWriter();
        ComposerConfig composerConfig2 = composerConfig;
        if (!(composerConfig2 instanceof PdfConfig)) {
            composerConfig2 = null;
        }
        if ((pdfConfig = (PdfConfig)composerConfig2) == null || (pdfConfig = pdfConfig.getPdfPageSize()) == null) {
            pdfConfig = PDFPageSize.FROM_IMAGE;
        }
        PdfConfig documentSize = pdfConfig;
        this.composePDF(pdfWriter, pages, (PDFPageSize)documentSize);
        this.writeDocumentToFile(document, pdfWriter);
    }

    private final void composePDF(PDFWriter pdfWriter, List<Page> pages, PDFPageSize pageSize) throws IOException {
        for (Page page : pages) {
            File document = new File(this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.DOCUMENT).getPath());
            File original = new File(this.pageFileStorage.getImageURI(page.getPageId(), PageFileStorage.PageFileType.ORIGINAL).getPath());
            File image = document.exists() ? document : original;
            Rect bounds = BitmapUtils.getBitmapBounds((String)image.getPath());
            RectF convertedBounds = PdfUtils.calculatePageBounds((PDFPageSize)pageSize, (Rect)bounds, (int)0);
            int convertedWidth = (int)convertedBounds.width();
            int convertedHeight = (int)convertedBounds.height();
            pdfWriter.newPage(convertedWidth, convertedHeight);
            pdfWriter.addJPGImageKeepRatio(convertedWidth, convertedHeight, 0, image.getPath());
        }
        pdfWriter.setDocumentInfo("/Creator (Scanbot for Android)");
    }

    static /* synthetic */ void composePDF$default(SimpleComposer simpleComposer, PDFWriter pDFWriter, List list, PDFPageSize pDFPageSize, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            pDFPageSize = PDFPageSize.FROM_IMAGE;
        }
        simpleComposer.composePDF(pDFWriter, list, pDFPageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeDocumentToFile(Document document, PDFWriter pdfWriter) throws IOException {
        File pdf = this.documentStoreStrategy.getDocumentFile(document.id, document.name);
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(pdf));
            pdfWriter.write(os);
            os.flush();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)os);
        }
    }

    public SimpleComposer(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull PageFileStorage pageFileStorage) {
        Intrinsics.checkNotNullParameter((Object)documentStoreStrategy, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)pageFileStorage, (String)"pageFileStorage");
        this.documentStoreStrategy = documentStoreStrategy;
        this.pageFileStorage = pageFileStorage;
    }
}

