/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.hicscanner;

import android.graphics.Bitmap;
import android.graphics.Rect;
import io.scanbot.hicscanner.HICRecognizer;
import io.scanbot.hicscanner.HealthInsuranceCardValidationType;
import io.scanbot.hicscanner.model.HealthInsuranceCardRecognitionResult;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.hicscanner.HealthInsuranceCardScanner;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J*\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J2\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J*\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J*\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J2\u0010\u001a\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/scanbot/sdk/hicscanner/DefaultHealthInsuranceCardScanner;", "Lio/scanbot/sdk/hicscanner/HealthInsuranceCardScanner;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "(Lio/scanbot/sdk/blob/BlobManager;)V", "hicRecognizer", "Lio/scanbot/hicscanner/HICRecognizer;", "traineddataPath", "", "detectAndRecognize", "Lio/scanbot/hicscanner/model/HealthInsuranceCardRecognitionResult;", "image", "", "width", "", "height", "orientation", "detectAndRecognizeBitmap", "Landroid/graphics/Bitmap;", "detectAndRecognizeJPEG", "detectAndRecognizeWithFinderOverlay", "finderRect", "Landroid/graphics/Rect;", "recognize", "recognizeBitmap", "recognizeJPEG", "recognizeWithFinderOverlay", "reinitWithValidationType", "", "validationType", "Lio/scanbot/hicscanner/HealthInsuranceCardValidationType;", "sdk-ehic_release"})
public final class DefaultHealthInsuranceCardScanner
implements HealthInsuranceCardScanner {
    private HICRecognizer hicRecognizer;
    private String traineddataPath;

    @Override
    public void reinitWithValidationType(@NotNull HealthInsuranceCardValidationType validationType) {
        Intrinsics.checkNotNullParameter((Object)validationType, (String)"validationType");
        String string = this.traineddataPath;
        if (string == null) {
            string = "";
        }
        this.hicRecognizer = new HICRecognizer(string, validationType);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult recognize(@NotNull byte[] image, int width, int height, int orientation) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.hicRecognizer.recognizeFromNV21(image, width, height, orientation);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult recognizeWithFinderOverlay(@NotNull byte[] image, int width, int height, int orientation, @NotNull Rect finderRect) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)finderRect, (String)"finderRect");
        return this.hicRecognizer.recognizeInAreaFromNV21(image, width, height, finderRect, orientation);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult recognizeJPEG(@NotNull byte[] image, int width, int height, int orientation) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.hicRecognizer.recognizeFromJPEG(image, width, height, orientation);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult recognizeBitmap(@NotNull Bitmap image, int orientation) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.hicRecognizer.recognizeFromBitmap(image, orientation);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult detectAndRecognize(@NotNull byte[] image, int width, int height, int orientation) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.hicRecognizer.detectAndRecognizeFromNV21(image, width, height, orientation);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult detectAndRecognizeWithFinderOverlay(@NotNull byte[] image, int width, int height, int orientation, @NotNull Rect finderRect) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)finderRect, (String)"finderRect");
        return this.hicRecognizer.detectAndRecognizeInAreaFromNV21(image, width, height, finderRect, orientation);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult detectAndRecognizeJPEG(@NotNull byte[] image, int width, int height, int orientation) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.hicRecognizer.detectAndRecognizeFromJPEG(image, width, height, orientation);
    }

    @Override
    @Nullable
    public HealthInsuranceCardRecognitionResult detectAndRecognizeBitmap(@NotNull Bitmap image, int orientation) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        return this.hicRecognizer.detectAndRecognizeFromBitmap(image, orientation);
    }

    public DefaultHealthInsuranceCardScanner(@NotNull BlobManager blobManager) {
        Intrinsics.checkNotNullParameter((Object)blobManager, (String)"blobManager");
        try {
            this.traineddataPath = blobManager.getOcrBlobsDirectory().getPath();
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("HIC scanner OCR blob is not available.");
        }
        String string = this.traineddataPath;
        if (string == null) {
            string = "";
        }
        this.hicRecognizer = new HICRecognizer(string, HealthInsuranceCardValidationType.ValidationAutoSupported);
    }
}

