/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.generictext.ui;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import io.scanbot.sdk.generic_text.R;
import io.scanbot.sdk.generictext.GenericTextWordBox;
import io.scanbot.sdk.ui.BasePolygonView;
import io.scanbot.sdk.ui.camera.UiZoomDelegate;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 @2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001@B\u0011\b\u0016\u0012\u0006\u0010:\u001a\u000209\u00a2\u0006\u0004\b;\u0010<B\u001b\b\u0016\u0012\u0006\u0010:\u001a\u000209\u0012\b\u0010>\u001a\u0004\u0018\u00010=\u00a2\u0006\u0004\b;\u0010?J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ/\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\t\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001b\u0010\u001a\u001a\u00020\u00042\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0019\u0010\u001e\u001a\u00020\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u001cH\u0014\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010\"\u001a\u00020\u00042\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b\"\u0010#R\u0016\u0010$\u001a\u00020\u00118\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0016\u0010'\u001a\u00020&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\"\u0010)\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010\u0016R\"\u0010.\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010*\u001a\u0004\b/\u0010,\"\u0004\b0\u0010\u0016R\"\u00101\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u0010*\u001a\u0004\b2\u0010,\"\u0004\b3\u0010\u0016R\u0016\u00104\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u00105R\u001c\u00106\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0016\u00108\u001a\u00020\u00118\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u0010%\u00a8\u0006A"}, d2={"Lio/scanbot/sdk/generictext/ui/WordboxPreviewView;", "Landroid/view/View;", "Lio/scanbot/sdk/ui/BasePolygonView;", "Lio/scanbot/sdk/ui/camera/UiZoomDelegate;", "", "initView", "()V", "", "confidence", "", "calculateAlpha", "(D)I", "Landroid/graphics/Rect;", "resultRect", "width", "height", "orientation", "Landroid/graphics/RectF;", "toRelativeRectF", "(Landroid/graphics/Rect;III)Landroid/graphics/RectF;", "strokeColor", "setColor", "(I)V", "", "Lio/scanbot/sdk/generictext/GenericTextWordBox;", "list", "updateCharacters", "(Ljava/util/List;)V", "Landroid/graphics/Canvas;", "canvas", "onDraw", "(Landroid/graphics/Canvas;)V", "", "zoomLevel", "setUiZoomLevel", "(F)V", "drawRect", "Landroid/graphics/RectF;", "Landroid/graphics/Paint;", "strokePaint", "Landroid/graphics/Paint;", "frameWidth", "I", "getFrameWidth", "()I", "setFrameWidth", "frameHeight", "getFrameHeight", "setFrameHeight", "frameOrientation", "getFrameOrientation", "setFrameOrientation", "cornerRadius", "F", "wordboxes", "Ljava/util/List;", "resultRectF", "Landroid/content/Context;", "context", "<init>", "(Landroid/content/Context;)V", "Landroid/util/AttributeSet;", "attrs", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "Companion", "sdk-generictext_release"})
public final class WordboxPreviewView
extends View
implements BasePolygonView,
UiZoomDelegate {
    private static final int CONFIDENCE_MAX_ALPHA = 50;
    private static final int CONFIDENCE_DIVIDER = 10000;
    private static final List<Integer> PORTRAIT_ORIENTATION;
    public static final Companion Companion;
    private List<GenericTextWordBox> wordboxes;
    private Paint strokePaint;
    private final RectF drawRect;
    private final RectF resultRectF;
    private float cornerRadius;
    private int frameWidth;
    private int frameHeight;
    private int frameOrientation;

    private final void initView() {
        WordboxPreviewView wordboxPreviewView = this;
        wordboxPreviewView.cornerRadius = wordboxPreviewView.getResources().getDimension(R.dimen.wordbox_rounded_corner_radius);
        wordboxPreviewView.strokePaint.setColor(-16711681);
        wordboxPreviewView.strokePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        wordboxPreviewView.strokePaint.setAntiAlias(true);
    }

    private final int calculateAlpha(double d) {
        double d2 = d;
        return (int)(d2 * d2 / (double)10000 * (double)50);
    }

    private final RectF toRelativeRectF(Rect rect, int n, int n2, int n3) {
        List<Integer> list = PORTRAIT_ORIENTATION;
        int n4 = list.contains(n3) ? n : n2;
        if (!list.contains(n3)) {
            n2 = n;
        }
        WordboxPreviewView wordboxPreviewView = wordboxPreviewView.resultRectF;
        float f = n4;
        ((RectF)wordboxPreviewView).left = (float)rect.left / f;
        float f2 = n2;
        ((RectF)wordboxPreviewView).top = (float)rect.top / f2;
        ((RectF)wordboxPreviewView).right = (float)rect.right / f;
        ((RectF)wordboxPreviewView).bottom = (float)rect.bottom / f2;
        return wordboxPreviewView;
    }

    public WordboxPreviewView(@NotNull Context context) {
        WordboxPreviewView wordboxPreviewView = this;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
        wordboxPreviewView.wordboxes = CollectionsKt.emptyList();
        wordboxPreviewView.strokePaint = new TextPaint();
        wordboxPreviewView.drawRect = new RectF();
        wordboxPreviewView.resultRectF = new RectF();
        wordboxPreviewView.initView();
    }

    public WordboxPreviewView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        WordboxPreviewView wordboxPreviewView = this;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, attributeSet);
        wordboxPreviewView.wordboxes = CollectionsKt.emptyList();
        wordboxPreviewView.strokePaint = new TextPaint();
        wordboxPreviewView.drawRect = new RectF();
        wordboxPreviewView.resultRectF = new RectF();
        wordboxPreviewView.initView();
    }

    static {
        Companion = new Companion(null);
        PORTRAIT_ORIENTATION = CollectionsKt.listOf((Object[])new Integer[]{0, 180});
    }

    public final int getFrameWidth() {
        return this.frameWidth;
    }

    public final void setFrameWidth(int n) {
        this.frameWidth = n;
    }

    public final int getFrameHeight() {
        return this.frameHeight;
    }

    public final void setFrameHeight(int n) {
        this.frameHeight = n;
    }

    public final int getFrameOrientation() {
        return this.frameOrientation;
    }

    public final void setFrameOrientation(int n) {
        this.frameOrientation = n;
    }

    public final void setColor(int n) {
        WordboxPreviewView wordboxPreviewView = this;
        wordboxPreviewView.strokePaint.setColor(n);
        wordboxPreviewView.invalidate();
    }

    public final void updateCharacters(@NotNull List<GenericTextWordBox> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        this.wordboxes = list;
        this.invalidate();
    }

    public void onDraw(@Nullable Canvas canvas) {
        super.onDraw(canvas);
        if (canvas != null) {
            Iterator iterator = this.wordboxes.iterator();
            while (iterator.hasNext()) {
                WordboxPreviewView wordboxPreviewView = this;
                GenericTextWordBox genericTextWordBox = (GenericTextWordBox)iterator.next();
                Rect rect = genericTextWordBox.getBoundingRect();
                int n = wordboxPreviewView.frameWidth;
                int n2 = wordboxPreviewView.frameHeight;
                int n3 = wordboxPreviewView.frameOrientation;
                rect = wordboxPreviewView.toRelativeRectF(rect, n, n2, n3);
                wordboxPreviewView.strokePaint.setAlpha(this.calculateAlpha(genericTextWordBox.getConfidenceValue()));
                wordboxPreviewView.drawRect.left = rect.left * (float)this.getWidth();
                wordboxPreviewView.drawRect.top = rect.top * (float)this.getHeight();
                wordboxPreviewView.drawRect.right = rect.right * (float)this.getWidth();
                wordboxPreviewView.drawRect.bottom = rect.bottom * (float)this.getHeight();
                genericTextWordBox = wordboxPreviewView.drawRect;
                float f = wordboxPreviewView.cornerRadius;
                Paint paint = wordboxPreviewView.strokePaint;
                float f2 = f;
                canvas.drawRoundRect((RectF)genericTextWordBox, f2, f2, paint);
            }
        }
    }

    public void setUiZoomLevel(float f) {
        WordboxPreviewView wordboxPreviewView = this;
        wordboxPreviewView.setScaleX(f);
        wordboxPreviewView.setScaleY(f);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\t\u0010\nR\u0016\u0010\u0003\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0016\u0010\u0005\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0004R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00068\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lio/scanbot/sdk/generictext/ui/WordboxPreviewView$Companion;", "", "", "CONFIDENCE_DIVIDER", "I", "CONFIDENCE_MAX_ALPHA", "", "PORTRAIT_ORIENTATION", "Ljava/util/List;", "<init>", "()V", "sdk-generictext_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

