/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.idcardscanner;

import android.graphics.Bitmap;
import android.graphics.Rect;
import io.scanbot.idcardscanner.NativeIdCardScanner;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.idcardscanner.IdCardResultsMappingKt;
import io.scanbot.sdk.idcardscanner.IdCardScanner;
import io.scanbot.sdk.idcardscanner.IdScanResult;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J<\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/scanbot/sdk/idcardscanner/DefaultIdCardScanner;", "Lio/scanbot/sdk/idcardscanner/IdCardScanner;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "(Lio/scanbot/sdk/blob/BlobManager;)V", "nativeIdCardScanner", "Lio/scanbot/idcardscanner/NativeIdCardScanner;", "scanBitmap", "Lio/scanbot/sdk/idcardscanner/IdScanResult;", "bitmap", "Landroid/graphics/Bitmap;", "shouldRecognize", "", "scanJpeg", "jpeg", "", "scanNv21", "nv21", "width", "", "height", "orientation", "finderRect", "Landroid/graphics/Rect;", "sdk-idcard_release"})
public final class DefaultIdCardScanner
implements IdCardScanner {
    private NativeIdCardScanner nativeIdCardScanner;

    @Override
    @Nullable
    public IdScanResult scanBitmap(@NotNull Bitmap bitmap, boolean shouldRecognize) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        return IdCardResultsMappingKt.mapIdCardScannerResultJniToSdk(this.nativeIdCardScanner.scanBitmap(bitmap, shouldRecognize));
    }

    @Override
    @Nullable
    public IdScanResult scanJpeg(@NotNull byte[] jpeg, boolean shouldRecognize) {
        Intrinsics.checkParameterIsNotNull((Object)jpeg, (String)"jpeg");
        return IdCardResultsMappingKt.mapIdCardScannerResultJniToSdk(this.nativeIdCardScanner.scanJpeg(jpeg, shouldRecognize));
    }

    @Override
    @Nullable
    public IdScanResult scanNv21(@NotNull byte[] nv21, int width, int height, int orientation, @Nullable Rect finderRect, boolean shouldRecognize) {
        Intrinsics.checkParameterIsNotNull((Object)nv21, (String)"nv21");
        return IdCardResultsMappingKt.mapIdCardScannerResultJniToSdk(this.nativeIdCardScanner.scanNv21(nv21, width, height, orientation, finderRect, shouldRecognize));
    }

    public DefaultIdCardScanner(@NotNull BlobManager blobManager) {
        String tessDataPath;
        String string;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)blobManager, (String)"blobManager");
        try {
            String string3 = blobManager.getIdCardScannerModelsFolderFile().getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"blobManager.idCardScannerModelsFolderFile.path");
            string2 = string3;
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("IdCard scanner trained data is not available.");
        }
        String modelsFolderPath = string2;
        try {
            string = blobManager.getOcrBlobsDirectory().getPath();
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("OCR trained data is not available.");
        }
        String string4 = tessDataPath = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"tessDataPath");
        this.nativeIdCardScanner = new NativeIdCardScanner(modelsFolderPath, string4);
    }
}

