/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.mrzscanner;

import android.graphics.Bitmap;
import android.graphics.Rect;
import io.scanbot.mrzscanner.MRZRecognizer;
import io.scanbot.mrzscanner.model.MRZRecognitionResult;
import io.scanbot.sdk.blob.BlobManager;
import io.scanbot.sdk.mrzscanner.MRZScanner;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J,\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\fH\u0016J,\u0010\u0014\u001a\u0004\u0018\u00010\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J<\u0010\u0016\u001a\u0004\u0018\u00010\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J<\u0010\u001b\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/scanbot/sdk/mrzscanner/DefaultMRZScanner;", "Lio/scanbot/sdk/mrzscanner/MRZScanner;", "blobManager", "Lio/scanbot/sdk/blob/BlobManager;", "(Lio/scanbot/sdk/blob/BlobManager;)V", "mrzRecognizer", "Lio/scanbot/mrzscanner/MRZRecognizer;", "recognizeMRZ", "Lio/scanbot/mrzscanner/model/MRZRecognitionResult;", "nv21", "", "width", "", "height", "orientation", "recognizeMRZBGR", "bgr", "recognizeMRZBitmap", "bitmap", "Landroid/graphics/Bitmap;", "recognizeMRZJPEG", "image", "recognizeMRZJPEGWithFinderOverlay", "finderRect", "Landroid/graphics/Rect;", "detectMRZ", "", "recognizeMRZWithFinderOverlay", "sdk-mrz_release"})
public final class DefaultMRZScanner
implements MRZScanner {
    private final MRZRecognizer mrzRecognizer;

    @Override
    @Nullable
    public MRZRecognitionResult recognizeMRZ(@Nullable byte[] nv21, int width, int height, int orientation) {
        return this.mrzRecognizer.recognizeMRZ(nv21, width, height, orientation);
    }

    @Override
    @Nullable
    public MRZRecognitionResult recognizeMRZBGR(@Nullable byte[] bgr, int width, int height, int orientation) {
        return this.mrzRecognizer.recognizeMRZBGR(bgr, width, height, orientation);
    }

    @Override
    @Nullable
    public MRZRecognitionResult recognizeMRZJPEG(@Nullable byte[] image, int width, int height, int orientation) {
        return this.mrzRecognizer.recognizeMRZJPEG(image, width, height, orientation);
    }

    @Override
    @Nullable
    public MRZRecognitionResult recognizeMRZJPEGWithFinderOverlay(@Nullable byte[] image, int width, int height, int orientation, @NotNull Rect finderRect, boolean detectMRZ) {
        Intrinsics.checkParameterIsNotNull((Object)finderRect, (String)"finderRect");
        return this.mrzRecognizer.recognizeMRZInAreaJPEG(image, width, height, orientation, finderRect, detectMRZ);
    }

    @Override
    @Nullable
    public MRZRecognitionResult recognizeMRZBitmap(@Nullable Bitmap bitmap, int orientation) {
        return this.mrzRecognizer.recognizeMRZBitmap(bitmap, orientation);
    }

    @Override
    @Nullable
    public MRZRecognitionResult recognizeMRZWithFinderOverlay(@Nullable byte[] nv21, int width, int height, int orientation, @NotNull Rect finderRect, boolean detectMRZ) {
        Intrinsics.checkParameterIsNotNull((Object)finderRect, (String)"finderRect");
        return this.mrzRecognizer.recognizeInAreaNV21(nv21, width, height, orientation, finderRect, detectMRZ);
    }

    public DefaultMRZScanner(@NotNull BlobManager blobManager) {
        String string;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)blobManager, (String)"blobManager");
        String mrzTraineddataPath = null;
        try {
            File file = blobManager.getOCRBlobsDirectory();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"blobManager.ocrBlobsDirectory");
            string2 = file.getPath();
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("MRZ blob is not available.");
        }
        mrzTraineddataPath = string2;
        String cascadeFilePath = null;
        try {
            File file = blobManager.getMRZCascadeFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"blobManager.mrzCascadeFile");
            string = file.getPath();
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("MRZ cascade file blob is not available.");
        }
        cascadeFilePath = string;
        String string3 = mrzTraineddataPath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"mrzTraineddataPath");
        String string4 = cascadeFilePath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"cascadeFilePath");
        this.mrzRecognizer = new MRZRecognizer(string3, string4);
    }
}

