/*
 * Decompiled with CFR 0.152.
 */
package net.doo.snap.intelligence;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.googlecode.leptonica.android.Pix;
import com.googlecode.leptonica.android.ReadFile;
import com.googlecode.tesseract.android.ResultIterator;
import com.googlecode.tesseract.android.TessBaseAPI;
import com.googlecode.tesseract.android.TessPdfRenderer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.doo.snap.entity.Document;
import net.doo.snap.entity.Language;
import net.doo.snap.entity.Page;
import net.doo.snap.intelligence.OcrSettings;
import net.doo.snap.persistence.BlobStoreStrategy;
import net.doo.snap.persistence.DocumentStoreStrategy;
import net.doo.snap.persistence.PageStoreStrategy;
import net.doo.snap.process.OcrResultBlock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class OcrPdfRenderer {
    private static final String ROTATED_TEMP_FILE_SUFFIX = "_rotated";
    private final Context context;
    private final DocumentStoreStrategy documentStoreStrategy;
    private final PageStoreStrategy pageStoreStrategy;
    private final BlobStoreStrategy blobStoreStrategy;
    private final BitmapBinarizer bitmapBinarizer;

    public OcrPdfRenderer(Context context, DocumentStoreStrategy documentStoreStrategy, PageStoreStrategy pageStoreStrategy, BlobStoreStrategy blobStoreStrategy, BitmapBinarizer bitmapBinarizer) {
        this.context = context;
        this.documentStoreStrategy = documentStoreStrategy;
        this.pageStoreStrategy = pageStoreStrategy;
        this.blobStoreStrategy = blobStoreStrategy;
        this.bitmapBinarizer = bitmapBinarizer;
    }

    public RenderIterator startRender(@NotNull Document document, @NotNull Page[] pages, @NotNull Collection<Language> languages, @NonNull OcrSettings ocrSettings) throws IOException {
        return new RenderIteratorImpl(document, pages, languages, ocrSettings);
    }

    private class RenderIteratorImpl
    implements RenderIterator {
        private final TessBaseAPI tessBaseAPI;
        private final TessPdfRenderer tessPdfRenderer;
        private final OcrSettings ocrSettings;
        private StringBuilder detectedText = new StringBuilder();
        private List<OcrResultBlock> paragraphs = new ArrayList<OcrResultBlock>();
        private List<OcrResultBlock> lines = new ArrayList<OcrResultBlock>();
        private List<OcrResultBlock> words = new ArrayList<OcrResultBlock>();
        private final Page[] pages;
        private final List<File> tempRotatedFiles = new ArrayList<File>();
        private int currentPosition = 0;

        private RenderIteratorImpl(Document document, Page[] pages, Collection<Language> languages, OcrSettings ocrSettings) throws IOException {
            this.pages = pages;
            this.ocrSettings = ocrSettings;
            OcrPdfRenderer.this.documentStoreStrategy.getDocumentDir(document.getId()).mkdirs();
            File documentFile = OcrPdfRenderer.this.documentStoreStrategy.getDocumentFile(document.getId(), document.getName());
            this.tessBaseAPI = this.initTessApi(Language.languageCodes(languages));
            this.tessPdfRenderer = new TessPdfRenderer(this.tessBaseAPI, FilenameUtils.removeExtension((String)documentFile.getPath()));
        }

        private TessBaseAPI initTessApi(String ... languageCodes) throws IOException {
            TessBaseAPI tessBaseAPI = new TessBaseAPI();
            tessBaseAPI.init(OcrPdfRenderer.this.blobStoreStrategy.getOCRDataDirectory().toString(), TextUtils.join((CharSequence)"+", (Object[])languageCodes));
            tessBaseAPI.setPageSegMode(1);
            return tessBaseAPI;
        }

        @Override
        public boolean renderNextPage() throws IOException {
            this.resetDataHolders();
            if (this.currentPosition == 0) {
                this.tessBaseAPI.beginDocument(this.tessPdfRenderer);
            }
            if (this.currentPosition >= this.pages.length || this.pages[this.currentPosition] == null) {
                return false;
            }
            Page page = this.pages[this.currentPosition];
            this.savePage(this.tessBaseAPI, this.tessPdfRenderer, page, this.detectedText);
            if (this.currentPosition == this.pages.length - 1) {
                this.tessBaseAPI.endDocument(this.tessPdfRenderer);
            }
            ++this.currentPosition;
            return true;
        }

        private void resetDataHolders() {
            this.detectedText = new StringBuilder();
            this.paragraphs = new ArrayList<OcrResultBlock>();
            this.lines = new ArrayList<OcrResultBlock>();
            this.words = new ArrayList<OcrResultBlock>();
        }

        private void savePage(@NotNull TessBaseAPI tessBaseAPI, @NotNull TessPdfRenderer tessPdfRenderer, @NotNull Page page, @NotNull StringBuilder detectedText) throws IOException {
            Pix pix;
            File imageFile = OcrPdfRenderer.this.pageStoreStrategy.getImageFile(page.getId(), Page.ImageType.OPTIMIZED);
            if (!imageFile.exists()) {
                return;
            }
            Bitmap bitmap = BitmapFactory.decodeFile((String)imageFile.getPath());
            if (this.ocrSettings.getUseRotationFromPage()) {
                bitmap = this.applyRotation(page, bitmap);
            }
            if (this.ocrSettings.getBinarizeImage()) {
                Bitmap bitmapBinarized = OcrPdfRenderer.this.bitmapBinarizer.binarizeBitmap(bitmap, false);
                pix = ReadFile.readBitmap(bitmapBinarized);
                bitmapBinarized.recycle();
            } else {
                pix = ReadFile.readBitmap(bitmap);
            }
            File rotatedPageFile = this.writeRotatedBitmapTempFile(page, bitmap);
            tessBaseAPI.addPageToDocument(pix, rotatedPageFile.getPath(), tessPdfRenderer);
            detectedText.append(tessBaseAPI.getUTF8Text());
            this.paragraphs.addAll(this.getBlocks(tessBaseAPI, 1, OcrResultBlock.OcrResultBlockType.PARAGRAPH));
            this.lines.addAll(this.getBlocks(tessBaseAPI, 2, OcrResultBlock.OcrResultBlockType.LINE));
            this.words.addAll(this.getBlocks(tessBaseAPI, 3, OcrResultBlock.OcrResultBlockType.WORD));
            pix.recycle();
            bitmap.recycle();
        }

        private List<OcrResultBlock> getBlocks(TessBaseAPI tessBaseAPI, int pageIteratorLevel, OcrResultBlock.OcrResultBlockType blockType) {
            ArrayList<OcrResultBlock> blocks = new ArrayList<OcrResultBlock>();
            Pix thresholdedImage = tessBaseAPI.getThresholdedImage();
            ResultIterator resultIterator = tessBaseAPI.getResultIterator();
            resultIterator.begin();
            blocks.add(this.extractBlock(resultIterator, pageIteratorLevel, thresholdedImage, blockType));
            while (resultIterator.next(pageIteratorLevel)) {
                blocks.add(this.extractBlock(resultIterator, pageIteratorLevel, thresholdedImage, blockType));
            }
            return blocks;
        }

        private OcrResultBlock extractBlock(ResultIterator resultIterator, int pageIteratorLevel, Pix thresholdedImage, OcrResultBlock.OcrResultBlockType blockType) {
            String text = resultIterator.getUTF8Text(pageIteratorLevel);
            int[] boundingBoxArray = resultIterator.getBoundingBox(pageIteratorLevel);
            Rect boundingBoxWithImageSize = new Rect();
            RectF boundingBox = new RectF();
            if (boundingBoxArray.length == 4) {
                boundingBoxWithImageSize = new Rect(boundingBoxArray[0], boundingBoxArray[1], boundingBoxArray[2], boundingBoxArray[3]);
                if (thresholdedImage != null) {
                    boundingBox = new RectF((float)boundingBoxArray[0] / (float)thresholdedImage.getWidth(), (float)boundingBoxArray[1] / (float)thresholdedImage.getHeight(), (float)boundingBoxArray[2] / (float)thresholdedImage.getWidth(), (float)boundingBoxArray[3] / (float)thresholdedImage.getHeight());
                }
            }
            return new OcrResultBlock(text, boundingBox, boundingBoxWithImageSize, Float.valueOf(resultIterator.confidence(pageIteratorLevel)), blockType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File writeRotatedBitmapTempFile(Page page, Bitmap bitmap) throws IOException {
            File rotatedPageFile = File.createTempFile("scanbot_", page.getId() + OcrPdfRenderer.ROTATED_TEMP_FILE_SUFFIX, OcrPdfRenderer.this.context.getExternalCacheDir());
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(rotatedPageFile);
                bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)fos);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fos);
            this.tempRotatedFiles.add(rotatedPageFile);
            return rotatedPageFile;
        }

        private Bitmap applyRotation(Page page, Bitmap bitmap) {
            Matrix matrix = new Matrix();
            matrix.setRotate((float)page.getRotationType().getDegrees());
            return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)false);
        }

        @Override
        public String getDetectedText() {
            return this.detectedText.toString();
        }

        @Override
        public List<OcrResultBlock> getDetectedParagraphs() {
            return this.paragraphs;
        }

        @Override
        public List<OcrResultBlock> getDetectedLines() {
            return this.lines;
        }

        @Override
        public List<OcrResultBlock> getDetectedWords() {
            return this.words;
        }

        @Override
        public Page getLastProcessedPage() {
            return this.currentPosition < this.pages.length ? this.pages[this.currentPosition] : null;
        }

        @Override
        public int getLastProcessedPosition() {
            return this.currentPosition - 1;
        }

        @Override
        public void recycle() {
            for (File tempFile : this.tempRotatedFiles) {
                FileUtils.deleteQuietly((File)tempFile);
            }
            this.tempRotatedFiles.clear();
            this.tessBaseAPI.end();
            this.tessPdfRenderer.recycle();
        }
    }

    public static interface BitmapBinarizer {
        public Bitmap binarizeBitmap(Bitmap var1, boolean var2);
    }

    public static interface RenderIterator {
        public boolean renderNextPage() throws IOException;

        public String getDetectedText();

        public List<OcrResultBlock> getDetectedParagraphs();

        public List<OcrResultBlock> getDetectedLines();

        public List<OcrResultBlock> getDetectedWords();

        public Page getLastProcessedPage();

        public int getLastProcessedPosition();

        public void recycle();
    }
}

