/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import android.graphics.Rect;
import android.util.Log;
import androidx.annotation.Size;
import com.googlecode.leptonica.android.Box;
import com.googlecode.leptonica.android.Pix;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public class Pixa
implements Iterable<Pix> {
    private static final String TAG;
    private final long mNativePixa;
    public final int mWidth;
    public final int mHeight;
    private boolean mRecycled;

    public static Pixa createPixa(int n) {
        return Pixa.createPixa(n, 0, 0);
    }

    public static Pixa createPixa(int n, int n2, int n3) {
        long l = Pixa.nativeCreate(n);
        if (l != 0L) {
            return new Pixa(l, n2, n3);
        }
        throw new OutOfMemoryError();
    }

    public Pixa(long l, int n, int n2) {
        this.mNativePixa = l;
        this.mWidth = n;
        this.mHeight = n2;
        this.mRecycled = false;
    }

    private static native long nativeCreate(int var0);

    private static native long nativeCopy(long var0);

    private static native long nativeSort(long var0, int var2, int var3);

    private static native boolean nativeJoin(long var0, long var2);

    private static native int nativeGetCount(long var0);

    private static native void nativeDestroy(long var0);

    private static native void nativeAddPix(long var0, long var2, int var4);

    private static native void nativeAddBox(long var0, long var2, int var4);

    private static native void nativeAdd(long var0, long var2, long var4, int var6);

    private static native boolean nativeWriteToFileRandomCmap(long var0, String var2, int var3, int var4);

    private static native void nativeReplacePix(long var0, int var2, long var3, long var5);

    private static native void nativeMergeAndReplacePix(long var0, int var2, int var3);

    private static native long nativeGetBox(long var0, int var2);

    private static native long nativeGetPix(long var0, int var2);

    private static native boolean nativeGetBoxGeometry(long var0, int var2, int[] var3);

    static {
        System.loadLibrary("lept");
        System.loadLibrary("jpgt");
        TAG = Pixa.class.getSimpleName();
    }

    public long getNativePixa() {
        if (!this.mRecycled) {
            return this.mNativePixa;
        }
        throw new IllegalStateException();
    }

    public Pixa copy() {
        if (!this.mRecycled) {
            long l = Pixa.nativeCopy(this.mNativePixa);
            if (l != 0L) {
                Pixa pixa = this;
                int n = pixa.mWidth;
                int n2 = pixa.mHeight;
                return new Pixa(l, n, n2);
            }
            throw new OutOfMemoryError();
        }
        throw new IllegalStateException();
    }

    public Pixa sort(int n, int n2) {
        if (!this.mRecycled) {
            long l = Pixa.nativeSort(this.mNativePixa, n, n2);
            if (l != 0L) {
                Pixa pixa = this;
                int n3 = pixa.mWidth;
                int n4 = pixa.mHeight;
                return new Pixa(l, n3, n4);
            }
            throw new OutOfMemoryError();
        }
        throw new IllegalStateException();
    }

    public int size() {
        if (!this.mRecycled) {
            return Pixa.nativeGetCount(this.mNativePixa);
        }
        throw new IllegalStateException();
    }

    public synchronized void recycle() {
        if (!this.mRecycled) {
            Pixa.nativeDestroy(this.mNativePixa);
            this.mRecycled = true;
        }
    }

    public void finalize() throws Throwable {
        block4: {
            try {
                if (this.mRecycled) break block4;
            }
            catch (Throwable throwable) {
                super.finalize();
                throw throwable;
            }
            Pixa pixa = this;
            Log.w((String)TAG, (String)"Pixa was not terminated using recycle()");
            pixa.recycle();
        }
        super.finalize();
    }

    public boolean join(Pixa pixa) {
        if (!this.mRecycled) {
            return Pixa.nativeJoin(this.mNativePixa, pixa.mNativePixa);
        }
        throw new IllegalStateException();
    }

    public void addPix(Pix pix, int n) {
        if (!this.mRecycled) {
            Pixa.nativeAddPix(this.mNativePixa, pix.getNativePix(), n);
            return;
        }
        throw new IllegalStateException();
    }

    public void addBox(Box box, int n) {
        if (!this.mRecycled) {
            Pixa.nativeAddBox(this.mNativePixa, box.getNativeBox(), n);
            return;
        }
        throw new IllegalStateException();
    }

    public void add(Pix pix, Box box, int n) {
        if (!this.mRecycled) {
            long l = pix.getNativePix();
            long l2 = box.getNativeBox();
            Pixa.nativeAdd(this.mNativePixa, l, l2, n);
            return;
        }
        throw new IllegalStateException();
    }

    public Box getBox(int n) {
        if (!this.mRecycled) {
            long l = Pixa.nativeGetBox(this.mNativePixa, n);
            if (l == 0L) {
                return null;
            }
            return new Box(l);
        }
        throw new IllegalStateException();
    }

    public Pix getPix(int n) {
        if (!this.mRecycled) {
            long l = Pixa.nativeGetPix(this.mNativePixa, n);
            if (l == 0L) {
                return null;
            }
            return new Pix(l);
        }
        throw new IllegalStateException();
    }

    public int getWidth() {
        if (!this.mRecycled) {
            return this.mWidth;
        }
        throw new IllegalStateException();
    }

    public int getHeight() {
        if (!this.mRecycled) {
            return this.mHeight;
        }
        throw new IllegalStateException();
    }

    public Rect getRect() {
        if (!this.mRecycled) {
            Pixa pixa = this;
            int n = pixa.mWidth;
            int n2 = pixa.mHeight;
            return new Rect(0, 0, n, n2);
        }
        throw new IllegalStateException();
    }

    public int[] getBoxGeometry(int n) {
        if (!((Pixa)object).mRecycled) {
            Pixa pixa = object;
            int[] nArray = new int[4];
            Object object = nArray;
            if (pixa.getBoxGeometry(n, nArray)) {
                return object;
            }
            return null;
        }
        throw new IllegalStateException();
    }

    public boolean getBoxGeometry(int n, @Size(min=4L) int[] nArray) {
        if (!this.mRecycled) {
            return Pixa.nativeGetBoxGeometry(this.mNativePixa, n, nArray);
        }
        throw new IllegalStateException();
    }

    public Rect getBoxRect(int object) {
        Object object2;
        int[] nArray = ((Pixa)object2).getBoxGeometry((int)object);
        object2 = nArray;
        if (nArray == null) {
            return null;
        }
        Object object3 = object2;
        Object object4 = object3[0];
        object = object3[1];
        Object object5 = object3[2];
        reference var3_5 = object3[3];
        reference var2_4 = object4 + object5;
        var3_5 = object + var3_5;
        return new Rect((int)object4, (int)object, (int)var2_4, (int)var3_5);
    }

    public ArrayList<Rect> getBoxRects() {
        if (!this.mRecycled) {
            ArrayList<Rect> arrayList;
            int n = Pixa.nativeGetCount(this.mNativePixa);
            int[] nArray = new int[4];
            ArrayList<Rect> arrayList2 = arrayList;
            arrayList = new ArrayList<Rect>(n);
            for (int i = 0; i < n; ++i) {
                this.getBoxGeometry(i, nArray);
                int n2 = nArray[0];
                int n3 = nArray[1];
                int n4 = n3 + nArray[3];
                arrayList2.add(new Rect(n2, n3, n2 += nArray[2], n4));
            }
            return arrayList2;
        }
        throw new IllegalStateException();
    }

    public void replacePix(int n, Pix pix, Box box) {
        if (!this.mRecycled) {
            long l = pix.getNativePix();
            long l2 = box.getNativeBox();
            Pixa.nativeReplacePix(this.mNativePixa, n, l, l2);
            return;
        }
        throw new IllegalStateException();
    }

    public void mergeAndReplacePix(int n, int n2) {
        if (!this.mRecycled) {
            Pixa.nativeMergeAndReplacePix(this.mNativePixa, n, n2);
            return;
        }
        throw new IllegalStateException();
    }

    public boolean writeToFileRandomCmap(File file) {
        if (!((Pixa)((Object)string)).mRecycled) {
            Pixa pixa = string;
            String string = file.getAbsolutePath();
            int n = pixa.mWidth;
            int n2 = pixa.mHeight;
            return Pixa.nativeWriteToFileRandomCmap(((Pixa)((Object)string)).mNativePixa, string, n, n2);
        }
        throw new IllegalStateException();
    }

    @Override
    public Iterator<Pix> iterator() {
        return new b(null);
    }

    public class b
    implements Iterator<Pix> {
        private int a = 0;

        private b() {
        }

        public /* synthetic */ b(a a2) {
            this();
        }

        @Override
        public boolean hasNext() {
            int n = Pixa.this.size();
            return n > 0 && this.a < n;
        }

        public Pix a() {
            int n = this.a;
            this.a = n + 1;
            return Pixa.this.getPix(n);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

