/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence.cleanup;

import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.persistence.DocumentStoreStrategy;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageStorageProcessor;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\f\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/scanbot/sdk/persistence/cleanup/Cleaner;", "", "documentStoreStrategy", "Lio/scanbot/sdk/persistence/DocumentStoreStrategy;", "pageStorageProcessor", "Lio/scanbot/sdk/persistence/PageStorageProcessor;", "(Lio/scanbot/sdk/persistence/DocumentStoreStrategy;Lio/scanbot/sdk/persistence/PageStorageProcessor;)V", "cleanUpDocumentData", "", "document", "Lio/scanbot/sdk/entity/Document;", "cleanUpDocumentThumbnail", "cleanUpPagesData", "pages", "", "Lio/scanbot/sdk/persistence/Page;", "sdk-persistence_release"})
public final class Cleaner {
    private final DocumentStoreStrategy documentStoreStrategy;
    private final PageStorageProcessor pageStorageProcessor;

    public final void cleanUpPagesData(@NotNull List<Page> pages) {
        Intrinsics.checkNotNullParameter(pages, (String)"pages");
        for (Page page : pages) {
            this.pageStorageProcessor.erasePageData(page);
        }
    }

    public final void cleanUpDocumentData(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.documentStoreStrategy.eraseDocument(document.id, document.name);
    }

    public final void cleanUpDocumentThumbnail(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.documentStoreStrategy.eraseDocumentThumbnail(document.id);
    }

    public Cleaner(@NotNull DocumentStoreStrategy documentStoreStrategy, @NotNull PageStorageProcessor pageStorageProcessor) {
        Intrinsics.checkNotNullParameter((Object)documentStoreStrategy, (String)"documentStoreStrategy");
        Intrinsics.checkNotNullParameter((Object)pageStorageProcessor, (String)"pageStorageProcessor");
        this.documentStoreStrategy = documentStoreStrategy;
        this.pageStorageProcessor = pageStorageProcessor;
    }
}

