/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.docprocessing;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.net.Uri;
import android.provider.MediaStore;
import io.scanbot.sdk.core.contourdetector.ContourDetector;
import io.scanbot.sdk.core.contourdetector.DetectionResult;
import io.scanbot.sdk.persistence.Page;
import io.scanbot.sdk.persistence.PageFileStorage;
import io.scanbot.sdk.process.CropOperation;
import io.scanbot.sdk.process.FilterOperation;
import io.scanbot.sdk.process.ImageFilterType;
import io.scanbot.sdk.process.ImageProcessor;
import io.scanbot.sdk.process.Operation;
import io.scanbot.sdk.process.RotateOperation;
import io.scanbot.sdk.process.TuneOperation;
import io.scanbot.sdk.util.PolygonHelper;
import io.scanbot.sdk.util.bitmap.BitmapUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010;\u001a\u000209\u0012\u0006\u00104\u001a\u000201\u0012\u0006\u00108\u001a\u000205\u0012\u0006\u0010\u001e\u001a\u00020\u0002\u00a2\u0006\u0004\b>\u0010?JA\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ9\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00140\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u000b2\b\b\u0002\u0010\u0011\u001a\u00020\u00102\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u0015J\u0017\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u0017J7\u0010\r\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\r\u0010 J\u001f\u0010\r\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b\r\u0010#J\u001d\u0010$\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b$\u0010%J3\u0010&\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\u0006\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\u0004\b&\u0010'J\u001d\u0010(\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b(\u0010)J3\u0010(\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\u0006\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\u0004\b(\u0010*J\u0015\u0010+\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b+\u0010,J\u001d\u0010-\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000b\u00a2\u0006\u0004\b-\u0010.J+\u0010/\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000b2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b/\u00100R\u0016\u00104\u001a\u0002018\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0016\u00108\u001a\u0002058\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0016\u0010;\u001a\u0002098\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010:R\u0016\u0010\u001e\u001a\u00020\u00028\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u0010=\u00a8\u0006@"}, d2={"Lio/scanbot/sdk/docprocessing/PageProcessor;", "", "Lio/scanbot/sdk/process/ImageProcessor;", "processor", "Landroid/graphics/Bitmap;", "originalBitmap", "", "Landroid/graphics/PointF;", "polygon", "Lio/scanbot/sdk/persistence/Page;", "page", "", "degrees", "a", "(Lio/scanbot/sdk/process/ImageProcessor;Landroid/graphics/Bitmap;Ljava/util/List;Lio/scanbot/sdk/persistence/Page;I)Landroid/graphics/Bitmap;", "filterOrder", "Lio/scanbot/sdk/process/ImageFilterType;", "filter", "Lio/scanbot/sdk/process/TuneOperation;", "tunes", "Lio/scanbot/sdk/process/Operation;", "(ILio/scanbot/sdk/process/ImageFilterType;Ljava/util/List;)Ljava/util/List;", "times", "(I)I", "bitmap", "rotationDegree", "", "pageId", "Lio/scanbot/sdk/persistence/PageFileStorage$PageFileType;", "pageType", "imageProcessor", "", "(Landroid/graphics/Bitmap;ILjava/lang/String;Lio/scanbot/sdk/persistence/PageFileStorage$PageFileType;Lio/scanbot/sdk/process/ImageProcessor;)V", "Lio/scanbot/sdk/persistence/Page$Size;", "imageSizeLimit", "(Landroid/graphics/Bitmap;Lio/scanbot/sdk/persistence/Page$Size;)Landroid/graphics/Bitmap;", "applyFilter", "(Lio/scanbot/sdk/persistence/Page;Lio/scanbot/sdk/process/ImageFilterType;)Lio/scanbot/sdk/persistence/Page;", "applyFilterTunes", "(Lio/scanbot/sdk/persistence/Page;Lio/scanbot/sdk/process/ImageFilterType;Ljava/util/List;I)Lio/scanbot/sdk/persistence/Page;", "generateFilteredPreview", "(Lio/scanbot/sdk/persistence/Page;Lio/scanbot/sdk/process/ImageFilterType;)Landroid/graphics/Bitmap;", "(Lio/scanbot/sdk/persistence/Page;Lio/scanbot/sdk/process/ImageFilterType;Ljava/util/List;I)Landroid/graphics/Bitmap;", "detectDocument", "(Lio/scanbot/sdk/persistence/Page;)Lio/scanbot/sdk/persistence/Page;", "rotate", "(Lio/scanbot/sdk/persistence/Page;I)Lio/scanbot/sdk/persistence/Page;", "cropAndRotate", "(Lio/scanbot/sdk/persistence/Page;ILjava/util/List;)Lio/scanbot/sdk/persistence/Page;", "Lio/scanbot/sdk/persistence/PageFileStorage;", "b", "Lio/scanbot/sdk/persistence/PageFileStorage;", "pageFileStorage", "Lio/scanbot/sdk/core/contourdetector/ContourDetector;", "c", "Lio/scanbot/sdk/core/contourdetector/ContourDetector;", "contourDetector", "Landroid/content/Context;", "Landroid/content/Context;", "context", "d", "Lio/scanbot/sdk/process/ImageProcessor;", "<init>", "(Landroid/content/Context;Lio/scanbot/sdk/persistence/PageFileStorage;Lio/scanbot/sdk/core/contourdetector/ContourDetector;Lio/scanbot/sdk/process/ImageProcessor;)V", "sdk-persistence_release"})
public final class PageProcessor {
    private Context a;
    private final PageFileStorage b;
    private final ContourDetector c;
    private final ImageProcessor d;

    private final Bitmap a(ImageProcessor imageProcessor, Bitmap bitmap, List<? extends PointF> list, Page page, int n) {
        list = CollectionsKt.toMutableList((Collection)CollectionsKt.listOf((Object)new CropOperation(list)));
        Page page2 = page;
        int n2 = page2.getFilterOrder();
        page = page2.getFilter();
        List<TuneOperation> list2 = page2.getTunes();
        list.addAll(this.a(n2, (ImageFilterType)page, list2));
        if (n != 0) {
            RotateOperation rotateOperation;
            RotateOperation rotateOperation2 = rotateOperation;
            rotateOperation = new RotateOperation(n);
            list.add(rotateOperation2);
        }
        return ImageProcessor.processBitmap$default((ImageProcessor)imageProcessor, (Bitmap)bitmap, (List)list, (boolean)false, (int)4, null);
    }

    public static /* synthetic */ Bitmap a(PageProcessor pageProcessor, ImageProcessor imageProcessor, Bitmap bitmap, List list, Page page, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        return pageProcessor.a(imageProcessor, bitmap, list, page, n);
    }

    private final List<Operation> a(int n, ImageFilterType imageFilterType, List<TuneOperation> list) {
        ArrayList arrayList;
        ArrayList<FilterOperation> arrayList2 = arrayList;
        List<TuneOperation> list2 = list;
        ArrayList<FilterOperation> arrayList3 = arrayList2;
        arrayList2();
        arrayList3.addAll(CollectionsKt.take(list, (int)n));
        arrayList3.add(new FilterOperation(imageFilterType));
        arrayList.addAll(CollectionsKt.takeLast(list2, (int)(list2.size() - n)));
        return arrayList;
    }

    public static /* synthetic */ List a(PageProcessor pageProcessor, int n, ImageFilterType imageFilterType, List list, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            imageFilterType = ImageFilterType.NONE;
        }
        if ((n2 & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return pageProcessor.a(n, imageFilterType, list);
    }

    private final int a(int n) {
        int n2 = n * -1 * 90;
        return n2 < 0 ? 360 - Math.abs(n2) % 360 : n2 % 360;
    }

    private final void a(Bitmap bitmap, int n, String string, PageFileStorage.PageFileType pageFileType, ImageProcessor imageProcessor) {
        if ((bitmap = ImageProcessor.processBitmap$default((ImageProcessor)imageProcessor, (Bitmap)bitmap, (List)CollectionsKt.listOf((Object)new RotateOperation(n)), (boolean)false, (int)4, null)) != null) {
            this.b.setImageForId(bitmap, string, pageFileType);
            bitmap.recycle();
            return;
        }
        throw new IOException("Unable to rotate");
    }

    private final Bitmap a(Bitmap bitmap, Page.Size size) {
        if (size.getHeight() != Integer.MAX_VALUE && size.getWidth() != Integer.MAX_VALUE) {
            Page.Size size2 = size;
            int n = size2.getWidth();
            bitmap = BitmapUtils.scaleIfNeeded((Bitmap)bitmap, (int)n, (int)size2.getHeight());
        }
        return bitmap;
    }

    public PageProcessor(@NotNull Context context, @NotNull PageFileStorage pageFileStorage, @NotNull ContourDetector contourDetector, @NotNull ImageProcessor imageProcessor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pageFileStorage, (String)"pageFileStorage");
        Intrinsics.checkNotNullParameter((Object)contourDetector, (String)"contourDetector");
        Intrinsics.checkNotNullParameter((Object)imageProcessor, (String)"imageProcessor");
        this.a = context;
        this.b = pageFileStorage;
        this.c = contourDetector;
        this.d = imageProcessor;
    }

    @NotNull
    public final Page applyFilter(@NotNull Page page, @NotNull ImageFilterType imageFilterType) throws IOException {
        PageProcessor pageProcessor = list;
        Page page2 = page;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)imageFilterType, (String)"filter");
        List<TuneOperation> list = page2.getTunes();
        int n = page2.getFilterOrder();
        return pageProcessor.applyFilterTunes(page2, imageFilterType, list, n);
    }

    @NotNull
    public final Page applyFilterTunes(@NotNull Page page, @NotNull ImageFilterType imageFilterType, @NotNull List<TuneOperation> bitmap, int n) throws IOException {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)imageFilterType, (String)"filter");
        Intrinsics.checkNotNullParameter(bitmap, (String)"tunes");
        Uri uri = this.b.getImageURI(page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        if (new File(uri.getPath()).exists()) {
            PageProcessor pageProcessor = this;
            uri = MediaStore.Images.Media.getBitmap((ContentResolver)pageProcessor.a.getContentResolver(), (Uri)uri);
            ImageProcessor imageProcessor = pageProcessor.d;
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"unfilteredDocumentBitmap");
            bitmap = ImageProcessor.processBitmap$default((ImageProcessor)imageProcessor, (Bitmap)uri, this.a(n, imageFilterType, (List<TuneOperation>)bitmap), (boolean)false, (int)4, null);
            if (bitmap != null) {
                this.b.setImageForId(bitmap, page.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
                bitmap.recycle();
                return Page.copy$default(page, null, null, null, imageFilterType, null, null, 0, 119, null);
            }
            throw new IOException("Unable to apply filter and tunes");
        }
        throw new IOException("Unfiltered document image does not exists for this page.");
    }

    @NotNull
    public final Bitmap generateFilteredPreview(@NotNull Page page, @NotNull ImageFilterType imageFilterType) throws IOException {
        PageProcessor pageProcessor = list;
        Page page2 = page;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)imageFilterType, (String)"filter");
        List<TuneOperation> list = page2.getTunes();
        int n = page2.getFilterOrder();
        return pageProcessor.generateFilteredPreview(page2, imageFilterType, list, n);
    }

    @NotNull
    public final Bitmap generateFilteredPreview(@NotNull Page page, @NotNull ImageFilterType imageFilterType, @NotNull List<TuneOperation> bitmap, int n) throws IOException {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)imageFilterType, (String)"filter");
        Intrinsics.checkNotNullParameter(bitmap, (String)"tunes");
        Uri uri = this.b.getImageURI(page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
        if (new File(uri.getPath()).exists()) {
            PageProcessor pageProcessor = this;
            uri = MediaStore.Images.Media.getBitmap((ContentResolver)pageProcessor.a.getContentResolver(), (Uri)uri);
            ImageProcessor imageProcessor = pageProcessor.d;
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"unfilteredDocumentBitmap");
            bitmap = ImageProcessor.processBitmap$default((ImageProcessor)imageProcessor, (Bitmap)uri, this.a(n, imageFilterType, (List<TuneOperation>)bitmap), (boolean)false, (int)4, null);
            if (bitmap != null) {
                Bitmap bitmap2 = this.b.generateAndSetFilteredPreviewForId(bitmap, page.getPageId(), imageFilterType);
                uri.recycle();
                bitmap.recycle();
                return bitmap2;
            }
            throw new IOException("Unable to generate filtered preview");
        }
        throw new IOException("Unfiltered document image does not exists for this page.");
    }

    @NotNull
    public final Page detectDocument(@NotNull Page page) throws IOException {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Uri uri = this.b.getImageURI(page.getPageId(), PageFileStorage.PageFileType.ORIGINAL);
        if (new File(uri.getPath()).exists()) {
            PageProcessor pageProcessor = this;
            uri = MediaStore.Images.Media.getBitmap((ContentResolver)pageProcessor.a.getContentResolver(), (Uri)uri);
            ContourDetector contourDetector = pageProcessor.c;
            Uri uri2 = uri;
            Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"originalBitmap");
            DetectionResult detectionResult = contourDetector.detect((Bitmap)uri2);
            if (detectionResult != null) {
                List list = this.c.getPolygonF();
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                PageProcessor pageProcessor2 = this;
                Bitmap bitmap = PageProcessor.a(pageProcessor2, pageProcessor2.d, (Bitmap)uri, list, page, 0, 16, null);
                Bitmap bitmap2 = page.getDocumentImageSizeLimit().getHeight() != Integer.MAX_VALUE && page.getDocumentImageSizeLimit().getWidth() != Integer.MAX_VALUE && bitmap != null ? BitmapUtils.scaleIfNeeded((Bitmap)bitmap, (int)page.getDocumentImageSizeLimit().getWidth(), (int)page.getDocumentImageSizeLimit().getHeight()) : bitmap;
                if (bitmap2 != null) {
                    Bitmap bitmap3 = page.getFilter() != ImageFilterType.NONE ? ImageProcessor.processBitmap$default((ImageProcessor)this.d, (Bitmap)uri, (List)CollectionsKt.listOf((Object)new CropOperation(list)), (boolean)false, (int)4, null) : bitmap2;
                    if (bitmap3 != null) {
                        PageProcessor pageProcessor3 = this;
                        pageProcessor3.b.setImageForId(bitmap2, page.getPageId(), PageFileStorage.PageFileType.DOCUMENT);
                        pageProcessor3.b.setImageForId(bitmap3, page.getPageId(), PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
                        pageProcessor3.b.removeFilteredPreviewImages(page.getPageId());
                        uri.recycle();
                        bitmap2.recycle();
                        bitmap3.recycle();
                        if (bitmap != null) {
                            bitmap.recycle();
                        }
                        return Page.copy$default(page, null, list, detectionResult, null, null, null, 0, 121, null);
                    }
                    throw new IOException("Unable to crop image");
                }
                throw new IOException("Unable to scale image");
            }
            return page;
        }
        throw new IOException("Original image does not exists for this page.");
    }

    @NotNull
    public final Page rotate(@NotNull Page page, int n) throws IOException {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        PageFileStorage.PageFileType pageFileType = PageFileStorage.PageFileType.ORIGINAL;
        Object object = ((PageProcessor)((Object)list)).b.getImageURI(page.getPageId(), pageFileType);
        if (new File(object.getPath()).exists()) {
            PageProcessor pageProcessor = list;
            n = pageProcessor.a(n);
            Bitmap bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)pageProcessor.a.getContentResolver(), (Uri)object);
            Uri uri = object = bitmap;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"originalBitmap");
            object = page.getPageId();
            Object object2 = ((PageProcessor)((Object)list)).d;
            ((PageProcessor)((Object)list)).a((Bitmap)uri, n, (String)object, pageFileType, (ImageProcessor)object2);
            bitmap.recycle();
            pageFileType = PageFileStorage.PageFileType.DOCUMENT;
            object = pageProcessor.b.getImageURI(page.getPageId(), pageFileType);
            if (new File(object.getPath()).exists()) {
                Bitmap bitmap2 = MediaStore.Images.Media.getBitmap((ContentResolver)((PageProcessor)((Object)list)).a.getContentResolver(), (Uri)object);
                ImageProcessor imageProcessor = object2 = bitmap2;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"documentBitmap");
                object2 = page.getPageId();
                ImageProcessor imageProcessor2 = ((PageProcessor)((Object)list)).d;
                ((PageProcessor)((Object)list)).a((Bitmap)imageProcessor, n, (String)object2, pageFileType, imageProcessor2);
                bitmap2.recycle();
            }
            pageFileType = PageFileStorage.PageFileType.UNFILTERED_DOCUMENT;
            object2 = ((PageProcessor)((Object)list)).b.getImageURI(page.getPageId(), pageFileType);
            if (new File(object.getPath()).exists()) {
                Bitmap bitmap3 = MediaStore.Images.Media.getBitmap((ContentResolver)((PageProcessor)((Object)list)).a.getContentResolver(), (Uri)object2);
                Object object3 = object = bitmap3;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"unfilteredDocumentBitmap");
                object = page.getPageId();
                object2 = ((PageProcessor)((Object)list)).d;
                ((PageProcessor)((Object)list)).a((Bitmap)object3, n, (String)object, pageFileType, (ImageProcessor)object2);
                bitmap3.recycle();
            }
            ((PageProcessor)((Object)list)).b.removeFilteredPreviewImages(page.getPageId());
            List list = page.getPolygon();
            if (list.isEmpty() ^ true) {
                list = page.getPolygon();
                list = PolygonHelper.Companion.rotatePolygon(list, (float)n);
            }
            return Page.copy$default(page, null, list, null, null, null, null, 0, 125, null);
        }
        throw new IOException("Original image does not exists for this page.");
    }

    @NotNull
    public final Page cropAndRotate(@NotNull Page page, int n, @NotNull List<? extends PointF> list) throws IOException {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter(list, (String)"polygon");
        String string = page.getPageId();
        PageFileStorage.PageFileType pageFileType = PageFileStorage.PageFileType.ORIGINAL;
        Uri uri = this.b.getImageURI(string, pageFileType);
        if (new File(uri.getPath()).exists()) {
            RotateOperation rotateOperation;
            CropOperation cropOperation;
            PageProcessor pageProcessor = this;
            n = pageProcessor.a(n);
            uri = MediaStore.Images.Media.getBitmap((ContentResolver)pageProcessor.a.getContentResolver(), (Uri)uri);
            ImageProcessor imageProcessor = pageProcessor.d;
            Uri uri2 = uri;
            Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"originalBitmap");
            Object[] objectArray = new Operation[2];
            CropOperation cropOperation2 = cropOperation;
            cropOperation = new CropOperation(list);
            objectArray[0] = cropOperation2;
            cropOperation2 = rotateOperation;
            rotateOperation = new RotateOperation(n);
            objectArray[1] = cropOperation2;
            cropOperation2 = ImageProcessor.processBitmap$default((ImageProcessor)imageProcessor, (Bitmap)uri2, (List)CollectionsKt.listOf((Object[])objectArray), (boolean)false, (int)4, null);
            if (cropOperation2 != null) {
                PageProcessor pageProcessor2 = this;
                Bitmap bitmap = pageProcessor2.a((Bitmap)cropOperation2, page.getDocumentImageSizeLimit());
                this.b.setImageForId(bitmap, string, PageFileStorage.PageFileType.UNFILTERED_DOCUMENT);
                bitmap.recycle();
                cropOperation2 = pageProcessor2.a(pageProcessor2.d, (Bitmap)uri, list, page, n);
                if (cropOperation2 != null) {
                    PageProcessor pageProcessor3 = this;
                    Bitmap bitmap2 = pageProcessor3.a((Bitmap)cropOperation2, page.getDocumentImageSizeLimit());
                    this.b.setImageForId(bitmap2, string, PageFileStorage.PageFileType.DOCUMENT);
                    bitmap2.recycle();
                    this.a((Bitmap)uri, n, string, pageFileType, pageProcessor3.d);
                    uri.recycle();
                    this.b.removeFilteredPreviewImages(string);
                    if (list.isEmpty() ^ true) {
                        list = PolygonHelper.Companion.rotatePolygon(list, (float)n);
                    }
                    return Page.copy$default(page, null, list, null, null, null, null, 0, 125, null);
                }
                throw new IOException("Unable to filter");
            }
            throw new IOException("Unable to crop and rotate");
        }
        throw new IOException("Original image does not exists for this page.");
    }
}

