/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.persistence;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import io.scanbot.sdk.entity.Document;
import io.scanbot.sdk.util.FileUtils;
import io.scanbot.sdk.util.log.Logger;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class DocumentStoreStrategy {
    public static final String d = "thumbnail";
    public static final String e = "snapping_documents";
    public static final String f = "%s(%d)%s";
    public static final String g = " (1).";
    public final Context a;
    public final SharedPreferences b;
    public final Logger c = LoggerProvider.getLogger();

    /*
     * WARNING - void declaration
     */
    public DocumentStoreStrategy(Context context, SharedPreferences preferences) {
        void var2_2;
        void var1_1;
        this.a = var1_1;
        this.b = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean ensureDocumentDir(File docDir) {
        void var1_1;
        return docDir != null && var1_1.exists() && (this = var1_1.listFiles()) != null && this.length >= 1;
    }

    public File getDocumentsDir() throws IOException {
        String string = this.b.getString("CUSTOM_SDK_FILES_PATH", "");
        if (!string.isEmpty()) {
            return FileUtils.getFilesDirOrShowError((String)string, (String)e);
        }
        return FileUtils.getFilesDirOrShowError((String)FileUtils.getAppFilesDirOrShowError((Context)this.a, (String)"scanbot-sdk").getPath(), (String)e);
    }

    /*
     * WARNING - void declaration
     */
    public File getDocumentDir(String docId) throws IOException {
        void var1_1;
        return FileUtils.getFilesDirOrShowError((String)this.getDocumentsDir().getPath(), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void ensureDocumentDirectory(String docId) throws IOException {
        void var1_1;
        org.apache.commons.io.FileUtils.forceMkdir((File)this.getDocumentDir((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public File getDocumentFile(String docId, String name) throws IOException {
        void var2_2;
        void var1_1;
        return org.apache.commons.io.FileUtils.getFile((File)this.getDocumentDir((String)var1_1), (String[])new String[]{var2_2});
    }

    public List<File> getDocumentsFiles() throws IOException {
        ArrayList<File> arrayList;
        ArrayList<File> arrayList2 = arrayList;
        arrayList = new ArrayList<File>();
        File[] fileArray = this.getDocumentsDir().listFiles();
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList2.addAll(Arrays.asList(fileArray[i].listFiles(new FilenameFilter(this){
                public final /* synthetic */ DocumentStoreStrategy a;
                {
                    void var1_1;
                    this.a = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean accept(File dir, String filename) {
                    void var2_2;
                    return filename.endsWith(".jpg") || var2_2.endsWith(".pdf");
                }
            })));
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    public File getThumbnailFile(String docId) throws IOException {
        void var1_1;
        return org.apache.commons.io.FileUtils.getFile((File)this.getDocumentsDir(), (String[])new String[]{var1_1, d});
    }

    /*
     * WARNING - void declaration
     */
    public void eraseDocument(String docId, String docName) {
        void var2_3;
        void var1_1;
        DocumentStoreStrategy documentStoreStrategy = this;
        void v1 = var1_1;
        org.apache.commons.io.FileUtils.deleteQuietly((File)this.getDocumentFile((String)var1_1, (String)var2_3));
        try {
            org.apache.commons.io.FileUtils.deleteQuietly((File)documentStoreStrategy.getDocumentDir((String)v1));
        }
        catch (IOException iOException) {
            this.c.logException((Throwable)iOException);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void eraseDocumentThumbnail(String docId) {
        try {
            void var1_1;
            org.apache.commons.io.FileUtils.deleteQuietly((File)this.getThumbnailFile((String)var1_1));
        }
        catch (IOException iOException) {
            this.c.logException((Throwable)iOException);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean renameDocument(String docId, String oldName, String newName) throws IOException {
        void var2_2;
        void var3_3;
        void var1_1;
        DocumentStoreStrategy documentStoreStrategy = this_;
        File this_ = ((DocumentStoreStrategy)((Object)this_)).getDocumentFile((String)var1_1, ((DocumentStoreStrategy)((Object)this_)).getUniqueName((String)var3_3));
        return documentStoreStrategy.getDocumentFile((String)var1_1, (String)var2_2).renameTo(this_);
    }

    /*
     * Loose catch block
     */
    public String getUniqueName(String newName) {
        String string;
        block15: {
            while (true) {
                int n;
                block14: {
                    String string2;
                    string2 = TextUtils.isEmpty((CharSequence)(string2 = FilenameUtils.getExtension((String)newName))) ? "" : "." + string2;
                    String string3 = FilenameUtils.getBaseName((String)string);
                    n = string3.lastIndexOf("(");
                    int n2 = string3.lastIndexOf(")");
                    Integer n3 = 0;
                    String string4 = FilenameUtils.getBaseName((String)string);
                    if (n >= 0 && n2 >= 0 && n2 > n) {
                        try {
                            n3 = Integer.valueOf(string3.substring(n + 1, n2));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        string4 = string3.substring(0, n - 1);
                    }
                    n = 0;
                    Iterator<File> iterator = this.getDocumentsFiles().iterator();
                    while (true) {
                        if (!iterator.hasNext()) break block14;
                        if (!FilenameUtils.getBaseName((String)iterator.next().getName()).equals(string3)) continue;
                        break;
                    }
                    StringBuilder stringBuilder = new StringBuilder().append(string4).append(" (");
                    int n4 = n3;
                    string = stringBuilder.append(n4 + 1).append(")").append(string2).toString();
                    n = 1;
                }
                if (n != 0) {
                    continue;
                }
                break block15;
                break;
            }
            catch (IOException iOException) {
                this.c.logException((Throwable)iOException);
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public String getPageImagePath(int pagePosition, Document document) throws IOException {
        void var1_1;
        void var2_2;
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        DocumentStoreStrategy documentStoreStrategy = string;
        void v2 = var2_2;
        String string = v2.id;
        objectArray2[0] = FilenameUtils.removeExtension((String)documentStoreStrategy.getDocumentFile(string, v2.name).getPath());
        objectArray[1] = (int)var1_1;
        objectArray[2] = ".jpg";
        return String.format(f, objectArray2);
    }

    /*
     * Unable to fully structure code
     */
    public void migrateDocuments(String newPath, List<Document> documents) {
        var2_3 = TextUtils.isEmpty((CharSequence)var1_1) ^ true;
        for (Document v0 : documents) {
            block14: {
                block13: {
                    v1 = v0;
                    var4_5 = v0.name;
                    var5_7 = v1.id;
                    if (!var2_3) ** GOTO lbl13
                    var6_8 = v2;
                    v2 = new File((String)var1_1);
                    break block13;
lbl13:
                    // 1 sources

                    var6_8 = this.getDocumentDir(var5_7);
                }
                if (!org.apache.commons.io.FileUtils.getFile((File)var6_8, (String[])new String[]{var4_5}).exists()) break block14;
                v3 = this;
                v4 = var5_7;
                v5 = var4_5;
                v6 = v5;
                var7_9 = FilenameUtils.getExtension((String)v5);
                var8_10 = FilenameUtils.getBaseName((String)v6);
                var7_9 = var8_10 + " (1)." + var7_9;
                v3.renameDocument(v4, var4_5, var7_9);
                var4_5 = var7_9;
            }
            try {
                org.apache.commons.io.FileUtils.moveFileToDirectory((File)this.getDocumentFile(var5_7, var4_5), (File)var6_8, (boolean)true);
            }
            catch (IOException var4_6) {
                this.c.logException((Throwable)var4_6);
            }
        }
    }
}

