/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.barcode;

import android.graphics.Bitmap;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import io.scanbot.sdk.SdkLicenseError;
import io.scanbot.sdk.barcode.BarcodeFilter;
import io.scanbot.sdk.barcode.IBarcodeFilter;
import io.scanbot.sdk.barcode.ScanbotBarcodeDetector;
import io.scanbot.sdk.barcode.entity.BarcodeDensity;
import io.scanbot.sdk.barcode.entity.BarcodeDocumentFormat;
import io.scanbot.sdk.barcode.entity.BarcodeFormat;
import io.scanbot.sdk.barcode.entity.BarcodeItem;
import io.scanbot.sdk.barcode.entity.BarcodeScannerAdditionalConfig;
import io.scanbot.sdk.barcode.entity.BarcodeScannerConfigBuilder;
import io.scanbot.sdk.barcode.entity.BarcodeScanningResult;
import io.scanbot.sdk.barcode.entity.EngineMode;
import io.scanbot.sdk.barcode.entity.MSIPlesseyChecksumAlgorithm;
import io.scanbot.sdk.camera.FrameHandlerResult;
import io.scanbot.sdk.ui.coroutines.IDispatchersProvider;
import io.scanbot.sdk.ui.utils.CommonNavigationEvent;
import io.scanbot.sdk.ui.utils.Event;
import io.scanbot.sdk.ui.utils.Router;
import io.scanbot.sdk.ui.utils.RouterImpl;
import io.scanbot.sdk.ui.view.barcode.BarcodeCameraViewModel;
import io.scanbot.sdk.ui.view.barcode.BarcodeNavigationEvents;
import io.scanbot.sdk.ui.view.barcode.BarcodeScanningSession;
import io.scanbot.sdk.ui.view.barcode.IBarcodeCameraView;
import io.scanbot.sdk.ui.view.barcode.configuration.BarcodeImageGenerationType;
import io.scanbot.sdk.ui.view.interactor.SaveBarcodePreviewFrameUseCase;
import io.scanbot.sdk.ui.view.interactor.SaveBarcodeTakenPictureUseCase;
import io.scanbot.sdk.util.log.LoggerProvider;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u001e\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010E\u001a\u00020F2\u0014\u0010G\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010'\u0012\u0004\u0012\u00020I0HH\u0016J\u0019\u0010J\u001a\u00020F2\u0006\u0010K\u001a\u00020'H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010LJ#\u0010M\u001a\u00020F\"\b\b\u0000\u0010N*\u00020;2\u0006\u0010O\u001a\u0002HNH\u0096A\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010PJ\b\u0010Q\u001a\u00020FH\u0016J\b\u0010R\u001a\u00020FH\u0016J\b\u0010S\u001a\u00020FH\u0016J\u0010\u0010T\u001a\u00020F2\u0006\u0010U\u001a\u00020VH\u0016J\u0018\u0010W\u001a\u00020F2\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020\u0010H\u0016J\u0006\u0010[\u001a\u00020FJ\u0019\u0010\\\u001a\u00020F2\u0006\u0010]\u001a\u00020\u0015H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010^J\u0018\u0010_\u001a\u00020F2\u0006\u0010K\u001a\u00020'2\u0006\u0010`\u001a\u00020aH\u0002J\u0016\u0010b\u001a\u00020F2\f\u0010c\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\u0010\u0010d\u001a\u00020F2\u0006\u0010e\u001a\u00020\u0010H\u0016J\u0010\u0010f\u001a\u00020F2\u0006\u0010g\u001a\u00020\u0015H\u0016J\u0010\u0010h\u001a\u00020F2\u0006\u0010g\u001a\u00020\u0015H\u0016J\u0010\u0010i\u001a\u00020F2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010j\u001a\u00020F2\f\u0010k\u001a\b\u0012\u0004\u0012\u00020#0\u001bH\u0016J\u000e\u0010l\u001a\u00020F2\u0006\u0010$\u001a\u00020%J\u0010\u0010m\u001a\u00020F2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010n\u001a\u00020F2\u0006\u0010o\u001a\u00020-H\u0016J\u0010\u0010p\u001a\u00020F2\u0006\u0010q\u001a\u00020\u001eH\u0016J\u000e\u0010r\u001a\u00020F2\u0006\u0010s\u001a\u00020\u0015J\u0010\u0010t\u001a\u00020F2\u0006\u00100\u001a\u00020\u0015H\u0016J\u0010\u0010u\u001a\u00020F2\u0006\u0010o\u001a\u00020-H\u0016J\u0010\u0010v\u001a\u00020F2\u0006\u00102\u001a\u00020\u0015H\u0016J\u0010\u0010w\u001a\u00020F2\u0006\u00103\u001a\u00020\u0010H\u0016J\u0010\u0010x\u001a\u00020F2\u0006\u00104\u001a\u00020\u0010H\u0016J\u0010\u0010y\u001a\u00020F2\u0006\u00105\u001a\u00020\u0010H\u0016J\u0016\u0010z\u001a\u00020F2\f\u00106\u001a\b\u0012\u0004\u0012\u00020807H\u0016J\u0010\u0010{\u001a\u00020F2\u0006\u0010C\u001a\u00020\u0015H\u0016J\u0010\u0010|\u001a\u00020F2\u0006\u0010g\u001a\u00020\u0015H\u0016J\b\u0010}\u001a\u00020FH\u0002J\b\u0010~\u001a\u00020FH\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0017R\u0016\u0010\"\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0017R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0017R\u000e\u00100\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00106\u001a\b\u0012\u0004\u0012\u00020807X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u00109\u001a\b\u0012\u0004\u0012\u00020;0:X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u000e\u0010@\u001a\u00020-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\u0017R\u000e\u0010C\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u007f"}, d2={"Lio/scanbot/sdk/ui/view/barcode/BarcodeCameraViewModel;", "Landroidx/lifecycle/ViewModel;", "Lio/scanbot/sdk/ui/view/barcode/IBarcodeCameraView$ViewModel;", "Lio/scanbot/sdk/ui/utils/Router;", "scanner", "Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "saveBarcodeTakenPictureUseCase", "Lio/scanbot/sdk/ui/view/interactor/SaveBarcodeTakenPictureUseCase;", "saveBarcodePreviewFrameUseCase", "Lio/scanbot/sdk/ui/view/interactor/SaveBarcodePreviewFrameUseCase;", "barcodeScanningSession", "Lio/scanbot/sdk/ui/view/barcode/BarcodeScanningSession;", "dispatchersProvider", "Lio/scanbot/sdk/ui/coroutines/IDispatchersProvider;", "(Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;Lio/scanbot/sdk/ui/view/interactor/SaveBarcodeTakenPictureUseCase;Lio/scanbot/sdk/ui/view/interactor/SaveBarcodePreviewFrameUseCase;Lio/scanbot/sdk/ui/view/barcode/BarcodeScanningSession;Lio/scanbot/sdk/ui/coroutines/IDispatchersProvider;)V", "autoCloseTimeInSeconds", "", "autoCloseTimer", "Lkotlinx/coroutines/Job;", "autoSnapEnabled", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "getAutoSnapEnabled", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "autoStopOnSuccess", "automaticSelectionEnabled", "barcodeDocumentFormatsFilter", "", "Lio/scanbot/sdk/barcode/entity/BarcodeDocumentFormat;", "barcodeEngineMode", "Lio/scanbot/sdk/barcode/entity/EngineMode;", "barcodeFilter", "Lio/scanbot/sdk/barcode/IBarcodeFilter;", "getBarcodeFilter", "barcodeFormatsFilter", "Lio/scanbot/sdk/barcode/entity/BarcodeFormat;", "barcodeImageGenerationType", "Lio/scanbot/sdk/ui/view/barcode/configuration/BarcodeImageGenerationType;", "cachedBarcodeResult", "Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;", "cameraOpened", "getCameraOpened", "codeDensity", "Lio/scanbot/sdk/barcode/entity/BarcodeDensity;", "delayAfterScanMs", "", "flash", "getFlash", "gs1DecodingEnabled", "initialScanDelayMs", "lowPowerMode", "maximumTextLength", "minimum1DQuietZoneSize", "minimumTextLength", "msiPlesseyChecksumAlgorithms", "Ljava/util/EnumSet;", "Lio/scanbot/sdk/barcode/entity/MSIPlesseyChecksumAlgorithm;", "navEvents", "Lkotlinx/coroutines/flow/SharedFlow;", "Lio/scanbot/sdk/ui/utils/Event;", "getNavEvents", "()Lkotlinx/coroutines/flow/SharedFlow;", "getScanner", "()Lio/scanbot/sdk/barcode/ScanbotBarcodeDetector;", "skipFramesUntil", "stopNewFrames", "getStopNewFrames", "stripCheckDigits", "useIata2Of5Checksum", "barcodeScanned", "", "result", "Lio/scanbot/sdk/camera/FrameHandlerResult;", "Lio/scanbot/sdk/SdkLicenseError;", "handleSuccessDetect", "barcodeScanningResult", "(Lio/scanbot/sdk/barcode/entity/BarcodeScanningResult;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "navigate", "T", "event", "(Lio/scanbot/sdk/ui/utils/Event;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onCameraOpened", "onCancelClicked", "onFlashClicked", "onSelectionOverlayBarcodeClicked", "barcodeItem", "Lio/scanbot/sdk/barcode/entity/BarcodeItem;", "pageSnapped", "image", "", "imageOrientation", "pause", "performCancel", "isTimeout", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "savePreviewFrameAndFinish", "previewFrame", "Landroid/graphics/Bitmap;", "setAcceptedDocumentFormats", "formats", "setAutoCancelTimeout", "timeoutInSeconds", "setAutoStopOnSuccess", "enabled", "setAutomaticSelectionEnabled", "setBarcodeFilter", "setBarcodeFormatsFilter", "barcodeFormats", "setBarcodeImageGenerationType", "setCodeDensity", "setDelayAfterScanMs", "ms", "setEngineMode", "engineMode", "setFlashEnabled", "flashEnabled", "setGs1DecodingEnabled", "setInitialScanDelayMs", "setLowPowerMode", "setMaximumTextLength", "setMinimum1DQuietZoneSize", "setMinimumTextLength", "setMsiPlesseyChecksumAlgorithms", "setStripCheckDigits", "setUseIata2Of5Checksum", "startAutoCloseTimer", "updateBarcodeScannerConfig", "rtu-ui-barcode_release"})
public final class BarcodeCameraViewModel
extends ViewModel
implements IBarcodeCameraView.ViewModel,
Router {
    @NotNull
    private final ScanbotBarcodeDetector scanner;
    @NotNull
    private final SaveBarcodeTakenPictureUseCase saveBarcodeTakenPictureUseCase;
    @NotNull
    private final SaveBarcodePreviewFrameUseCase saveBarcodePreviewFrameUseCase;
    @NotNull
    private final BarcodeScanningSession barcodeScanningSession;
    @NotNull
    private final IDispatchersProvider dispatchersProvider;
    private final /* synthetic */ RouterImpl $$delegate_0;
    @Nullable
    private List<? extends BarcodeFormat> barcodeFormatsFilter;
    @Nullable
    private List<? extends BarcodeDocumentFormat> barcodeDocumentFormatsFilter;
    @Nullable
    private EngineMode barcodeEngineMode;
    private int minimumTextLength;
    private int maximumTextLength;
    private int minimum1DQuietZoneSize;
    private boolean gs1DecodingEnabled;
    @NotNull
    private EnumSet<MSIPlesseyChecksumAlgorithm> msiPlesseyChecksumAlgorithms;
    private boolean stripCheckDigits;
    private boolean lowPowerMode;
    @NotNull
    private BarcodeDensity codeDensity;
    private boolean useIata2Of5Checksum;
    @Nullable
    private BarcodeScanningResult cachedBarcodeResult;
    @NotNull
    private BarcodeImageGenerationType barcodeImageGenerationType;
    private int autoCloseTimeInSeconds;
    private boolean autoStopOnSuccess;
    private boolean automaticSelectionEnabled;
    private long initialScanDelayMs;
    private long delayAfterScanMs;
    @NotNull
    private final MutableStateFlow<Boolean> cameraOpened;
    @NotNull
    private final MutableStateFlow<Boolean> stopNewFrames;
    @NotNull
    private final MutableStateFlow<Boolean> flash;
    @NotNull
    private final MutableStateFlow<Boolean> autoSnapEnabled;
    @NotNull
    private final MutableStateFlow<IBarcodeFilter> barcodeFilter;
    @Nullable
    private Job autoCloseTimer;
    private long skipFramesUntil;

    public BarcodeCameraViewModel(@NotNull ScanbotBarcodeDetector scanner, @NotNull SaveBarcodeTakenPictureUseCase saveBarcodeTakenPictureUseCase, @NotNull SaveBarcodePreviewFrameUseCase saveBarcodePreviewFrameUseCase, @NotNull BarcodeScanningSession barcodeScanningSession, @NotNull IDispatchersProvider dispatchersProvider) {
        Intrinsics.checkNotNullParameter((Object)scanner, (String)"scanner");
        Intrinsics.checkNotNullParameter((Object)saveBarcodeTakenPictureUseCase, (String)"saveBarcodeTakenPictureUseCase");
        Intrinsics.checkNotNullParameter((Object)saveBarcodePreviewFrameUseCase, (String)"saveBarcodePreviewFrameUseCase");
        Intrinsics.checkNotNullParameter((Object)barcodeScanningSession, (String)"barcodeScanningSession");
        Intrinsics.checkNotNullParameter((Object)dispatchersProvider, (String)"dispatchersProvider");
        this.scanner = scanner;
        this.saveBarcodeTakenPictureUseCase = saveBarcodeTakenPictureUseCase;
        this.saveBarcodePreviewFrameUseCase = saveBarcodePreviewFrameUseCase;
        this.barcodeScanningSession = barcodeScanningSession;
        this.dispatchersProvider = dispatchersProvider;
        this.$$delegate_0 = new RouterImpl();
        this.barcodeEngineMode = EngineMode.NextGen;
        this.minimum1DQuietZoneSize = 10;
        this.gs1DecodingEnabled = true;
        this.msiPlesseyChecksumAlgorithms = BarcodeScannerAdditionalConfig.Companion.getDEFAULT_MSI_PLESSEY_CHECKSUM_ALGORITHMS();
        this.codeDensity = BarcodeScannerAdditionalConfig.Companion.getDEFAULT_CODE_DENSITY();
        this.useIata2Of5Checksum = true;
        this.barcodeImageGenerationType = BarcodeImageGenerationType.NONE;
        this.autoStopOnSuccess = true;
        this.cameraOpened = StateFlowKt.MutableStateFlow((Object)false);
        this.stopNewFrames = StateFlowKt.MutableStateFlow((Object)false);
        this.flash = StateFlowKt.MutableStateFlow((Object)false);
        this.autoSnapEnabled = StateFlowKt.MutableStateFlow((Object)false);
        this.barcodeFilter = StateFlowKt.MutableStateFlow((Object)new BarcodeFilter());
    }

    @Override
    @NotNull
    public ScanbotBarcodeDetector getScanner() {
        return this.scanner;
    }

    @NotNull
    public SharedFlow<Event> getNavEvents() {
        return (SharedFlow)this.$$delegate_0.getNavEvents();
    }

    @Nullable
    public <T extends Event> Object navigate(@NotNull T event, @NotNull Continuation<? super Unit> $completion) {
        return this.$$delegate_0.navigate(event, $completion);
    }

    @NotNull
    public MutableStateFlow<Boolean> getCameraOpened() {
        return this.cameraOpened;
    }

    @NotNull
    public MutableStateFlow<Boolean> getStopNewFrames() {
        return this.stopNewFrames;
    }

    @NotNull
    public MutableStateFlow<Boolean> getFlash() {
        return this.flash;
    }

    @NotNull
    public MutableStateFlow<Boolean> getAutoSnapEnabled() {
        return this.autoSnapEnabled;
    }

    @NotNull
    public MutableStateFlow<IBarcodeFilter> getBarcodeFilter() {
        return this.barcodeFilter;
    }

    public final void pause() {
        this.getCameraOpened().setValue((Object)false);
    }

    @Override
    public void onCameraOpened() {
        this.updateBarcodeScannerConfig();
        this.startAutoCloseTimer();
        this.skipFramesUntil = System.currentTimeMillis() + this.initialScanDelayMs;
    }

    private final void startAutoCloseTimer() {
        if (this.autoCloseTimeInSeconds != 0 && this.autoCloseTimer == null) {
            this.autoCloseTimer = BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ BarcodeCameraViewModel this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = DelayKt.delay((long)TimeUnit.MILLISECONDS.convert(BarcodeCameraViewModel.access$getAutoCloseTimeInSeconds$p(this.this$0), TimeUnit.SECONDS), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            this.label = 2;
                            v1 = BarcodeCameraViewModel.access$performCancel(this.this$0, true, (Continuation)this);
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl21
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl21:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @Override
    public void onCancelClicked() {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ BarcodeCameraViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = BarcodeCameraViewModel.access$performCancel(this.this$0, false, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void setAutoStopOnSuccess(boolean enabled) {
        this.autoStopOnSuccess = enabled;
    }

    private final Object performCancel(boolean isTimeout, Continuation<? super Unit> $completion) {
        Object object = this.navigate(isTimeout ? (Event)BarcodeNavigationEvents.SnappingTimeOut.INSTANCE : (Event)CommonNavigationEvent.Cancel.INSTANCE, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void onFlashClicked() {
        this.getFlash().setValue((Object)((Boolean)this.getFlash().getValue() == false ? 1 : 0));
    }

    @Override
    public void barcodeScanned(@NotNull FrameHandlerResult<BarcodeScanningResult, SdkLicenseError> result) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, result, null){
            int label;
            final /* synthetic */ BarcodeCameraViewModel this$0;
            final /* synthetic */ FrameHandlerResult<BarcodeScanningResult, SdkLicenseError> $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                void $result;
                FrameHandlerResult<BarcodeScanningResult, SdkLicenseError> frameHandlerResult;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (System.currentTimeMillis() <= BarcodeCameraViewModel.access$getSkipFramesUntil$p(this.this$0)) return Unit.INSTANCE;
                        frameHandlerResult = this.$result;
                        if (!(frameHandlerResult instanceof FrameHandlerResult.Success)) break;
                        BarcodeScanningResult barcodeScanningResult = (BarcodeScanningResult)((FrameHandlerResult.Success)this.$result).getValue();
                        if (barcodeScanningResult == null) return Unit.INSTANCE;
                        BarcodeScanningResult barcodeScanningResult2 = barcodeScanningResult;
                        BarcodeCameraViewModel barcodeCameraViewModel = this.this$0;
                        BarcodeScanningResult barcodeScanningResult3 = barcodeScanningResult2;
                        boolean bl = false;
                        this.label = 1;
                        Object object3 = BarcodeCameraViewModel.access$handleSuccessDetect(barcodeCameraViewModel, barcodeScanningResult3, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        boolean bl = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                if (!(frameHandlerResult instanceof FrameHandlerResult.Failure)) return Unit.INSTANCE;
                this.label = 2;
                Object object4 = this.this$0.navigate((Event)CommonNavigationEvent.InvalidLicense.INSTANCE, (Continuation<? super Unit>)((Continuation)this));
                if (object4 != object2) return Unit.INSTANCE;
                return object2;
                {
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        object4 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void onSelectionOverlayBarcodeClicked(@NotNull BarcodeItem barcodeItem) {
        Intrinsics.checkNotNullParameter((Object)barcodeItem, (String)"barcodeItem");
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, barcodeItem, null){
            int label;
            final /* synthetic */ BarcodeCameraViewModel this$0;
            final /* synthetic */ BarcodeItem $barcodeItem;
            {
                this.this$0 = $receiver;
                this.$barcodeItem = $barcodeItem;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.navigate((Event)new BarcodeNavigationEvents.BarcodesSelected(CollectionsKt.listOf((Object)this.$barcodeItem), false, Boxing.boxLong((long)BarcodeCameraViewModel.access$getDelayAfterScanMs$p(this.this$0))), (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Exception decompiling
     */
    private final Object handleSuccessDetect(BarcodeScanningResult var1_1, Continuation<? super Unit> var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[CASE]], but top level block is 5[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void pageSnapped(@NotNull byte[] image, int imageOrientation) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this.getStopNewFrames().setValue((Object)this.autoStopOnSuccess);
        FlowKt.launchIn((Flow)FlowKt.catch((Flow)FlowKt.onEach((Flow)FlowKt.flowOn(this.saveBarcodeTakenPictureUseCase.saveTakenPicture(image, imageOrientation), (CoroutineContext)this.dispatchersProvider.getBackground()), (Function2)((Function2)new Function2<String, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ BarcodeCameraViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void var2_3;
                        ResultKt.throwOnFailure((Object)object);
                        String barcodeImagePath = (String)this.L$0;
                        BarcodeScanningResult barcodeScanningResult = BarcodeCameraViewModel.access$getCachedBarcodeResult$p(this.this$0);
                        if (barcodeScanningResult == null) break;
                        BarcodeScanningResult barcodeScanningResult2 = barcodeScanningResult;
                        BarcodeCameraViewModel barcodeCameraViewModel = this.this$0;
                        BarcodeScanningResult it = barcodeScanningResult2;
                        boolean bl = false;
                        this.label = 1;
                        Object object3 = barcodeCameraViewModel.navigate((Event)new BarcodeNavigationEvents.BarcodeScanned(it, (String)var2_3, null, Boxing.boxLong((long)BarcodeCameraViewModel.access$getDelayAfterScanMs$p(barcodeCameraViewModel)), 4, null), (Continuation<? super Unit>)this);
                        if (object3 == object2) {
                            return object2;
                        }
                        break;
                    }
                    case 1: {
                        void $result;
                        boolean bl = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        break;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<String, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull String p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (Function3)((Function3)new Function3<FlowCollector<? super String>, Throwable, Continuation<? super Unit>, Object>(null){
            int label;
            /* synthetic */ Object L$0;

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Throwable it = (Throwable)this.L$0;
                        LoggerProvider.getLogger().logException(it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Nullable
            public final Object invoke(@NotNull FlowCollector<? super String> p1, @NotNull Throwable p2, @Nullable Continuation<? super Unit> p3) {
                Function3<FlowCollector<? super String>, Throwable, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p2;
                return function3.invokeSuspend((Object)Unit.INSTANCE);
            }
        })), (CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this));
    }

    private final void savePreviewFrameAndFinish(BarcodeScanningResult barcodeScanningResult, Bitmap previewFrame) {
        FlowKt.launchIn((Flow)FlowKt.catch((Flow)FlowKt.onEach((Flow)FlowKt.flowOn(this.saveBarcodePreviewFrameUseCase.savePreviewFrame(previewFrame), (CoroutineContext)this.dispatchersProvider.getBackground()), (Function2)((Function2)new Function2<String, Continuation<? super Unit>, Object>(this, barcodeScanningResult, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ BarcodeCameraViewModel this$0;
            final /* synthetic */ BarcodeScanningResult $barcodeScanningResult;
            {
                this.this$0 = $receiver;
                this.$barcodeScanningResult = $barcodeScanningResult;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void var2_3;
                        ResultKt.throwOnFailure((Object)object);
                        String barcodeImagePath = (String)this.L$0;
                        this.label = 1;
                        Object object3 = this.this$0.navigate((Event)new BarcodeNavigationEvents.BarcodeScanned(this.$barcodeScanningResult, null, (String)var2_3, Boxing.boxLong((long)BarcodeCameraViewModel.access$getDelayAfterScanMs$p(this.this$0)), 2, null), (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<String, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull String p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (Function3)((Function3)new Function3<FlowCollector<? super String>, Throwable, Continuation<? super Unit>, Object>(null){
            int label;
            /* synthetic */ Object L$0;

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Throwable it = (Throwable)this.L$0;
                        LoggerProvider.getLogger().logException(it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Nullable
            public final Object invoke(@NotNull FlowCollector<? super String> p1, @NotNull Throwable p2, @Nullable Continuation<? super Unit> p3) {
                Function3<FlowCollector<? super String>, Throwable, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p2;
                return function3.invokeSuspend((Object)Unit.INSTANCE);
            }
        })), (CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this));
    }

    public final void setFlashEnabled(boolean flashEnabled) {
        this.getFlash().setValue((Object)flashEnabled);
    }

    @Override
    public void setAutoCancelTimeout(int timeoutInSeconds) {
        this.autoCloseTimeInSeconds = timeoutInSeconds;
    }

    @Override
    public void setInitialScanDelayMs(long ms) {
        this.initialScanDelayMs = ms;
    }

    @Override
    public void setDelayAfterScanMs(long ms) {
        this.delayAfterScanMs = ms;
    }

    @Override
    public void setAutomaticSelectionEnabled(boolean enabled) {
        this.automaticSelectionEnabled = enabled;
    }

    public final void setBarcodeImageGenerationType(@NotNull BarcodeImageGenerationType barcodeImageGenerationType) {
        Intrinsics.checkNotNullParameter((Object)((Object)barcodeImageGenerationType), (String)"barcodeImageGenerationType");
        this.barcodeImageGenerationType = barcodeImageGenerationType;
    }

    @Override
    public void setBarcodeFormatsFilter(@NotNull List<? extends BarcodeFormat> barcodeFormats) {
        Intrinsics.checkNotNullParameter(barcodeFormats, (String)"barcodeFormats");
        this.barcodeFormatsFilter = barcodeFormats;
    }

    @Override
    public void setAcceptedDocumentFormats(@NotNull List<? extends BarcodeDocumentFormat> formats) {
        Intrinsics.checkNotNullParameter(formats, (String)"formats");
        this.barcodeDocumentFormatsFilter = formats;
    }

    @Override
    public void setMinimumTextLength(int minimumTextLength) {
        this.minimumTextLength = minimumTextLength;
    }

    @Override
    public void setMaximumTextLength(int maximumTextLength) {
        this.maximumTextLength = maximumTextLength;
    }

    @Override
    public void setMinimum1DQuietZoneSize(int minimum1DQuietZoneSize) {
        this.minimum1DQuietZoneSize = minimum1DQuietZoneSize;
    }

    @Override
    public void setGs1DecodingEnabled(boolean gs1DecodingEnabled) {
        this.gs1DecodingEnabled = gs1DecodingEnabled;
    }

    @Override
    public void setMsiPlesseyChecksumAlgorithms(@NotNull EnumSet<MSIPlesseyChecksumAlgorithm> msiPlesseyChecksumAlgorithms) {
        Intrinsics.checkNotNullParameter(msiPlesseyChecksumAlgorithms, (String)"msiPlesseyChecksumAlgorithms");
        this.msiPlesseyChecksumAlgorithms = msiPlesseyChecksumAlgorithms;
    }

    @Override
    public void setStripCheckDigits(boolean stripCheckDigits) {
        this.stripCheckDigits = stripCheckDigits;
    }

    @Override
    public void setLowPowerMode(boolean lowPowerMode) {
        this.lowPowerMode = lowPowerMode;
    }

    @Override
    public void setCodeDensity(@NotNull BarcodeDensity codeDensity) {
        Intrinsics.checkNotNullParameter((Object)codeDensity, (String)"codeDensity");
        this.codeDensity = codeDensity;
    }

    @Override
    public void setUseIata2Of5Checksum(boolean enabled) {
        this.useIata2Of5Checksum = enabled;
    }

    @Override
    public void setEngineMode(@NotNull EngineMode engineMode) {
        Intrinsics.checkNotNullParameter((Object)engineMode, (String)"engineMode");
        this.barcodeEngineMode = engineMode;
    }

    @Override
    public void setBarcodeFilter(@NotNull IBarcodeFilter barcodeFilter) {
        Intrinsics.checkNotNullParameter((Object)barcodeFilter, (String)"barcodeFilter");
        this.getBarcodeFilter().setValue((Object)barcodeFilter);
    }

    private final void updateBarcodeScannerConfig() {
        this.getScanner().modifyConfig((Function1)new Function1<BarcodeScannerConfigBuilder, Unit>(this){
            final /* synthetic */ BarcodeCameraViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull BarcodeScannerConfigBuilder $this$modifyConfig) {
                List it;
                Intrinsics.checkNotNullParameter((Object)$this$modifyConfig, (String)"$this$modifyConfig");
                List list = BarcodeCameraViewModel.access$getBarcodeFormatsFilter$p(this.this$0);
                if (list != null) {
                    it = list;
                    boolean bl = false;
                    $this$modifyConfig.setBarcodeFormats(it);
                }
                List list2 = BarcodeCameraViewModel.access$getBarcodeDocumentFormatsFilter$p(this.this$0);
                if (list2 != null) {
                    it = list2;
                    boolean bl = false;
                    $this$modifyConfig.setAcceptedDocumentFormats(it);
                }
                EngineMode engineMode = BarcodeCameraViewModel.access$getBarcodeEngineMode$p(this.this$0);
                if (engineMode != null) {
                    it = engineMode;
                    boolean bl = false;
                    $this$modifyConfig.setEngineMode((EngineMode)it);
                }
                $this$modifyConfig.setAdditionalConfig(new BarcodeScannerAdditionalConfig(BarcodeCameraViewModel.access$getMinimumTextLength$p(this.this$0), BarcodeCameraViewModel.access$getMaximumTextLength$p(this.this$0), BarcodeCameraViewModel.access$getMinimum1DQuietZoneSize$p(this.this$0), BarcodeCameraViewModel.access$getGs1DecodingEnabled$p(this.this$0), BarcodeCameraViewModel.access$getMsiPlesseyChecksumAlgorithms$p(this.this$0), BarcodeCameraViewModel.access$getStripCheckDigits$p(this.this$0), BarcodeCameraViewModel.access$getLowPowerMode$p(this.this$0), BarcodeCameraViewModel.access$getCodeDensity$p(this.this$0), BarcodeCameraViewModel.access$getUseIata2Of5Checksum$p(this.this$0)));
                switch (updateBarcodeScannerConfig.WhenMappings.$EnumSwitchMapping$0[BarcodeCameraViewModel.access$getBarcodeImageGenerationType$p(this.this$0).ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        $this$modifyConfig.setSaveCameraPreviewFrame(true);
                        break;
                    }
                    case 3: {
                        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ BarcodeCameraViewModel this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        this.label = 1;
                                        v0 = DelayKt.delay((long)BarcodeCameraViewModel.access$getInitialScanDelayMs$p(this.this$0), (Continuation)((Continuation)this));
                                        if (v0 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl13
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl13:
                                        // 2 sources

                                        this.this$0.getAutoSnapEnabled().setValue((Object)Boxing.boxBoolean((boolean)true));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                    }
                }
            }
        });
    }

    public static final /* synthetic */ int access$getAutoCloseTimeInSeconds$p(BarcodeCameraViewModel $this) {
        return $this.autoCloseTimeInSeconds;
    }

    public static final /* synthetic */ Object access$performCancel(BarcodeCameraViewModel $this, boolean isTimeout, Continuation $completion) {
        return $this.performCancel(isTimeout, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ long access$getSkipFramesUntil$p(BarcodeCameraViewModel $this) {
        return $this.skipFramesUntil;
    }

    public static final /* synthetic */ Object access$handleSuccessDetect(BarcodeCameraViewModel $this, BarcodeScanningResult barcodeScanningResult, Continuation $completion) {
        return $this.handleSuccessDetect(barcodeScanningResult, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ long access$getDelayAfterScanMs$p(BarcodeCameraViewModel $this) {
        return $this.delayAfterScanMs;
    }

    public static final /* synthetic */ BarcodeScanningResult access$getCachedBarcodeResult$p(BarcodeCameraViewModel $this) {
        return $this.cachedBarcodeResult;
    }

    public static final /* synthetic */ List access$getBarcodeFormatsFilter$p(BarcodeCameraViewModel $this) {
        return $this.barcodeFormatsFilter;
    }

    public static final /* synthetic */ List access$getBarcodeDocumentFormatsFilter$p(BarcodeCameraViewModel $this) {
        return $this.barcodeDocumentFormatsFilter;
    }

    public static final /* synthetic */ EngineMode access$getBarcodeEngineMode$p(BarcodeCameraViewModel $this) {
        return $this.barcodeEngineMode;
    }

    public static final /* synthetic */ int access$getMinimumTextLength$p(BarcodeCameraViewModel $this) {
        return $this.minimumTextLength;
    }

    public static final /* synthetic */ int access$getMaximumTextLength$p(BarcodeCameraViewModel $this) {
        return $this.maximumTextLength;
    }

    public static final /* synthetic */ int access$getMinimum1DQuietZoneSize$p(BarcodeCameraViewModel $this) {
        return $this.minimum1DQuietZoneSize;
    }

    public static final /* synthetic */ boolean access$getGs1DecodingEnabled$p(BarcodeCameraViewModel $this) {
        return $this.gs1DecodingEnabled;
    }

    public static final /* synthetic */ EnumSet access$getMsiPlesseyChecksumAlgorithms$p(BarcodeCameraViewModel $this) {
        return $this.msiPlesseyChecksumAlgorithms;
    }

    public static final /* synthetic */ boolean access$getStripCheckDigits$p(BarcodeCameraViewModel $this) {
        return $this.stripCheckDigits;
    }

    public static final /* synthetic */ boolean access$getLowPowerMode$p(BarcodeCameraViewModel $this) {
        return $this.lowPowerMode;
    }

    public static final /* synthetic */ BarcodeDensity access$getCodeDensity$p(BarcodeCameraViewModel $this) {
        return $this.codeDensity;
    }

    public static final /* synthetic */ boolean access$getUseIata2Of5Checksum$p(BarcodeCameraViewModel $this) {
        return $this.useIata2Of5Checksum;
    }

    public static final /* synthetic */ BarcodeImageGenerationType access$getBarcodeImageGenerationType$p(BarcodeCameraViewModel $this) {
        return $this.barcodeImageGenerationType;
    }

    public static final /* synthetic */ long access$getInitialScanDelayMs$p(BarcodeCameraViewModel $this) {
        return $this.initialScanDelayMs;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BarcodeImageGenerationType.values().length];
            nArray[BarcodeImageGenerationType.NONE.ordinal()] = 1;
            nArray[BarcodeImageGenerationType.VIDEO_FRAME.ordinal()] = 2;
            nArray[BarcodeImageGenerationType.CAPTURED_IMAGE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

