/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui.view.genericdocument.list;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListAdapter;
import io.scanbot.genericdocument.entity.CommonFieldType;
import io.scanbot.genericdocument.entity.Field;
import io.scanbot.sdk.ui.genericdocument.R;
import io.scanbot.sdk.ui.view.genericdocument.list.DocumentFieldDiffCallback;
import io.scanbot.sdk.ui.view.genericdocument.list.DocumentFieldItemViewHolder;
import io.scanbot.sdk.ui.view.genericdocument.list.DocumentItemViewHolder;
import io.scanbot.sdk.ui.view.genericdocument.list.DocumentSectionItemViewHolder;
import io.scanbot.sdk.ui.view.genericdocument.list.FieldViewModel;
import io.scanbot.sdk.ui.view.genericdocument.list.GenericDocumentFieldListView;
import io.scanbot.sdk.ui.view.genericdocument.list.GenericDocumentListViewModel;
import io.scanbot.sdk.ui.view.genericdocument.list.GenericDocumentListViewType;
import io.scanbot.sdk.ui.view.genericdocument.list.SectionViewModel;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00142\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0014B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/scanbot/sdk/ui/view/genericdocument/list/GenericDocumentFieldItemAdapter;", "Landroidx/recyclerview/widget/ListAdapter;", "Lio/scanbot/sdk/ui/view/genericdocument/list/GenericDocumentListViewModel;", "Lio/scanbot/sdk/ui/view/genericdocument/list/DocumentItemViewHolder;", "context", "Landroid/content/Context;", "configProvider", "Ljavax/inject/Provider;", "Lio/scanbot/sdk/ui/view/genericdocument/list/GenericDocumentFieldListView$Configuration;", "(Landroid/content/Context;Ljavax/inject/Provider;)V", "getItemViewType", "", "position", "onBindViewHolder", "", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "Companion", "rtu-ui-genericdocument_release"})
public final class GenericDocumentFieldItemAdapter
extends ListAdapter<GenericDocumentListViewModel, DocumentItemViewHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Provider<GenericDocumentFieldListView.Configuration> configProvider;
    private static final int TYPE_TITLE_FIELD_ALPHA = 180;
    private static final int IMAGE_GENERIC_DOCUMENT_FIELD_ALPHA = 100;

    public GenericDocumentFieldItemAdapter(@NotNull Context context, @NotNull Provider<GenericDocumentFieldListView.Configuration> configProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(configProvider, (String)"configProvider");
        super((DiffUtil.ItemCallback)new DocumentFieldDiffCallback());
        this.context = context;
        this.configProvider = configProvider;
    }

    @NotNull
    public DocumentItemViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        int n = viewType;
        if (n == GenericDocumentListViewType.FIELD.ordinal()) {
            View view = LayoutInflater.from((Context)this.context).inflate(R.layout.scanbot_sdk_generic_document_field_item, parent, false);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
            DocumentFieldItemViewHolder holder = new DocumentFieldItemViewHolder(view);
            int n2 = ((GenericDocumentFieldListView.Configuration)this.configProvider.get()).getPrimaryColor();
            boolean bl = false;
            boolean bl2 = false;
            int it = n2;
            boolean bl3 = false;
            holder.getValue().setTextColor(it);
            holder.getType().setTextColor(Color.argb((int)180, (int)Color.red((int)it), (int)Color.green((int)it), (int)Color.blue((int)it)));
            holder.getImage().setBackgroundTintList(ColorStateList.valueOf((int)Color.argb((int)100, (int)Color.red((int)it), (int)Color.green((int)it), (int)Color.blue((int)it))));
            n2 = ((GenericDocumentFieldListView.Configuration)this.configProvider.get()).getFieldConfidenceTextColor();
            bl = false;
            bl2 = false;
            it = n2;
            boolean bl4 = false;
            holder.getConfidenceImage().setImageTintList(ColorStateList.valueOf((int)it));
            holder.getConfidence().setTextColor(it);
            return holder;
        }
        if (n == GenericDocumentListViewType.SECTION.ordinal()) {
            View view = LayoutInflater.from((Context)this.context).inflate(R.layout.scanbot_sdk_generic_document_section_item, parent, false);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
            DocumentSectionItemViewHolder holder = new DocumentSectionItemViewHolder(view);
            int n3 = ((GenericDocumentFieldListView.Configuration)this.configProvider.get()).getPrimaryColor();
            boolean bl = false;
            boolean bl5 = false;
            int it = n3;
            boolean bl6 = false;
            holder.getValue().setTextColor(it);
            return holder;
        }
        throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unknown type of view holder ", (Object)viewType));
    }

    public int getItemViewType(int position) {
        int n;
        GenericDocumentListViewModel genericDocumentListViewModel = (GenericDocumentListViewModel)this.getItem(position);
        if (genericDocumentListViewModel instanceof FieldViewModel) {
            n = GenericDocumentListViewType.FIELD.ordinal();
        } else if (genericDocumentListViewModel instanceof SectionViewModel) {
            n = GenericDocumentListViewType.SECTION.ordinal();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    public void onBindViewHolder(@NotNull DocumentItemViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        GenericDocumentListViewModel item = (GenericDocumentListViewModel)this.getItem(position);
        if (item instanceof FieldViewModel) {
            boolean bl;
            boolean bl2;
            float f;
            DocumentFieldItemViewHolder cfr_ignored_0 = (DocumentFieldItemViewHolder)holder;
            Field documentField = ((FieldViewModel)item).getField();
            ((DocumentFieldItemViewHolder)holder).getImage().setImageBitmap(documentField.getImage());
            Object object = documentField.getValue();
            ((DocumentFieldItemViewHolder)holder).getValue().setText((CharSequence)(object == null ? null : object.getText()));
            Object[] objectArray = ((GenericDocumentFieldListView.Configuration)this.configProvider.get()).getFieldsDisplayMap().get(documentField.getType().getNormalizedName());
            object = objectArray == null ? null : objectArray.getDefaultDisplayText();
            ((DocumentFieldItemViewHolder)holder).getType().setText(object == null ? (CharSequence)documentField.getType().getName() : (CharSequence)object);
            objectArray = new CommonFieldType[]{CommonFieldType.Signature, CommonFieldType.Photo};
            boolean isImage = CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)documentField.getType().getCommonType());
            if (isImage) {
                f = 1.0f;
            } else {
                float f2;
                Object object2 = documentField.getValue();
                object2 = object2 == null ? null : object2.getText();
                bl2 = false;
                bl = false;
                f = object2 == null || StringsKt.isBlank((CharSequence)object2) ? 1.0f : ((object2 = documentField.getValue()) == null ? 0.0f : (f2 = object2.getConfidence()));
            }
            float conf = f;
            ((DocumentFieldItemViewHolder)holder).getConfidence().setText((CharSequence)"");
            if (isImage) {
                ((DocumentFieldItemViewHolder)holder).getValue().setText((CharSequence)((GenericDocumentFieldListView.Configuration)this.configProvider.get()).getImageTitle());
                ((DocumentFieldItemViewHolder)holder).getConfidenceImage().setVisibility(0);
                ((DocumentFieldItemViewHolder)holder).getConfidenceImage().setImageResource(R.drawable.generic_document_scanner_checked);
            } else if (conf == 1.0f) {
                ((DocumentFieldItemViewHolder)holder).getConfidenceImage().setVisibility(0);
                ((DocumentFieldItemViewHolder)holder).getConfidenceImage().setImageResource(R.drawable.generic_document_scanner_checked);
            } else if (conf == 0.0f) {
                ((DocumentFieldItemViewHolder)holder).getConfidenceImage().setVisibility(0);
                ((DocumentFieldItemViewHolder)holder).getConfidenceImage().setImageResource(R.drawable.generic_document_scanner_crossed);
            } else {
                int textConfidence = MathKt.roundToInt((float)(conf * (float)100));
                ((DocumentFieldItemViewHolder)holder).getConfidence().setText((CharSequence)String.valueOf(textConfidence));
                ((DocumentFieldItemViewHolder)holder).getConfidenceImage().setVisibility(8);
            }
            Object object3 = this.configProvider.get();
            bl2 = false;
            bl = false;
            GenericDocumentFieldListView.Configuration config = (GenericDocumentFieldListView.Configuration)object3;
            boolean bl3 = false;
            ((DocumentFieldItemViewHolder)holder).getConfidenceLayout().setBackgroundTintList((double)conf > 0.9 ? ColorStateList.valueOf((int)config.getFieldConfidenceHighColor()) : ((double)conf > 0.5 ? ColorStateList.valueOf((int)config.getFieldConfidenceModerateColor()) : ColorStateList.valueOf((int)config.getFieldConfidenceLowColor())));
        } else if (item instanceof SectionViewModel) {
            DocumentSectionItemViewHolder cfr_ignored_1 = (DocumentSectionItemViewHolder)holder;
            ((DocumentSectionItemViewHolder)holder).getValue().setText((CharSequence)((SectionViewModel)item).getHeader());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/scanbot/sdk/ui/view/genericdocument/list/GenericDocumentFieldItemAdapter$Companion;", "", "()V", "IMAGE_GENERIC_DOCUMENT_FIELD_ALPHA", "", "TYPE_TITLE_FIELD_ALPHA", "rtu-ui-genericdocument_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

